/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.radar;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.Charge;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.PaymentIntent;
import com.stripe.model.radar.EarlyFraudWarningCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.radar.EarlyFraudWarningListParams;
import com.stripe.param.radar.EarlyFraudWarningRetrieveParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class EarlyFraudWarning
extends ApiResource
implements HasId {
    @SerializedName(value="actionable")
    Boolean actionable;
    @SerializedName(value="charge")
    ExpandableField<Charge> charge;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="fraud_type")
    String fraudType;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="payment_intent")
    ExpandableField<PaymentIntent> paymentIntent;

    public String getCharge() {
        return this.charge != null ? this.charge.getId() : null;
    }

    public void setCharge(String id) {
        this.charge = ApiResource.setExpandableFieldId(id, this.charge);
    }

    public Charge getChargeObject() {
        return this.charge != null ? this.charge.getExpanded() : null;
    }

    public void setChargeObject(Charge expandableObject) {
        this.charge = new ExpandableField<Charge>(expandableObject.getId(), expandableObject);
    }

    public String getPaymentIntent() {
        return this.paymentIntent != null ? this.paymentIntent.getId() : null;
    }

    public void setPaymentIntent(String id) {
        this.paymentIntent = ApiResource.setExpandableFieldId(id, this.paymentIntent);
    }

    public PaymentIntent getPaymentIntentObject() {
        return this.paymentIntent != null ? this.paymentIntent.getExpanded() : null;
    }

    public void setPaymentIntentObject(PaymentIntent expandableObject) {
        this.paymentIntent = new ExpandableField<PaymentIntent>(expandableObject.getId(), expandableObject);
    }

    public static EarlyFraudWarningCollection list(Map<String, Object> params) throws StripeException {
        return EarlyFraudWarning.list(params, (RequestOptions)null);
    }

    public static EarlyFraudWarningCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/radar/early_fraud_warnings";
        return (EarlyFraudWarningCollection)EarlyFraudWarning.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)EarlyFraudWarningCollection.class), options, ApiMode.V1);
    }

    public static EarlyFraudWarningCollection list(EarlyFraudWarningListParams params) throws StripeException {
        return EarlyFraudWarning.list(params, (RequestOptions)null);
    }

    public static EarlyFraudWarningCollection list(EarlyFraudWarningListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/radar/early_fraud_warnings";
        ApiResource.checkNullTypedParams(path, params);
        return (EarlyFraudWarningCollection)EarlyFraudWarning.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)EarlyFraudWarningCollection.class), options, ApiMode.V1);
    }

    public static EarlyFraudWarning retrieve(String earlyFraudWarning) throws StripeException {
        return EarlyFraudWarning.retrieve(earlyFraudWarning, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static EarlyFraudWarning retrieve(String earlyFraudWarning, RequestOptions options) throws StripeException {
        return EarlyFraudWarning.retrieve(earlyFraudWarning, (Map<String, Object>)null, options);
    }

    public static EarlyFraudWarning retrieve(String earlyFraudWarning, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/radar/early_fraud_warnings/%s", ApiResource.urlEncodeId(earlyFraudWarning));
        return (EarlyFraudWarning)EarlyFraudWarning.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)EarlyFraudWarning.class), options, ApiMode.V1);
    }

    public static EarlyFraudWarning retrieve(String earlyFraudWarning, EarlyFraudWarningRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/radar/early_fraud_warnings/%s", ApiResource.urlEncodeId(earlyFraudWarning));
        ApiResource.checkNullTypedParams(path, params);
        return (EarlyFraudWarning)EarlyFraudWarning.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)EarlyFraudWarning.class), options, ApiMode.V1);
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.charge, responseGetter);
        this.trySetResponseGetter(this.paymentIntent, responseGetter);
    }

    @Generated
    public Boolean getActionable() {
        return this.actionable;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getFraudType() {
        return this.fraudType;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public void setActionable(Boolean actionable) {
        this.actionable = actionable;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setFraudType(String fraudType) {
        this.fraudType = fraudType;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EarlyFraudWarning)) {
            return false;
        }
        EarlyFraudWarning other = (EarlyFraudWarning)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$actionable = this.getActionable();
        Boolean other$actionable = other.getActionable();
        if (this$actionable == null ? other$actionable != null : !((Object)this$actionable).equals(other$actionable)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$charge = this.getCharge();
        String other$charge = other.getCharge();
        if (this$charge == null ? other$charge != null : !this$charge.equals(other$charge)) {
            return false;
        }
        String this$fraudType = this.getFraudType();
        String other$fraudType = other.getFraudType();
        if (this$fraudType == null ? other$fraudType != null : !this$fraudType.equals(other$fraudType)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$paymentIntent = this.getPaymentIntent();
        String other$paymentIntent = other.getPaymentIntent();
        return !(this$paymentIntent == null ? other$paymentIntent != null : !this$paymentIntent.equals(other$paymentIntent));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EarlyFraudWarning;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $actionable = this.getActionable();
        result = result * 59 + ($actionable == null ? 43 : ((Object)$actionable).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $charge = this.getCharge();
        result = result * 59 + ($charge == null ? 43 : $charge.hashCode());
        String $fraudType = this.getFraudType();
        result = result * 59 + ($fraudType == null ? 43 : $fraudType.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $paymentIntent = this.getPaymentIntent();
        result = result * 59 + ($paymentIntent == null ? 43 : $paymentIntent.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }
}

