/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import com.stripe.param.common.EmptyParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class PaymentIntentCaptureParams
extends ApiRequestParams {
    @SerializedName(value="amount_to_capture")
    Long amountToCapture;
    @SerializedName(value="application_fee_amount")
    Long applicationFeeAmount;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="_stripe_java_extra_param_key")
    Map<String, Object> extraParams;
    @SerializedName(value="final_capture")
    Boolean finalCapture;
    @SerializedName(value="metadata")
    Object metadata;
    @SerializedName(value="payment_details")
    Object paymentDetails;
    @SerializedName(value="statement_descriptor")
    String statementDescriptor;
    @SerializedName(value="statement_descriptor_suffix")
    String statementDescriptorSuffix;
    @SerializedName(value="transfer_data")
    TransferData transferData;

    private PaymentIntentCaptureParams(Long amountToCapture, Long applicationFeeAmount, List<String> expand, Map<String, Object> extraParams, Boolean finalCapture, Object metadata, Object paymentDetails, String statementDescriptor, String statementDescriptorSuffix, TransferData transferData) {
        this.amountToCapture = amountToCapture;
        this.applicationFeeAmount = applicationFeeAmount;
        this.expand = expand;
        this.extraParams = extraParams;
        this.finalCapture = finalCapture;
        this.metadata = metadata;
        this.paymentDetails = paymentDetails;
        this.statementDescriptor = statementDescriptor;
        this.statementDescriptorSuffix = statementDescriptorSuffix;
        this.transferData = transferData;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public Long getAmountToCapture() {
        return this.amountToCapture;
    }

    @Generated
    public Long getApplicationFeeAmount() {
        return this.applicationFeeAmount;
    }

    @Generated
    public List<String> getExpand() {
        return this.expand;
    }

    @Generated
    public Map<String, Object> getExtraParams() {
        return this.extraParams;
    }

    @Generated
    public Boolean getFinalCapture() {
        return this.finalCapture;
    }

    @Generated
    public Object getMetadata() {
        return this.metadata;
    }

    @Generated
    public Object getPaymentDetails() {
        return this.paymentDetails;
    }

    @Generated
    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    @Generated
    public String getStatementDescriptorSuffix() {
        return this.statementDescriptorSuffix;
    }

    @Generated
    public TransferData getTransferData() {
        return this.transferData;
    }

    public static class TransferData {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;

        private TransferData(Long amount, Map<String, Object> extraParams) {
            this.amount = amount;
            this.extraParams = extraParams;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        public static class Builder {
            private Long amount;
            private Map<String, Object> extraParams;

            public TransferData build() {
                return new TransferData(this.amount, this.extraParams);
            }

            public Builder setAmount(Long amount) {
                this.amount = amount;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }
        }
    }

    public static class Builder {
        private Long amountToCapture;
        private Long applicationFeeAmount;
        private List<String> expand;
        private Map<String, Object> extraParams;
        private Boolean finalCapture;
        private Object metadata;
        private Object paymentDetails;
        private String statementDescriptor;
        private String statementDescriptorSuffix;
        private TransferData transferData;

        public PaymentIntentCaptureParams build() {
            return new PaymentIntentCaptureParams(this.amountToCapture, this.applicationFeeAmount, this.expand, this.extraParams, this.finalCapture, this.metadata, this.paymentDetails, this.statementDescriptor, this.statementDescriptorSuffix, this.transferData);
        }

        public Builder setAmountToCapture(Long amountToCapture) {
            this.amountToCapture = amountToCapture;
            return this;
        }

        public Builder setApplicationFeeAmount(Long applicationFeeAmount) {
            this.applicationFeeAmount = applicationFeeAmount;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.put(key, value);
            return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.putAll(map);
            return this;
        }

        public Builder setFinalCapture(Boolean finalCapture) {
            this.finalCapture = finalCapture;
            return this;
        }

        public Builder putMetadata(String key, String value) {
            if (this.metadata == null || this.metadata instanceof EmptyParam) {
                this.metadata = new HashMap();
            }
            ((Map)this.metadata).put(key, value);
            return this;
        }

        public Builder putAllMetadata(Map<String, String> map) {
            if (this.metadata == null || this.metadata instanceof EmptyParam) {
                this.metadata = new HashMap();
            }
            ((Map)this.metadata).putAll(map);
            return this;
        }

        public Builder setMetadata(EmptyParam metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder setMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder setPaymentDetails(PaymentDetails paymentDetails) {
            this.paymentDetails = paymentDetails;
            return this;
        }

        public Builder setPaymentDetails(EmptyParam paymentDetails) {
            this.paymentDetails = paymentDetails;
            return this;
        }

        public Builder setStatementDescriptor(String statementDescriptor) {
            this.statementDescriptor = statementDescriptor;
            return this;
        }

        public Builder setStatementDescriptorSuffix(String statementDescriptorSuffix) {
            this.statementDescriptorSuffix = statementDescriptorSuffix;
            return this;
        }

        public Builder setTransferData(TransferData transferData) {
            this.transferData = transferData;
            return this;
        }
    }

    public static class PaymentDetails {
        @SerializedName(value="car_rental")
        CarRental carRental;
        @SerializedName(value="event_details")
        EventDetails eventDetails;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="flight")
        Flight flight;
        @SerializedName(value="lodging")
        Lodging lodging;
        @SerializedName(value="subscription")
        Subscription subscription;

        private PaymentDetails(CarRental carRental, EventDetails eventDetails, Map<String, Object> extraParams, Flight flight, Lodging lodging, Subscription subscription) {
            this.carRental = carRental;
            this.eventDetails = eventDetails;
            this.extraParams = extraParams;
            this.flight = flight;
            this.lodging = lodging;
            this.subscription = subscription;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public CarRental getCarRental() {
            return this.carRental;
        }

        @Generated
        public EventDetails getEventDetails() {
            return this.eventDetails;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public Flight getFlight() {
            return this.flight;
        }

        @Generated
        public Lodging getLodging() {
            return this.lodging;
        }

        @Generated
        public Subscription getSubscription() {
            return this.subscription;
        }

        public static class CarRental {
            @SerializedName(value="affiliate")
            Affiliate affiliate;
            @SerializedName(value="booking_number")
            String bookingNumber;
            @SerializedName(value="car_class_code")
            String carClassCode;
            @SerializedName(value="car_make")
            String carMake;
            @SerializedName(value="car_model")
            String carModel;
            @SerializedName(value="company")
            String company;
            @SerializedName(value="customer_service_phone_number")
            String customerServicePhoneNumber;
            @SerializedName(value="days_rented")
            Long daysRented;
            @SerializedName(value="delivery")
            Delivery delivery;
            @SerializedName(value="drivers")
            List<Driver> drivers;
            @SerializedName(value="extra_charges")
            List<ExtraCharge> extraCharges;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="no_show")
            Boolean noShow;
            @SerializedName(value="pickup_address")
            PickupAddress pickupAddress;
            @SerializedName(value="pickup_at")
            Long pickupAt;
            @SerializedName(value="rate_amount")
            Long rateAmount;
            @SerializedName(value="rate_interval")
            RateInterval rateInterval;
            @SerializedName(value="renter_name")
            String renterName;
            @SerializedName(value="return_address")
            ReturnAddress returnAddress;
            @SerializedName(value="return_at")
            Long returnAt;
            @SerializedName(value="tax_exempt")
            Boolean taxExempt;

            private CarRental(Affiliate affiliate, String bookingNumber, String carClassCode, String carMake, String carModel, String company, String customerServicePhoneNumber, Long daysRented, Delivery delivery, List<Driver> drivers, List<ExtraCharge> extraCharges, Map<String, Object> extraParams, Boolean noShow, PickupAddress pickupAddress, Long pickupAt, Long rateAmount, RateInterval rateInterval, String renterName, ReturnAddress returnAddress, Long returnAt, Boolean taxExempt) {
                this.affiliate = affiliate;
                this.bookingNumber = bookingNumber;
                this.carClassCode = carClassCode;
                this.carMake = carMake;
                this.carModel = carModel;
                this.company = company;
                this.customerServicePhoneNumber = customerServicePhoneNumber;
                this.daysRented = daysRented;
                this.delivery = delivery;
                this.drivers = drivers;
                this.extraCharges = extraCharges;
                this.extraParams = extraParams;
                this.noShow = noShow;
                this.pickupAddress = pickupAddress;
                this.pickupAt = pickupAt;
                this.rateAmount = rateAmount;
                this.rateInterval = rateInterval;
                this.renterName = renterName;
                this.returnAddress = returnAddress;
                this.returnAt = returnAt;
                this.taxExempt = taxExempt;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Affiliate getAffiliate() {
                return this.affiliate;
            }

            @Generated
            public String getBookingNumber() {
                return this.bookingNumber;
            }

            @Generated
            public String getCarClassCode() {
                return this.carClassCode;
            }

            @Generated
            public String getCarMake() {
                return this.carMake;
            }

            @Generated
            public String getCarModel() {
                return this.carModel;
            }

            @Generated
            public String getCompany() {
                return this.company;
            }

            @Generated
            public String getCustomerServicePhoneNumber() {
                return this.customerServicePhoneNumber;
            }

            @Generated
            public Long getDaysRented() {
                return this.daysRented;
            }

            @Generated
            public Delivery getDelivery() {
                return this.delivery;
            }

            @Generated
            public List<Driver> getDrivers() {
                return this.drivers;
            }

            @Generated
            public List<ExtraCharge> getExtraCharges() {
                return this.extraCharges;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Boolean getNoShow() {
                return this.noShow;
            }

            @Generated
            public PickupAddress getPickupAddress() {
                return this.pickupAddress;
            }

            @Generated
            public Long getPickupAt() {
                return this.pickupAt;
            }

            @Generated
            public Long getRateAmount() {
                return this.rateAmount;
            }

            @Generated
            public RateInterval getRateInterval() {
                return this.rateInterval;
            }

            @Generated
            public String getRenterName() {
                return this.renterName;
            }

            @Generated
            public ReturnAddress getReturnAddress() {
                return this.returnAddress;
            }

            @Generated
            public Long getReturnAt() {
                return this.returnAt;
            }

            @Generated
            public Boolean getTaxExempt() {
                return this.taxExempt;
            }

            public static class Affiliate {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="name")
                String name;

                private Affiliate(Map<String, Object> extraParams, String name) {
                    this.extraParams = extraParams;
                    this.name = name;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getName() {
                    return this.name;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private String name;

                    public Affiliate build() {
                        return new Affiliate(this.extraParams, this.name);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setName(String name) {
                        this.name = name;
                        return this;
                    }
                }
            }

            public static class Delivery {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="mode")
                Mode mode;
                @SerializedName(value="recipient")
                Recipient recipient;

                private Delivery(Map<String, Object> extraParams, Mode mode, Recipient recipient) {
                    this.extraParams = extraParams;
                    this.mode = mode;
                    this.recipient = recipient;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Mode getMode() {
                    return this.mode;
                }

                @Generated
                public Recipient getRecipient() {
                    return this.recipient;
                }

                public static enum Mode implements ApiRequestParams.EnumParam
                {
                    EMAIL("email"),
                    PHONE("phone"),
                    PICKUP("pickup"),
                    POST("post");

                    private final String value;

                    private Mode(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Recipient {
                    @SerializedName(value="email")
                    String email;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="name")
                    String name;
                    @SerializedName(value="phone")
                    String phone;

                    private Recipient(String email, Map<String, Object> extraParams, String name, String phone) {
                        this.email = email;
                        this.extraParams = extraParams;
                        this.name = name;
                        this.phone = phone;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public String getEmail() {
                        return this.email;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public String getName() {
                        return this.name;
                    }

                    @Generated
                    public String getPhone() {
                        return this.phone;
                    }

                    public static class Builder {
                        private String email;
                        private Map<String, Object> extraParams;
                        private String name;
                        private String phone;

                        public Recipient build() {
                            return new Recipient(this.email, this.extraParams, this.name, this.phone);
                        }

                        public Builder setEmail(String email) {
                            this.email = email;
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setName(String name) {
                            this.name = name;
                            return this;
                        }

                        public Builder setPhone(String phone) {
                            this.phone = phone;
                            return this;
                        }
                    }
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private Mode mode;
                    private Recipient recipient;

                    public Delivery build() {
                        return new Delivery(this.extraParams, this.mode, this.recipient);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setMode(Mode mode) {
                        this.mode = mode;
                        return this;
                    }

                    public Builder setRecipient(Recipient recipient) {
                        this.recipient = recipient;
                        return this;
                    }
                }
            }

            public static class PickupAddress {
                @SerializedName(value="city")
                String city;
                @SerializedName(value="country")
                String country;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="line1")
                String line1;
                @SerializedName(value="line2")
                String line2;
                @SerializedName(value="postal_code")
                String postalCode;
                @SerializedName(value="state")
                String state;

                private PickupAddress(String city, String country, Map<String, Object> extraParams, String line1, String line2, String postalCode, String state) {
                    this.city = city;
                    this.country = country;
                    this.extraParams = extraParams;
                    this.line1 = line1;
                    this.line2 = line2;
                    this.postalCode = postalCode;
                    this.state = state;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public String getCity() {
                    return this.city;
                }

                @Generated
                public String getCountry() {
                    return this.country;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getLine1() {
                    return this.line1;
                }

                @Generated
                public String getLine2() {
                    return this.line2;
                }

                @Generated
                public String getPostalCode() {
                    return this.postalCode;
                }

                @Generated
                public String getState() {
                    return this.state;
                }

                public static class Builder {
                    private String city;
                    private String country;
                    private Map<String, Object> extraParams;
                    private String line1;
                    private String line2;
                    private String postalCode;
                    private String state;

                    public PickupAddress build() {
                        return new PickupAddress(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
                    }

                    public Builder setCity(String city) {
                        this.city = city;
                        return this;
                    }

                    public Builder setCountry(String country) {
                        this.country = country;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setLine1(String line1) {
                        this.line1 = line1;
                        return this;
                    }

                    public Builder setLine2(String line2) {
                        this.line2 = line2;
                        return this;
                    }

                    public Builder setPostalCode(String postalCode) {
                        this.postalCode = postalCode;
                        return this;
                    }

                    public Builder setState(String state) {
                        this.state = state;
                        return this;
                    }
                }
            }

            public static enum RateInterval implements ApiRequestParams.EnumParam
            {
                DAY("day"),
                MONTH("month"),
                WEEK("week");

                private final String value;

                private RateInterval(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class ReturnAddress {
                @SerializedName(value="city")
                String city;
                @SerializedName(value="country")
                String country;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="line1")
                String line1;
                @SerializedName(value="line2")
                String line2;
                @SerializedName(value="postal_code")
                String postalCode;
                @SerializedName(value="state")
                String state;

                private ReturnAddress(String city, String country, Map<String, Object> extraParams, String line1, String line2, String postalCode, String state) {
                    this.city = city;
                    this.country = country;
                    this.extraParams = extraParams;
                    this.line1 = line1;
                    this.line2 = line2;
                    this.postalCode = postalCode;
                    this.state = state;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public String getCity() {
                    return this.city;
                }

                @Generated
                public String getCountry() {
                    return this.country;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getLine1() {
                    return this.line1;
                }

                @Generated
                public String getLine2() {
                    return this.line2;
                }

                @Generated
                public String getPostalCode() {
                    return this.postalCode;
                }

                @Generated
                public String getState() {
                    return this.state;
                }

                public static class Builder {
                    private String city;
                    private String country;
                    private Map<String, Object> extraParams;
                    private String line1;
                    private String line2;
                    private String postalCode;
                    private String state;

                    public ReturnAddress build() {
                        return new ReturnAddress(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
                    }

                    public Builder setCity(String city) {
                        this.city = city;
                        return this;
                    }

                    public Builder setCountry(String country) {
                        this.country = country;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setLine1(String line1) {
                        this.line1 = line1;
                        return this;
                    }

                    public Builder setLine2(String line2) {
                        this.line2 = line2;
                        return this;
                    }

                    public Builder setPostalCode(String postalCode) {
                        this.postalCode = postalCode;
                        return this;
                    }

                    public Builder setState(String state) {
                        this.state = state;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Affiliate affiliate;
                private String bookingNumber;
                private String carClassCode;
                private String carMake;
                private String carModel;
                private String company;
                private String customerServicePhoneNumber;
                private Long daysRented;
                private Delivery delivery;
                private List<Driver> drivers;
                private List<ExtraCharge> extraCharges;
                private Map<String, Object> extraParams;
                private Boolean noShow;
                private PickupAddress pickupAddress;
                private Long pickupAt;
                private Long rateAmount;
                private RateInterval rateInterval;
                private String renterName;
                private ReturnAddress returnAddress;
                private Long returnAt;
                private Boolean taxExempt;

                public CarRental build() {
                    return new CarRental(this.affiliate, this.bookingNumber, this.carClassCode, this.carMake, this.carModel, this.company, this.customerServicePhoneNumber, this.daysRented, this.delivery, this.drivers, this.extraCharges, this.extraParams, this.noShow, this.pickupAddress, this.pickupAt, this.rateAmount, this.rateInterval, this.renterName, this.returnAddress, this.returnAt, this.taxExempt);
                }

                public Builder setAffiliate(Affiliate affiliate) {
                    this.affiliate = affiliate;
                    return this;
                }

                public Builder setBookingNumber(String bookingNumber) {
                    this.bookingNumber = bookingNumber;
                    return this;
                }

                public Builder setCarClassCode(String carClassCode) {
                    this.carClassCode = carClassCode;
                    return this;
                }

                public Builder setCarMake(String carMake) {
                    this.carMake = carMake;
                    return this;
                }

                public Builder setCarModel(String carModel) {
                    this.carModel = carModel;
                    return this;
                }

                public Builder setCompany(String company) {
                    this.company = company;
                    return this;
                }

                public Builder setCustomerServicePhoneNumber(String customerServicePhoneNumber) {
                    this.customerServicePhoneNumber = customerServicePhoneNumber;
                    return this;
                }

                public Builder setDaysRented(Long daysRented) {
                    this.daysRented = daysRented;
                    return this;
                }

                public Builder setDelivery(Delivery delivery) {
                    this.delivery = delivery;
                    return this;
                }

                public Builder addDriver(Driver element) {
                    if (this.drivers == null) {
                        this.drivers = new ArrayList<Driver>();
                    }
                    this.drivers.add(element);
                    return this;
                }

                public Builder addAllDriver(List<Driver> elements) {
                    if (this.drivers == null) {
                        this.drivers = new ArrayList<Driver>();
                    }
                    this.drivers.addAll(elements);
                    return this;
                }

                public Builder addExtraCharge(ExtraCharge element) {
                    if (this.extraCharges == null) {
                        this.extraCharges = new ArrayList<ExtraCharge>();
                    }
                    this.extraCharges.add(element);
                    return this;
                }

                public Builder addAllExtraCharge(List<ExtraCharge> elements) {
                    if (this.extraCharges == null) {
                        this.extraCharges = new ArrayList<ExtraCharge>();
                    }
                    this.extraCharges.addAll(elements);
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setNoShow(Boolean noShow) {
                    this.noShow = noShow;
                    return this;
                }

                public Builder setPickupAddress(PickupAddress pickupAddress) {
                    this.pickupAddress = pickupAddress;
                    return this;
                }

                public Builder setPickupAt(Long pickupAt) {
                    this.pickupAt = pickupAt;
                    return this;
                }

                public Builder setRateAmount(Long rateAmount) {
                    this.rateAmount = rateAmount;
                    return this;
                }

                public Builder setRateInterval(RateInterval rateInterval) {
                    this.rateInterval = rateInterval;
                    return this;
                }

                public Builder setRenterName(String renterName) {
                    this.renterName = renterName;
                    return this;
                }

                public Builder setReturnAddress(ReturnAddress returnAddress) {
                    this.returnAddress = returnAddress;
                    return this;
                }

                public Builder setReturnAt(Long returnAt) {
                    this.returnAt = returnAt;
                    return this;
                }

                public Builder setTaxExempt(Boolean taxExempt) {
                    this.taxExempt = taxExempt;
                    return this;
                }
            }

            public static enum ExtraCharge implements ApiRequestParams.EnumParam
            {
                EXTRA_MILEAGE("extra_mileage"),
                GAS("gas"),
                LATE_RETURN("late_return"),
                ONE_WAY_SERVICE("one_way_service"),
                PARKING_VIOLATION("parking_violation");

                private final String value;

                private ExtraCharge(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Driver {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="name")
                String name;

                private Driver(Map<String, Object> extraParams, String name) {
                    this.extraParams = extraParams;
                    this.name = name;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getName() {
                    return this.name;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private String name;

                    public Driver build() {
                        return new Driver(this.extraParams, this.name);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setName(String name) {
                        this.name = name;
                        return this;
                    }
                }
            }
        }

        public static class EventDetails {
            @SerializedName(value="access_controlled_venue")
            Boolean accessControlledVenue;
            @SerializedName(value="address")
            Address address;
            @SerializedName(value="affiliate")
            Affiliate affiliate;
            @SerializedName(value="company")
            String company;
            @SerializedName(value="delivery")
            Delivery delivery;
            @SerializedName(value="ends_at")
            Long endsAt;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="genre")
            String genre;
            @SerializedName(value="name")
            String name;
            @SerializedName(value="starts_at")
            Long startsAt;

            private EventDetails(Boolean accessControlledVenue, Address address, Affiliate affiliate, String company, Delivery delivery, Long endsAt, Map<String, Object> extraParams, String genre, String name, Long startsAt) {
                this.accessControlledVenue = accessControlledVenue;
                this.address = address;
                this.affiliate = affiliate;
                this.company = company;
                this.delivery = delivery;
                this.endsAt = endsAt;
                this.extraParams = extraParams;
                this.genre = genre;
                this.name = name;
                this.startsAt = startsAt;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Boolean getAccessControlledVenue() {
                return this.accessControlledVenue;
            }

            @Generated
            public Address getAddress() {
                return this.address;
            }

            @Generated
            public Affiliate getAffiliate() {
                return this.affiliate;
            }

            @Generated
            public String getCompany() {
                return this.company;
            }

            @Generated
            public Delivery getDelivery() {
                return this.delivery;
            }

            @Generated
            public Long getEndsAt() {
                return this.endsAt;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getGenre() {
                return this.genre;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public Long getStartsAt() {
                return this.startsAt;
            }

            public static class Address {
                @SerializedName(value="city")
                String city;
                @SerializedName(value="country")
                String country;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="line1")
                String line1;
                @SerializedName(value="line2")
                String line2;
                @SerializedName(value="postal_code")
                String postalCode;
                @SerializedName(value="state")
                String state;

                private Address(String city, String country, Map<String, Object> extraParams, String line1, String line2, String postalCode, String state) {
                    this.city = city;
                    this.country = country;
                    this.extraParams = extraParams;
                    this.line1 = line1;
                    this.line2 = line2;
                    this.postalCode = postalCode;
                    this.state = state;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public String getCity() {
                    return this.city;
                }

                @Generated
                public String getCountry() {
                    return this.country;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getLine1() {
                    return this.line1;
                }

                @Generated
                public String getLine2() {
                    return this.line2;
                }

                @Generated
                public String getPostalCode() {
                    return this.postalCode;
                }

                @Generated
                public String getState() {
                    return this.state;
                }

                public static class Builder {
                    private String city;
                    private String country;
                    private Map<String, Object> extraParams;
                    private String line1;
                    private String line2;
                    private String postalCode;
                    private String state;

                    public Address build() {
                        return new Address(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
                    }

                    public Builder setCity(String city) {
                        this.city = city;
                        return this;
                    }

                    public Builder setCountry(String country) {
                        this.country = country;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setLine1(String line1) {
                        this.line1 = line1;
                        return this;
                    }

                    public Builder setLine2(String line2) {
                        this.line2 = line2;
                        return this;
                    }

                    public Builder setPostalCode(String postalCode) {
                        this.postalCode = postalCode;
                        return this;
                    }

                    public Builder setState(String state) {
                        this.state = state;
                        return this;
                    }
                }
            }

            public static class Affiliate {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="name")
                String name;

                private Affiliate(Map<String, Object> extraParams, String name) {
                    this.extraParams = extraParams;
                    this.name = name;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getName() {
                    return this.name;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private String name;

                    public Affiliate build() {
                        return new Affiliate(this.extraParams, this.name);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setName(String name) {
                        this.name = name;
                        return this;
                    }
                }
            }

            public static class Delivery {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="mode")
                Mode mode;
                @SerializedName(value="recipient")
                Recipient recipient;

                private Delivery(Map<String, Object> extraParams, Mode mode, Recipient recipient) {
                    this.extraParams = extraParams;
                    this.mode = mode;
                    this.recipient = recipient;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Mode getMode() {
                    return this.mode;
                }

                @Generated
                public Recipient getRecipient() {
                    return this.recipient;
                }

                public static enum Mode implements ApiRequestParams.EnumParam
                {
                    EMAIL("email"),
                    PHONE("phone"),
                    PICKUP("pickup"),
                    POST("post");

                    private final String value;

                    private Mode(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Recipient {
                    @SerializedName(value="email")
                    String email;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="name")
                    String name;
                    @SerializedName(value="phone")
                    String phone;

                    private Recipient(String email, Map<String, Object> extraParams, String name, String phone) {
                        this.email = email;
                        this.extraParams = extraParams;
                        this.name = name;
                        this.phone = phone;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public String getEmail() {
                        return this.email;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public String getName() {
                        return this.name;
                    }

                    @Generated
                    public String getPhone() {
                        return this.phone;
                    }

                    public static class Builder {
                        private String email;
                        private Map<String, Object> extraParams;
                        private String name;
                        private String phone;

                        public Recipient build() {
                            return new Recipient(this.email, this.extraParams, this.name, this.phone);
                        }

                        public Builder setEmail(String email) {
                            this.email = email;
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setName(String name) {
                            this.name = name;
                            return this;
                        }

                        public Builder setPhone(String phone) {
                            this.phone = phone;
                            return this;
                        }
                    }
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private Mode mode;
                    private Recipient recipient;

                    public Delivery build() {
                        return new Delivery(this.extraParams, this.mode, this.recipient);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setMode(Mode mode) {
                        this.mode = mode;
                        return this;
                    }

                    public Builder setRecipient(Recipient recipient) {
                        this.recipient = recipient;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Boolean accessControlledVenue;
                private Address address;
                private Affiliate affiliate;
                private String company;
                private Delivery delivery;
                private Long endsAt;
                private Map<String, Object> extraParams;
                private String genre;
                private String name;
                private Long startsAt;

                public EventDetails build() {
                    return new EventDetails(this.accessControlledVenue, this.address, this.affiliate, this.company, this.delivery, this.endsAt, this.extraParams, this.genre, this.name, this.startsAt);
                }

                public Builder setAccessControlledVenue(Boolean accessControlledVenue) {
                    this.accessControlledVenue = accessControlledVenue;
                    return this;
                }

                public Builder setAddress(Address address) {
                    this.address = address;
                    return this;
                }

                public Builder setAffiliate(Affiliate affiliate) {
                    this.affiliate = affiliate;
                    return this;
                }

                public Builder setCompany(String company) {
                    this.company = company;
                    return this;
                }

                public Builder setDelivery(Delivery delivery) {
                    this.delivery = delivery;
                    return this;
                }

                public Builder setEndsAt(Long endsAt) {
                    this.endsAt = endsAt;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setGenre(String genre) {
                    this.genre = genre;
                    return this;
                }

                public Builder setName(String name) {
                    this.name = name;
                    return this;
                }

                public Builder setStartsAt(Long startsAt) {
                    this.startsAt = startsAt;
                    return this;
                }
            }
        }

        public static class Flight {
            @SerializedName(value="affiliate")
            Affiliate affiliate;
            @SerializedName(value="agency_number")
            String agencyNumber;
            @SerializedName(value="carrier")
            String carrier;
            @SerializedName(value="delivery")
            Delivery delivery;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="passenger_name")
            String passengerName;
            @SerializedName(value="passengers")
            List<Passenger> passengers;
            @SerializedName(value="segments")
            List<Segment> segments;
            @SerializedName(value="ticket_number")
            String ticketNumber;

            private Flight(Affiliate affiliate, String agencyNumber, String carrier, Delivery delivery, Map<String, Object> extraParams, String passengerName, List<Passenger> passengers, List<Segment> segments, String ticketNumber) {
                this.affiliate = affiliate;
                this.agencyNumber = agencyNumber;
                this.carrier = carrier;
                this.delivery = delivery;
                this.extraParams = extraParams;
                this.passengerName = passengerName;
                this.passengers = passengers;
                this.segments = segments;
                this.ticketNumber = ticketNumber;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Affiliate getAffiliate() {
                return this.affiliate;
            }

            @Generated
            public String getAgencyNumber() {
                return this.agencyNumber;
            }

            @Generated
            public String getCarrier() {
                return this.carrier;
            }

            @Generated
            public Delivery getDelivery() {
                return this.delivery;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getPassengerName() {
                return this.passengerName;
            }

            @Generated
            public List<Passenger> getPassengers() {
                return this.passengers;
            }

            @Generated
            public List<Segment> getSegments() {
                return this.segments;
            }

            @Generated
            public String getTicketNumber() {
                return this.ticketNumber;
            }

            public static class Affiliate {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="name")
                String name;

                private Affiliate(Map<String, Object> extraParams, String name) {
                    this.extraParams = extraParams;
                    this.name = name;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getName() {
                    return this.name;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private String name;

                    public Affiliate build() {
                        return new Affiliate(this.extraParams, this.name);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setName(String name) {
                        this.name = name;
                        return this;
                    }
                }
            }

            public static class Delivery {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="mode")
                Mode mode;
                @SerializedName(value="recipient")
                Recipient recipient;

                private Delivery(Map<String, Object> extraParams, Mode mode, Recipient recipient) {
                    this.extraParams = extraParams;
                    this.mode = mode;
                    this.recipient = recipient;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Mode getMode() {
                    return this.mode;
                }

                @Generated
                public Recipient getRecipient() {
                    return this.recipient;
                }

                public static enum Mode implements ApiRequestParams.EnumParam
                {
                    EMAIL("email"),
                    PHONE("phone"),
                    PICKUP("pickup"),
                    POST("post");

                    private final String value;

                    private Mode(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Recipient {
                    @SerializedName(value="email")
                    String email;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="name")
                    String name;
                    @SerializedName(value="phone")
                    String phone;

                    private Recipient(String email, Map<String, Object> extraParams, String name, String phone) {
                        this.email = email;
                        this.extraParams = extraParams;
                        this.name = name;
                        this.phone = phone;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public String getEmail() {
                        return this.email;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public String getName() {
                        return this.name;
                    }

                    @Generated
                    public String getPhone() {
                        return this.phone;
                    }

                    public static class Builder {
                        private String email;
                        private Map<String, Object> extraParams;
                        private String name;
                        private String phone;

                        public Recipient build() {
                            return new Recipient(this.email, this.extraParams, this.name, this.phone);
                        }

                        public Builder setEmail(String email) {
                            this.email = email;
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setName(String name) {
                            this.name = name;
                            return this;
                        }

                        public Builder setPhone(String phone) {
                            this.phone = phone;
                            return this;
                        }
                    }
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private Mode mode;
                    private Recipient recipient;

                    public Delivery build() {
                        return new Delivery(this.extraParams, this.mode, this.recipient);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setMode(Mode mode) {
                        this.mode = mode;
                        return this;
                    }

                    public Builder setRecipient(Recipient recipient) {
                        this.recipient = recipient;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Affiliate affiliate;
                private String agencyNumber;
                private String carrier;
                private Delivery delivery;
                private Map<String, Object> extraParams;
                private String passengerName;
                private List<Passenger> passengers;
                private List<Segment> segments;
                private String ticketNumber;

                public Flight build() {
                    return new Flight(this.affiliate, this.agencyNumber, this.carrier, this.delivery, this.extraParams, this.passengerName, this.passengers, this.segments, this.ticketNumber);
                }

                public Builder setAffiliate(Affiliate affiliate) {
                    this.affiliate = affiliate;
                    return this;
                }

                public Builder setAgencyNumber(String agencyNumber) {
                    this.agencyNumber = agencyNumber;
                    return this;
                }

                public Builder setCarrier(String carrier) {
                    this.carrier = carrier;
                    return this;
                }

                public Builder setDelivery(Delivery delivery) {
                    this.delivery = delivery;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setPassengerName(String passengerName) {
                    this.passengerName = passengerName;
                    return this;
                }

                public Builder addPassenger(Passenger element) {
                    if (this.passengers == null) {
                        this.passengers = new ArrayList<Passenger>();
                    }
                    this.passengers.add(element);
                    return this;
                }

                public Builder addAllPassenger(List<Passenger> elements) {
                    if (this.passengers == null) {
                        this.passengers = new ArrayList<Passenger>();
                    }
                    this.passengers.addAll(elements);
                    return this;
                }

                public Builder addSegment(Segment element) {
                    if (this.segments == null) {
                        this.segments = new ArrayList<Segment>();
                    }
                    this.segments.add(element);
                    return this;
                }

                public Builder addAllSegment(List<Segment> elements) {
                    if (this.segments == null) {
                        this.segments = new ArrayList<Segment>();
                    }
                    this.segments.addAll(elements);
                    return this;
                }

                public Builder setTicketNumber(String ticketNumber) {
                    this.ticketNumber = ticketNumber;
                    return this;
                }
            }

            public static class Segment {
                @SerializedName(value="arrival_airport")
                String arrivalAirport;
                @SerializedName(value="arrives_at")
                Long arrivesAt;
                @SerializedName(value="carrier")
                String carrier;
                @SerializedName(value="departs_at")
                Long departsAt;
                @SerializedName(value="departure_airport")
                String departureAirport;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="flight_number")
                String flightNumber;
                @SerializedName(value="service_class")
                ServiceClass serviceClass;

                private Segment(String arrivalAirport, Long arrivesAt, String carrier, Long departsAt, String departureAirport, Map<String, Object> extraParams, String flightNumber, ServiceClass serviceClass) {
                    this.arrivalAirport = arrivalAirport;
                    this.arrivesAt = arrivesAt;
                    this.carrier = carrier;
                    this.departsAt = departsAt;
                    this.departureAirport = departureAirport;
                    this.extraParams = extraParams;
                    this.flightNumber = flightNumber;
                    this.serviceClass = serviceClass;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public String getArrivalAirport() {
                    return this.arrivalAirport;
                }

                @Generated
                public Long getArrivesAt() {
                    return this.arrivesAt;
                }

                @Generated
                public String getCarrier() {
                    return this.carrier;
                }

                @Generated
                public Long getDepartsAt() {
                    return this.departsAt;
                }

                @Generated
                public String getDepartureAirport() {
                    return this.departureAirport;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getFlightNumber() {
                    return this.flightNumber;
                }

                @Generated
                public ServiceClass getServiceClass() {
                    return this.serviceClass;
                }

                public static enum ServiceClass implements ApiRequestParams.EnumParam
                {
                    BUSINESS("business"),
                    ECONOMY("economy"),
                    FIRST("first"),
                    PREMIUM_ECONOMY("premium_economy");

                    private final String value;

                    private ServiceClass(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private String arrivalAirport;
                    private Long arrivesAt;
                    private String carrier;
                    private Long departsAt;
                    private String departureAirport;
                    private Map<String, Object> extraParams;
                    private String flightNumber;
                    private ServiceClass serviceClass;

                    public Segment build() {
                        return new Segment(this.arrivalAirport, this.arrivesAt, this.carrier, this.departsAt, this.departureAirport, this.extraParams, this.flightNumber, this.serviceClass);
                    }

                    public Builder setArrivalAirport(String arrivalAirport) {
                        this.arrivalAirport = arrivalAirport;
                        return this;
                    }

                    public Builder setArrivesAt(Long arrivesAt) {
                        this.arrivesAt = arrivesAt;
                        return this;
                    }

                    public Builder setCarrier(String carrier) {
                        this.carrier = carrier;
                        return this;
                    }

                    public Builder setDepartsAt(Long departsAt) {
                        this.departsAt = departsAt;
                        return this;
                    }

                    public Builder setDepartureAirport(String departureAirport) {
                        this.departureAirport = departureAirport;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setFlightNumber(String flightNumber) {
                        this.flightNumber = flightNumber;
                        return this;
                    }

                    public Builder setServiceClass(ServiceClass serviceClass) {
                        this.serviceClass = serviceClass;
                        return this;
                    }
                }
            }

            public static class Passenger {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="name")
                String name;

                private Passenger(Map<String, Object> extraParams, String name) {
                    this.extraParams = extraParams;
                    this.name = name;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getName() {
                    return this.name;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private String name;

                    public Passenger build() {
                        return new Passenger(this.extraParams, this.name);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setName(String name) {
                        this.name = name;
                        return this;
                    }
                }
            }
        }

        public static class Lodging {
            @SerializedName(value="address")
            Address address;
            @SerializedName(value="adults")
            Long adults;
            @SerializedName(value="affiliate")
            Affiliate affiliate;
            @SerializedName(value="booking_number")
            String bookingNumber;
            @SerializedName(value="category")
            Category category;
            @SerializedName(value="checkin_at")
            Long checkinAt;
            @SerializedName(value="checkout_at")
            Long checkoutAt;
            @SerializedName(value="customer_service_phone_number")
            String customerServicePhoneNumber;
            @SerializedName(value="daily_room_rate_amount")
            Long dailyRoomRateAmount;
            @SerializedName(value="delivery")
            Delivery delivery;
            @SerializedName(value="extra_charges")
            List<ExtraCharge> extraCharges;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="fire_safety_act_compliance")
            Boolean fireSafetyActCompliance;
            @SerializedName(value="name")
            String name;
            @SerializedName(value="no_show")
            Boolean noShow;
            @SerializedName(value="passengers")
            List<Passenger> passengers;
            @SerializedName(value="property_phone_number")
            String propertyPhoneNumber;
            @SerializedName(value="room_nights")
            Long roomNights;
            @SerializedName(value="total_room_tax_amount")
            Long totalRoomTaxAmount;
            @SerializedName(value="total_tax_amount")
            Long totalTaxAmount;

            private Lodging(Address address, Long adults, Affiliate affiliate, String bookingNumber, Category category, Long checkinAt, Long checkoutAt, String customerServicePhoneNumber, Long dailyRoomRateAmount, Delivery delivery, List<ExtraCharge> extraCharges, Map<String, Object> extraParams, Boolean fireSafetyActCompliance, String name, Boolean noShow, List<Passenger> passengers, String propertyPhoneNumber, Long roomNights, Long totalRoomTaxAmount, Long totalTaxAmount) {
                this.address = address;
                this.adults = adults;
                this.affiliate = affiliate;
                this.bookingNumber = bookingNumber;
                this.category = category;
                this.checkinAt = checkinAt;
                this.checkoutAt = checkoutAt;
                this.customerServicePhoneNumber = customerServicePhoneNumber;
                this.dailyRoomRateAmount = dailyRoomRateAmount;
                this.delivery = delivery;
                this.extraCharges = extraCharges;
                this.extraParams = extraParams;
                this.fireSafetyActCompliance = fireSafetyActCompliance;
                this.name = name;
                this.noShow = noShow;
                this.passengers = passengers;
                this.propertyPhoneNumber = propertyPhoneNumber;
                this.roomNights = roomNights;
                this.totalRoomTaxAmount = totalRoomTaxAmount;
                this.totalTaxAmount = totalTaxAmount;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Address getAddress() {
                return this.address;
            }

            @Generated
            public Long getAdults() {
                return this.adults;
            }

            @Generated
            public Affiliate getAffiliate() {
                return this.affiliate;
            }

            @Generated
            public String getBookingNumber() {
                return this.bookingNumber;
            }

            @Generated
            public Category getCategory() {
                return this.category;
            }

            @Generated
            public Long getCheckinAt() {
                return this.checkinAt;
            }

            @Generated
            public Long getCheckoutAt() {
                return this.checkoutAt;
            }

            @Generated
            public String getCustomerServicePhoneNumber() {
                return this.customerServicePhoneNumber;
            }

            @Generated
            public Long getDailyRoomRateAmount() {
                return this.dailyRoomRateAmount;
            }

            @Generated
            public Delivery getDelivery() {
                return this.delivery;
            }

            @Generated
            public List<ExtraCharge> getExtraCharges() {
                return this.extraCharges;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Boolean getFireSafetyActCompliance() {
                return this.fireSafetyActCompliance;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public Boolean getNoShow() {
                return this.noShow;
            }

            @Generated
            public List<Passenger> getPassengers() {
                return this.passengers;
            }

            @Generated
            public String getPropertyPhoneNumber() {
                return this.propertyPhoneNumber;
            }

            @Generated
            public Long getRoomNights() {
                return this.roomNights;
            }

            @Generated
            public Long getTotalRoomTaxAmount() {
                return this.totalRoomTaxAmount;
            }

            @Generated
            public Long getTotalTaxAmount() {
                return this.totalTaxAmount;
            }

            public static class Address {
                @SerializedName(value="city")
                String city;
                @SerializedName(value="country")
                String country;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="line1")
                String line1;
                @SerializedName(value="line2")
                String line2;
                @SerializedName(value="postal_code")
                String postalCode;
                @SerializedName(value="state")
                String state;

                private Address(String city, String country, Map<String, Object> extraParams, String line1, String line2, String postalCode, String state) {
                    this.city = city;
                    this.country = country;
                    this.extraParams = extraParams;
                    this.line1 = line1;
                    this.line2 = line2;
                    this.postalCode = postalCode;
                    this.state = state;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public String getCity() {
                    return this.city;
                }

                @Generated
                public String getCountry() {
                    return this.country;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getLine1() {
                    return this.line1;
                }

                @Generated
                public String getLine2() {
                    return this.line2;
                }

                @Generated
                public String getPostalCode() {
                    return this.postalCode;
                }

                @Generated
                public String getState() {
                    return this.state;
                }

                public static class Builder {
                    private String city;
                    private String country;
                    private Map<String, Object> extraParams;
                    private String line1;
                    private String line2;
                    private String postalCode;
                    private String state;

                    public Address build() {
                        return new Address(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
                    }

                    public Builder setCity(String city) {
                        this.city = city;
                        return this;
                    }

                    public Builder setCountry(String country) {
                        this.country = country;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setLine1(String line1) {
                        this.line1 = line1;
                        return this;
                    }

                    public Builder setLine2(String line2) {
                        this.line2 = line2;
                        return this;
                    }

                    public Builder setPostalCode(String postalCode) {
                        this.postalCode = postalCode;
                        return this;
                    }

                    public Builder setState(String state) {
                        this.state = state;
                        return this;
                    }
                }
            }

            public static class Affiliate {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="name")
                String name;

                private Affiliate(Map<String, Object> extraParams, String name) {
                    this.extraParams = extraParams;
                    this.name = name;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getName() {
                    return this.name;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private String name;

                    public Affiliate build() {
                        return new Affiliate(this.extraParams, this.name);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setName(String name) {
                        this.name = name;
                        return this;
                    }
                }
            }

            public static enum Category implements ApiRequestParams.EnumParam
            {
                HOTEL("hotel"),
                VACATION_RENTAL("vacation_rental");

                private final String value;

                private Category(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Delivery {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="mode")
                Mode mode;
                @SerializedName(value="recipient")
                Recipient recipient;

                private Delivery(Map<String, Object> extraParams, Mode mode, Recipient recipient) {
                    this.extraParams = extraParams;
                    this.mode = mode;
                    this.recipient = recipient;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Mode getMode() {
                    return this.mode;
                }

                @Generated
                public Recipient getRecipient() {
                    return this.recipient;
                }

                public static enum Mode implements ApiRequestParams.EnumParam
                {
                    EMAIL("email"),
                    PHONE("phone"),
                    PICKUP("pickup"),
                    POST("post");

                    private final String value;

                    private Mode(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Recipient {
                    @SerializedName(value="email")
                    String email;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="name")
                    String name;
                    @SerializedName(value="phone")
                    String phone;

                    private Recipient(String email, Map<String, Object> extraParams, String name, String phone) {
                        this.email = email;
                        this.extraParams = extraParams;
                        this.name = name;
                        this.phone = phone;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public String getEmail() {
                        return this.email;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public String getName() {
                        return this.name;
                    }

                    @Generated
                    public String getPhone() {
                        return this.phone;
                    }

                    public static class Builder {
                        private String email;
                        private Map<String, Object> extraParams;
                        private String name;
                        private String phone;

                        public Recipient build() {
                            return new Recipient(this.email, this.extraParams, this.name, this.phone);
                        }

                        public Builder setEmail(String email) {
                            this.email = email;
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setName(String name) {
                            this.name = name;
                            return this;
                        }

                        public Builder setPhone(String phone) {
                            this.phone = phone;
                            return this;
                        }
                    }
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private Mode mode;
                    private Recipient recipient;

                    public Delivery build() {
                        return new Delivery(this.extraParams, this.mode, this.recipient);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setMode(Mode mode) {
                        this.mode = mode;
                        return this;
                    }

                    public Builder setRecipient(Recipient recipient) {
                        this.recipient = recipient;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Address address;
                private Long adults;
                private Affiliate affiliate;
                private String bookingNumber;
                private Category category;
                private Long checkinAt;
                private Long checkoutAt;
                private String customerServicePhoneNumber;
                private Long dailyRoomRateAmount;
                private Delivery delivery;
                private List<ExtraCharge> extraCharges;
                private Map<String, Object> extraParams;
                private Boolean fireSafetyActCompliance;
                private String name;
                private Boolean noShow;
                private List<Passenger> passengers;
                private String propertyPhoneNumber;
                private Long roomNights;
                private Long totalRoomTaxAmount;
                private Long totalTaxAmount;

                public Lodging build() {
                    return new Lodging(this.address, this.adults, this.affiliate, this.bookingNumber, this.category, this.checkinAt, this.checkoutAt, this.customerServicePhoneNumber, this.dailyRoomRateAmount, this.delivery, this.extraCharges, this.extraParams, this.fireSafetyActCompliance, this.name, this.noShow, this.passengers, this.propertyPhoneNumber, this.roomNights, this.totalRoomTaxAmount, this.totalTaxAmount);
                }

                public Builder setAddress(Address address) {
                    this.address = address;
                    return this;
                }

                public Builder setAdults(Long adults) {
                    this.adults = adults;
                    return this;
                }

                public Builder setAffiliate(Affiliate affiliate) {
                    this.affiliate = affiliate;
                    return this;
                }

                public Builder setBookingNumber(String bookingNumber) {
                    this.bookingNumber = bookingNumber;
                    return this;
                }

                public Builder setCategory(Category category) {
                    this.category = category;
                    return this;
                }

                public Builder setCheckinAt(Long checkinAt) {
                    this.checkinAt = checkinAt;
                    return this;
                }

                public Builder setCheckoutAt(Long checkoutAt) {
                    this.checkoutAt = checkoutAt;
                    return this;
                }

                public Builder setCustomerServicePhoneNumber(String customerServicePhoneNumber) {
                    this.customerServicePhoneNumber = customerServicePhoneNumber;
                    return this;
                }

                public Builder setDailyRoomRateAmount(Long dailyRoomRateAmount) {
                    this.dailyRoomRateAmount = dailyRoomRateAmount;
                    return this;
                }

                public Builder setDelivery(Delivery delivery) {
                    this.delivery = delivery;
                    return this;
                }

                public Builder addExtraCharge(ExtraCharge element) {
                    if (this.extraCharges == null) {
                        this.extraCharges = new ArrayList<ExtraCharge>();
                    }
                    this.extraCharges.add(element);
                    return this;
                }

                public Builder addAllExtraCharge(List<ExtraCharge> elements) {
                    if (this.extraCharges == null) {
                        this.extraCharges = new ArrayList<ExtraCharge>();
                    }
                    this.extraCharges.addAll(elements);
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setFireSafetyActCompliance(Boolean fireSafetyActCompliance) {
                    this.fireSafetyActCompliance = fireSafetyActCompliance;
                    return this;
                }

                public Builder setName(String name) {
                    this.name = name;
                    return this;
                }

                public Builder setNoShow(Boolean noShow) {
                    this.noShow = noShow;
                    return this;
                }

                public Builder addPassenger(Passenger element) {
                    if (this.passengers == null) {
                        this.passengers = new ArrayList<Passenger>();
                    }
                    this.passengers.add(element);
                    return this;
                }

                public Builder addAllPassenger(List<Passenger> elements) {
                    if (this.passengers == null) {
                        this.passengers = new ArrayList<Passenger>();
                    }
                    this.passengers.addAll(elements);
                    return this;
                }

                public Builder setPropertyPhoneNumber(String propertyPhoneNumber) {
                    this.propertyPhoneNumber = propertyPhoneNumber;
                    return this;
                }

                public Builder setRoomNights(Long roomNights) {
                    this.roomNights = roomNights;
                    return this;
                }

                public Builder setTotalRoomTaxAmount(Long totalRoomTaxAmount) {
                    this.totalRoomTaxAmount = totalRoomTaxAmount;
                    return this;
                }

                public Builder setTotalTaxAmount(Long totalTaxAmount) {
                    this.totalTaxAmount = totalTaxAmount;
                    return this;
                }
            }

            public static enum ExtraCharge implements ApiRequestParams.EnumParam
            {
                GIFT_SHOP("gift_shop"),
                LAUNDRY("laundry"),
                MINI_BAR("mini_bar"),
                OTHER("other"),
                RESTAURANT("restaurant"),
                TELEPHONE("telephone");

                private final String value;

                private ExtraCharge(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Passenger {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="name")
                String name;

                private Passenger(Map<String, Object> extraParams, String name) {
                    this.extraParams = extraParams;
                    this.name = name;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getName() {
                    return this.name;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private String name;

                    public Passenger build() {
                        return new Passenger(this.extraParams, this.name);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setName(String name) {
                        this.name = name;
                        return this;
                    }
                }
            }
        }

        public static class Subscription {
            @SerializedName(value="affiliate")
            Affiliate affiliate;
            @SerializedName(value="auto_renewal")
            Boolean autoRenewal;
            @SerializedName(value="billing_interval")
            BillingInterval billingInterval;
            @SerializedName(value="ends_at")
            Long endsAt;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="name")
            String name;
            @SerializedName(value="starts_at")
            Long startsAt;

            private Subscription(Affiliate affiliate, Boolean autoRenewal, BillingInterval billingInterval, Long endsAt, Map<String, Object> extraParams, String name, Long startsAt) {
                this.affiliate = affiliate;
                this.autoRenewal = autoRenewal;
                this.billingInterval = billingInterval;
                this.endsAt = endsAt;
                this.extraParams = extraParams;
                this.name = name;
                this.startsAt = startsAt;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Affiliate getAffiliate() {
                return this.affiliate;
            }

            @Generated
            public Boolean getAutoRenewal() {
                return this.autoRenewal;
            }

            @Generated
            public BillingInterval getBillingInterval() {
                return this.billingInterval;
            }

            @Generated
            public Long getEndsAt() {
                return this.endsAt;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public Long getStartsAt() {
                return this.startsAt;
            }

            public static class Affiliate {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="name")
                String name;

                private Affiliate(Map<String, Object> extraParams, String name) {
                    this.extraParams = extraParams;
                    this.name = name;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getName() {
                    return this.name;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private String name;

                    public Affiliate build() {
                        return new Affiliate(this.extraParams, this.name);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setName(String name) {
                        this.name = name;
                        return this;
                    }
                }
            }

            public static class BillingInterval {
                @SerializedName(value="count")
                Long count;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="interval")
                Interval interval;

                private BillingInterval(Long count, Map<String, Object> extraParams, Interval interval) {
                    this.count = count;
                    this.extraParams = extraParams;
                    this.interval = interval;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Long getCount() {
                    return this.count;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Interval getInterval() {
                    return this.interval;
                }

                public static enum Interval implements ApiRequestParams.EnumParam
                {
                    DAY("day"),
                    MONTH("month"),
                    WEEK("week"),
                    YEAR("year");

                    private final String value;

                    private Interval(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Long count;
                    private Map<String, Object> extraParams;
                    private Interval interval;

                    public BillingInterval build() {
                        return new BillingInterval(this.count, this.extraParams, this.interval);
                    }

                    public Builder setCount(Long count) {
                        this.count = count;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setInterval(Interval interval) {
                        this.interval = interval;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Affiliate affiliate;
                private Boolean autoRenewal;
                private BillingInterval billingInterval;
                private Long endsAt;
                private Map<String, Object> extraParams;
                private String name;
                private Long startsAt;

                public Subscription build() {
                    return new Subscription(this.affiliate, this.autoRenewal, this.billingInterval, this.endsAt, this.extraParams, this.name, this.startsAt);
                }

                public Builder setAffiliate(Affiliate affiliate) {
                    this.affiliate = affiliate;
                    return this;
                }

                public Builder setAutoRenewal(Boolean autoRenewal) {
                    this.autoRenewal = autoRenewal;
                    return this;
                }

                public Builder setBillingInterval(BillingInterval billingInterval) {
                    this.billingInterval = billingInterval;
                    return this;
                }

                public Builder setEndsAt(Long endsAt) {
                    this.endsAt = endsAt;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setName(String name) {
                    this.name = name;
                    return this;
                }

                public Builder setStartsAt(Long startsAt) {
                    this.startsAt = startsAt;
                    return this;
                }
            }
        }

        public static class Builder {
            private CarRental carRental;
            private EventDetails eventDetails;
            private Map<String, Object> extraParams;
            private Flight flight;
            private Lodging lodging;
            private Subscription subscription;

            public PaymentDetails build() {
                return new PaymentDetails(this.carRental, this.eventDetails, this.extraParams, this.flight, this.lodging, this.subscription);
            }

            public Builder setCarRental(CarRental carRental) {
                this.carRental = carRental;
                return this;
            }

            public Builder setEventDetails(EventDetails eventDetails) {
                this.eventDetails = eventDetails;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setFlight(Flight flight) {
                this.flight = flight;
                return this;
            }

            public Builder setLodging(Lodging lodging) {
                this.lodging = lodging;
                return this;
            }

            public Builder setSubscription(Subscription subscription) {
                this.subscription = subscription;
                return this;
            }
        }
    }
}

