/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.CreditNote;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.CreditNoteCreateParams;
import com.stripe.param.CreditNoteListParams;
import com.stripe.param.CreditNotePreviewParams;
import com.stripe.param.CreditNoteRetrieveParams;
import com.stripe.param.CreditNoteUpdateParams;
import com.stripe.param.CreditNoteVoidCreditNoteParams;
import com.stripe.service.CreditNoteLineItemService;
import com.stripe.service.CreditNotePreviewLinesService;
import java.lang.reflect.Type;

public final class CreditNoteService
extends ApiService {
    public CreditNoteService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public CreditNote create(CreditNoteCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public CreditNote create(CreditNoteCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/credit_notes";
        return (CreditNote)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)CreditNote.class), options, ApiMode.V1);
    }

    public StripeCollection<CreditNote> list(CreditNoteListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<CreditNote> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<CreditNote> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<CreditNote> list(CreditNoteListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/credit_notes";
        return (StripeCollection)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), new TypeToken<StripeCollection<CreditNote>>(){}.getType(), options, ApiMode.V1);
    }

    public CreditNote preview(CreditNotePreviewParams params) throws StripeException {
        return this.preview(params, null);
    }

    public CreditNote preview(CreditNotePreviewParams params, RequestOptions options) throws StripeException {
        String path = "/v1/credit_notes/preview";
        return (CreditNote)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)CreditNote.class), options, ApiMode.V1);
    }

    public CreditNote retrieve(String id, CreditNoteRetrieveParams params) throws StripeException {
        return this.retrieve(id, params, null);
    }

    public CreditNote retrieve(String id, RequestOptions options) throws StripeException {
        return this.retrieve(id, null, options);
    }

    public CreditNote retrieve(String id) throws StripeException {
        return this.retrieve(id, null, null);
    }

    public CreditNote retrieve(String id, CreditNoteRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/credit_notes/%s", ApiResource.urlEncodeId(id));
        return (CreditNote)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)CreditNote.class), options, ApiMode.V1);
    }

    public CreditNote update(String id, CreditNoteUpdateParams params) throws StripeException {
        return this.update(id, params, null);
    }

    public CreditNote update(String id, RequestOptions options) throws StripeException {
        return this.update(id, null, options);
    }

    public CreditNote update(String id) throws StripeException {
        return this.update(id, null, null);
    }

    public CreditNote update(String id, CreditNoteUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/credit_notes/%s", ApiResource.urlEncodeId(id));
        return (CreditNote)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)CreditNote.class), options, ApiMode.V1);
    }

    public CreditNote voidCreditNote(String id, CreditNoteVoidCreditNoteParams params) throws StripeException {
        return this.voidCreditNote(id, params, null);
    }

    public CreditNote voidCreditNote(String id, RequestOptions options) throws StripeException {
        return this.voidCreditNote(id, null, options);
    }

    public CreditNote voidCreditNote(String id) throws StripeException {
        return this.voidCreditNote(id, null, null);
    }

    public CreditNote voidCreditNote(String id, CreditNoteVoidCreditNoteParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/credit_notes/%s/void", ApiResource.urlEncodeId(id));
        return (CreditNote)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)CreditNote.class), options, ApiMode.V1);
    }

    public CreditNoteLineItemService lineItems() {
        return new CreditNoteLineItemService(this.getResponseGetter());
    }

    public CreditNotePreviewLinesService previewLines() {
        return new CreditNotePreviewLinesService(this.getResponseGetter());
    }
}

