/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.Margin;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.MarginCreateParams;
import com.stripe.param.MarginListParams;
import com.stripe.param.MarginRetrieveParams;
import com.stripe.param.MarginUpdateParams;
import java.lang.reflect.Type;

public final class MarginService
extends ApiService {
    public MarginService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public Margin create(MarginCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Margin create(MarginCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/billing/margins";
        return (Margin)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Margin.class), options, ApiMode.V1);
    }

    public StripeCollection<Margin> list(MarginListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Margin> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Margin> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Margin> list(MarginListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/billing/margins";
        return (StripeCollection)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), new TypeToken<StripeCollection<Margin>>(){}.getType(), options, ApiMode.V1);
    }

    public Margin retrieve(String margin, MarginRetrieveParams params) throws StripeException {
        return this.retrieve(margin, params, null);
    }

    public Margin retrieve(String margin, RequestOptions options) throws StripeException {
        return this.retrieve(margin, null, options);
    }

    public Margin retrieve(String margin) throws StripeException {
        return this.retrieve(margin, null, null);
    }

    public Margin retrieve(String margin, MarginRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/margins/%s", ApiResource.urlEncodeId(margin));
        return (Margin)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Margin.class), options, ApiMode.V1);
    }

    public Margin update(String margin, MarginUpdateParams params) throws StripeException {
        return this.update(margin, params, null);
    }

    public Margin update(String margin, RequestOptions options) throws StripeException {
        return this.update(margin, null, options);
    }

    public Margin update(String margin) throws StripeException {
        return this.update(margin, null, null);
    }

    public Margin update(String margin, MarginUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/margins/%s", ApiResource.urlEncodeId(margin));
        return (Margin)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Margin.class), options, ApiMode.V1);
    }
}

