/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.giftcards;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.giftcards.Card;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.giftcards.CardCreateParams;
import com.stripe.param.giftcards.CardListParams;
import com.stripe.param.giftcards.CardRetrieveParams;
import com.stripe.param.giftcards.CardUpdateParams;
import com.stripe.param.giftcards.CardValidateParams;
import java.lang.reflect.Type;

public final class CardService
extends ApiService {
    public CardService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public Card create(CardCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Card create(CardCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/gift_cards/cards";
        return (Card)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Card.class), options, ApiMode.V1);
    }

    public StripeCollection<Card> list(CardListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Card> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Card> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Card> list(CardListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/gift_cards/cards";
        return (StripeCollection)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), new TypeToken<StripeCollection<Card>>(){}.getType(), options, ApiMode.V1);
    }

    public Card validate(CardValidateParams params) throws StripeException {
        return this.validate(params, null);
    }

    public Card validate(CardValidateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/gift_cards/cards/validate";
        return (Card)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Card.class), options, ApiMode.V1);
    }

    public Card retrieve(String id, CardRetrieveParams params) throws StripeException {
        return this.retrieve(id, params, null);
    }

    public Card retrieve(String id, RequestOptions options) throws StripeException {
        return this.retrieve(id, null, options);
    }

    public Card retrieve(String id) throws StripeException {
        return this.retrieve(id, null, null);
    }

    public Card retrieve(String id, CardRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/gift_cards/cards/%s", ApiResource.urlEncodeId(id));
        return (Card)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Card.class), options, ApiMode.V1);
    }

    public Card update(String id, CardUpdateParams params) throws StripeException {
        return this.update(id, params, null);
    }

    public Card update(String id, RequestOptions options) throws StripeException {
        return this.update(id, null, options);
    }

    public Card update(String id) throws StripeException {
        return this.update(id, null, null);
    }

    public Card update(String id, CardUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/gift_cards/cards/%s", ApiResource.urlEncodeId(id));
        return (Card)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Card.class), options, ApiMode.V1);
    }
}

