/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.Product;
import com.stripe.model.StripeCollection;
import com.stripe.model.StripeSearchResult;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.ProductCreateParams;
import com.stripe.param.ProductListParams;
import com.stripe.param.ProductRetrieveParams;
import com.stripe.param.ProductSearchParams;
import com.stripe.param.ProductUpdateParams;
import java.lang.reflect.Type;

public final class ProductService
extends ApiService {
    public ProductService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public Product delete(String id) throws StripeException {
        return this.delete(id, null);
    }

    public Product delete(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v1/products/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, null, options, ApiMode.V1);
        return (Product)this.getResponseGetter().request(request, (Type)((Object)Product.class));
    }

    public Product retrieve(String id, ProductRetrieveParams params) throws StripeException {
        return this.retrieve(id, params, null);
    }

    public Product retrieve(String id, RequestOptions options) throws StripeException {
        return this.retrieve(id, null, options);
    }

    public Product retrieve(String id) throws StripeException {
        return this.retrieve(id, null, null);
    }

    public Product retrieve(String id, ProductRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/products/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Product)this.getResponseGetter().request(request, (Type)((Object)Product.class));
    }

    public Product update(String id, ProductUpdateParams params) throws StripeException {
        return this.update(id, params, null);
    }

    public Product update(String id, RequestOptions options) throws StripeException {
        return this.update(id, null, options);
    }

    public Product update(String id) throws StripeException {
        return this.update(id, null, null);
    }

    public Product update(String id, ProductUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/products/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Product)this.getResponseGetter().request(request, (Type)((Object)Product.class));
    }

    public StripeCollection<Product> list(ProductListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Product> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Product> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Product> list(ProductListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/products";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<Product>>(){}.getType());
    }

    public Product create(ProductCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Product create(ProductCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/products";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Product)this.getResponseGetter().request(request, (Type)((Object)Product.class));
    }

    public StripeSearchResult<Product> search(ProductSearchParams params) throws StripeException {
        return this.search(params, null);
    }

    public StripeSearchResult<Product> search(ProductSearchParams params, RequestOptions options) throws StripeException {
        String path = "/v1/products/search";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeSearchResult)this.getResponseGetter().request(request, new TypeToken<StripeSearchResult<Product>>(){}.getType());
    }
}

