/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.SetupIntent;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.SetupIntentCancelParams;
import com.stripe.param.SetupIntentConfirmParams;
import com.stripe.param.SetupIntentCreateParams;
import com.stripe.param.SetupIntentListParams;
import com.stripe.param.SetupIntentRetrieveParams;
import com.stripe.param.SetupIntentUpdateParams;
import com.stripe.param.SetupIntentVerifyMicrodepositsParams;
import java.lang.reflect.Type;

public final class SetupIntentService
extends ApiService {
    public SetupIntentService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<SetupIntent> list(SetupIntentListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<SetupIntent> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<SetupIntent> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<SetupIntent> list(SetupIntentListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/setup_intents";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<SetupIntent>>(){}.getType());
    }

    public SetupIntent create(SetupIntentCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public SetupIntent create(RequestOptions options) throws StripeException {
        return this.create(null, options);
    }

    public SetupIntent create() throws StripeException {
        return this.create(null, null);
    }

    public SetupIntent create(SetupIntentCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/setup_intents";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (SetupIntent)this.getResponseGetter().request(request, (Type)((Object)SetupIntent.class));
    }

    public SetupIntent retrieve(String intent, SetupIntentRetrieveParams params) throws StripeException {
        return this.retrieve(intent, params, null);
    }

    public SetupIntent retrieve(String intent, RequestOptions options) throws StripeException {
        return this.retrieve(intent, null, options);
    }

    public SetupIntent retrieve(String intent) throws StripeException {
        return this.retrieve(intent, null, null);
    }

    public SetupIntent retrieve(String intent, SetupIntentRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/setup_intents/%s", ApiResource.urlEncodeId(intent));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (SetupIntent)this.getResponseGetter().request(request, (Type)((Object)SetupIntent.class));
    }

    public SetupIntent update(String intent, SetupIntentUpdateParams params) throws StripeException {
        return this.update(intent, params, null);
    }

    public SetupIntent update(String intent, RequestOptions options) throws StripeException {
        return this.update(intent, null, options);
    }

    public SetupIntent update(String intent) throws StripeException {
        return this.update(intent, null, null);
    }

    public SetupIntent update(String intent, SetupIntentUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/setup_intents/%s", ApiResource.urlEncodeId(intent));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (SetupIntent)this.getResponseGetter().request(request, (Type)((Object)SetupIntent.class));
    }

    public SetupIntent cancel(String intent, SetupIntentCancelParams params) throws StripeException {
        return this.cancel(intent, params, null);
    }

    public SetupIntent cancel(String intent, RequestOptions options) throws StripeException {
        return this.cancel(intent, null, options);
    }

    public SetupIntent cancel(String intent) throws StripeException {
        return this.cancel(intent, null, null);
    }

    public SetupIntent cancel(String intent, SetupIntentCancelParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/setup_intents/%s/cancel", ApiResource.urlEncodeId(intent));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (SetupIntent)this.getResponseGetter().request(request, (Type)((Object)SetupIntent.class));
    }

    public SetupIntent confirm(String intent, SetupIntentConfirmParams params) throws StripeException {
        return this.confirm(intent, params, null);
    }

    public SetupIntent confirm(String intent, RequestOptions options) throws StripeException {
        return this.confirm(intent, null, options);
    }

    public SetupIntent confirm(String intent) throws StripeException {
        return this.confirm(intent, null, null);
    }

    public SetupIntent confirm(String intent, SetupIntentConfirmParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/setup_intents/%s/confirm", ApiResource.urlEncodeId(intent));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (SetupIntent)this.getResponseGetter().request(request, (Type)((Object)SetupIntent.class));
    }

    public SetupIntent verifyMicrodeposits(String intent, SetupIntentVerifyMicrodepositsParams params) throws StripeException {
        return this.verifyMicrodeposits(intent, params, null);
    }

    public SetupIntent verifyMicrodeposits(String intent, RequestOptions options) throws StripeException {
        return this.verifyMicrodeposits(intent, null, options);
    }

    public SetupIntent verifyMicrodeposits(String intent) throws StripeException {
        return this.verifyMicrodeposits(intent, null, null);
    }

    public SetupIntent verifyMicrodeposits(String intent, SetupIntentVerifyMicrodepositsParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/setup_intents/%s/verify_microdeposits", ApiResource.urlEncodeId(intent));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (SetupIntent)this.getResponseGetter().request(request, (Type)((Object)SetupIntent.class));
    }
}

