/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.ApplePayDomain;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.ApplePayDomainCreateParams;
import com.stripe.param.ApplePayDomainListParams;
import com.stripe.param.ApplePayDomainRetrieveParams;
import java.lang.reflect.Type;

public final class ApplePayDomainService
extends ApiService {
    public ApplePayDomainService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public ApplePayDomain delete(String domain) throws StripeException {
        return this.delete(domain, null);
    }

    public ApplePayDomain delete(String domain, RequestOptions options) throws StripeException {
        String path = String.format("/v1/apple_pay/domains/%s", ApiResource.urlEncodeId(domain));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, null, options, ApiMode.V1);
        return (ApplePayDomain)this.getResponseGetter().request(request, (Type)((Object)ApplePayDomain.class));
    }

    public ApplePayDomain retrieve(String domain, ApplePayDomainRetrieveParams params) throws StripeException {
        return this.retrieve(domain, params, null);
    }

    public ApplePayDomain retrieve(String domain, RequestOptions options) throws StripeException {
        return this.retrieve(domain, null, options);
    }

    public ApplePayDomain retrieve(String domain) throws StripeException {
        return this.retrieve(domain, null, null);
    }

    public ApplePayDomain retrieve(String domain, ApplePayDomainRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/apple_pay/domains/%s", ApiResource.urlEncodeId(domain));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (ApplePayDomain)this.getResponseGetter().request(request, (Type)((Object)ApplePayDomain.class));
    }

    public StripeCollection<ApplePayDomain> list(ApplePayDomainListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<ApplePayDomain> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<ApplePayDomain> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<ApplePayDomain> list(ApplePayDomainListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/apple_pay/domains";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<ApplePayDomain>>(){}.getType());
    }

    public ApplePayDomain create(ApplePayDomainCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public ApplePayDomain create(ApplePayDomainCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/apple_pay/domains";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (ApplePayDomain)this.getResponseGetter().request(request, (Type)((Object)ApplePayDomain.class));
    }
}

