/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.ExternalAccount;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.ExternalAccountCreateParams;
import com.stripe.param.ExternalAccountListParams;
import com.stripe.param.ExternalAccountRetrieveParams;
import com.stripe.param.ExternalAccountUpdateParams;
import java.lang.reflect.Type;

public final class ExternalAccountService
extends ApiService {
    public ExternalAccountService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public ExternalAccount delete(String account, String id) throws StripeException {
        return this.delete(account, id, null);
    }

    public ExternalAccount delete(String account, String id, RequestOptions options) throws StripeException {
        String path = String.format("/v1/accounts/%s/external_accounts/%s", ApiResource.urlEncodeId(account), ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, null, options, ApiMode.V1);
        return (ExternalAccount)this.getResponseGetter().request(request, (Type)((Object)ExternalAccount.class));
    }

    public ExternalAccount retrieve(String account, String id, ExternalAccountRetrieveParams params) throws StripeException {
        return this.retrieve(account, id, params, null);
    }

    public ExternalAccount retrieve(String account, String id, RequestOptions options) throws StripeException {
        return this.retrieve(account, id, null, options);
    }

    public ExternalAccount retrieve(String account, String id) throws StripeException {
        return this.retrieve(account, id, null, null);
    }

    public ExternalAccount retrieve(String account, String id, ExternalAccountRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/accounts/%s/external_accounts/%s", ApiResource.urlEncodeId(account), ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (ExternalAccount)this.getResponseGetter().request(request, (Type)((Object)ExternalAccount.class));
    }

    public ExternalAccount update(String account, String id, ExternalAccountUpdateParams params) throws StripeException {
        return this.update(account, id, params, null);
    }

    public ExternalAccount update(String account, String id, RequestOptions options) throws StripeException {
        return this.update(account, id, null, options);
    }

    public ExternalAccount update(String account, String id) throws StripeException {
        return this.update(account, id, null, null);
    }

    public ExternalAccount update(String account, String id, ExternalAccountUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/accounts/%s/external_accounts/%s", ApiResource.urlEncodeId(account), ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (ExternalAccount)this.getResponseGetter().request(request, (Type)((Object)ExternalAccount.class));
    }

    public StripeCollection<ExternalAccount> list(String account, ExternalAccountListParams params) throws StripeException {
        return this.list(account, params, null);
    }

    public StripeCollection<ExternalAccount> list(String account, RequestOptions options) throws StripeException {
        return this.list(account, null, options);
    }

    public StripeCollection<ExternalAccount> list(String account) throws StripeException {
        return this.list(account, null, null);
    }

    public StripeCollection<ExternalAccount> list(String account, ExternalAccountListParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/accounts/%s/external_accounts", ApiResource.urlEncodeId(account));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<ExternalAccount>>(){}.getType());
    }

    public ExternalAccount create(String account, ExternalAccountCreateParams params) throws StripeException {
        return this.create(account, params, null);
    }

    public ExternalAccount create(String account, ExternalAccountCreateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/accounts/%s/external_accounts", ApiResource.urlEncodeId(account));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (ExternalAccount)this.getResponseGetter().request(request, (Type)((Object)ExternalAccount.class));
    }
}

