/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.Plan;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.PlanCreateParams;
import com.stripe.param.PlanListParams;
import com.stripe.param.PlanRetrieveParams;
import com.stripe.param.PlanUpdateParams;
import java.lang.reflect.Type;

public final class PlanService
extends ApiService {
    public PlanService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public Plan delete(String plan) throws StripeException {
        return this.delete(plan, null);
    }

    public Plan delete(String plan, RequestOptions options) throws StripeException {
        String path = String.format("/v1/plans/%s", ApiResource.urlEncodeId(plan));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, null, options, ApiMode.V1);
        return (Plan)this.getResponseGetter().request(request, (Type)((Object)Plan.class));
    }

    public Plan retrieve(String plan, PlanRetrieveParams params) throws StripeException {
        return this.retrieve(plan, params, null);
    }

    public Plan retrieve(String plan, RequestOptions options) throws StripeException {
        return this.retrieve(plan, null, options);
    }

    public Plan retrieve(String plan) throws StripeException {
        return this.retrieve(plan, null, null);
    }

    public Plan retrieve(String plan, PlanRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/plans/%s", ApiResource.urlEncodeId(plan));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Plan)this.getResponseGetter().request(request, (Type)((Object)Plan.class));
    }

    public Plan update(String plan, PlanUpdateParams params) throws StripeException {
        return this.update(plan, params, null);
    }

    public Plan update(String plan, RequestOptions options) throws StripeException {
        return this.update(plan, null, options);
    }

    public Plan update(String plan) throws StripeException {
        return this.update(plan, null, null);
    }

    public Plan update(String plan, PlanUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/plans/%s", ApiResource.urlEncodeId(plan));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Plan)this.getResponseGetter().request(request, (Type)((Object)Plan.class));
    }

    public StripeCollection<Plan> list(PlanListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Plan> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Plan> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Plan> list(PlanListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/plans";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<Plan>>(){}.getType());
    }

    public Plan create(PlanCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Plan create(PlanCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/plans";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Plan)this.getResponseGetter().request(request, (Type)((Object)Plan.class));
    }
}

