/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.PromotionCode;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.PromotionCodeCreateParams;
import com.stripe.param.PromotionCodeListParams;
import com.stripe.param.PromotionCodeRetrieveParams;
import com.stripe.param.PromotionCodeUpdateParams;
import java.lang.reflect.Type;

public final class PromotionCodeService
extends ApiService {
    public PromotionCodeService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<PromotionCode> list(PromotionCodeListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<PromotionCode> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<PromotionCode> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<PromotionCode> list(PromotionCodeListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/promotion_codes";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<PromotionCode>>(){}.getType());
    }

    public PromotionCode create(PromotionCodeCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public PromotionCode create(PromotionCodeCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/promotion_codes";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (PromotionCode)this.getResponseGetter().request(request, (Type)((Object)PromotionCode.class));
    }

    public PromotionCode retrieve(String promotionCode, PromotionCodeRetrieveParams params) throws StripeException {
        return this.retrieve(promotionCode, params, null);
    }

    public PromotionCode retrieve(String promotionCode, RequestOptions options) throws StripeException {
        return this.retrieve(promotionCode, null, options);
    }

    public PromotionCode retrieve(String promotionCode) throws StripeException {
        return this.retrieve(promotionCode, null, null);
    }

    public PromotionCode retrieve(String promotionCode, PromotionCodeRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/promotion_codes/%s", ApiResource.urlEncodeId(promotionCode));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (PromotionCode)this.getResponseGetter().request(request, (Type)((Object)PromotionCode.class));
    }

    public PromotionCode update(String promotionCode, PromotionCodeUpdateParams params) throws StripeException {
        return this.update(promotionCode, params, null);
    }

    public PromotionCode update(String promotionCode, RequestOptions options) throws StripeException {
        return this.update(promotionCode, null, options);
    }

    public PromotionCode update(String promotionCode) throws StripeException {
        return this.update(promotionCode, null, null);
    }

    public PromotionCode update(String promotionCode, PromotionCodeUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/promotion_codes/%s", ApiResource.urlEncodeId(promotionCode));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (PromotionCode)this.getResponseGetter().request(request, (Type)((Object)PromotionCode.class));
    }
}

