/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.Discount;
import com.stripe.model.StripeCollection;
import com.stripe.model.StripeSearchResult;
import com.stripe.model.Subscription;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.SubscriptionCancelParams;
import com.stripe.param.SubscriptionCreateParams;
import com.stripe.param.SubscriptionListParams;
import com.stripe.param.SubscriptionResumeParams;
import com.stripe.param.SubscriptionRetrieveParams;
import com.stripe.param.SubscriptionSearchParams;
import com.stripe.param.SubscriptionUpdateParams;
import java.lang.reflect.Type;

public final class SubscriptionService
extends ApiService {
    public SubscriptionService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public Subscription cancel(String subscriptionExposedId, SubscriptionCancelParams params) throws StripeException {
        return this.cancel(subscriptionExposedId, params, null);
    }

    public Subscription cancel(String subscriptionExposedId, RequestOptions options) throws StripeException {
        return this.cancel(subscriptionExposedId, null, options);
    }

    public Subscription cancel(String subscriptionExposedId) throws StripeException {
        return this.cancel(subscriptionExposedId, null, null);
    }

    public Subscription cancel(String subscriptionExposedId, SubscriptionCancelParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/subscriptions/%s", ApiResource.urlEncodeId(subscriptionExposedId));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Subscription)this.getResponseGetter().request(request, (Type)((Object)Subscription.class));
    }

    public Subscription retrieve(String subscriptionExposedId, SubscriptionRetrieveParams params) throws StripeException {
        return this.retrieve(subscriptionExposedId, params, null);
    }

    public Subscription retrieve(String subscriptionExposedId, RequestOptions options) throws StripeException {
        return this.retrieve(subscriptionExposedId, null, options);
    }

    public Subscription retrieve(String subscriptionExposedId) throws StripeException {
        return this.retrieve(subscriptionExposedId, null, null);
    }

    public Subscription retrieve(String subscriptionExposedId, SubscriptionRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/subscriptions/%s", ApiResource.urlEncodeId(subscriptionExposedId));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Subscription)this.getResponseGetter().request(request, (Type)((Object)Subscription.class));
    }

    public Subscription update(String subscriptionExposedId, SubscriptionUpdateParams params) throws StripeException {
        return this.update(subscriptionExposedId, params, null);
    }

    public Subscription update(String subscriptionExposedId, RequestOptions options) throws StripeException {
        return this.update(subscriptionExposedId, null, options);
    }

    public Subscription update(String subscriptionExposedId) throws StripeException {
        return this.update(subscriptionExposedId, null, null);
    }

    public Subscription update(String subscriptionExposedId, SubscriptionUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/subscriptions/%s", ApiResource.urlEncodeId(subscriptionExposedId));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Subscription)this.getResponseGetter().request(request, (Type)((Object)Subscription.class));
    }

    public Discount deleteDiscount(String subscriptionExposedId) throws StripeException {
        return this.deleteDiscount(subscriptionExposedId, null);
    }

    public Discount deleteDiscount(String subscriptionExposedId, RequestOptions options) throws StripeException {
        String path = String.format("/v1/subscriptions/%s/discount", ApiResource.urlEncodeId(subscriptionExposedId));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, null, options, ApiMode.V1);
        return (Discount)this.getResponseGetter().request(request, (Type)((Object)Discount.class));
    }

    public StripeCollection<Subscription> list(SubscriptionListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Subscription> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Subscription> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Subscription> list(SubscriptionListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/subscriptions";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<Subscription>>(){}.getType());
    }

    public Subscription create(SubscriptionCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Subscription create(SubscriptionCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/subscriptions";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Subscription)this.getResponseGetter().request(request, (Type)((Object)Subscription.class));
    }

    public StripeSearchResult<Subscription> search(SubscriptionSearchParams params) throws StripeException {
        return this.search(params, null);
    }

    public StripeSearchResult<Subscription> search(SubscriptionSearchParams params, RequestOptions options) throws StripeException {
        String path = "/v1/subscriptions/search";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeSearchResult)this.getResponseGetter().request(request, new TypeToken<StripeSearchResult<Subscription>>(){}.getType());
    }

    public Subscription resume(String subscription, SubscriptionResumeParams params) throws StripeException {
        return this.resume(subscription, params, null);
    }

    public Subscription resume(String subscription, RequestOptions options) throws StripeException {
        return this.resume(subscription, null, options);
    }

    public Subscription resume(String subscription) throws StripeException {
        return this.resume(subscription, null, null);
    }

    public Subscription resume(String subscription, SubscriptionResumeParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/subscriptions/%s/resume", ApiResource.urlEncodeId(subscription));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Subscription)this.getResponseGetter().request(request, (Type)((Object)Subscription.class));
    }
}

