/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.TaxRate;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.TaxRateCreateParams;
import com.stripe.param.TaxRateListParams;
import com.stripe.param.TaxRateRetrieveParams;
import com.stripe.param.TaxRateUpdateParams;
import java.lang.reflect.Type;

public final class TaxRateService
extends ApiService {
    public TaxRateService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<TaxRate> list(TaxRateListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<TaxRate> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<TaxRate> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<TaxRate> list(TaxRateListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/tax_rates";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<TaxRate>>(){}.getType());
    }

    public TaxRate create(TaxRateCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public TaxRate create(TaxRateCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/tax_rates";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (TaxRate)this.getResponseGetter().request(request, (Type)((Object)TaxRate.class));
    }

    public TaxRate retrieve(String taxRate, TaxRateRetrieveParams params) throws StripeException {
        return this.retrieve(taxRate, params, null);
    }

    public TaxRate retrieve(String taxRate, RequestOptions options) throws StripeException {
        return this.retrieve(taxRate, null, options);
    }

    public TaxRate retrieve(String taxRate) throws StripeException {
        return this.retrieve(taxRate, null, null);
    }

    public TaxRate retrieve(String taxRate, TaxRateRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/tax_rates/%s", ApiResource.urlEncodeId(taxRate));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (TaxRate)this.getResponseGetter().request(request, (Type)((Object)TaxRate.class));
    }

    public TaxRate update(String taxRate, TaxRateUpdateParams params) throws StripeException {
        return this.update(taxRate, params, null);
    }

    public TaxRate update(String taxRate, RequestOptions options) throws StripeException {
        return this.update(taxRate, null, options);
    }

    public TaxRate update(String taxRate) throws StripeException {
        return this.update(taxRate, null, null);
    }

    public TaxRate update(String taxRate, TaxRateUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/tax_rates/%s", ApiResource.urlEncodeId(taxRate));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (TaxRate)this.getResponseGetter().request(request, (Type)((Object)TaxRate.class));
    }
}

