/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.issuing;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.issuing.Card;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.issuing.CardCreateParams;
import com.stripe.param.issuing.CardListParams;
import com.stripe.param.issuing.CardRetrieveParams;
import com.stripe.param.issuing.CardUpdateParams;
import java.lang.reflect.Type;

public final class CardService
extends ApiService {
    public CardService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<Card> list(CardListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Card> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Card> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Card> list(CardListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/cards";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<Card>>(){}.getType());
    }

    public Card create(CardCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Card create(CardCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/cards";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Card)this.getResponseGetter().request(request, (Type)((Object)Card.class));
    }

    public Card retrieve(String card, CardRetrieveParams params) throws StripeException {
        return this.retrieve(card, params, null);
    }

    public Card retrieve(String card, RequestOptions options) throws StripeException {
        return this.retrieve(card, null, options);
    }

    public Card retrieve(String card) throws StripeException {
        return this.retrieve(card, null, null);
    }

    public Card retrieve(String card, CardRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/cards/%s", ApiResource.urlEncodeId(card));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Card)this.getResponseGetter().request(request, (Type)((Object)Card.class));
    }

    public Card update(String card, CardUpdateParams params) throws StripeException {
        return this.update(card, params, null);
    }

    public Card update(String card, RequestOptions options) throws StripeException {
        return this.update(card, null, options);
    }

    public Card update(String card) throws StripeException {
        return this.update(card, null, null);
    }

    public Card update(String card, CardUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/cards/%s", ApiResource.urlEncodeId(card));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Card)this.getResponseGetter().request(request, (Type)((Object)Card.class));
    }
}

