/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.reporting;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.reporting.ReportType;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.reporting.ReportTypeListParams;
import com.stripe.param.reporting.ReportTypeRetrieveParams;
import java.lang.reflect.Type;

public final class ReportTypeService
extends ApiService {
    public ReportTypeService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<ReportType> list(ReportTypeListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<ReportType> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<ReportType> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<ReportType> list(ReportTypeListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/reporting/report_types";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<ReportType>>(){}.getType());
    }

    public ReportType retrieve(String reportType, ReportTypeRetrieveParams params) throws StripeException {
        return this.retrieve(reportType, params, null);
    }

    public ReportType retrieve(String reportType, RequestOptions options) throws StripeException {
        return this.retrieve(reportType, null, options);
    }

    public ReportType retrieve(String reportType) throws StripeException {
        return this.retrieve(reportType, null, null);
    }

    public ReportType retrieve(String reportType, ReportTypeRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/reporting/report_types/%s", ApiResource.urlEncodeId(reportType));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (ReportType)this.getResponseGetter().request(request, (Type)((Object)ReportType.class));
    }
}

