/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.Invoice;
import com.stripe.model.StripeCollection;
import com.stripe.model.StripeSearchResult;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.InvoiceCreateParams;
import com.stripe.param.InvoiceFinalizeInvoiceParams;
import com.stripe.param.InvoiceListParams;
import com.stripe.param.InvoiceMarkUncollectibleParams;
import com.stripe.param.InvoicePayParams;
import com.stripe.param.InvoiceRetrieveParams;
import com.stripe.param.InvoiceSearchParams;
import com.stripe.param.InvoiceSendInvoiceParams;
import com.stripe.param.InvoiceUpcomingParams;
import com.stripe.param.InvoiceUpdateParams;
import com.stripe.param.InvoiceVoidInvoiceParams;
import com.stripe.service.InvoiceLineItemService;
import com.stripe.service.InvoiceUpcomingLinesService;
import java.lang.reflect.Type;

public final class InvoiceService
extends ApiService {
    public InvoiceService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public Invoice delete(String invoice) throws StripeException {
        return this.delete(invoice, null);
    }

    public Invoice delete(String invoice, RequestOptions options) throws StripeException {
        String path = String.format("/v1/invoices/%s", ApiResource.urlEncodeId(invoice));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, null, options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Invoice)this.getResponseGetter().request(request, (Type)((Object)Invoice.class));
    }

    public Invoice retrieve(String invoice, InvoiceRetrieveParams params) throws StripeException {
        return this.retrieve(invoice, params, null);
    }

    public Invoice retrieve(String invoice, RequestOptions options) throws StripeException {
        return this.retrieve(invoice, null, options);
    }

    public Invoice retrieve(String invoice) throws StripeException {
        return this.retrieve(invoice, null, null);
    }

    public Invoice retrieve(String invoice, InvoiceRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/invoices/%s", ApiResource.urlEncodeId(invoice));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Invoice)this.getResponseGetter().request(request, (Type)((Object)Invoice.class));
    }

    public Invoice update(String invoice, InvoiceUpdateParams params) throws StripeException {
        return this.update(invoice, params, null);
    }

    public Invoice update(String invoice, RequestOptions options) throws StripeException {
        return this.update(invoice, null, options);
    }

    public Invoice update(String invoice) throws StripeException {
        return this.update(invoice, null, null);
    }

    public Invoice update(String invoice, InvoiceUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/invoices/%s", ApiResource.urlEncodeId(invoice));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Invoice)this.getResponseGetter().request(request, (Type)((Object)Invoice.class));
    }

    public StripeCollection<Invoice> list(InvoiceListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Invoice> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Invoice> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Invoice> list(InvoiceListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/invoices";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<Invoice>>(){}.getType());
    }

    public Invoice create(InvoiceCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Invoice create(RequestOptions options) throws StripeException {
        return this.create(null, options);
    }

    public Invoice create() throws StripeException {
        return this.create(null, null);
    }

    public Invoice create(InvoiceCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/invoices";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Invoice)this.getResponseGetter().request(request, (Type)((Object)Invoice.class));
    }

    public StripeSearchResult<Invoice> search(InvoiceSearchParams params) throws StripeException {
        return this.search(params, null);
    }

    public StripeSearchResult<Invoice> search(InvoiceSearchParams params, RequestOptions options) throws StripeException {
        String path = "/v1/invoices/search";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (StripeSearchResult)this.getResponseGetter().request(request, new TypeToken<StripeSearchResult<Invoice>>(){}.getType());
    }

    public Invoice upcoming(InvoiceUpcomingParams params) throws StripeException {
        return this.upcoming(params, null);
    }

    public Invoice upcoming(RequestOptions options) throws StripeException {
        return this.upcoming(null, options);
    }

    public Invoice upcoming() throws StripeException {
        return this.upcoming(null, null);
    }

    public Invoice upcoming(InvoiceUpcomingParams params, RequestOptions options) throws StripeException {
        String path = "/v1/invoices/upcoming";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Invoice)this.getResponseGetter().request(request, (Type)((Object)Invoice.class));
    }

    public Invoice finalizeInvoice(String invoice, InvoiceFinalizeInvoiceParams params) throws StripeException {
        return this.finalizeInvoice(invoice, params, null);
    }

    public Invoice finalizeInvoice(String invoice, RequestOptions options) throws StripeException {
        return this.finalizeInvoice(invoice, null, options);
    }

    public Invoice finalizeInvoice(String invoice) throws StripeException {
        return this.finalizeInvoice(invoice, null, null);
    }

    public Invoice finalizeInvoice(String invoice, InvoiceFinalizeInvoiceParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/invoices/%s/finalize", ApiResource.urlEncodeId(invoice));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Invoice)this.getResponseGetter().request(request, (Type)((Object)Invoice.class));
    }

    public Invoice markUncollectible(String invoice, InvoiceMarkUncollectibleParams params) throws StripeException {
        return this.markUncollectible(invoice, params, null);
    }

    public Invoice markUncollectible(String invoice, RequestOptions options) throws StripeException {
        return this.markUncollectible(invoice, null, options);
    }

    public Invoice markUncollectible(String invoice) throws StripeException {
        return this.markUncollectible(invoice, null, null);
    }

    public Invoice markUncollectible(String invoice, InvoiceMarkUncollectibleParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/invoices/%s/mark_uncollectible", ApiResource.urlEncodeId(invoice));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Invoice)this.getResponseGetter().request(request, (Type)((Object)Invoice.class));
    }

    public Invoice pay(String invoice, InvoicePayParams params) throws StripeException {
        return this.pay(invoice, params, null);
    }

    public Invoice pay(String invoice, RequestOptions options) throws StripeException {
        return this.pay(invoice, null, options);
    }

    public Invoice pay(String invoice) throws StripeException {
        return this.pay(invoice, null, null);
    }

    public Invoice pay(String invoice, InvoicePayParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/invoices/%s/pay", ApiResource.urlEncodeId(invoice));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Invoice)this.getResponseGetter().request(request, (Type)((Object)Invoice.class));
    }

    public Invoice sendInvoice(String invoice, InvoiceSendInvoiceParams params) throws StripeException {
        return this.sendInvoice(invoice, params, null);
    }

    public Invoice sendInvoice(String invoice, RequestOptions options) throws StripeException {
        return this.sendInvoice(invoice, null, options);
    }

    public Invoice sendInvoice(String invoice) throws StripeException {
        return this.sendInvoice(invoice, null, null);
    }

    public Invoice sendInvoice(String invoice, InvoiceSendInvoiceParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/invoices/%s/send", ApiResource.urlEncodeId(invoice));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Invoice)this.getResponseGetter().request(request, (Type)((Object)Invoice.class));
    }

    public Invoice voidInvoice(String invoice, InvoiceVoidInvoiceParams params) throws StripeException {
        return this.voidInvoice(invoice, params, null);
    }

    public Invoice voidInvoice(String invoice, RequestOptions options) throws StripeException {
        return this.voidInvoice(invoice, null, options);
    }

    public Invoice voidInvoice(String invoice) throws StripeException {
        return this.voidInvoice(invoice, null, null);
    }

    public Invoice voidInvoice(String invoice, InvoiceVoidInvoiceParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/invoices/%s/void", ApiResource.urlEncodeId(invoice));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Invoice)this.getResponseGetter().request(request, (Type)((Object)Invoice.class));
    }

    public InvoiceLineItemService lineItems() {
        return new InvoiceLineItemService(this.getResponseGetter());
    }

    public InvoiceUpcomingLinesService upcomingLines() {
        return new InvoiceUpcomingLinesService(this.getResponseGetter());
    }
}

