/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.Review;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.ReviewApproveParams;
import com.stripe.param.ReviewListParams;
import com.stripe.param.ReviewRetrieveParams;
import java.lang.reflect.Type;

public final class ReviewService
extends ApiService {
    public ReviewService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<Review> list(ReviewListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Review> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Review> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Review> list(ReviewListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/reviews";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<Review>>(){}.getType());
    }

    public Review retrieve(String review, ReviewRetrieveParams params) throws StripeException {
        return this.retrieve(review, params, null);
    }

    public Review retrieve(String review, RequestOptions options) throws StripeException {
        return this.retrieve(review, null, options);
    }

    public Review retrieve(String review) throws StripeException {
        return this.retrieve(review, null, null);
    }

    public Review retrieve(String review, ReviewRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/reviews/%s", ApiResource.urlEncodeId(review));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Review)this.getResponseGetter().request(request, (Type)((Object)Review.class));
    }

    public Review approve(String review, ReviewApproveParams params) throws StripeException {
        return this.approve(review, params, null);
    }

    public Review approve(String review, RequestOptions options) throws StripeException {
        return this.approve(review, null, options);
    }

    public Review approve(String review) throws StripeException {
        return this.approve(review, null, null);
    }

    public Review approve(String review, ReviewApproveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/reviews/%s/approve", ApiResource.urlEncodeId(review));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Review)this.getResponseGetter().request(request, (Type)((Object)Review.class));
    }
}

