/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.ShippingRate;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.ShippingRateCreateParams;
import com.stripe.param.ShippingRateListParams;
import com.stripe.param.ShippingRateRetrieveParams;
import com.stripe.param.ShippingRateUpdateParams;
import java.lang.reflect.Type;

public final class ShippingRateService
extends ApiService {
    public ShippingRateService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<ShippingRate> list(ShippingRateListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<ShippingRate> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<ShippingRate> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<ShippingRate> list(ShippingRateListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/shipping_rates";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<ShippingRate>>(){}.getType());
    }

    public ShippingRate create(ShippingRateCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public ShippingRate create(ShippingRateCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/shipping_rates";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (ShippingRate)this.getResponseGetter().request(request, (Type)((Object)ShippingRate.class));
    }

    public ShippingRate retrieve(String shippingRateToken, ShippingRateRetrieveParams params) throws StripeException {
        return this.retrieve(shippingRateToken, params, null);
    }

    public ShippingRate retrieve(String shippingRateToken, RequestOptions options) throws StripeException {
        return this.retrieve(shippingRateToken, null, options);
    }

    public ShippingRate retrieve(String shippingRateToken) throws StripeException {
        return this.retrieve(shippingRateToken, null, null);
    }

    public ShippingRate retrieve(String shippingRateToken, ShippingRateRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/shipping_rates/%s", ApiResource.urlEncodeId(shippingRateToken));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (ShippingRate)this.getResponseGetter().request(request, (Type)((Object)ShippingRate.class));
    }

    public ShippingRate update(String shippingRateToken, ShippingRateUpdateParams params) throws StripeException {
        return this.update(shippingRateToken, params, null);
    }

    public ShippingRate update(String shippingRateToken, RequestOptions options) throws StripeException {
        return this.update(shippingRateToken, null, options);
    }

    public ShippingRate update(String shippingRateToken) throws StripeException {
        return this.update(shippingRateToken, null, null);
    }

    public ShippingRate update(String shippingRateToken, ShippingRateUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/shipping_rates/%s", ApiResource.urlEncodeId(shippingRateToken));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (ShippingRate)this.getResponseGetter().request(request, (Type)((Object)ShippingRate.class));
    }
}

