/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.SubscriptionSchedule;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.SubscriptionScheduleCancelParams;
import com.stripe.param.SubscriptionScheduleCreateParams;
import com.stripe.param.SubscriptionScheduleListParams;
import com.stripe.param.SubscriptionScheduleReleaseParams;
import com.stripe.param.SubscriptionScheduleRetrieveParams;
import com.stripe.param.SubscriptionScheduleUpdateParams;
import java.lang.reflect.Type;

public final class SubscriptionScheduleService
extends ApiService {
    public SubscriptionScheduleService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<SubscriptionSchedule> list(SubscriptionScheduleListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<SubscriptionSchedule> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<SubscriptionSchedule> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<SubscriptionSchedule> list(SubscriptionScheduleListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/subscription_schedules";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<SubscriptionSchedule>>(){}.getType());
    }

    public SubscriptionSchedule create(SubscriptionScheduleCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public SubscriptionSchedule create(RequestOptions options) throws StripeException {
        return this.create(null, options);
    }

    public SubscriptionSchedule create() throws StripeException {
        return this.create(null, null);
    }

    public SubscriptionSchedule create(SubscriptionScheduleCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/subscription_schedules";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (SubscriptionSchedule)this.getResponseGetter().request(request, (Type)((Object)SubscriptionSchedule.class));
    }

    public SubscriptionSchedule retrieve(String schedule, SubscriptionScheduleRetrieveParams params) throws StripeException {
        return this.retrieve(schedule, params, null);
    }

    public SubscriptionSchedule retrieve(String schedule, RequestOptions options) throws StripeException {
        return this.retrieve(schedule, null, options);
    }

    public SubscriptionSchedule retrieve(String schedule) throws StripeException {
        return this.retrieve(schedule, null, null);
    }

    public SubscriptionSchedule retrieve(String schedule, SubscriptionScheduleRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/subscription_schedules/%s", ApiResource.urlEncodeId(schedule));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (SubscriptionSchedule)this.getResponseGetter().request(request, (Type)((Object)SubscriptionSchedule.class));
    }

    public SubscriptionSchedule update(String schedule, SubscriptionScheduleUpdateParams params) throws StripeException {
        return this.update(schedule, params, null);
    }

    public SubscriptionSchedule update(String schedule, RequestOptions options) throws StripeException {
        return this.update(schedule, null, options);
    }

    public SubscriptionSchedule update(String schedule) throws StripeException {
        return this.update(schedule, null, null);
    }

    public SubscriptionSchedule update(String schedule, SubscriptionScheduleUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/subscription_schedules/%s", ApiResource.urlEncodeId(schedule));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (SubscriptionSchedule)this.getResponseGetter().request(request, (Type)((Object)SubscriptionSchedule.class));
    }

    public SubscriptionSchedule cancel(String schedule, SubscriptionScheduleCancelParams params) throws StripeException {
        return this.cancel(schedule, params, null);
    }

    public SubscriptionSchedule cancel(String schedule, RequestOptions options) throws StripeException {
        return this.cancel(schedule, null, options);
    }

    public SubscriptionSchedule cancel(String schedule) throws StripeException {
        return this.cancel(schedule, null, null);
    }

    public SubscriptionSchedule cancel(String schedule, SubscriptionScheduleCancelParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/subscription_schedules/%s/cancel", ApiResource.urlEncodeId(schedule));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (SubscriptionSchedule)this.getResponseGetter().request(request, (Type)((Object)SubscriptionSchedule.class));
    }

    public SubscriptionSchedule release(String schedule, SubscriptionScheduleReleaseParams params) throws StripeException {
        return this.release(schedule, params, null);
    }

    public SubscriptionSchedule release(String schedule, RequestOptions options) throws StripeException {
        return this.release(schedule, null, options);
    }

    public SubscriptionSchedule release(String schedule) throws StripeException {
        return this.release(schedule, null, null);
    }

    public SubscriptionSchedule release(String schedule, SubscriptionScheduleReleaseParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/subscription_schedules/%s/release", ApiResource.urlEncodeId(schedule));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (SubscriptionSchedule)this.getResponseGetter().request(request, (Type)((Object)SubscriptionSchedule.class));
    }
}

