/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.Topup;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.TopupCancelParams;
import com.stripe.param.TopupCreateParams;
import com.stripe.param.TopupListParams;
import com.stripe.param.TopupRetrieveParams;
import com.stripe.param.TopupUpdateParams;
import java.lang.reflect.Type;

public final class TopupService
extends ApiService {
    public TopupService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<Topup> list(TopupListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Topup> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Topup> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Topup> list(TopupListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/topups";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<Topup>>(){}.getType());
    }

    public Topup create(TopupCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Topup create(TopupCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/topups";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Topup)this.getResponseGetter().request(request, (Type)((Object)Topup.class));
    }

    public Topup retrieve(String topup, TopupRetrieveParams params) throws StripeException {
        return this.retrieve(topup, params, null);
    }

    public Topup retrieve(String topup, RequestOptions options) throws StripeException {
        return this.retrieve(topup, null, options);
    }

    public Topup retrieve(String topup) throws StripeException {
        return this.retrieve(topup, null, null);
    }

    public Topup retrieve(String topup, TopupRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/topups/%s", ApiResource.urlEncodeId(topup));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Topup)this.getResponseGetter().request(request, (Type)((Object)Topup.class));
    }

    public Topup update(String topup, TopupUpdateParams params) throws StripeException {
        return this.update(topup, params, null);
    }

    public Topup update(String topup, RequestOptions options) throws StripeException {
        return this.update(topup, null, options);
    }

    public Topup update(String topup) throws StripeException {
        return this.update(topup, null, null);
    }

    public Topup update(String topup, TopupUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/topups/%s", ApiResource.urlEncodeId(topup));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Topup)this.getResponseGetter().request(request, (Type)((Object)Topup.class));
    }

    public Topup cancel(String topup, TopupCancelParams params) throws StripeException {
        return this.cancel(topup, params, null);
    }

    public Topup cancel(String topup, RequestOptions options) throws StripeException {
        return this.cancel(topup, null, options);
    }

    public Topup cancel(String topup) throws StripeException {
        return this.cancel(topup, null, null);
    }

    public Topup cancel(String topup, TopupCancelParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/topups/%s/cancel", ApiResource.urlEncodeId(topup));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Topup)this.getResponseGetter().request(request, (Type)((Object)Topup.class));
    }
}

