/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.issuing;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.issuing.Transaction;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.issuing.TransactionListParams;
import com.stripe.param.issuing.TransactionRetrieveParams;
import com.stripe.param.issuing.TransactionUpdateParams;
import java.lang.reflect.Type;

public final class TransactionService
extends ApiService {
    public TransactionService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<Transaction> list(TransactionListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Transaction> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Transaction> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Transaction> list(TransactionListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/transactions";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<Transaction>>(){}.getType());
    }

    public Transaction retrieve(String transaction, TransactionRetrieveParams params) throws StripeException {
        return this.retrieve(transaction, params, null);
    }

    public Transaction retrieve(String transaction, RequestOptions options) throws StripeException {
        return this.retrieve(transaction, null, options);
    }

    public Transaction retrieve(String transaction) throws StripeException {
        return this.retrieve(transaction, null, null);
    }

    public Transaction retrieve(String transaction, TransactionRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/transactions/%s", ApiResource.urlEncodeId(transaction));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Transaction)this.getResponseGetter().request(request, (Type)((Object)Transaction.class));
    }

    public Transaction update(String transaction, TransactionUpdateParams params) throws StripeException {
        return this.update(transaction, params, null);
    }

    public Transaction update(String transaction, RequestOptions options) throws StripeException {
        return this.update(transaction, null, options);
    }

    public Transaction update(String transaction) throws StripeException {
        return this.update(transaction, null, null);
    }

    public Transaction update(String transaction, TransactionUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/transactions/%s", ApiResource.urlEncodeId(transaction));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Transaction)this.getResponseGetter().request(request, (Type)((Object)Transaction.class));
    }
}

