/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.testhelpers;

import com.stripe.exception.StripeException;
import com.stripe.model.CustomerCashBalanceTransaction;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.CustomerFundCashBalanceParams;
import java.lang.reflect.Type;

public final class CustomerService
extends ApiService {
    public CustomerService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public CustomerCashBalanceTransaction fundCashBalance(String customer, CustomerFundCashBalanceParams params) throws StripeException {
        return this.fundCashBalance(customer, params, null);
    }

    public CustomerCashBalanceTransaction fundCashBalance(String customer, CustomerFundCashBalanceParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/test_helpers/customers/%s/fund_cash_balance", ApiResource.urlEncodeId(customer));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (CustomerCashBalanceTransaction)this.getResponseGetter().request(request, (Type)((Object)CustomerCashBalanceTransaction.class));
    }
}

