/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.treasury;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.treasury.InboundTransfer;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.treasury.InboundTransferCancelParams;
import com.stripe.param.treasury.InboundTransferCreateParams;
import com.stripe.param.treasury.InboundTransferListParams;
import com.stripe.param.treasury.InboundTransferRetrieveParams;
import java.lang.reflect.Type;

public final class InboundTransferService
extends ApiService {
    public InboundTransferService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<InboundTransfer> list(InboundTransferListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<InboundTransfer> list(InboundTransferListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/treasury/inbound_transfers";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<InboundTransfer>>(){}.getType());
    }

    public InboundTransfer create(InboundTransferCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public InboundTransfer create(InboundTransferCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/treasury/inbound_transfers";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (InboundTransfer)this.getResponseGetter().request(request, (Type)((Object)InboundTransfer.class));
    }

    public InboundTransfer retrieve(String id, InboundTransferRetrieveParams params) throws StripeException {
        return this.retrieve(id, params, null);
    }

    public InboundTransfer retrieve(String id, RequestOptions options) throws StripeException {
        return this.retrieve(id, null, options);
    }

    public InboundTransfer retrieve(String id) throws StripeException {
        return this.retrieve(id, null, null);
    }

    public InboundTransfer retrieve(String id, InboundTransferRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/treasury/inbound_transfers/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (InboundTransfer)this.getResponseGetter().request(request, (Type)((Object)InboundTransfer.class));
    }

    public InboundTransfer cancel(String inboundTransfer, InboundTransferCancelParams params) throws StripeException {
        return this.cancel(inboundTransfer, params, null);
    }

    public InboundTransfer cancel(String inboundTransfer, RequestOptions options) throws StripeException {
        return this.cancel(inboundTransfer, null, options);
    }

    public InboundTransfer cancel(String inboundTransfer) throws StripeException {
        return this.cancel(inboundTransfer, null, null);
    }

    public InboundTransfer cancel(String inboundTransfer, InboundTransferCancelParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/treasury/inbound_transfers/%s/cancel", ApiResource.urlEncodeId(inboundTransfer));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (InboundTransfer)this.getResponseGetter().request(request, (Type)((Object)InboundTransfer.class));
    }
}

