/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.capital;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.model.capital.FinancingOfferCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.capital.FinancingOfferListParams;
import com.stripe.param.capital.FinancingOfferMarkDeliveredParams;
import com.stripe.param.capital.FinancingOfferRetrieveParams;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Map;
import lombok.Generated;

public class FinancingOffer
extends ApiResource
implements HasId {
    @SerializedName(value="accepted_terms")
    AcceptedTerms acceptedTerms;
    @SerializedName(value="account")
    String account;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="expires_after")
    BigDecimal expiresAfter;
    @SerializedName(value="financing_type")
    String financingType;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="offered_terms")
    OfferedTerms offeredTerms;
    @SerializedName(value="product_type")
    String productType;
    @SerializedName(value="replacement")
    String replacement;
    @SerializedName(value="replacement_for")
    String replacementFor;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="type")
    String type;

    public static FinancingOfferCollection list(Map<String, Object> params) throws StripeException {
        return FinancingOffer.list(params, (RequestOptions)null);
    }

    public static FinancingOfferCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/capital/financing_offers";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (FinancingOfferCollection)FinancingOffer.getGlobalResponseGetter().request(request, (Type)((Object)FinancingOfferCollection.class));
    }

    public static FinancingOfferCollection list(FinancingOfferListParams params) throws StripeException {
        return FinancingOffer.list(params, (RequestOptions)null);
    }

    public static FinancingOfferCollection list(FinancingOfferListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/capital/financing_offers";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (FinancingOfferCollection)FinancingOffer.getGlobalResponseGetter().request(request, (Type)((Object)FinancingOfferCollection.class));
    }

    public FinancingOffer markDelivered() throws StripeException {
        return this.markDelivered((Map<String, Object>)null, (RequestOptions)null);
    }

    public FinancingOffer markDelivered(RequestOptions options) throws StripeException {
        return this.markDelivered((Map<String, Object>)null, options);
    }

    public FinancingOffer markDelivered(Map<String, Object> params) throws StripeException {
        return this.markDelivered(params, (RequestOptions)null);
    }

    public FinancingOffer markDelivered(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/capital/financing_offers/%s/mark_delivered", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (FinancingOffer)this.getResponseGetter().request(request, (Type)((Object)FinancingOffer.class));
    }

    public FinancingOffer markDelivered(FinancingOfferMarkDeliveredParams params) throws StripeException {
        return this.markDelivered(params, (RequestOptions)null);
    }

    public FinancingOffer markDelivered(FinancingOfferMarkDeliveredParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/capital/financing_offers/%s/mark_delivered", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (FinancingOffer)this.getResponseGetter().request(request, (Type)((Object)FinancingOffer.class));
    }

    public static FinancingOffer retrieve(String financingOffer) throws StripeException {
        return FinancingOffer.retrieve(financingOffer, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static FinancingOffer retrieve(String financingOffer, RequestOptions options) throws StripeException {
        return FinancingOffer.retrieve(financingOffer, (Map<String, Object>)null, options);
    }

    public static FinancingOffer retrieve(String financingOffer, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/capital/financing_offers/%s", ApiResource.urlEncodeId(financingOffer));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (FinancingOffer)FinancingOffer.getGlobalResponseGetter().request(request, (Type)((Object)FinancingOffer.class));
    }

    public static FinancingOffer retrieve(String financingOffer, FinancingOfferRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/capital/financing_offers/%s", ApiResource.urlEncodeId(financingOffer));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (FinancingOffer)FinancingOffer.getGlobalResponseGetter().request(request, (Type)((Object)FinancingOffer.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.acceptedTerms, responseGetter);
        this.trySetResponseGetter(this.offeredTerms, responseGetter);
    }

    @Generated
    public AcceptedTerms getAcceptedTerms() {
        return this.acceptedTerms;
    }

    @Generated
    public String getAccount() {
        return this.account;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public BigDecimal getExpiresAfter() {
        return this.expiresAfter;
    }

    @Generated
    public String getFinancingType() {
        return this.financingType;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public OfferedTerms getOfferedTerms() {
        return this.offeredTerms;
    }

    @Generated
    public String getProductType() {
        return this.productType;
    }

    @Generated
    public String getReplacement() {
        return this.replacement;
    }

    @Generated
    public String getReplacementFor() {
        return this.replacementFor;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setAcceptedTerms(AcceptedTerms acceptedTerms) {
        this.acceptedTerms = acceptedTerms;
    }

    @Generated
    public void setAccount(String account) {
        this.account = account;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setExpiresAfter(BigDecimal expiresAfter) {
        this.expiresAfter = expiresAfter;
    }

    @Generated
    public void setFinancingType(String financingType) {
        this.financingType = financingType;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setOfferedTerms(OfferedTerms offeredTerms) {
        this.offeredTerms = offeredTerms;
    }

    @Generated
    public void setProductType(String productType) {
        this.productType = productType;
    }

    @Generated
    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    @Generated
    public void setReplacementFor(String replacementFor) {
        this.replacementFor = replacementFor;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FinancingOffer)) {
            return false;
        }
        FinancingOffer other = (FinancingOffer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        AcceptedTerms this$acceptedTerms = this.getAcceptedTerms();
        AcceptedTerms other$acceptedTerms = other.getAcceptedTerms();
        if (this$acceptedTerms == null ? other$acceptedTerms != null : !((Object)this$acceptedTerms).equals(other$acceptedTerms)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        BigDecimal this$expiresAfter = this.getExpiresAfter();
        BigDecimal other$expiresAfter = other.getExpiresAfter();
        if (this$expiresAfter == null ? other$expiresAfter != null : !((Object)this$expiresAfter).equals(other$expiresAfter)) {
            return false;
        }
        String this$financingType = this.getFinancingType();
        String other$financingType = other.getFinancingType();
        if (this$financingType == null ? other$financingType != null : !this$financingType.equals(other$financingType)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        OfferedTerms this$offeredTerms = this.getOfferedTerms();
        OfferedTerms other$offeredTerms = other.getOfferedTerms();
        if (this$offeredTerms == null ? other$offeredTerms != null : !((Object)this$offeredTerms).equals(other$offeredTerms)) {
            return false;
        }
        String this$productType = this.getProductType();
        String other$productType = other.getProductType();
        if (this$productType == null ? other$productType != null : !this$productType.equals(other$productType)) {
            return false;
        }
        String this$replacement = this.getReplacement();
        String other$replacement = other.getReplacement();
        if (this$replacement == null ? other$replacement != null : !this$replacement.equals(other$replacement)) {
            return false;
        }
        String this$replacementFor = this.getReplacementFor();
        String other$replacementFor = other.getReplacementFor();
        if (this$replacementFor == null ? other$replacementFor != null : !this$replacementFor.equals(other$replacementFor)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FinancingOffer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        AcceptedTerms $acceptedTerms = this.getAcceptedTerms();
        result = result * 59 + ($acceptedTerms == null ? 43 : ((Object)$acceptedTerms).hashCode());
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        BigDecimal $expiresAfter = this.getExpiresAfter();
        result = result * 59 + ($expiresAfter == null ? 43 : ((Object)$expiresAfter).hashCode());
        String $financingType = this.getFinancingType();
        result = result * 59 + ($financingType == null ? 43 : $financingType.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        OfferedTerms $offeredTerms = this.getOfferedTerms();
        result = result * 59 + ($offeredTerms == null ? 43 : ((Object)$offeredTerms).hashCode());
        String $productType = this.getProductType();
        result = result * 59 + ($productType == null ? 43 : $productType.hashCode());
        String $replacement = this.getReplacement();
        result = result * 59 + ($replacement == null ? 43 : $replacement.hashCode());
        String $replacementFor = this.getReplacementFor();
        result = result * 59 + ($replacementFor == null ? 43 : $replacementFor.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class AcceptedTerms
    extends StripeObject {
        @SerializedName(value="advance_amount")
        Long advanceAmount;
        @SerializedName(value="currency")
        String currency;
        @SerializedName(value="fee_amount")
        Long feeAmount;
        @SerializedName(value="previous_financing_fee_discount_amount")
        Long previousFinancingFeeDiscountAmount;
        @SerializedName(value="withhold_rate")
        BigDecimal withholdRate;

        @Generated
        public Long getAdvanceAmount() {
            return this.advanceAmount;
        }

        @Generated
        public String getCurrency() {
            return this.currency;
        }

        @Generated
        public Long getFeeAmount() {
            return this.feeAmount;
        }

        @Generated
        public Long getPreviousFinancingFeeDiscountAmount() {
            return this.previousFinancingFeeDiscountAmount;
        }

        @Generated
        public BigDecimal getWithholdRate() {
            return this.withholdRate;
        }

        @Generated
        public void setAdvanceAmount(Long advanceAmount) {
            this.advanceAmount = advanceAmount;
        }

        @Generated
        public void setCurrency(String currency) {
            this.currency = currency;
        }

        @Generated
        public void setFeeAmount(Long feeAmount) {
            this.feeAmount = feeAmount;
        }

        @Generated
        public void setPreviousFinancingFeeDiscountAmount(Long previousFinancingFeeDiscountAmount) {
            this.previousFinancingFeeDiscountAmount = previousFinancingFeeDiscountAmount;
        }

        @Generated
        public void setWithholdRate(BigDecimal withholdRate) {
            this.withholdRate = withholdRate;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AcceptedTerms)) {
                return false;
            }
            AcceptedTerms other = (AcceptedTerms)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$advanceAmount = this.getAdvanceAmount();
            Long other$advanceAmount = other.getAdvanceAmount();
            if (this$advanceAmount == null ? other$advanceAmount != null : !((Object)this$advanceAmount).equals(other$advanceAmount)) {
                return false;
            }
            Long this$feeAmount = this.getFeeAmount();
            Long other$feeAmount = other.getFeeAmount();
            if (this$feeAmount == null ? other$feeAmount != null : !((Object)this$feeAmount).equals(other$feeAmount)) {
                return false;
            }
            Long this$previousFinancingFeeDiscountAmount = this.getPreviousFinancingFeeDiscountAmount();
            Long other$previousFinancingFeeDiscountAmount = other.getPreviousFinancingFeeDiscountAmount();
            if (this$previousFinancingFeeDiscountAmount == null ? other$previousFinancingFeeDiscountAmount != null : !((Object)this$previousFinancingFeeDiscountAmount).equals(other$previousFinancingFeeDiscountAmount)) {
                return false;
            }
            String this$currency = this.getCurrency();
            String other$currency = other.getCurrency();
            if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                return false;
            }
            BigDecimal this$withholdRate = this.getWithholdRate();
            BigDecimal other$withholdRate = other.getWithholdRate();
            return !(this$withholdRate == null ? other$withholdRate != null : !((Object)this$withholdRate).equals(other$withholdRate));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AcceptedTerms;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $advanceAmount = this.getAdvanceAmount();
            result = result * 59 + ($advanceAmount == null ? 43 : ((Object)$advanceAmount).hashCode());
            Long $feeAmount = this.getFeeAmount();
            result = result * 59 + ($feeAmount == null ? 43 : ((Object)$feeAmount).hashCode());
            Long $previousFinancingFeeDiscountAmount = this.getPreviousFinancingFeeDiscountAmount();
            result = result * 59 + ($previousFinancingFeeDiscountAmount == null ? 43 : ((Object)$previousFinancingFeeDiscountAmount).hashCode());
            String $currency = this.getCurrency();
            result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
            BigDecimal $withholdRate = this.getWithholdRate();
            result = result * 59 + ($withholdRate == null ? 43 : ((Object)$withholdRate).hashCode());
            return result;
        }
    }

    public static class OfferedTerms
    extends StripeObject {
        @SerializedName(value="advance_amount")
        Long advanceAmount;
        @SerializedName(value="campaign_type")
        String campaignType;
        @SerializedName(value="currency")
        String currency;
        @SerializedName(value="fee_amount")
        Long feeAmount;
        @SerializedName(value="previous_financing_fee_discount_rate")
        BigDecimal previousFinancingFeeDiscountRate;
        @SerializedName(value="withhold_rate")
        BigDecimal withholdRate;

        @Generated
        public Long getAdvanceAmount() {
            return this.advanceAmount;
        }

        @Generated
        public String getCampaignType() {
            return this.campaignType;
        }

        @Generated
        public String getCurrency() {
            return this.currency;
        }

        @Generated
        public Long getFeeAmount() {
            return this.feeAmount;
        }

        @Generated
        public BigDecimal getPreviousFinancingFeeDiscountRate() {
            return this.previousFinancingFeeDiscountRate;
        }

        @Generated
        public BigDecimal getWithholdRate() {
            return this.withholdRate;
        }

        @Generated
        public void setAdvanceAmount(Long advanceAmount) {
            this.advanceAmount = advanceAmount;
        }

        @Generated
        public void setCampaignType(String campaignType) {
            this.campaignType = campaignType;
        }

        @Generated
        public void setCurrency(String currency) {
            this.currency = currency;
        }

        @Generated
        public void setFeeAmount(Long feeAmount) {
            this.feeAmount = feeAmount;
        }

        @Generated
        public void setPreviousFinancingFeeDiscountRate(BigDecimal previousFinancingFeeDiscountRate) {
            this.previousFinancingFeeDiscountRate = previousFinancingFeeDiscountRate;
        }

        @Generated
        public void setWithholdRate(BigDecimal withholdRate) {
            this.withholdRate = withholdRate;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OfferedTerms)) {
                return false;
            }
            OfferedTerms other = (OfferedTerms)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$advanceAmount = this.getAdvanceAmount();
            Long other$advanceAmount = other.getAdvanceAmount();
            if (this$advanceAmount == null ? other$advanceAmount != null : !((Object)this$advanceAmount).equals(other$advanceAmount)) {
                return false;
            }
            Long this$feeAmount = this.getFeeAmount();
            Long other$feeAmount = other.getFeeAmount();
            if (this$feeAmount == null ? other$feeAmount != null : !((Object)this$feeAmount).equals(other$feeAmount)) {
                return false;
            }
            String this$campaignType = this.getCampaignType();
            String other$campaignType = other.getCampaignType();
            if (this$campaignType == null ? other$campaignType != null : !this$campaignType.equals(other$campaignType)) {
                return false;
            }
            String this$currency = this.getCurrency();
            String other$currency = other.getCurrency();
            if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                return false;
            }
            BigDecimal this$previousFinancingFeeDiscountRate = this.getPreviousFinancingFeeDiscountRate();
            BigDecimal other$previousFinancingFeeDiscountRate = other.getPreviousFinancingFeeDiscountRate();
            if (this$previousFinancingFeeDiscountRate == null ? other$previousFinancingFeeDiscountRate != null : !((Object)this$previousFinancingFeeDiscountRate).equals(other$previousFinancingFeeDiscountRate)) {
                return false;
            }
            BigDecimal this$withholdRate = this.getWithholdRate();
            BigDecimal other$withholdRate = other.getWithholdRate();
            return !(this$withholdRate == null ? other$withholdRate != null : !((Object)this$withholdRate).equals(other$withholdRate));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OfferedTerms;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $advanceAmount = this.getAdvanceAmount();
            result = result * 59 + ($advanceAmount == null ? 43 : ((Object)$advanceAmount).hashCode());
            Long $feeAmount = this.getFeeAmount();
            result = result * 59 + ($feeAmount == null ? 43 : ((Object)$feeAmount).hashCode());
            String $campaignType = this.getCampaignType();
            result = result * 59 + ($campaignType == null ? 43 : $campaignType.hashCode());
            String $currency = this.getCurrency();
            result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
            BigDecimal $previousFinancingFeeDiscountRate = this.getPreviousFinancingFeeDiscountRate();
            result = result * 59 + ($previousFinancingFeeDiscountRate == null ? 43 : ((Object)$previousFinancingFeeDiscountRate).hashCode());
            BigDecimal $withholdRate = this.getWithholdRate();
            result = result * 59 + ($withholdRate == null ? 43 : ((Object)$withholdRate).hashCode());
            return result;
        }
    }
}

