/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.CustomerBalanceTransaction;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.CustomerBalanceTransactionCreateParams;
import com.stripe.param.CustomerBalanceTransactionListParams;
import com.stripe.param.CustomerBalanceTransactionRetrieveParams;
import com.stripe.param.CustomerBalanceTransactionUpdateParams;
import java.lang.reflect.Type;

public final class CustomerBalanceTransactionService
extends ApiService {
    public CustomerBalanceTransactionService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<CustomerBalanceTransaction> list(String customer, CustomerBalanceTransactionListParams params) throws StripeException {
        return this.list(customer, params, null);
    }

    public StripeCollection<CustomerBalanceTransaction> list(String customer, RequestOptions options) throws StripeException {
        return this.list(customer, null, options);
    }

    public StripeCollection<CustomerBalanceTransaction> list(String customer) throws StripeException {
        return this.list(customer, null, null);
    }

    public StripeCollection<CustomerBalanceTransaction> list(String customer, CustomerBalanceTransactionListParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/customers/%s/balance_transactions", ApiResource.urlEncodeId(customer));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<CustomerBalanceTransaction>>(){}.getType());
    }

    public CustomerBalanceTransaction create(String customer, CustomerBalanceTransactionCreateParams params) throws StripeException {
        return this.create(customer, params, null);
    }

    public CustomerBalanceTransaction create(String customer, CustomerBalanceTransactionCreateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/customers/%s/balance_transactions", ApiResource.urlEncodeId(customer));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (CustomerBalanceTransaction)this.getResponseGetter().request(request, (Type)((Object)CustomerBalanceTransaction.class));
    }

    public CustomerBalanceTransaction retrieve(String customer, String transaction, CustomerBalanceTransactionRetrieveParams params) throws StripeException {
        return this.retrieve(customer, transaction, params, null);
    }

    public CustomerBalanceTransaction retrieve(String customer, String transaction, RequestOptions options) throws StripeException {
        return this.retrieve(customer, transaction, null, options);
    }

    public CustomerBalanceTransaction retrieve(String customer, String transaction) throws StripeException {
        return this.retrieve(customer, transaction, null, null);
    }

    public CustomerBalanceTransaction retrieve(String customer, String transaction, CustomerBalanceTransactionRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/customers/%s/balance_transactions/%s", ApiResource.urlEncodeId(customer), ApiResource.urlEncodeId(transaction));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (CustomerBalanceTransaction)this.getResponseGetter().request(request, (Type)((Object)CustomerBalanceTransaction.class));
    }

    public CustomerBalanceTransaction update(String customer, String transaction, CustomerBalanceTransactionUpdateParams params) throws StripeException {
        return this.update(customer, transaction, params, null);
    }

    public CustomerBalanceTransaction update(String customer, String transaction, RequestOptions options) throws StripeException {
        return this.update(customer, transaction, null, options);
    }

    public CustomerBalanceTransaction update(String customer, String transaction) throws StripeException {
        return this.update(customer, transaction, null, null);
    }

    public CustomerBalanceTransaction update(String customer, String transaction, CustomerBalanceTransactionUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/customers/%s/balance_transactions/%s", ApiResource.urlEncodeId(customer), ApiResource.urlEncodeId(transaction));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (CustomerBalanceTransaction)this.getResponseGetter().request(request, (Type)((Object)CustomerBalanceTransaction.class));
    }
}

