/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.PaymentMethodDomain;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.PaymentMethodDomainCreateParams;
import com.stripe.param.PaymentMethodDomainListParams;
import com.stripe.param.PaymentMethodDomainRetrieveParams;
import com.stripe.param.PaymentMethodDomainUpdateParams;
import com.stripe.param.PaymentMethodDomainValidateParams;
import java.lang.reflect.Type;

public final class PaymentMethodDomainService
extends ApiService {
    public PaymentMethodDomainService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<PaymentMethodDomain> list(PaymentMethodDomainListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<PaymentMethodDomain> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<PaymentMethodDomain> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<PaymentMethodDomain> list(PaymentMethodDomainListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/payment_method_domains";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<PaymentMethodDomain>>(){}.getType());
    }

    public PaymentMethodDomain create(PaymentMethodDomainCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public PaymentMethodDomain create(PaymentMethodDomainCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/payment_method_domains";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (PaymentMethodDomain)this.getResponseGetter().request(request, (Type)((Object)PaymentMethodDomain.class));
    }

    public PaymentMethodDomain retrieve(String paymentMethodDomain, PaymentMethodDomainRetrieveParams params) throws StripeException {
        return this.retrieve(paymentMethodDomain, params, null);
    }

    public PaymentMethodDomain retrieve(String paymentMethodDomain, RequestOptions options) throws StripeException {
        return this.retrieve(paymentMethodDomain, null, options);
    }

    public PaymentMethodDomain retrieve(String paymentMethodDomain) throws StripeException {
        return this.retrieve(paymentMethodDomain, null, null);
    }

    public PaymentMethodDomain retrieve(String paymentMethodDomain, PaymentMethodDomainRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_method_domains/%s", ApiResource.urlEncodeId(paymentMethodDomain));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (PaymentMethodDomain)this.getResponseGetter().request(request, (Type)((Object)PaymentMethodDomain.class));
    }

    public PaymentMethodDomain update(String paymentMethodDomain, PaymentMethodDomainUpdateParams params) throws StripeException {
        return this.update(paymentMethodDomain, params, null);
    }

    public PaymentMethodDomain update(String paymentMethodDomain, RequestOptions options) throws StripeException {
        return this.update(paymentMethodDomain, null, options);
    }

    public PaymentMethodDomain update(String paymentMethodDomain) throws StripeException {
        return this.update(paymentMethodDomain, null, null);
    }

    public PaymentMethodDomain update(String paymentMethodDomain, PaymentMethodDomainUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_method_domains/%s", ApiResource.urlEncodeId(paymentMethodDomain));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (PaymentMethodDomain)this.getResponseGetter().request(request, (Type)((Object)PaymentMethodDomain.class));
    }

    public PaymentMethodDomain validate(String paymentMethodDomain, PaymentMethodDomainValidateParams params) throws StripeException {
        return this.validate(paymentMethodDomain, params, null);
    }

    public PaymentMethodDomain validate(String paymentMethodDomain, RequestOptions options) throws StripeException {
        return this.validate(paymentMethodDomain, null, options);
    }

    public PaymentMethodDomain validate(String paymentMethodDomain) throws StripeException {
        return this.validate(paymentMethodDomain, null, null);
    }

    public PaymentMethodDomain validate(String paymentMethodDomain, PaymentMethodDomainValidateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_method_domains/%s/validate", ApiResource.urlEncodeId(paymentMethodDomain));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (PaymentMethodDomain)this.getResponseGetter().request(request, (Type)((Object)PaymentMethodDomain.class));
    }
}

