/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.stripe.exception.StripeException;
import com.stripe.model.Token;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.TokenCreateParams;
import com.stripe.param.TokenRetrieveParams;
import java.lang.reflect.Type;

public final class TokenService
extends ApiService {
    public TokenService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public Token retrieve(String token, TokenRetrieveParams params) throws StripeException {
        return this.retrieve(token, params, null);
    }

    public Token retrieve(String token, RequestOptions options) throws StripeException {
        return this.retrieve(token, null, options);
    }

    public Token retrieve(String token) throws StripeException {
        return this.retrieve(token, null, null);
    }

    public Token retrieve(String token, TokenRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/tokens/%s", ApiResource.urlEncodeId(token));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Token)this.getResponseGetter().request(request, (Type)((Object)Token.class));
    }

    public Token create(TokenCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Token create(RequestOptions options) throws StripeException {
        return this.create(null, options);
    }

    public Token create() throws StripeException {
        return this.create(null, null);
    }

    public Token create(TokenCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/tokens";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Token)this.getResponseGetter().request(request, (Type)((Object)Token.class));
    }
}

