/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.capital;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.capital.FinancingOffer;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.capital.FinancingOfferListParams;
import com.stripe.param.capital.FinancingOfferMarkDeliveredParams;
import com.stripe.param.capital.FinancingOfferRetrieveParams;
import java.lang.reflect.Type;

public final class FinancingOfferService
extends ApiService {
    public FinancingOfferService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<FinancingOffer> list(FinancingOfferListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<FinancingOffer> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<FinancingOffer> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<FinancingOffer> list(FinancingOfferListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/capital/financing_offers";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<FinancingOffer>>(){}.getType());
    }

    public FinancingOffer retrieve(String financingOffer, FinancingOfferRetrieveParams params) throws StripeException {
        return this.retrieve(financingOffer, params, null);
    }

    public FinancingOffer retrieve(String financingOffer, RequestOptions options) throws StripeException {
        return this.retrieve(financingOffer, null, options);
    }

    public FinancingOffer retrieve(String financingOffer) throws StripeException {
        return this.retrieve(financingOffer, null, null);
    }

    public FinancingOffer retrieve(String financingOffer, FinancingOfferRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/capital/financing_offers/%s", ApiResource.urlEncodeId(financingOffer));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (FinancingOffer)this.getResponseGetter().request(request, (Type)((Object)FinancingOffer.class));
    }

    public FinancingOffer markDelivered(String financingOffer, FinancingOfferMarkDeliveredParams params) throws StripeException {
        return this.markDelivered(financingOffer, params, null);
    }

    public FinancingOffer markDelivered(String financingOffer, RequestOptions options) throws StripeException {
        return this.markDelivered(financingOffer, null, options);
    }

    public FinancingOffer markDelivered(String financingOffer) throws StripeException {
        return this.markDelivered(financingOffer, null, null);
    }

    public FinancingOffer markDelivered(String financingOffer, FinancingOfferMarkDeliveredParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/capital/financing_offers/%s/mark_delivered", ApiResource.urlEncodeId(financingOffer));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (FinancingOffer)this.getResponseGetter().request(request, (Type)((Object)FinancingOffer.class));
    }
}

