/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.TransferReversal;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.TransferReversalCreateParams;
import com.stripe.param.TransferReversalListParams;
import com.stripe.param.TransferReversalRetrieveParams;
import com.stripe.param.TransferReversalUpdateParams;
import java.lang.reflect.Type;

public final class TransferReversalService
extends ApiService {
    public TransferReversalService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<TransferReversal> list(String id, TransferReversalListParams params) throws StripeException {
        return this.list(id, params, null);
    }

    public StripeCollection<TransferReversal> list(String id, RequestOptions options) throws StripeException {
        return this.list(id, null, options);
    }

    public StripeCollection<TransferReversal> list(String id) throws StripeException {
        return this.list(id, null, null);
    }

    public StripeCollection<TransferReversal> list(String id, TransferReversalListParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/transfers/%s/reversals", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<TransferReversal>>(){}.getType());
    }

    public TransferReversal create(String id, TransferReversalCreateParams params) throws StripeException {
        return this.create(id, params, null);
    }

    public TransferReversal create(String id, RequestOptions options) throws StripeException {
        return this.create(id, null, options);
    }

    public TransferReversal create(String id) throws StripeException {
        return this.create(id, null, null);
    }

    public TransferReversal create(String id, TransferReversalCreateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/transfers/%s/reversals", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (TransferReversal)this.getResponseGetter().request(request, (Type)((Object)TransferReversal.class));
    }

    public TransferReversal retrieve(String transfer, String id, TransferReversalRetrieveParams params) throws StripeException {
        return this.retrieve(transfer, id, params, null);
    }

    public TransferReversal retrieve(String transfer, String id, RequestOptions options) throws StripeException {
        return this.retrieve(transfer, id, null, options);
    }

    public TransferReversal retrieve(String transfer, String id) throws StripeException {
        return this.retrieve(transfer, id, null, null);
    }

    public TransferReversal retrieve(String transfer, String id, TransferReversalRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/transfers/%s/reversals/%s", ApiResource.urlEncodeId(transfer), ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (TransferReversal)this.getResponseGetter().request(request, (Type)((Object)TransferReversal.class));
    }

    public TransferReversal update(String transfer, String id, TransferReversalUpdateParams params) throws StripeException {
        return this.update(transfer, id, params, null);
    }

    public TransferReversal update(String transfer, String id, RequestOptions options) throws StripeException {
        return this.update(transfer, id, null, options);
    }

    public TransferReversal update(String transfer, String id) throws StripeException {
        return this.update(transfer, id, null, null);
    }

    public TransferReversal update(String transfer, String id, TransferReversalUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/transfers/%s/reversals/%s", ApiResource.urlEncodeId(transfer), ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (TransferReversal)this.getResponseGetter().request(request, (Type)((Object)TransferReversal.class));
    }
}

