/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.issuing;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.issuing.Token;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.issuing.TokenListParams;
import com.stripe.param.issuing.TokenRetrieveParams;
import com.stripe.param.issuing.TokenUpdateParams;
import java.lang.reflect.Type;

public final class TokenService
extends ApiService {
    public TokenService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<Token> list(TokenListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Token> list(TokenListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/tokens";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<Token>>(){}.getType());
    }

    public Token retrieve(String token, TokenRetrieveParams params) throws StripeException {
        return this.retrieve(token, params, null);
    }

    public Token retrieve(String token, RequestOptions options) throws StripeException {
        return this.retrieve(token, null, options);
    }

    public Token retrieve(String token) throws StripeException {
        return this.retrieve(token, null, null);
    }

    public Token retrieve(String token, TokenRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/tokens/%s", ApiResource.urlEncodeId(token));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Token)this.getResponseGetter().request(request, (Type)((Object)Token.class));
    }

    public Token update(String token, TokenUpdateParams params) throws StripeException {
        return this.update(token, params, null);
    }

    public Token update(String token, TokenUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/tokens/%s", ApiResource.urlEncodeId(token));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Token)this.getResponseGetter().request(request, (Type)((Object)Token.class));
    }
}

