/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.Price;
import com.stripe.model.StripeCollection;
import com.stripe.model.StripeSearchResult;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.PriceCreateParams;
import com.stripe.param.PriceListParams;
import com.stripe.param.PriceRetrieveParams;
import com.stripe.param.PriceSearchParams;
import com.stripe.param.PriceUpdateParams;
import java.lang.reflect.Type;

public final class PriceService
extends ApiService {
    public PriceService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<Price> list(PriceListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Price> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Price> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Price> list(PriceListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/prices";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<Price>>(){}.getType());
    }

    public Price create(PriceCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Price create(PriceCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/prices";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Price)this.getResponseGetter().request(request, (Type)((Object)Price.class));
    }

    public Price retrieve(String price, PriceRetrieveParams params) throws StripeException {
        return this.retrieve(price, params, null);
    }

    public Price retrieve(String price, RequestOptions options) throws StripeException {
        return this.retrieve(price, null, options);
    }

    public Price retrieve(String price) throws StripeException {
        return this.retrieve(price, null, null);
    }

    public Price retrieve(String price, PriceRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/prices/%s", ApiResource.urlEncodeId(price));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Price)this.getResponseGetter().request(request, (Type)((Object)Price.class));
    }

    public Price update(String price, PriceUpdateParams params) throws StripeException {
        return this.update(price, params, null);
    }

    public Price update(String price, RequestOptions options) throws StripeException {
        return this.update(price, null, options);
    }

    public Price update(String price) throws StripeException {
        return this.update(price, null, null);
    }

    public Price update(String price, PriceUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/prices/%s", ApiResource.urlEncodeId(price));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Price)this.getResponseGetter().request(request, (Type)((Object)Price.class));
    }

    public StripeSearchResult<Price> search(PriceSearchParams params) throws StripeException {
        return this.search(params, null);
    }

    public StripeSearchResult<Price> search(PriceSearchParams params, RequestOptions options) throws StripeException {
        String path = "/v1/prices/search";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (StripeSearchResult)this.getResponseGetter().request(request, new TypeToken<StripeSearchResult<Price>>(){}.getType());
    }
}

