/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.LineItem;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.QuotePhaseLineItemListParams;

public final class QuotePhaseLineItemService
extends ApiService {
    public QuotePhaseLineItemService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<LineItem> list(String quotePhase, QuotePhaseLineItemListParams params) throws StripeException {
        return this.list(quotePhase, params, null);
    }

    public StripeCollection<LineItem> list(String quotePhase, RequestOptions options) throws StripeException {
        return this.list(quotePhase, null, options);
    }

    public StripeCollection<LineItem> list(String quotePhase) throws StripeException {
        return this.list(quotePhase, null, null);
    }

    public StripeCollection<LineItem> list(String quotePhase, QuotePhaseLineItemListParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/quote_phases/%s/line_items", ApiResource.urlEncodeId(quotePhase));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<LineItem>>(){}.getType());
    }
}

