/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.capital;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.capital.FinancingTransaction;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.capital.FinancingTransactionListParams;
import com.stripe.param.capital.FinancingTransactionRetrieveParams;
import java.lang.reflect.Type;

public final class FinancingTransactionService
extends ApiService {
    public FinancingTransactionService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<FinancingTransaction> list(FinancingTransactionListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<FinancingTransaction> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<FinancingTransaction> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<FinancingTransaction> list(FinancingTransactionListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/capital/financing_transactions";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<FinancingTransaction>>(){}.getType());
    }

    public FinancingTransaction retrieve(String financingTransaction, FinancingTransactionRetrieveParams params) throws StripeException {
        return this.retrieve(financingTransaction, params, null);
    }

    public FinancingTransaction retrieve(String financingTransaction, RequestOptions options) throws StripeException {
        return this.retrieve(financingTransaction, null, options);
    }

    public FinancingTransaction retrieve(String financingTransaction) throws StripeException {
        return this.retrieve(financingTransaction, null, null);
    }

    public FinancingTransaction retrieve(String financingTransaction, FinancingTransactionRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/capital/financing_transactions/%s", ApiResource.urlEncodeId(financingTransaction));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (FinancingTransaction)this.getResponseGetter().request(request, (Type)((Object)FinancingTransaction.class));
    }
}

