/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.radar;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.radar.ValueList;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.radar.ValueListCreateParams;
import com.stripe.param.radar.ValueListListParams;
import com.stripe.param.radar.ValueListRetrieveParams;
import com.stripe.param.radar.ValueListUpdateParams;
import java.lang.reflect.Type;

public final class ValueListService
extends ApiService {
    public ValueListService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public ValueList delete(String valueList) throws StripeException {
        return this.delete(valueList, null);
    }

    public ValueList delete(String valueList, RequestOptions options) throws StripeException {
        String path = String.format("/v1/radar/value_lists/%s", ApiResource.urlEncodeId(valueList));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, null, options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (ValueList)this.getResponseGetter().request(request, (Type)((Object)ValueList.class));
    }

    public ValueList retrieve(String valueList, ValueListRetrieveParams params) throws StripeException {
        return this.retrieve(valueList, params, null);
    }

    public ValueList retrieve(String valueList, RequestOptions options) throws StripeException {
        return this.retrieve(valueList, null, options);
    }

    public ValueList retrieve(String valueList) throws StripeException {
        return this.retrieve(valueList, null, null);
    }

    public ValueList retrieve(String valueList, ValueListRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/radar/value_lists/%s", ApiResource.urlEncodeId(valueList));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (ValueList)this.getResponseGetter().request(request, (Type)((Object)ValueList.class));
    }

    public ValueList update(String valueList, ValueListUpdateParams params) throws StripeException {
        return this.update(valueList, params, null);
    }

    public ValueList update(String valueList, RequestOptions options) throws StripeException {
        return this.update(valueList, null, options);
    }

    public ValueList update(String valueList) throws StripeException {
        return this.update(valueList, null, null);
    }

    public ValueList update(String valueList, ValueListUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/radar/value_lists/%s", ApiResource.urlEncodeId(valueList));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (ValueList)this.getResponseGetter().request(request, (Type)((Object)ValueList.class));
    }

    public StripeCollection<ValueList> list(ValueListListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<ValueList> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<ValueList> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<ValueList> list(ValueListListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/radar/value_lists";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<ValueList>>(){}.getType());
    }

    public ValueList create(ValueListCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public ValueList create(ValueListCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/radar/value_lists";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (ValueList)this.getResponseGetter().request(request, (Type)((Object)ValueList.class));
    }
}

