/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.treasury;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.treasury.TransactionEntry;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.treasury.TransactionEntryListParams;
import com.stripe.param.treasury.TransactionEntryRetrieveParams;
import java.lang.reflect.Type;

public final class TransactionEntryService
extends ApiService {
    public TransactionEntryService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<TransactionEntry> list(TransactionEntryListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<TransactionEntry> list(TransactionEntryListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/treasury/transaction_entries";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<TransactionEntry>>(){}.getType());
    }

    public TransactionEntry retrieve(String id, TransactionEntryRetrieveParams params) throws StripeException {
        return this.retrieve(id, params, null);
    }

    public TransactionEntry retrieve(String id, RequestOptions options) throws StripeException {
        return this.retrieve(id, null, options);
    }

    public TransactionEntry retrieve(String id) throws StripeException {
        return this.retrieve(id, null, null);
    }

    public TransactionEntry retrieve(String id, TransactionEntryRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/treasury/transaction_entries/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (TransactionEntry)this.getResponseGetter().request(request, (Type)((Object)TransactionEntry.class));
    }
}

