/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.terminal;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.terminal.Reader;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.terminal.ReaderCancelActionParams;
import com.stripe.param.terminal.ReaderCreateParams;
import com.stripe.param.terminal.ReaderListParams;
import com.stripe.param.terminal.ReaderProcessPaymentIntentParams;
import com.stripe.param.terminal.ReaderProcessSetupIntentParams;
import com.stripe.param.terminal.ReaderRefundPaymentParams;
import com.stripe.param.terminal.ReaderRetrieveParams;
import com.stripe.param.terminal.ReaderSetReaderDisplayParams;
import com.stripe.param.terminal.ReaderUpdateParams;
import java.lang.reflect.Type;

public final class ReaderService
extends ApiService {
    public ReaderService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public Reader delete(String reader) throws StripeException {
        return this.delete(reader, null);
    }

    public Reader delete(String reader, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/readers/%s", ApiResource.urlEncodeId(reader));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, null, options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Reader)this.getResponseGetter().request(request, (Type)((Object)Reader.class));
    }

    public Reader retrieve(String reader, ReaderRetrieveParams params) throws StripeException {
        return this.retrieve(reader, params, null);
    }

    public Reader retrieve(String reader, RequestOptions options) throws StripeException {
        return this.retrieve(reader, null, options);
    }

    public Reader retrieve(String reader) throws StripeException {
        return this.retrieve(reader, null, null);
    }

    public Reader retrieve(String reader, ReaderRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/readers/%s", ApiResource.urlEncodeId(reader));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Reader)this.getResponseGetter().request(request, (Type)((Object)Reader.class));
    }

    public Reader update(String reader, ReaderUpdateParams params) throws StripeException {
        return this.update(reader, params, null);
    }

    public Reader update(String reader, RequestOptions options) throws StripeException {
        return this.update(reader, null, options);
    }

    public Reader update(String reader) throws StripeException {
        return this.update(reader, null, null);
    }

    public Reader update(String reader, ReaderUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/readers/%s", ApiResource.urlEncodeId(reader));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Reader)this.getResponseGetter().request(request, (Type)((Object)Reader.class));
    }

    public StripeCollection<Reader> list(ReaderListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Reader> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Reader> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Reader> list(ReaderListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/terminal/readers";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<Reader>>(){}.getType());
    }

    public Reader create(ReaderCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Reader create(ReaderCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/terminal/readers";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Reader)this.getResponseGetter().request(request, (Type)((Object)Reader.class));
    }

    public Reader cancelAction(String reader, ReaderCancelActionParams params) throws StripeException {
        return this.cancelAction(reader, params, null);
    }

    public Reader cancelAction(String reader, RequestOptions options) throws StripeException {
        return this.cancelAction(reader, null, options);
    }

    public Reader cancelAction(String reader) throws StripeException {
        return this.cancelAction(reader, null, null);
    }

    public Reader cancelAction(String reader, ReaderCancelActionParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/readers/%s/cancel_action", ApiResource.urlEncodeId(reader));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Reader)this.getResponseGetter().request(request, (Type)((Object)Reader.class));
    }

    public Reader processPaymentIntent(String reader, ReaderProcessPaymentIntentParams params) throws StripeException {
        return this.processPaymentIntent(reader, params, null);
    }

    public Reader processPaymentIntent(String reader, ReaderProcessPaymentIntentParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/readers/%s/process_payment_intent", ApiResource.urlEncodeId(reader));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Reader)this.getResponseGetter().request(request, (Type)((Object)Reader.class));
    }

    public Reader processSetupIntent(String reader, ReaderProcessSetupIntentParams params) throws StripeException {
        return this.processSetupIntent(reader, params, null);
    }

    public Reader processSetupIntent(String reader, ReaderProcessSetupIntentParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/readers/%s/process_setup_intent", ApiResource.urlEncodeId(reader));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Reader)this.getResponseGetter().request(request, (Type)((Object)Reader.class));
    }

    public Reader refundPayment(String reader, ReaderRefundPaymentParams params) throws StripeException {
        return this.refundPayment(reader, params, null);
    }

    public Reader refundPayment(String reader, RequestOptions options) throws StripeException {
        return this.refundPayment(reader, null, options);
    }

    public Reader refundPayment(String reader) throws StripeException {
        return this.refundPayment(reader, null, null);
    }

    public Reader refundPayment(String reader, ReaderRefundPaymentParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/readers/%s/refund_payment", ApiResource.urlEncodeId(reader));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Reader)this.getResponseGetter().request(request, (Type)((Object)Reader.class));
    }

    public Reader setReaderDisplay(String reader, ReaderSetReaderDisplayParams params) throws StripeException {
        return this.setReaderDisplay(reader, params, null);
    }

    public Reader setReaderDisplay(String reader, ReaderSetReaderDisplayParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/terminal/readers/%s/set_reader_display", ApiResource.urlEncodeId(reader));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Reader)this.getResponseGetter().request(request, (Type)((Object)Reader.class));
    }
}

