/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.treasury;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.treasury.FinancialAccount;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.treasury.FinancialAccountCreateParams;
import com.stripe.param.treasury.FinancialAccountListParams;
import com.stripe.param.treasury.FinancialAccountRetrieveParams;
import com.stripe.param.treasury.FinancialAccountUpdateParams;
import com.stripe.service.treasury.FinancialAccountFeaturesService;
import java.lang.reflect.Type;

public final class FinancialAccountService
extends ApiService {
    public FinancialAccountService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<FinancialAccount> list(FinancialAccountListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<FinancialAccount> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<FinancialAccount> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<FinancialAccount> list(FinancialAccountListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/treasury/financial_accounts";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<FinancialAccount>>(){}.getType());
    }

    public FinancialAccount create(FinancialAccountCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public FinancialAccount create(FinancialAccountCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/treasury/financial_accounts";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (FinancialAccount)this.getResponseGetter().request(request, (Type)((Object)FinancialAccount.class));
    }

    public FinancialAccount retrieve(String financialAccount, FinancialAccountRetrieveParams params) throws StripeException {
        return this.retrieve(financialAccount, params, null);
    }

    public FinancialAccount retrieve(String financialAccount, RequestOptions options) throws StripeException {
        return this.retrieve(financialAccount, null, options);
    }

    public FinancialAccount retrieve(String financialAccount) throws StripeException {
        return this.retrieve(financialAccount, null, null);
    }

    public FinancialAccount retrieve(String financialAccount, FinancialAccountRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/treasury/financial_accounts/%s", ApiResource.urlEncodeId(financialAccount));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (FinancialAccount)this.getResponseGetter().request(request, (Type)((Object)FinancialAccount.class));
    }

    public FinancialAccount update(String financialAccount, FinancialAccountUpdateParams params) throws StripeException {
        return this.update(financialAccount, params, null);
    }

    public FinancialAccount update(String financialAccount, RequestOptions options) throws StripeException {
        return this.update(financialAccount, null, options);
    }

    public FinancialAccount update(String financialAccount) throws StripeException {
        return this.update(financialAccount, null, null);
    }

    public FinancialAccount update(String financialAccount, FinancialAccountUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/treasury/financial_accounts/%s", ApiResource.urlEncodeId(financialAccount));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (FinancialAccount)this.getResponseGetter().request(request, (Type)((Object)FinancialAccount.class));
    }

    public FinancialAccountFeaturesService features() {
        return new FinancialAccountFeaturesService(this.getResponseGetter());
    }
}

