/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.entitlements;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.model.entitlements.FeatureCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.entitlements.FeatureCreateParams;
import com.stripe.param.entitlements.FeatureListParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class Feature
extends ApiResource
implements HasId {
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="lookup_key")
    String lookupKey;
    @SerializedName(value="name")
    String name;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="quantity")
    Quantity quantity;
    @SerializedName(value="type")
    String type;

    public static Feature create(Map<String, Object> params) throws StripeException {
        return Feature.create(params, (RequestOptions)null);
    }

    public static Feature create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/entitlements/features";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (Feature)Feature.getGlobalResponseGetter().request(request, (Type)((Object)Feature.class));
    }

    public static Feature create(FeatureCreateParams params) throws StripeException {
        return Feature.create(params, (RequestOptions)null);
    }

    public static Feature create(FeatureCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/entitlements/features";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Feature)Feature.getGlobalResponseGetter().request(request, (Type)((Object)Feature.class));
    }

    public static FeatureCollection list(Map<String, Object> params) throws StripeException {
        return Feature.list(params, (RequestOptions)null);
    }

    public static FeatureCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/entitlements/features";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (FeatureCollection)Feature.getGlobalResponseGetter().request(request, (Type)((Object)FeatureCollection.class));
    }

    public static FeatureCollection list(FeatureListParams params) throws StripeException {
        return Feature.list(params, (RequestOptions)null);
    }

    public static FeatureCollection list(FeatureListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/entitlements/features";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (FeatureCollection)Feature.getGlobalResponseGetter().request(request, (Type)((Object)FeatureCollection.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.quantity, responseGetter);
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getLookupKey() {
        return this.lookupKey;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Quantity getQuantity() {
        return this.quantity;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setLookupKey(String lookupKey) {
        this.lookupKey = lookupKey;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setQuantity(Quantity quantity) {
        this.quantity = quantity;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Feature)) {
            return false;
        }
        Feature other = (Feature)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$lookupKey = this.getLookupKey();
        String other$lookupKey = other.getLookupKey();
        if (this$lookupKey == null ? other$lookupKey != null : !this$lookupKey.equals(other$lookupKey)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Quantity this$quantity = this.getQuantity();
        Quantity other$quantity = other.getQuantity();
        if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Feature;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $lookupKey = this.getLookupKey();
        result = result * 59 + ($lookupKey == null ? 43 : $lookupKey.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Quantity $quantity = this.getQuantity();
        result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class Quantity
    extends StripeObject {
        @SerializedName(value="units_available")
        Long unitsAvailable;

        @Generated
        public Long getUnitsAvailable() {
            return this.unitsAvailable;
        }

        @Generated
        public void setUnitsAvailable(Long unitsAvailable) {
            this.unitsAvailable = unitsAvailable;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Quantity)) {
                return false;
            }
            Quantity other = (Quantity)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$unitsAvailable = this.getUnitsAvailable();
            Long other$unitsAvailable = other.getUnitsAvailable();
            return !(this$unitsAvailable == null ? other$unitsAvailable != null : !((Object)this$unitsAvailable).equals(other$unitsAvailable));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Quantity;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $unitsAvailable = this.getUnitsAvailable();
            result = result * 59 + ($unitsAvailable == null ? 43 : ((Object)$unitsAvailable).hashCode());
            return result;
        }
    }
}

