/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.treasury;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.Address;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.model.treasury.ReceivedDebitCollection;
import com.stripe.model.treasury.Transaction;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.treasury.ReceivedDebitCreateParams;
import com.stripe.param.treasury.ReceivedDebitListParams;
import com.stripe.param.treasury.ReceivedDebitRetrieveParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class ReceivedDebit
extends ApiResource
implements HasId {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="failure_code")
    String failureCode;
    @SerializedName(value="financial_account")
    String financialAccount;
    @SerializedName(value="hosted_regulatory_receipt_url")
    String hostedRegulatoryReceiptUrl;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="initiating_payment_method_details")
    InitiatingPaymentMethodDetails initiatingPaymentMethodDetails;
    @SerializedName(value="linked_flows")
    LinkedFlows linkedFlows;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="network")
    String network;
    @SerializedName(value="network_details")
    NetworkDetails networkDetails;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="reversal_details")
    ReversalDetails reversalDetails;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="transaction")
    ExpandableField<Transaction> transaction;

    public String getTransaction() {
        return this.transaction != null ? this.transaction.getId() : null;
    }

    public void setTransaction(String id) {
        this.transaction = ApiResource.setExpandableFieldId(id, this.transaction);
    }

    public Transaction getTransactionObject() {
        return this.transaction != null ? this.transaction.getExpanded() : null;
    }

    public void setTransactionObject(Transaction expandableObject) {
        this.transaction = new ExpandableField<Transaction>(expandableObject.getId(), expandableObject);
    }

    public static ReceivedDebitCollection list(Map<String, Object> params) throws StripeException {
        return ReceivedDebit.list(params, (RequestOptions)null);
    }

    public static ReceivedDebitCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/treasury/received_debits";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (ReceivedDebitCollection)ReceivedDebit.getGlobalResponseGetter().request(request, (Type)((Object)ReceivedDebitCollection.class));
    }

    public static ReceivedDebitCollection list(ReceivedDebitListParams params) throws StripeException {
        return ReceivedDebit.list(params, (RequestOptions)null);
    }

    public static ReceivedDebitCollection list(ReceivedDebitListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/treasury/received_debits";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (ReceivedDebitCollection)ReceivedDebit.getGlobalResponseGetter().request(request, (Type)((Object)ReceivedDebitCollection.class));
    }

    public static ReceivedDebit retrieve(String id) throws StripeException {
        return ReceivedDebit.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static ReceivedDebit retrieve(String id, RequestOptions options) throws StripeException {
        return ReceivedDebit.retrieve(id, (Map<String, Object>)null, options);
    }

    public static ReceivedDebit retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/treasury/received_debits/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (ReceivedDebit)ReceivedDebit.getGlobalResponseGetter().request(request, (Type)((Object)ReceivedDebit.class));
    }

    public static ReceivedDebit retrieve(String id, ReceivedDebitRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/treasury/received_debits/%s", ApiResource.urlEncodeId(id));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (ReceivedDebit)ReceivedDebit.getGlobalResponseGetter().request(request, (Type)((Object)ReceivedDebit.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.initiatingPaymentMethodDetails, responseGetter);
        this.trySetResponseGetter(this.linkedFlows, responseGetter);
        this.trySetResponseGetter(this.networkDetails, responseGetter);
        this.trySetResponseGetter(this.reversalDetails, responseGetter);
        this.trySetResponseGetter(this.transaction, responseGetter);
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getFailureCode() {
        return this.failureCode;
    }

    @Generated
    public String getFinancialAccount() {
        return this.financialAccount;
    }

    @Generated
    public String getHostedRegulatoryReceiptUrl() {
        return this.hostedRegulatoryReceiptUrl;
    }

    @Generated
    public InitiatingPaymentMethodDetails getInitiatingPaymentMethodDetails() {
        return this.initiatingPaymentMethodDetails;
    }

    @Generated
    public LinkedFlows getLinkedFlows() {
        return this.linkedFlows;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getNetwork() {
        return this.network;
    }

    @Generated
    public NetworkDetails getNetworkDetails() {
        return this.networkDetails;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public ReversalDetails getReversalDetails() {
        return this.reversalDetails;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setFailureCode(String failureCode) {
        this.failureCode = failureCode;
    }

    @Generated
    public void setFinancialAccount(String financialAccount) {
        this.financialAccount = financialAccount;
    }

    @Generated
    public void setHostedRegulatoryReceiptUrl(String hostedRegulatoryReceiptUrl) {
        this.hostedRegulatoryReceiptUrl = hostedRegulatoryReceiptUrl;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setInitiatingPaymentMethodDetails(InitiatingPaymentMethodDetails initiatingPaymentMethodDetails) {
        this.initiatingPaymentMethodDetails = initiatingPaymentMethodDetails;
    }

    @Generated
    public void setLinkedFlows(LinkedFlows linkedFlows) {
        this.linkedFlows = linkedFlows;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setNetwork(String network) {
        this.network = network;
    }

    @Generated
    public void setNetworkDetails(NetworkDetails networkDetails) {
        this.networkDetails = networkDetails;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setReversalDetails(ReversalDetails reversalDetails) {
        this.reversalDetails = reversalDetails;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReceivedDebit)) {
            return false;
        }
        ReceivedDebit other = (ReceivedDebit)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$failureCode = this.getFailureCode();
        String other$failureCode = other.getFailureCode();
        if (this$failureCode == null ? other$failureCode != null : !this$failureCode.equals(other$failureCode)) {
            return false;
        }
        String this$financialAccount = this.getFinancialAccount();
        String other$financialAccount = other.getFinancialAccount();
        if (this$financialAccount == null ? other$financialAccount != null : !this$financialAccount.equals(other$financialAccount)) {
            return false;
        }
        String this$hostedRegulatoryReceiptUrl = this.getHostedRegulatoryReceiptUrl();
        String other$hostedRegulatoryReceiptUrl = other.getHostedRegulatoryReceiptUrl();
        if (this$hostedRegulatoryReceiptUrl == null ? other$hostedRegulatoryReceiptUrl != null : !this$hostedRegulatoryReceiptUrl.equals(other$hostedRegulatoryReceiptUrl)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        InitiatingPaymentMethodDetails this$initiatingPaymentMethodDetails = this.getInitiatingPaymentMethodDetails();
        InitiatingPaymentMethodDetails other$initiatingPaymentMethodDetails = other.getInitiatingPaymentMethodDetails();
        if (this$initiatingPaymentMethodDetails == null ? other$initiatingPaymentMethodDetails != null : !((Object)this$initiatingPaymentMethodDetails).equals(other$initiatingPaymentMethodDetails)) {
            return false;
        }
        LinkedFlows this$linkedFlows = this.getLinkedFlows();
        LinkedFlows other$linkedFlows = other.getLinkedFlows();
        if (this$linkedFlows == null ? other$linkedFlows != null : !((Object)this$linkedFlows).equals(other$linkedFlows)) {
            return false;
        }
        String this$network = this.getNetwork();
        String other$network = other.getNetwork();
        if (this$network == null ? other$network != null : !this$network.equals(other$network)) {
            return false;
        }
        NetworkDetails this$networkDetails = this.getNetworkDetails();
        NetworkDetails other$networkDetails = other.getNetworkDetails();
        if (this$networkDetails == null ? other$networkDetails != null : !((Object)this$networkDetails).equals(other$networkDetails)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        ReversalDetails this$reversalDetails = this.getReversalDetails();
        ReversalDetails other$reversalDetails = other.getReversalDetails();
        if (this$reversalDetails == null ? other$reversalDetails != null : !((Object)this$reversalDetails).equals(other$reversalDetails)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$transaction = this.getTransaction();
        String other$transaction = other.getTransaction();
        return !(this$transaction == null ? other$transaction != null : !this$transaction.equals(other$transaction));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReceivedDebit;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $failureCode = this.getFailureCode();
        result = result * 59 + ($failureCode == null ? 43 : $failureCode.hashCode());
        String $financialAccount = this.getFinancialAccount();
        result = result * 59 + ($financialAccount == null ? 43 : $financialAccount.hashCode());
        String $hostedRegulatoryReceiptUrl = this.getHostedRegulatoryReceiptUrl();
        result = result * 59 + ($hostedRegulatoryReceiptUrl == null ? 43 : $hostedRegulatoryReceiptUrl.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        InitiatingPaymentMethodDetails $initiatingPaymentMethodDetails = this.getInitiatingPaymentMethodDetails();
        result = result * 59 + ($initiatingPaymentMethodDetails == null ? 43 : ((Object)$initiatingPaymentMethodDetails).hashCode());
        LinkedFlows $linkedFlows = this.getLinkedFlows();
        result = result * 59 + ($linkedFlows == null ? 43 : ((Object)$linkedFlows).hashCode());
        String $network = this.getNetwork();
        result = result * 59 + ($network == null ? 43 : $network.hashCode());
        NetworkDetails $networkDetails = this.getNetworkDetails();
        result = result * 59 + ($networkDetails == null ? 43 : ((Object)$networkDetails).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        ReversalDetails $reversalDetails = this.getReversalDetails();
        result = result * 59 + ($reversalDetails == null ? 43 : ((Object)$reversalDetails).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $transaction = this.getTransaction();
        result = result * 59 + ($transaction == null ? 43 : $transaction.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class InitiatingPaymentMethodDetails
    extends StripeObject {
        @SerializedName(value="balance")
        String balance;
        @SerializedName(value="billing_details")
        BillingDetails billingDetails;
        @SerializedName(value="financial_account")
        FinancialAccount financialAccount;
        @SerializedName(value="issuing_card")
        String issuingCard;
        @SerializedName(value="type")
        String type;
        @SerializedName(value="us_bank_account")
        UsBankAccount usBankAccount;

        @Generated
        public String getBalance() {
            return this.balance;
        }

        @Generated
        public BillingDetails getBillingDetails() {
            return this.billingDetails;
        }

        @Generated
        public FinancialAccount getFinancialAccount() {
            return this.financialAccount;
        }

        @Generated
        public String getIssuingCard() {
            return this.issuingCard;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public UsBankAccount getUsBankAccount() {
            return this.usBankAccount;
        }

        @Generated
        public void setBalance(String balance) {
            this.balance = balance;
        }

        @Generated
        public void setBillingDetails(BillingDetails billingDetails) {
            this.billingDetails = billingDetails;
        }

        @Generated
        public void setFinancialAccount(FinancialAccount financialAccount) {
            this.financialAccount = financialAccount;
        }

        @Generated
        public void setIssuingCard(String issuingCard) {
            this.issuingCard = issuingCard;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setUsBankAccount(UsBankAccount usBankAccount) {
            this.usBankAccount = usBankAccount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InitiatingPaymentMethodDetails)) {
                return false;
            }
            InitiatingPaymentMethodDetails other = (InitiatingPaymentMethodDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$balance = this.getBalance();
            String other$balance = other.getBalance();
            if (this$balance == null ? other$balance != null : !this$balance.equals(other$balance)) {
                return false;
            }
            BillingDetails this$billingDetails = this.getBillingDetails();
            BillingDetails other$billingDetails = other.getBillingDetails();
            if (this$billingDetails == null ? other$billingDetails != null : !((Object)this$billingDetails).equals(other$billingDetails)) {
                return false;
            }
            FinancialAccount this$financialAccount = this.getFinancialAccount();
            FinancialAccount other$financialAccount = other.getFinancialAccount();
            if (this$financialAccount == null ? other$financialAccount != null : !((Object)this$financialAccount).equals(other$financialAccount)) {
                return false;
            }
            String this$issuingCard = this.getIssuingCard();
            String other$issuingCard = other.getIssuingCard();
            if (this$issuingCard == null ? other$issuingCard != null : !this$issuingCard.equals(other$issuingCard)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            UsBankAccount this$usBankAccount = this.getUsBankAccount();
            UsBankAccount other$usBankAccount = other.getUsBankAccount();
            return !(this$usBankAccount == null ? other$usBankAccount != null : !((Object)this$usBankAccount).equals(other$usBankAccount));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof InitiatingPaymentMethodDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $balance = this.getBalance();
            result = result * 59 + ($balance == null ? 43 : $balance.hashCode());
            BillingDetails $billingDetails = this.getBillingDetails();
            result = result * 59 + ($billingDetails == null ? 43 : ((Object)$billingDetails).hashCode());
            FinancialAccount $financialAccount = this.getFinancialAccount();
            result = result * 59 + ($financialAccount == null ? 43 : ((Object)$financialAccount).hashCode());
            String $issuingCard = this.getIssuingCard();
            result = result * 59 + ($issuingCard == null ? 43 : $issuingCard.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            UsBankAccount $usBankAccount = this.getUsBankAccount();
            result = result * 59 + ($usBankAccount == null ? 43 : ((Object)$usBankAccount).hashCode());
            return result;
        }

        public static class BillingDetails
        extends StripeObject {
            @SerializedName(value="address")
            Address address;
            @SerializedName(value="email")
            String email;
            @SerializedName(value="name")
            String name;

            @Generated
            public Address getAddress() {
                return this.address;
            }

            @Generated
            public String getEmail() {
                return this.email;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public void setAddress(Address address) {
                this.address = address;
            }

            @Generated
            public void setEmail(String email) {
                this.email = email;
            }

            @Generated
            public void setName(String name) {
                this.name = name;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BillingDetails)) {
                    return false;
                }
                BillingDetails other = (BillingDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Address this$address = this.getAddress();
                Address other$address = other.getAddress();
                if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                    return false;
                }
                String this$email = this.getEmail();
                String other$email = other.getEmail();
                if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                return !(this$name == null ? other$name != null : !this$name.equals(other$name));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof BillingDetails;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Address $address = this.getAddress();
                result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
                String $email = this.getEmail();
                result = result * 59 + ($email == null ? 43 : $email.hashCode());
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                return result;
            }
        }

        public static class FinancialAccount
        extends StripeObject
        implements HasId {
            @SerializedName(value="id")
            String id;
            @SerializedName(value="network")
            String network;

            @Generated
            public String getNetwork() {
                return this.network;
            }

            @Generated
            public void setId(String id) {
                this.id = id;
            }

            @Generated
            public void setNetwork(String network) {
                this.network = network;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof FinancialAccount)) {
                    return false;
                }
                FinancialAccount other = (FinancialAccount)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$id = this.getId();
                String other$id = other.getId();
                if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                    return false;
                }
                String this$network = this.getNetwork();
                String other$network = other.getNetwork();
                return !(this$network == null ? other$network != null : !this$network.equals(other$network));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof FinancialAccount;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $id = this.getId();
                result = result * 59 + ($id == null ? 43 : $id.hashCode());
                String $network = this.getNetwork();
                result = result * 59 + ($network == null ? 43 : $network.hashCode());
                return result;
            }

            @Override
            @Generated
            public String getId() {
                return this.id;
            }
        }

        public static class UsBankAccount
        extends StripeObject {
            @SerializedName(value="bank_name")
            String bankName;
            @SerializedName(value="last4")
            String last4;
            @SerializedName(value="routing_number")
            String routingNumber;

            @Generated
            public String getBankName() {
                return this.bankName;
            }

            @Generated
            public String getLast4() {
                return this.last4;
            }

            @Generated
            public String getRoutingNumber() {
                return this.routingNumber;
            }

            @Generated
            public void setBankName(String bankName) {
                this.bankName = bankName;
            }

            @Generated
            public void setLast4(String last4) {
                this.last4 = last4;
            }

            @Generated
            public void setRoutingNumber(String routingNumber) {
                this.routingNumber = routingNumber;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof UsBankAccount)) {
                    return false;
                }
                UsBankAccount other = (UsBankAccount)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$bankName = this.getBankName();
                String other$bankName = other.getBankName();
                if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                    return false;
                }
                String this$last4 = this.getLast4();
                String other$last4 = other.getLast4();
                if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                    return false;
                }
                String this$routingNumber = this.getRoutingNumber();
                String other$routingNumber = other.getRoutingNumber();
                return !(this$routingNumber == null ? other$routingNumber != null : !this$routingNumber.equals(other$routingNumber));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof UsBankAccount;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $bankName = this.getBankName();
                result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
                String $last4 = this.getLast4();
                result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                String $routingNumber = this.getRoutingNumber();
                result = result * 59 + ($routingNumber == null ? 43 : $routingNumber.hashCode());
                return result;
            }
        }
    }

    public static class LinkedFlows
    extends StripeObject {
        @SerializedName(value="debit_reversal")
        String debitReversal;
        @SerializedName(value="inbound_transfer")
        String inboundTransfer;
        @SerializedName(value="issuing_authorization")
        String issuingAuthorization;
        @SerializedName(value="issuing_transaction")
        String issuingTransaction;
        @SerializedName(value="received_credit_capital_withholding")
        String receivedCreditCapitalWithholding;

        @Generated
        public String getDebitReversal() {
            return this.debitReversal;
        }

        @Generated
        public String getInboundTransfer() {
            return this.inboundTransfer;
        }

        @Generated
        public String getIssuingAuthorization() {
            return this.issuingAuthorization;
        }

        @Generated
        public String getIssuingTransaction() {
            return this.issuingTransaction;
        }

        @Generated
        public String getReceivedCreditCapitalWithholding() {
            return this.receivedCreditCapitalWithholding;
        }

        @Generated
        public void setDebitReversal(String debitReversal) {
            this.debitReversal = debitReversal;
        }

        @Generated
        public void setInboundTransfer(String inboundTransfer) {
            this.inboundTransfer = inboundTransfer;
        }

        @Generated
        public void setIssuingAuthorization(String issuingAuthorization) {
            this.issuingAuthorization = issuingAuthorization;
        }

        @Generated
        public void setIssuingTransaction(String issuingTransaction) {
            this.issuingTransaction = issuingTransaction;
        }

        @Generated
        public void setReceivedCreditCapitalWithholding(String receivedCreditCapitalWithholding) {
            this.receivedCreditCapitalWithholding = receivedCreditCapitalWithholding;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LinkedFlows)) {
                return false;
            }
            LinkedFlows other = (LinkedFlows)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$debitReversal = this.getDebitReversal();
            String other$debitReversal = other.getDebitReversal();
            if (this$debitReversal == null ? other$debitReversal != null : !this$debitReversal.equals(other$debitReversal)) {
                return false;
            }
            String this$inboundTransfer = this.getInboundTransfer();
            String other$inboundTransfer = other.getInboundTransfer();
            if (this$inboundTransfer == null ? other$inboundTransfer != null : !this$inboundTransfer.equals(other$inboundTransfer)) {
                return false;
            }
            String this$issuingAuthorization = this.getIssuingAuthorization();
            String other$issuingAuthorization = other.getIssuingAuthorization();
            if (this$issuingAuthorization == null ? other$issuingAuthorization != null : !this$issuingAuthorization.equals(other$issuingAuthorization)) {
                return false;
            }
            String this$issuingTransaction = this.getIssuingTransaction();
            String other$issuingTransaction = other.getIssuingTransaction();
            if (this$issuingTransaction == null ? other$issuingTransaction != null : !this$issuingTransaction.equals(other$issuingTransaction)) {
                return false;
            }
            String this$receivedCreditCapitalWithholding = this.getReceivedCreditCapitalWithholding();
            String other$receivedCreditCapitalWithholding = other.getReceivedCreditCapitalWithholding();
            return !(this$receivedCreditCapitalWithholding == null ? other$receivedCreditCapitalWithholding != null : !this$receivedCreditCapitalWithholding.equals(other$receivedCreditCapitalWithholding));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LinkedFlows;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $debitReversal = this.getDebitReversal();
            result = result * 59 + ($debitReversal == null ? 43 : $debitReversal.hashCode());
            String $inboundTransfer = this.getInboundTransfer();
            result = result * 59 + ($inboundTransfer == null ? 43 : $inboundTransfer.hashCode());
            String $issuingAuthorization = this.getIssuingAuthorization();
            result = result * 59 + ($issuingAuthorization == null ? 43 : $issuingAuthorization.hashCode());
            String $issuingTransaction = this.getIssuingTransaction();
            result = result * 59 + ($issuingTransaction == null ? 43 : $issuingTransaction.hashCode());
            String $receivedCreditCapitalWithholding = this.getReceivedCreditCapitalWithholding();
            result = result * 59 + ($receivedCreditCapitalWithholding == null ? 43 : $receivedCreditCapitalWithholding.hashCode());
            return result;
        }
    }

    public static class NetworkDetails
    extends StripeObject {
        @SerializedName(value="ach")
        Ach ach;
        @SerializedName(value="type")
        String type;

        @Generated
        public Ach getAch() {
            return this.ach;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setAch(Ach ach) {
            this.ach = ach;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NetworkDetails)) {
                return false;
            }
            NetworkDetails other = (NetworkDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Ach this$ach = this.getAch();
            Ach other$ach = other.getAch();
            if (this$ach == null ? other$ach != null : !((Object)this$ach).equals(other$ach)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NetworkDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Ach $ach = this.getAch();
            result = result * 59 + ($ach == null ? 43 : ((Object)$ach).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class Ach
        extends StripeObject {
            @SerializedName(value="addenda")
            String addenda;

            @Generated
            public String getAddenda() {
                return this.addenda;
            }

            @Generated
            public void setAddenda(String addenda) {
                this.addenda = addenda;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ach)) {
                    return false;
                }
                Ach other = (Ach)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$addenda = this.getAddenda();
                String other$addenda = other.getAddenda();
                return !(this$addenda == null ? other$addenda != null : !this$addenda.equals(other$addenda));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ach;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $addenda = this.getAddenda();
                result = result * 59 + ($addenda == null ? 43 : $addenda.hashCode());
                return result;
            }
        }
    }

    public static class ReversalDetails
    extends StripeObject {
        @SerializedName(value="deadline")
        Long deadline;
        @SerializedName(value="restricted_reason")
        String restrictedReason;

        @Generated
        public Long getDeadline() {
            return this.deadline;
        }

        @Generated
        public String getRestrictedReason() {
            return this.restrictedReason;
        }

        @Generated
        public void setDeadline(Long deadline) {
            this.deadline = deadline;
        }

        @Generated
        public void setRestrictedReason(String restrictedReason) {
            this.restrictedReason = restrictedReason;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReversalDetails)) {
                return false;
            }
            ReversalDetails other = (ReversalDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$deadline = this.getDeadline();
            Long other$deadline = other.getDeadline();
            if (this$deadline == null ? other$deadline != null : !((Object)this$deadline).equals(other$deadline)) {
                return false;
            }
            String this$restrictedReason = this.getRestrictedReason();
            String other$restrictedReason = other.getRestrictedReason();
            return !(this$restrictedReason == null ? other$restrictedReason != null : !this$restrictedReason.equals(other$restrictedReason));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ReversalDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $deadline = this.getDeadline();
            result = result * 59 + ($deadline == null ? 43 : ((Object)$deadline).hashCode());
            String $restrictedReason = this.getRestrictedReason();
            result = result * 59 + ($restrictedReason == null ? 43 : $restrictedReason.hashCode());
            return result;
        }
    }

    public static class TestHelpers {
        private TestHelpers() {
        }

        public static ReceivedDebit create(Map<String, Object> params) throws StripeException {
            return TestHelpers.create(params, (RequestOptions)null);
        }

        public static ReceivedDebit create(Map<String, Object> params, RequestOptions options) throws StripeException {
            String path = "/v1/test_helpers/treasury/received_debits";
            ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
            return (ReceivedDebit)ApiResource.getGlobalResponseGetter().request(request, (Type)((Object)ReceivedDebit.class));
        }

        public static ReceivedDebit create(ReceivedDebitCreateParams params) throws StripeException {
            return TestHelpers.create(params, (RequestOptions)null);
        }

        public static ReceivedDebit create(ReceivedDebitCreateParams params, RequestOptions options) throws StripeException {
            String path = "/v1/test_helpers/treasury/received_debits";
            ApiResource.checkNullTypedParams(path, params);
            ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
            return (ReceivedDebit)ApiResource.getGlobalResponseGetter().request(request, (Type)((Object)ReceivedDebit.class));
        }
    }
}

