/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import com.stripe.param.common.EmptyParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class PaymentIntentUpdateParams
extends ApiRequestParams {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="application_fee_amount")
    Object applicationFeeAmount;
    @SerializedName(value="capture_method")
    CaptureMethod captureMethod;
    @SerializedName(value="currency")
    Object currency;
    @SerializedName(value="customer")
    Object customer;
    @SerializedName(value="description")
    Object description;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="_stripe_java_extra_param_key")
    Map<String, Object> extraParams;
    @SerializedName(value="mandate_data")
    MandateData mandateData;
    @SerializedName(value="metadata")
    Object metadata;
    @SerializedName(value="payment_details")
    Object paymentDetails;
    @SerializedName(value="payment_method")
    Object paymentMethod;
    @SerializedName(value="payment_method_configuration")
    Object paymentMethodConfiguration;
    @SerializedName(value="payment_method_data")
    PaymentMethodData paymentMethodData;
    @SerializedName(value="payment_method_options")
    PaymentMethodOptions paymentMethodOptions;
    @SerializedName(value="payment_method_types")
    List<String> paymentMethodTypes;
    @SerializedName(value="receipt_email")
    Object receiptEmail;
    @SerializedName(value="setup_future_usage")
    ApiRequestParams.EnumParam setupFutureUsage;
    @SerializedName(value="shipping")
    Object shipping;
    @SerializedName(value="statement_descriptor")
    Object statementDescriptor;
    @SerializedName(value="statement_descriptor_suffix")
    Object statementDescriptorSuffix;
    @SerializedName(value="transfer_data")
    TransferData transferData;
    @SerializedName(value="transfer_group")
    Object transferGroup;

    private PaymentIntentUpdateParams(Long amount, Object applicationFeeAmount, CaptureMethod captureMethod, Object currency, Object customer, Object description, List<String> expand, Map<String, Object> extraParams, MandateData mandateData, Object metadata, Object paymentDetails, Object paymentMethod, Object paymentMethodConfiguration, PaymentMethodData paymentMethodData, PaymentMethodOptions paymentMethodOptions, List<String> paymentMethodTypes, Object receiptEmail, ApiRequestParams.EnumParam setupFutureUsage, Object shipping, Object statementDescriptor, Object statementDescriptorSuffix, TransferData transferData, Object transferGroup) {
        this.amount = amount;
        this.applicationFeeAmount = applicationFeeAmount;
        this.captureMethod = captureMethod;
        this.currency = currency;
        this.customer = customer;
        this.description = description;
        this.expand = expand;
        this.extraParams = extraParams;
        this.mandateData = mandateData;
        this.metadata = metadata;
        this.paymentDetails = paymentDetails;
        this.paymentMethod = paymentMethod;
        this.paymentMethodConfiguration = paymentMethodConfiguration;
        this.paymentMethodData = paymentMethodData;
        this.paymentMethodOptions = paymentMethodOptions;
        this.paymentMethodTypes = paymentMethodTypes;
        this.receiptEmail = receiptEmail;
        this.setupFutureUsage = setupFutureUsage;
        this.shipping = shipping;
        this.statementDescriptor = statementDescriptor;
        this.statementDescriptorSuffix = statementDescriptorSuffix;
        this.transferData = transferData;
        this.transferGroup = transferGroup;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Object getApplicationFeeAmount() {
        return this.applicationFeeAmount;
    }

    @Generated
    public CaptureMethod getCaptureMethod() {
        return this.captureMethod;
    }

    @Generated
    public Object getCurrency() {
        return this.currency;
    }

    @Generated
    public Object getCustomer() {
        return this.customer;
    }

    @Generated
    public Object getDescription() {
        return this.description;
    }

    @Generated
    public List<String> getExpand() {
        return this.expand;
    }

    @Generated
    public Map<String, Object> getExtraParams() {
        return this.extraParams;
    }

    @Generated
    public MandateData getMandateData() {
        return this.mandateData;
    }

    @Generated
    public Object getMetadata() {
        return this.metadata;
    }

    @Generated
    public Object getPaymentDetails() {
        return this.paymentDetails;
    }

    @Generated
    public Object getPaymentMethod() {
        return this.paymentMethod;
    }

    @Generated
    public Object getPaymentMethodConfiguration() {
        return this.paymentMethodConfiguration;
    }

    @Generated
    public PaymentMethodData getPaymentMethodData() {
        return this.paymentMethodData;
    }

    @Generated
    public PaymentMethodOptions getPaymentMethodOptions() {
        return this.paymentMethodOptions;
    }

    @Generated
    public List<String> getPaymentMethodTypes() {
        return this.paymentMethodTypes;
    }

    @Generated
    public Object getReceiptEmail() {
        return this.receiptEmail;
    }

    @Generated
    public ApiRequestParams.EnumParam getSetupFutureUsage() {
        return this.setupFutureUsage;
    }

    @Generated
    public Object getShipping() {
        return this.shipping;
    }

    @Generated
    public Object getStatementDescriptor() {
        return this.statementDescriptor;
    }

    @Generated
    public Object getStatementDescriptorSuffix() {
        return this.statementDescriptorSuffix;
    }

    @Generated
    public TransferData getTransferData() {
        return this.transferData;
    }

    @Generated
    public Object getTransferGroup() {
        return this.transferGroup;
    }

    public static enum CaptureMethod implements ApiRequestParams.EnumParam
    {
        AUTOMATIC("automatic"),
        AUTOMATIC_ASYNC("automatic_async"),
        MANUAL("manual");

        private final String value;

        private CaptureMethod(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class MandateData {
        @SerializedName(value="customer_acceptance")
        CustomerAcceptance customerAcceptance;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;

        private MandateData(CustomerAcceptance customerAcceptance, Map<String, Object> extraParams) {
            this.customerAcceptance = customerAcceptance;
            this.extraParams = extraParams;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public CustomerAcceptance getCustomerAcceptance() {
            return this.customerAcceptance;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        public static class CustomerAcceptance {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="online")
            Online online;
            @SerializedName(value="type")
            Type type;

            private CustomerAcceptance(Map<String, Object> extraParams, Online online, Type type) {
                this.extraParams = extraParams;
                this.online = online;
                this.type = type;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Online getOnline() {
                return this.online;
            }

            @Generated
            public Type getType() {
                return this.type;
            }

            public static class Online {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="ip_address")
                Object ipAddress;
                @SerializedName(value="user_agent")
                Object userAgent;

                private Online(Map<String, Object> extraParams, Object ipAddress, Object userAgent) {
                    this.extraParams = extraParams;
                    this.ipAddress = ipAddress;
                    this.userAgent = userAgent;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Object getIpAddress() {
                    return this.ipAddress;
                }

                @Generated
                public Object getUserAgent() {
                    return this.userAgent;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private Object ipAddress;
                    private Object userAgent;

                    public Online build() {
                        return new Online(this.extraParams, this.ipAddress, this.userAgent);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setIpAddress(String ipAddress) {
                        this.ipAddress = ipAddress;
                        return this;
                    }

                    public Builder setIpAddress(EmptyParam ipAddress) {
                        this.ipAddress = ipAddress;
                        return this;
                    }

                    public Builder setUserAgent(String userAgent) {
                        this.userAgent = userAgent;
                        return this;
                    }

                    public Builder setUserAgent(EmptyParam userAgent) {
                        this.userAgent = userAgent;
                        return this;
                    }
                }
            }

            public static enum Type implements ApiRequestParams.EnumParam
            {
                ONLINE("online");

                private final String value;

                private Type(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Online online;
                private Type type;

                public CustomerAcceptance build() {
                    return new CustomerAcceptance(this.extraParams, this.online, this.type);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setOnline(Online online) {
                    this.online = online;
                    return this;
                }

                public Builder setType(Type type) {
                    this.type = type;
                    return this;
                }
            }
        }

        public static class Builder {
            private CustomerAcceptance customerAcceptance;
            private Map<String, Object> extraParams;

            public MandateData build() {
                return new MandateData(this.customerAcceptance, this.extraParams);
            }

            public Builder setCustomerAcceptance(CustomerAcceptance customerAcceptance) {
                this.customerAcceptance = customerAcceptance;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }
        }
    }

    public static class PaymentMethodData {
        @SerializedName(value="acss_debit")
        AcssDebit acssDebit;
        @SerializedName(value="affirm")
        Affirm affirm;
        @SerializedName(value="afterpay_clearpay")
        AfterpayClearpay afterpayClearpay;
        @SerializedName(value="alipay")
        Alipay alipay;
        @SerializedName(value="au_becs_debit")
        AuBecsDebit auBecsDebit;
        @SerializedName(value="bacs_debit")
        BacsDebit bacsDebit;
        @SerializedName(value="bancontact")
        Bancontact bancontact;
        @SerializedName(value="billing_details")
        BillingDetails billingDetails;
        @SerializedName(value="blik")
        Blik blik;
        @SerializedName(value="boleto")
        Boleto boleto;
        @SerializedName(value="cashapp")
        Cashapp cashapp;
        @SerializedName(value="customer_balance")
        CustomerBalance customerBalance;
        @SerializedName(value="eps")
        Eps eps;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="fpx")
        Fpx fpx;
        @SerializedName(value="giropay")
        Giropay giropay;
        @SerializedName(value="grabpay")
        Grabpay grabpay;
        @SerializedName(value="ideal")
        Ideal ideal;
        @SerializedName(value="interac_present")
        InteracPresent interacPresent;
        @SerializedName(value="klarna")
        Klarna klarna;
        @SerializedName(value="konbini")
        Konbini konbini;
        @SerializedName(value="link")
        Link link;
        @SerializedName(value="metadata")
        Map<String, String> metadata;
        @SerializedName(value="oxxo")
        Oxxo oxxo;
        @SerializedName(value="p24")
        P24 p24;
        @SerializedName(value="paynow")
        Paynow paynow;
        @SerializedName(value="paypal")
        Paypal paypal;
        @SerializedName(value="pix")
        Pix pix;
        @SerializedName(value="promptpay")
        Promptpay promptpay;
        @SerializedName(value="radar_options")
        RadarOptions radarOptions;
        @SerializedName(value="revolut_pay")
        RevolutPay revolutPay;
        @SerializedName(value="sepa_debit")
        SepaDebit sepaDebit;
        @SerializedName(value="sofort")
        Sofort sofort;
        @SerializedName(value="swish")
        Swish swish;
        @SerializedName(value="type")
        Type type;
        @SerializedName(value="us_bank_account")
        UsBankAccount usBankAccount;
        @SerializedName(value="wechat_pay")
        WechatPay wechatPay;
        @SerializedName(value="zip")
        Zip zip;

        private PaymentMethodData(AcssDebit acssDebit, Affirm affirm, AfterpayClearpay afterpayClearpay, Alipay alipay, AuBecsDebit auBecsDebit, BacsDebit bacsDebit, Bancontact bancontact, BillingDetails billingDetails, Blik blik, Boleto boleto, Cashapp cashapp, CustomerBalance customerBalance, Eps eps, Map<String, Object> extraParams, Fpx fpx, Giropay giropay, Grabpay grabpay, Ideal ideal, InteracPresent interacPresent, Klarna klarna, Konbini konbini, Link link, Map<String, String> metadata, Oxxo oxxo, P24 p24, Paynow paynow, Paypal paypal, Pix pix, Promptpay promptpay, RadarOptions radarOptions, RevolutPay revolutPay, SepaDebit sepaDebit, Sofort sofort, Swish swish, Type type, UsBankAccount usBankAccount, WechatPay wechatPay, Zip zip) {
            this.acssDebit = acssDebit;
            this.affirm = affirm;
            this.afterpayClearpay = afterpayClearpay;
            this.alipay = alipay;
            this.auBecsDebit = auBecsDebit;
            this.bacsDebit = bacsDebit;
            this.bancontact = bancontact;
            this.billingDetails = billingDetails;
            this.blik = blik;
            this.boleto = boleto;
            this.cashapp = cashapp;
            this.customerBalance = customerBalance;
            this.eps = eps;
            this.extraParams = extraParams;
            this.fpx = fpx;
            this.giropay = giropay;
            this.grabpay = grabpay;
            this.ideal = ideal;
            this.interacPresent = interacPresent;
            this.klarna = klarna;
            this.konbini = konbini;
            this.link = link;
            this.metadata = metadata;
            this.oxxo = oxxo;
            this.p24 = p24;
            this.paynow = paynow;
            this.paypal = paypal;
            this.pix = pix;
            this.promptpay = promptpay;
            this.radarOptions = radarOptions;
            this.revolutPay = revolutPay;
            this.sepaDebit = sepaDebit;
            this.sofort = sofort;
            this.swish = swish;
            this.type = type;
            this.usBankAccount = usBankAccount;
            this.wechatPay = wechatPay;
            this.zip = zip;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public AcssDebit getAcssDebit() {
            return this.acssDebit;
        }

        @Generated
        public Affirm getAffirm() {
            return this.affirm;
        }

        @Generated
        public AfterpayClearpay getAfterpayClearpay() {
            return this.afterpayClearpay;
        }

        @Generated
        public Alipay getAlipay() {
            return this.alipay;
        }

        @Generated
        public AuBecsDebit getAuBecsDebit() {
            return this.auBecsDebit;
        }

        @Generated
        public BacsDebit getBacsDebit() {
            return this.bacsDebit;
        }

        @Generated
        public Bancontact getBancontact() {
            return this.bancontact;
        }

        @Generated
        public BillingDetails getBillingDetails() {
            return this.billingDetails;
        }

        @Generated
        public Blik getBlik() {
            return this.blik;
        }

        @Generated
        public Boleto getBoleto() {
            return this.boleto;
        }

        @Generated
        public Cashapp getCashapp() {
            return this.cashapp;
        }

        @Generated
        public CustomerBalance getCustomerBalance() {
            return this.customerBalance;
        }

        @Generated
        public Eps getEps() {
            return this.eps;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public Fpx getFpx() {
            return this.fpx;
        }

        @Generated
        public Giropay getGiropay() {
            return this.giropay;
        }

        @Generated
        public Grabpay getGrabpay() {
            return this.grabpay;
        }

        @Generated
        public Ideal getIdeal() {
            return this.ideal;
        }

        @Generated
        public InteracPresent getInteracPresent() {
            return this.interacPresent;
        }

        @Generated
        public Klarna getKlarna() {
            return this.klarna;
        }

        @Generated
        public Konbini getKonbini() {
            return this.konbini;
        }

        @Generated
        public Link getLink() {
            return this.link;
        }

        @Generated
        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        @Generated
        public Oxxo getOxxo() {
            return this.oxxo;
        }

        @Generated
        public P24 getP24() {
            return this.p24;
        }

        @Generated
        public Paynow getPaynow() {
            return this.paynow;
        }

        @Generated
        public Paypal getPaypal() {
            return this.paypal;
        }

        @Generated
        public Pix getPix() {
            return this.pix;
        }

        @Generated
        public Promptpay getPromptpay() {
            return this.promptpay;
        }

        @Generated
        public RadarOptions getRadarOptions() {
            return this.radarOptions;
        }

        @Generated
        public RevolutPay getRevolutPay() {
            return this.revolutPay;
        }

        @Generated
        public SepaDebit getSepaDebit() {
            return this.sepaDebit;
        }

        @Generated
        public Sofort getSofort() {
            return this.sofort;
        }

        @Generated
        public Swish getSwish() {
            return this.swish;
        }

        @Generated
        public Type getType() {
            return this.type;
        }

        @Generated
        public UsBankAccount getUsBankAccount() {
            return this.usBankAccount;
        }

        @Generated
        public WechatPay getWechatPay() {
            return this.wechatPay;
        }

        @Generated
        public Zip getZip() {
            return this.zip;
        }

        public static class AcssDebit {
            @SerializedName(value="account_number")
            Object accountNumber;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="institution_number")
            Object institutionNumber;
            @SerializedName(value="transit_number")
            Object transitNumber;

            private AcssDebit(Object accountNumber, Map<String, Object> extraParams, Object institutionNumber, Object transitNumber) {
                this.accountNumber = accountNumber;
                this.extraParams = extraParams;
                this.institutionNumber = institutionNumber;
                this.transitNumber = transitNumber;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Object getAccountNumber() {
                return this.accountNumber;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Object getInstitutionNumber() {
                return this.institutionNumber;
            }

            @Generated
            public Object getTransitNumber() {
                return this.transitNumber;
            }

            public static class Builder {
                private Object accountNumber;
                private Map<String, Object> extraParams;
                private Object institutionNumber;
                private Object transitNumber;

                public AcssDebit build() {
                    return new AcssDebit(this.accountNumber, this.extraParams, this.institutionNumber, this.transitNumber);
                }

                public Builder setAccountNumber(String accountNumber) {
                    this.accountNumber = accountNumber;
                    return this;
                }

                public Builder setAccountNumber(EmptyParam accountNumber) {
                    this.accountNumber = accountNumber;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setInstitutionNumber(String institutionNumber) {
                    this.institutionNumber = institutionNumber;
                    return this;
                }

                public Builder setInstitutionNumber(EmptyParam institutionNumber) {
                    this.institutionNumber = institutionNumber;
                    return this;
                }

                public Builder setTransitNumber(String transitNumber) {
                    this.transitNumber = transitNumber;
                    return this;
                }

                public Builder setTransitNumber(EmptyParam transitNumber) {
                    this.transitNumber = transitNumber;
                    return this;
                }
            }
        }

        public static class Affirm {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Affirm(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Affirm build() {
                    return new Affirm(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class AfterpayClearpay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private AfterpayClearpay(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public AfterpayClearpay build() {
                    return new AfterpayClearpay(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Alipay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Alipay(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Alipay build() {
                    return new Alipay(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class AuBecsDebit {
            @SerializedName(value="account_number")
            Object accountNumber;
            @SerializedName(value="bsb_number")
            Object bsbNumber;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private AuBecsDebit(Object accountNumber, Object bsbNumber, Map<String, Object> extraParams) {
                this.accountNumber = accountNumber;
                this.bsbNumber = bsbNumber;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Object getAccountNumber() {
                return this.accountNumber;
            }

            @Generated
            public Object getBsbNumber() {
                return this.bsbNumber;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Object accountNumber;
                private Object bsbNumber;
                private Map<String, Object> extraParams;

                public AuBecsDebit build() {
                    return new AuBecsDebit(this.accountNumber, this.bsbNumber, this.extraParams);
                }

                public Builder setAccountNumber(String accountNumber) {
                    this.accountNumber = accountNumber;
                    return this;
                }

                public Builder setAccountNumber(EmptyParam accountNumber) {
                    this.accountNumber = accountNumber;
                    return this;
                }

                public Builder setBsbNumber(String bsbNumber) {
                    this.bsbNumber = bsbNumber;
                    return this;
                }

                public Builder setBsbNumber(EmptyParam bsbNumber) {
                    this.bsbNumber = bsbNumber;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class BacsDebit {
            @SerializedName(value="account_number")
            Object accountNumber;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="sort_code")
            Object sortCode;

            private BacsDebit(Object accountNumber, Map<String, Object> extraParams, Object sortCode) {
                this.accountNumber = accountNumber;
                this.extraParams = extraParams;
                this.sortCode = sortCode;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Object getAccountNumber() {
                return this.accountNumber;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Object getSortCode() {
                return this.sortCode;
            }

            public static class Builder {
                private Object accountNumber;
                private Map<String, Object> extraParams;
                private Object sortCode;

                public BacsDebit build() {
                    return new BacsDebit(this.accountNumber, this.extraParams, this.sortCode);
                }

                public Builder setAccountNumber(String accountNumber) {
                    this.accountNumber = accountNumber;
                    return this;
                }

                public Builder setAccountNumber(EmptyParam accountNumber) {
                    this.accountNumber = accountNumber;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSortCode(String sortCode) {
                    this.sortCode = sortCode;
                    return this;
                }

                public Builder setSortCode(EmptyParam sortCode) {
                    this.sortCode = sortCode;
                    return this;
                }
            }
        }

        public static class Bancontact {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Bancontact(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Bancontact build() {
                    return new Bancontact(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class BillingDetails {
            @SerializedName(value="address")
            Object address;
            @SerializedName(value="email")
            Object email;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="name")
            Object name;
            @SerializedName(value="phone")
            Object phone;

            private BillingDetails(Object address, Object email, Map<String, Object> extraParams, Object name, Object phone) {
                this.address = address;
                this.email = email;
                this.extraParams = extraParams;
                this.name = name;
                this.phone = phone;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Object getAddress() {
                return this.address;
            }

            @Generated
            public Object getEmail() {
                return this.email;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Object getName() {
                return this.name;
            }

            @Generated
            public Object getPhone() {
                return this.phone;
            }

            public static class Builder {
                private Object address;
                private Object email;
                private Map<String, Object> extraParams;
                private Object name;
                private Object phone;

                public BillingDetails build() {
                    return new BillingDetails(this.address, this.email, this.extraParams, this.name, this.phone);
                }

                public Builder setAddress(Address address) {
                    this.address = address;
                    return this;
                }

                public Builder setAddress(EmptyParam address) {
                    this.address = address;
                    return this;
                }

                public Builder setEmail(String email) {
                    this.email = email;
                    return this;
                }

                public Builder setEmail(EmptyParam email) {
                    this.email = email;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setName(String name) {
                    this.name = name;
                    return this;
                }

                public Builder setName(EmptyParam name) {
                    this.name = name;
                    return this;
                }

                public Builder setPhone(String phone) {
                    this.phone = phone;
                    return this;
                }

                public Builder setPhone(EmptyParam phone) {
                    this.phone = phone;
                    return this;
                }
            }

            public static class Address {
                @SerializedName(value="city")
                Object city;
                @SerializedName(value="country")
                Object country;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="line1")
                Object line1;
                @SerializedName(value="line2")
                Object line2;
                @SerializedName(value="postal_code")
                Object postalCode;
                @SerializedName(value="state")
                Object state;

                private Address(Object city, Object country, Map<String, Object> extraParams, Object line1, Object line2, Object postalCode, Object state) {
                    this.city = city;
                    this.country = country;
                    this.extraParams = extraParams;
                    this.line1 = line1;
                    this.line2 = line2;
                    this.postalCode = postalCode;
                    this.state = state;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Object getCity() {
                    return this.city;
                }

                @Generated
                public Object getCountry() {
                    return this.country;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Object getLine1() {
                    return this.line1;
                }

                @Generated
                public Object getLine2() {
                    return this.line2;
                }

                @Generated
                public Object getPostalCode() {
                    return this.postalCode;
                }

                @Generated
                public Object getState() {
                    return this.state;
                }

                public static class Builder {
                    private Object city;
                    private Object country;
                    private Map<String, Object> extraParams;
                    private Object line1;
                    private Object line2;
                    private Object postalCode;
                    private Object state;

                    public Address build() {
                        return new Address(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
                    }

                    public Builder setCity(String city) {
                        this.city = city;
                        return this;
                    }

                    public Builder setCity(EmptyParam city) {
                        this.city = city;
                        return this;
                    }

                    public Builder setCountry(String country) {
                        this.country = country;
                        return this;
                    }

                    public Builder setCountry(EmptyParam country) {
                        this.country = country;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setLine1(String line1) {
                        this.line1 = line1;
                        return this;
                    }

                    public Builder setLine1(EmptyParam line1) {
                        this.line1 = line1;
                        return this;
                    }

                    public Builder setLine2(String line2) {
                        this.line2 = line2;
                        return this;
                    }

                    public Builder setLine2(EmptyParam line2) {
                        this.line2 = line2;
                        return this;
                    }

                    public Builder setPostalCode(String postalCode) {
                        this.postalCode = postalCode;
                        return this;
                    }

                    public Builder setPostalCode(EmptyParam postalCode) {
                        this.postalCode = postalCode;
                        return this;
                    }

                    public Builder setState(String state) {
                        this.state = state;
                        return this;
                    }

                    public Builder setState(EmptyParam state) {
                        this.state = state;
                        return this;
                    }
                }
            }
        }

        public static class Blik {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Blik(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Blik build() {
                    return new Blik(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Boleto {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="tax_id")
            Object taxId;

            private Boleto(Map<String, Object> extraParams, Object taxId) {
                this.extraParams = extraParams;
                this.taxId = taxId;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Object getTaxId() {
                return this.taxId;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Object taxId;

                public Boleto build() {
                    return new Boleto(this.extraParams, this.taxId);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setTaxId(String taxId) {
                    this.taxId = taxId;
                    return this;
                }

                public Builder setTaxId(EmptyParam taxId) {
                    this.taxId = taxId;
                    return this;
                }
            }
        }

        public static class Cashapp {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Cashapp(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Cashapp build() {
                    return new Cashapp(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class CustomerBalance {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private CustomerBalance(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public CustomerBalance build() {
                    return new CustomerBalance(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Eps {
            @SerializedName(value="bank")
            Bank bank;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Eps(Bank bank, Map<String, Object> extraParams) {
                this.bank = bank;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Bank getBank() {
                return this.bank;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static enum Bank implements ApiRequestParams.EnumParam
            {
                ARZTE_UND_APOTHEKER_BANK("arzte_und_apotheker_bank"),
                AUSTRIAN_ANADI_BANK_AG("austrian_anadi_bank_ag"),
                BANK_AUSTRIA("bank_austria"),
                BANKHAUS_CARL_SPANGLER("bankhaus_carl_spangler"),
                BANKHAUS_SCHELHAMMER_UND_SCHATTERA_AG("bankhaus_schelhammer_und_schattera_ag"),
                BAWAG_PSK_AG("bawag_psk_ag"),
                BKS_BANK_AG("bks_bank_ag"),
                BRULL_KALLMUS_BANK_AG("brull_kallmus_bank_ag"),
                BTV_VIER_LANDER_BANK("btv_vier_lander_bank"),
                CAPITAL_BANK_GRAWE_GRUPPE_AG("capital_bank_grawe_gruppe_ag"),
                DEUTSCHE_BANK_AG("deutsche_bank_ag"),
                DOLOMITENBANK("dolomitenbank"),
                EASYBANK_AG("easybank_ag"),
                ERSTE_BANK_UND_SPARKASSEN("erste_bank_und_sparkassen"),
                HYPO_ALPEADRIABANK_INTERNATIONAL_AG("hypo_alpeadriabank_international_ag"),
                HYPO_BANK_BURGENLAND_AKTIENGESELLSCHAFT("hypo_bank_burgenland_aktiengesellschaft"),
                HYPO_NOE_LB_FUR_NIEDEROSTERREICH_U_WIEN("hypo_noe_lb_fur_niederosterreich_u_wien"),
                HYPO_OBEROSTERREICH_SALZBURG_STEIERMARK("hypo_oberosterreich_salzburg_steiermark"),
                HYPO_TIROL_BANK_AG("hypo_tirol_bank_ag"),
                HYPO_VORARLBERG_BANK_AG("hypo_vorarlberg_bank_ag"),
                MARCHFELDER_BANK("marchfelder_bank"),
                OBERBANK_AG("oberbank_ag"),
                RAIFFEISEN_BANKENGRUPPE_OSTERREICH("raiffeisen_bankengruppe_osterreich"),
                SCHOELLERBANK_AG("schoellerbank_ag"),
                SPARDA_BANK_WIEN("sparda_bank_wien"),
                VOLKSBANK_GRUPPE("volksbank_gruppe"),
                VOLKSKREDITBANK_AG("volkskreditbank_ag"),
                VR_BANK_BRAUNAU("vr_bank_braunau");

                private final String value;

                private Bank(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Bank bank;
                private Map<String, Object> extraParams;

                public Eps build() {
                    return new Eps(this.bank, this.extraParams);
                }

                public Builder setBank(Bank bank) {
                    this.bank = bank;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Fpx {
            @SerializedName(value="account_holder_type")
            AccountHolderType accountHolderType;
            @SerializedName(value="bank")
            Bank bank;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Fpx(AccountHolderType accountHolderType, Bank bank, Map<String, Object> extraParams) {
                this.accountHolderType = accountHolderType;
                this.bank = bank;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public AccountHolderType getAccountHolderType() {
                return this.accountHolderType;
            }

            @Generated
            public Bank getBank() {
                return this.bank;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static enum AccountHolderType implements ApiRequestParams.EnumParam
            {
                COMPANY("company"),
                INDIVIDUAL("individual");

                private final String value;

                private AccountHolderType(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum Bank implements ApiRequestParams.EnumParam
            {
                AFFIN_BANK("affin_bank"),
                AGROBANK("agrobank"),
                ALLIANCE_BANK("alliance_bank"),
                AMBANK("ambank"),
                BANK_ISLAM("bank_islam"),
                BANK_MUAMALAT("bank_muamalat"),
                BANK_OF_CHINA("bank_of_china"),
                BANK_RAKYAT("bank_rakyat"),
                BSN("bsn"),
                CIMB("cimb"),
                DEUTSCHE_BANK("deutsche_bank"),
                HONG_LEONG_BANK("hong_leong_bank"),
                HSBC("hsbc"),
                KFH("kfh"),
                MAYBANK2E("maybank2e"),
                MAYBANK2U("maybank2u"),
                OCBC("ocbc"),
                PB_ENTERPRISE("pb_enterprise"),
                PUBLIC_BANK("public_bank"),
                RHB("rhb"),
                STANDARD_CHARTERED("standard_chartered"),
                UOB("uob");

                private final String value;

                private Bank(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private AccountHolderType accountHolderType;
                private Bank bank;
                private Map<String, Object> extraParams;

                public Fpx build() {
                    return new Fpx(this.accountHolderType, this.bank, this.extraParams);
                }

                public Builder setAccountHolderType(AccountHolderType accountHolderType) {
                    this.accountHolderType = accountHolderType;
                    return this;
                }

                public Builder setBank(Bank bank) {
                    this.bank = bank;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Giropay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Giropay(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Giropay build() {
                    return new Giropay(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Grabpay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Grabpay(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Grabpay build() {
                    return new Grabpay(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Ideal {
            @SerializedName(value="bank")
            Bank bank;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Ideal(Bank bank, Map<String, Object> extraParams) {
                this.bank = bank;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Bank getBank() {
                return this.bank;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static enum Bank implements ApiRequestParams.EnumParam
            {
                ABN_AMRO("abn_amro"),
                ASN_BANK("asn_bank"),
                BUNQ("bunq"),
                HANDELSBANKEN("handelsbanken"),
                ING("ing"),
                KNAB("knab"),
                MONEYOU("moneyou"),
                N26("n26"),
                NN("nn"),
                RABOBANK("rabobank"),
                REGIOBANK("regiobank"),
                REVOLUT("revolut"),
                SNS_BANK("sns_bank"),
                TRIODOS_BANK("triodos_bank"),
                VAN_LANSCHOT("van_lanschot"),
                YOURSAFE("yoursafe");

                private final String value;

                private Bank(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Bank bank;
                private Map<String, Object> extraParams;

                public Ideal build() {
                    return new Ideal(this.bank, this.extraParams);
                }

                public Builder setBank(Bank bank) {
                    this.bank = bank;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class InteracPresent {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private InteracPresent(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public InteracPresent build() {
                    return new InteracPresent(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Klarna {
            @SerializedName(value="dob")
            Dob dob;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Klarna(Dob dob, Map<String, Object> extraParams) {
                this.dob = dob;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Dob getDob() {
                return this.dob;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Dob {
                @SerializedName(value="day")
                Long day;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="month")
                Long month;
                @SerializedName(value="year")
                Long year;

                private Dob(Long day, Map<String, Object> extraParams, Long month, Long year) {
                    this.day = day;
                    this.extraParams = extraParams;
                    this.month = month;
                    this.year = year;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Long getDay() {
                    return this.day;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Long getMonth() {
                    return this.month;
                }

                @Generated
                public Long getYear() {
                    return this.year;
                }

                public static class Builder {
                    private Long day;
                    private Map<String, Object> extraParams;
                    private Long month;
                    private Long year;

                    public Dob build() {
                        return new Dob(this.day, this.extraParams, this.month, this.year);
                    }

                    public Builder setDay(Long day) {
                        this.day = day;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setMonth(Long month) {
                        this.month = month;
                        return this;
                    }

                    public Builder setYear(Long year) {
                        this.year = year;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Dob dob;
                private Map<String, Object> extraParams;

                public Klarna build() {
                    return new Klarna(this.dob, this.extraParams);
                }

                public Builder setDob(Dob dob) {
                    this.dob = dob;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Konbini {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Konbini(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Konbini build() {
                    return new Konbini(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Link {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Link(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Link build() {
                    return new Link(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Oxxo {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Oxxo(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Oxxo build() {
                    return new Oxxo(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class P24 {
            @SerializedName(value="bank")
            Bank bank;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private P24(Bank bank, Map<String, Object> extraParams) {
                this.bank = bank;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Bank getBank() {
                return this.bank;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static enum Bank implements ApiRequestParams.EnumParam
            {
                ALIOR_BANK("alior_bank"),
                BANK_MILLENNIUM("bank_millennium"),
                BANK_NOWY_BFG_SA("bank_nowy_bfg_sa"),
                BANK_PEKAO_SA("bank_pekao_sa"),
                BANKI_SPBDZIELCZE("banki_spbdzielcze"),
                BLIK("blik"),
                BNP_PARIBAS("bnp_paribas"),
                BOZ("boz"),
                CITI_HANDLOWY("citi_handlowy"),
                CREDIT_AGRICOLE("credit_agricole"),
                ENVELOBANK("envelobank"),
                ETRANSFER_POCZTOWY24("etransfer_pocztowy24"),
                GETIN_BANK("getin_bank"),
                IDEABANK("ideabank"),
                ING("ing"),
                INTELIGO("inteligo"),
                MBANK_MTRANSFER("mbank_mtransfer"),
                NEST_PRZELEW("nest_przelew"),
                NOBLE_PAY("noble_pay"),
                PBAC_Z_IPKO("pbac_z_ipko"),
                PLUS_BANK("plus_bank"),
                SANTANDER_PRZELEW24("santander_przelew24"),
                TMOBILE_USBUGI_BANKOWE("tmobile_usbugi_bankowe"),
                TOYOTA_BANK("toyota_bank"),
                VOLKSWAGEN_BANK("volkswagen_bank");

                private final String value;

                private Bank(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Bank bank;
                private Map<String, Object> extraParams;

                public P24 build() {
                    return new P24(this.bank, this.extraParams);
                }

                public Builder setBank(Bank bank) {
                    this.bank = bank;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Paynow {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Paynow(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Paynow build() {
                    return new Paynow(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Paypal {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Paypal(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Paypal build() {
                    return new Paypal(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Pix {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Pix(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Pix build() {
                    return new Pix(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Promptpay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Promptpay(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Promptpay build() {
                    return new Promptpay(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class RadarOptions {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="session")
            Object session;

            private RadarOptions(Map<String, Object> extraParams, Object session) {
                this.extraParams = extraParams;
                this.session = session;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Object getSession() {
                return this.session;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Object session;

                public RadarOptions build() {
                    return new RadarOptions(this.extraParams, this.session);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSession(String session) {
                    this.session = session;
                    return this;
                }

                public Builder setSession(EmptyParam session) {
                    this.session = session;
                    return this;
                }
            }
        }

        public static class RevolutPay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private RevolutPay(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public RevolutPay build() {
                    return new RevolutPay(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class SepaDebit {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="iban")
            Object iban;

            private SepaDebit(Map<String, Object> extraParams, Object iban) {
                this.extraParams = extraParams;
                this.iban = iban;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Object getIban() {
                return this.iban;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Object iban;

                public SepaDebit build() {
                    return new SepaDebit(this.extraParams, this.iban);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setIban(String iban) {
                    this.iban = iban;
                    return this;
                }

                public Builder setIban(EmptyParam iban) {
                    this.iban = iban;
                    return this;
                }
            }
        }

        public static class Sofort {
            @SerializedName(value="country")
            Country country;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Sofort(Country country, Map<String, Object> extraParams) {
                this.country = country;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Country getCountry() {
                return this.country;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static enum Country implements ApiRequestParams.EnumParam
            {
                AT("AT"),
                BE("BE"),
                DE("DE"),
                ES("ES"),
                IT("IT"),
                NL("NL");

                private final String value;

                private Country(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Country country;
                private Map<String, Object> extraParams;

                public Sofort build() {
                    return new Sofort(this.country, this.extraParams);
                }

                public Builder setCountry(Country country) {
                    this.country = country;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Swish {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Swish(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Swish build() {
                    return new Swish(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static enum Type implements ApiRequestParams.EnumParam
        {
            ACSS_DEBIT("acss_debit"),
            AFFIRM("affirm"),
            AFTERPAY_CLEARPAY("afterpay_clearpay"),
            ALIPAY("alipay"),
            AU_BECS_DEBIT("au_becs_debit"),
            BACS_DEBIT("bacs_debit"),
            BANCONTACT("bancontact"),
            BLIK("blik"),
            BOLETO("boleto"),
            CASHAPP("cashapp"),
            CUSTOMER_BALANCE("customer_balance"),
            EPS("eps"),
            FPX("fpx"),
            GIROPAY("giropay"),
            GRABPAY("grabpay"),
            IDEAL("ideal"),
            KLARNA("klarna"),
            KONBINI("konbini"),
            LINK("link"),
            OXXO("oxxo"),
            P24("p24"),
            PAYNOW("paynow"),
            PAYPAL("paypal"),
            PIX("pix"),
            PROMPTPAY("promptpay"),
            REVOLUT_PAY("revolut_pay"),
            SEPA_DEBIT("sepa_debit"),
            SOFORT("sofort"),
            SWISH("swish"),
            US_BANK_ACCOUNT("us_bank_account"),
            WECHAT_PAY("wechat_pay"),
            ZIP("zip");

            private final String value;

            private Type(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class UsBankAccount {
            @SerializedName(value="account_holder_type")
            AccountHolderType accountHolderType;
            @SerializedName(value="account_number")
            Object accountNumber;
            @SerializedName(value="account_type")
            AccountType accountType;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="financial_connections_account")
            Object financialConnectionsAccount;
            @SerializedName(value="routing_number")
            Object routingNumber;

            private UsBankAccount(AccountHolderType accountHolderType, Object accountNumber, AccountType accountType, Map<String, Object> extraParams, Object financialConnectionsAccount, Object routingNumber) {
                this.accountHolderType = accountHolderType;
                this.accountNumber = accountNumber;
                this.accountType = accountType;
                this.extraParams = extraParams;
                this.financialConnectionsAccount = financialConnectionsAccount;
                this.routingNumber = routingNumber;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public AccountHolderType getAccountHolderType() {
                return this.accountHolderType;
            }

            @Generated
            public Object getAccountNumber() {
                return this.accountNumber;
            }

            @Generated
            public AccountType getAccountType() {
                return this.accountType;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Object getFinancialConnectionsAccount() {
                return this.financialConnectionsAccount;
            }

            @Generated
            public Object getRoutingNumber() {
                return this.routingNumber;
            }

            public static enum AccountHolderType implements ApiRequestParams.EnumParam
            {
                COMPANY("company"),
                INDIVIDUAL("individual");

                private final String value;

                private AccountHolderType(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum AccountType implements ApiRequestParams.EnumParam
            {
                CHECKING("checking"),
                SAVINGS("savings");

                private final String value;

                private AccountType(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private AccountHolderType accountHolderType;
                private Object accountNumber;
                private AccountType accountType;
                private Map<String, Object> extraParams;
                private Object financialConnectionsAccount;
                private Object routingNumber;

                public UsBankAccount build() {
                    return new UsBankAccount(this.accountHolderType, this.accountNumber, this.accountType, this.extraParams, this.financialConnectionsAccount, this.routingNumber);
                }

                public Builder setAccountHolderType(AccountHolderType accountHolderType) {
                    this.accountHolderType = accountHolderType;
                    return this;
                }

                public Builder setAccountNumber(String accountNumber) {
                    this.accountNumber = accountNumber;
                    return this;
                }

                public Builder setAccountNumber(EmptyParam accountNumber) {
                    this.accountNumber = accountNumber;
                    return this;
                }

                public Builder setAccountType(AccountType accountType) {
                    this.accountType = accountType;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setFinancialConnectionsAccount(String financialConnectionsAccount) {
                    this.financialConnectionsAccount = financialConnectionsAccount;
                    return this;
                }

                public Builder setFinancialConnectionsAccount(EmptyParam financialConnectionsAccount) {
                    this.financialConnectionsAccount = financialConnectionsAccount;
                    return this;
                }

                public Builder setRoutingNumber(String routingNumber) {
                    this.routingNumber = routingNumber;
                    return this;
                }

                public Builder setRoutingNumber(EmptyParam routingNumber) {
                    this.routingNumber = routingNumber;
                    return this;
                }
            }
        }

        public static class WechatPay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private WechatPay(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public WechatPay build() {
                    return new WechatPay(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Zip {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Zip(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Zip build() {
                    return new Zip(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Builder {
            private AcssDebit acssDebit;
            private Affirm affirm;
            private AfterpayClearpay afterpayClearpay;
            private Alipay alipay;
            private AuBecsDebit auBecsDebit;
            private BacsDebit bacsDebit;
            private Bancontact bancontact;
            private BillingDetails billingDetails;
            private Blik blik;
            private Boleto boleto;
            private Cashapp cashapp;
            private CustomerBalance customerBalance;
            private Eps eps;
            private Map<String, Object> extraParams;
            private Fpx fpx;
            private Giropay giropay;
            private Grabpay grabpay;
            private Ideal ideal;
            private InteracPresent interacPresent;
            private Klarna klarna;
            private Konbini konbini;
            private Link link;
            private Map<String, String> metadata;
            private Oxxo oxxo;
            private P24 p24;
            private Paynow paynow;
            private Paypal paypal;
            private Pix pix;
            private Promptpay promptpay;
            private RadarOptions radarOptions;
            private RevolutPay revolutPay;
            private SepaDebit sepaDebit;
            private Sofort sofort;
            private Swish swish;
            private Type type;
            private UsBankAccount usBankAccount;
            private WechatPay wechatPay;
            private Zip zip;

            public PaymentMethodData build() {
                return new PaymentMethodData(this.acssDebit, this.affirm, this.afterpayClearpay, this.alipay, this.auBecsDebit, this.bacsDebit, this.bancontact, this.billingDetails, this.blik, this.boleto, this.cashapp, this.customerBalance, this.eps, this.extraParams, this.fpx, this.giropay, this.grabpay, this.ideal, this.interacPresent, this.klarna, this.konbini, this.link, this.metadata, this.oxxo, this.p24, this.paynow, this.paypal, this.pix, this.promptpay, this.radarOptions, this.revolutPay, this.sepaDebit, this.sofort, this.swish, this.type, this.usBankAccount, this.wechatPay, this.zip);
            }

            public Builder setAcssDebit(AcssDebit acssDebit) {
                this.acssDebit = acssDebit;
                return this;
            }

            public Builder setAffirm(Affirm affirm) {
                this.affirm = affirm;
                return this;
            }

            public Builder setAfterpayClearpay(AfterpayClearpay afterpayClearpay) {
                this.afterpayClearpay = afterpayClearpay;
                return this;
            }

            public Builder setAlipay(Alipay alipay) {
                this.alipay = alipay;
                return this;
            }

            public Builder setAuBecsDebit(AuBecsDebit auBecsDebit) {
                this.auBecsDebit = auBecsDebit;
                return this;
            }

            public Builder setBacsDebit(BacsDebit bacsDebit) {
                this.bacsDebit = bacsDebit;
                return this;
            }

            public Builder setBancontact(Bancontact bancontact) {
                this.bancontact = bancontact;
                return this;
            }

            public Builder setBillingDetails(BillingDetails billingDetails) {
                this.billingDetails = billingDetails;
                return this;
            }

            public Builder setBlik(Blik blik) {
                this.blik = blik;
                return this;
            }

            public Builder setBoleto(Boleto boleto) {
                this.boleto = boleto;
                return this;
            }

            public Builder setCashapp(Cashapp cashapp) {
                this.cashapp = cashapp;
                return this;
            }

            public Builder setCustomerBalance(CustomerBalance customerBalance) {
                this.customerBalance = customerBalance;
                return this;
            }

            public Builder setEps(Eps eps) {
                this.eps = eps;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setFpx(Fpx fpx) {
                this.fpx = fpx;
                return this;
            }

            public Builder setGiropay(Giropay giropay) {
                this.giropay = giropay;
                return this;
            }

            public Builder setGrabpay(Grabpay grabpay) {
                this.grabpay = grabpay;
                return this;
            }

            public Builder setIdeal(Ideal ideal) {
                this.ideal = ideal;
                return this;
            }

            public Builder setInteracPresent(InteracPresent interacPresent) {
                this.interacPresent = interacPresent;
                return this;
            }

            public Builder setKlarna(Klarna klarna) {
                this.klarna = klarna;
                return this;
            }

            public Builder setKonbini(Konbini konbini) {
                this.konbini = konbini;
                return this;
            }

            public Builder setLink(Link link) {
                this.link = link;
                return this;
            }

            public Builder putMetadata(String key, String value) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.put(key, value);
                return this;
            }

            public Builder putAllMetadata(Map<String, String> map) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.putAll(map);
                return this;
            }

            public Builder setOxxo(Oxxo oxxo) {
                this.oxxo = oxxo;
                return this;
            }

            public Builder setP24(P24 p24) {
                this.p24 = p24;
                return this;
            }

            public Builder setPaynow(Paynow paynow) {
                this.paynow = paynow;
                return this;
            }

            public Builder setPaypal(Paypal paypal) {
                this.paypal = paypal;
                return this;
            }

            public Builder setPix(Pix pix) {
                this.pix = pix;
                return this;
            }

            public Builder setPromptpay(Promptpay promptpay) {
                this.promptpay = promptpay;
                return this;
            }

            public Builder setRadarOptions(RadarOptions radarOptions) {
                this.radarOptions = radarOptions;
                return this;
            }

            public Builder setRevolutPay(RevolutPay revolutPay) {
                this.revolutPay = revolutPay;
                return this;
            }

            public Builder setSepaDebit(SepaDebit sepaDebit) {
                this.sepaDebit = sepaDebit;
                return this;
            }

            public Builder setSofort(Sofort sofort) {
                this.sofort = sofort;
                return this;
            }

            public Builder setSwish(Swish swish) {
                this.swish = swish;
                return this;
            }

            public Builder setType(Type type) {
                this.type = type;
                return this;
            }

            public Builder setUsBankAccount(UsBankAccount usBankAccount) {
                this.usBankAccount = usBankAccount;
                return this;
            }

            public Builder setWechatPay(WechatPay wechatPay) {
                this.wechatPay = wechatPay;
                return this;
            }

            public Builder setZip(Zip zip) {
                this.zip = zip;
                return this;
            }
        }
    }

    public static class PaymentMethodOptions {
        @SerializedName(value="acss_debit")
        Object acssDebit;
        @SerializedName(value="affirm")
        Object affirm;
        @SerializedName(value="afterpay_clearpay")
        Object afterpayClearpay;
        @SerializedName(value="alipay")
        Object alipay;
        @SerializedName(value="au_becs_debit")
        Object auBecsDebit;
        @SerializedName(value="bacs_debit")
        Object bacsDebit;
        @SerializedName(value="bancontact")
        Object bancontact;
        @SerializedName(value="blik")
        Object blik;
        @SerializedName(value="boleto")
        Object boleto;
        @SerializedName(value="card")
        Object card;
        @SerializedName(value="card_present")
        Object cardPresent;
        @SerializedName(value="cashapp")
        Object cashapp;
        @SerializedName(value="customer_balance")
        Object customerBalance;
        @SerializedName(value="eps")
        Object eps;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="fpx")
        Object fpx;
        @SerializedName(value="giropay")
        Object giropay;
        @SerializedName(value="grabpay")
        Object grabpay;
        @SerializedName(value="ideal")
        Object ideal;
        @SerializedName(value="interac_present")
        Object interacPresent;
        @SerializedName(value="klarna")
        Object klarna;
        @SerializedName(value="konbini")
        Object konbini;
        @SerializedName(value="link")
        Object link;
        @SerializedName(value="oxxo")
        Object oxxo;
        @SerializedName(value="p24")
        Object p24;
        @SerializedName(value="paynow")
        Object paynow;
        @SerializedName(value="paypal")
        Object paypal;
        @SerializedName(value="pix")
        Object pix;
        @SerializedName(value="promptpay")
        Object promptpay;
        @SerializedName(value="revolut_pay")
        Object revolutPay;
        @SerializedName(value="sepa_debit")
        Object sepaDebit;
        @SerializedName(value="sofort")
        Object sofort;
        @SerializedName(value="swish")
        Object swish;
        @SerializedName(value="us_bank_account")
        Object usBankAccount;
        @SerializedName(value="wechat_pay")
        Object wechatPay;
        @SerializedName(value="zip")
        Object zip;

        private PaymentMethodOptions(Object acssDebit, Object affirm, Object afterpayClearpay, Object alipay, Object auBecsDebit, Object bacsDebit, Object bancontact, Object blik, Object boleto, Object card, Object cardPresent, Object cashapp, Object customerBalance, Object eps, Map<String, Object> extraParams, Object fpx, Object giropay, Object grabpay, Object ideal, Object interacPresent, Object klarna, Object konbini, Object link, Object oxxo, Object p24, Object paynow, Object paypal, Object pix, Object promptpay, Object revolutPay, Object sepaDebit, Object sofort, Object swish, Object usBankAccount, Object wechatPay, Object zip) {
            this.acssDebit = acssDebit;
            this.affirm = affirm;
            this.afterpayClearpay = afterpayClearpay;
            this.alipay = alipay;
            this.auBecsDebit = auBecsDebit;
            this.bacsDebit = bacsDebit;
            this.bancontact = bancontact;
            this.blik = blik;
            this.boleto = boleto;
            this.card = card;
            this.cardPresent = cardPresent;
            this.cashapp = cashapp;
            this.customerBalance = customerBalance;
            this.eps = eps;
            this.extraParams = extraParams;
            this.fpx = fpx;
            this.giropay = giropay;
            this.grabpay = grabpay;
            this.ideal = ideal;
            this.interacPresent = interacPresent;
            this.klarna = klarna;
            this.konbini = konbini;
            this.link = link;
            this.oxxo = oxxo;
            this.p24 = p24;
            this.paynow = paynow;
            this.paypal = paypal;
            this.pix = pix;
            this.promptpay = promptpay;
            this.revolutPay = revolutPay;
            this.sepaDebit = sepaDebit;
            this.sofort = sofort;
            this.swish = swish;
            this.usBankAccount = usBankAccount;
            this.wechatPay = wechatPay;
            this.zip = zip;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Object getAcssDebit() {
            return this.acssDebit;
        }

        @Generated
        public Object getAffirm() {
            return this.affirm;
        }

        @Generated
        public Object getAfterpayClearpay() {
            return this.afterpayClearpay;
        }

        @Generated
        public Object getAlipay() {
            return this.alipay;
        }

        @Generated
        public Object getAuBecsDebit() {
            return this.auBecsDebit;
        }

        @Generated
        public Object getBacsDebit() {
            return this.bacsDebit;
        }

        @Generated
        public Object getBancontact() {
            return this.bancontact;
        }

        @Generated
        public Object getBlik() {
            return this.blik;
        }

        @Generated
        public Object getBoleto() {
            return this.boleto;
        }

        @Generated
        public Object getCard() {
            return this.card;
        }

        @Generated
        public Object getCardPresent() {
            return this.cardPresent;
        }

        @Generated
        public Object getCashapp() {
            return this.cashapp;
        }

        @Generated
        public Object getCustomerBalance() {
            return this.customerBalance;
        }

        @Generated
        public Object getEps() {
            return this.eps;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public Object getFpx() {
            return this.fpx;
        }

        @Generated
        public Object getGiropay() {
            return this.giropay;
        }

        @Generated
        public Object getGrabpay() {
            return this.grabpay;
        }

        @Generated
        public Object getIdeal() {
            return this.ideal;
        }

        @Generated
        public Object getInteracPresent() {
            return this.interacPresent;
        }

        @Generated
        public Object getKlarna() {
            return this.klarna;
        }

        @Generated
        public Object getKonbini() {
            return this.konbini;
        }

        @Generated
        public Object getLink() {
            return this.link;
        }

        @Generated
        public Object getOxxo() {
            return this.oxxo;
        }

        @Generated
        public Object getP24() {
            return this.p24;
        }

        @Generated
        public Object getPaynow() {
            return this.paynow;
        }

        @Generated
        public Object getPaypal() {
            return this.paypal;
        }

        @Generated
        public Object getPix() {
            return this.pix;
        }

        @Generated
        public Object getPromptpay() {
            return this.promptpay;
        }

        @Generated
        public Object getRevolutPay() {
            return this.revolutPay;
        }

        @Generated
        public Object getSepaDebit() {
            return this.sepaDebit;
        }

        @Generated
        public Object getSofort() {
            return this.sofort;
        }

        @Generated
        public Object getSwish() {
            return this.swish;
        }

        @Generated
        public Object getUsBankAccount() {
            return this.usBankAccount;
        }

        @Generated
        public Object getWechatPay() {
            return this.wechatPay;
        }

        @Generated
        public Object getZip() {
            return this.zip;
        }

        public static class Builder {
            private Object acssDebit;
            private Object affirm;
            private Object afterpayClearpay;
            private Object alipay;
            private Object auBecsDebit;
            private Object bacsDebit;
            private Object bancontact;
            private Object blik;
            private Object boleto;
            private Object card;
            private Object cardPresent;
            private Object cashapp;
            private Object customerBalance;
            private Object eps;
            private Map<String, Object> extraParams;
            private Object fpx;
            private Object giropay;
            private Object grabpay;
            private Object ideal;
            private Object interacPresent;
            private Object klarna;
            private Object konbini;
            private Object link;
            private Object oxxo;
            private Object p24;
            private Object paynow;
            private Object paypal;
            private Object pix;
            private Object promptpay;
            private Object revolutPay;
            private Object sepaDebit;
            private Object sofort;
            private Object swish;
            private Object usBankAccount;
            private Object wechatPay;
            private Object zip;

            public PaymentMethodOptions build() {
                return new PaymentMethodOptions(this.acssDebit, this.affirm, this.afterpayClearpay, this.alipay, this.auBecsDebit, this.bacsDebit, this.bancontact, this.blik, this.boleto, this.card, this.cardPresent, this.cashapp, this.customerBalance, this.eps, this.extraParams, this.fpx, this.giropay, this.grabpay, this.ideal, this.interacPresent, this.klarna, this.konbini, this.link, this.oxxo, this.p24, this.paynow, this.paypal, this.pix, this.promptpay, this.revolutPay, this.sepaDebit, this.sofort, this.swish, this.usBankAccount, this.wechatPay, this.zip);
            }

            public Builder setAcssDebit(AcssDebit acssDebit) {
                this.acssDebit = acssDebit;
                return this;
            }

            public Builder setAcssDebit(EmptyParam acssDebit) {
                this.acssDebit = acssDebit;
                return this;
            }

            public Builder setAffirm(Affirm affirm) {
                this.affirm = affirm;
                return this;
            }

            public Builder setAffirm(EmptyParam affirm) {
                this.affirm = affirm;
                return this;
            }

            public Builder setAfterpayClearpay(AfterpayClearpay afterpayClearpay) {
                this.afterpayClearpay = afterpayClearpay;
                return this;
            }

            public Builder setAfterpayClearpay(EmptyParam afterpayClearpay) {
                this.afterpayClearpay = afterpayClearpay;
                return this;
            }

            public Builder setAlipay(Alipay alipay) {
                this.alipay = alipay;
                return this;
            }

            public Builder setAlipay(EmptyParam alipay) {
                this.alipay = alipay;
                return this;
            }

            public Builder setAuBecsDebit(AuBecsDebit auBecsDebit) {
                this.auBecsDebit = auBecsDebit;
                return this;
            }

            public Builder setAuBecsDebit(EmptyParam auBecsDebit) {
                this.auBecsDebit = auBecsDebit;
                return this;
            }

            public Builder setBacsDebit(BacsDebit bacsDebit) {
                this.bacsDebit = bacsDebit;
                return this;
            }

            public Builder setBacsDebit(EmptyParam bacsDebit) {
                this.bacsDebit = bacsDebit;
                return this;
            }

            public Builder setBancontact(Bancontact bancontact) {
                this.bancontact = bancontact;
                return this;
            }

            public Builder setBancontact(EmptyParam bancontact) {
                this.bancontact = bancontact;
                return this;
            }

            public Builder setBlik(Blik blik) {
                this.blik = blik;
                return this;
            }

            public Builder setBlik(EmptyParam blik) {
                this.blik = blik;
                return this;
            }

            public Builder setBoleto(Boleto boleto) {
                this.boleto = boleto;
                return this;
            }

            public Builder setBoleto(EmptyParam boleto) {
                this.boleto = boleto;
                return this;
            }

            public Builder setCard(Card card) {
                this.card = card;
                return this;
            }

            public Builder setCard(EmptyParam card) {
                this.card = card;
                return this;
            }

            public Builder setCardPresent(CardPresent cardPresent) {
                this.cardPresent = cardPresent;
                return this;
            }

            public Builder setCardPresent(EmptyParam cardPresent) {
                this.cardPresent = cardPresent;
                return this;
            }

            public Builder setCashapp(Cashapp cashapp) {
                this.cashapp = cashapp;
                return this;
            }

            public Builder setCashapp(EmptyParam cashapp) {
                this.cashapp = cashapp;
                return this;
            }

            public Builder setCustomerBalance(CustomerBalance customerBalance) {
                this.customerBalance = customerBalance;
                return this;
            }

            public Builder setCustomerBalance(EmptyParam customerBalance) {
                this.customerBalance = customerBalance;
                return this;
            }

            public Builder setEps(Eps eps) {
                this.eps = eps;
                return this;
            }

            public Builder setEps(EmptyParam eps) {
                this.eps = eps;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setFpx(Fpx fpx) {
                this.fpx = fpx;
                return this;
            }

            public Builder setFpx(EmptyParam fpx) {
                this.fpx = fpx;
                return this;
            }

            public Builder setGiropay(Giropay giropay) {
                this.giropay = giropay;
                return this;
            }

            public Builder setGiropay(EmptyParam giropay) {
                this.giropay = giropay;
                return this;
            }

            public Builder setGrabpay(Grabpay grabpay) {
                this.grabpay = grabpay;
                return this;
            }

            public Builder setGrabpay(EmptyParam grabpay) {
                this.grabpay = grabpay;
                return this;
            }

            public Builder setIdeal(Ideal ideal) {
                this.ideal = ideal;
                return this;
            }

            public Builder setIdeal(EmptyParam ideal) {
                this.ideal = ideal;
                return this;
            }

            public Builder setInteracPresent(InteracPresent interacPresent) {
                this.interacPresent = interacPresent;
                return this;
            }

            public Builder setInteracPresent(EmptyParam interacPresent) {
                this.interacPresent = interacPresent;
                return this;
            }

            public Builder setKlarna(Klarna klarna) {
                this.klarna = klarna;
                return this;
            }

            public Builder setKlarna(EmptyParam klarna) {
                this.klarna = klarna;
                return this;
            }

            public Builder setKonbini(Konbini konbini) {
                this.konbini = konbini;
                return this;
            }

            public Builder setKonbini(EmptyParam konbini) {
                this.konbini = konbini;
                return this;
            }

            public Builder setLink(Link link) {
                this.link = link;
                return this;
            }

            public Builder setLink(EmptyParam link) {
                this.link = link;
                return this;
            }

            public Builder setOxxo(Oxxo oxxo) {
                this.oxxo = oxxo;
                return this;
            }

            public Builder setOxxo(EmptyParam oxxo) {
                this.oxxo = oxxo;
                return this;
            }

            public Builder setP24(P24 p24) {
                this.p24 = p24;
                return this;
            }

            public Builder setP24(EmptyParam p24) {
                this.p24 = p24;
                return this;
            }

            public Builder setPaynow(Paynow paynow) {
                this.paynow = paynow;
                return this;
            }

            public Builder setPaynow(EmptyParam paynow) {
                this.paynow = paynow;
                return this;
            }

            public Builder setPaypal(Paypal paypal) {
                this.paypal = paypal;
                return this;
            }

            public Builder setPaypal(EmptyParam paypal) {
                this.paypal = paypal;
                return this;
            }

            public Builder setPix(Pix pix) {
                this.pix = pix;
                return this;
            }

            public Builder setPix(EmptyParam pix) {
                this.pix = pix;
                return this;
            }

            public Builder setPromptpay(Promptpay promptpay) {
                this.promptpay = promptpay;
                return this;
            }

            public Builder setPromptpay(EmptyParam promptpay) {
                this.promptpay = promptpay;
                return this;
            }

            public Builder setRevolutPay(RevolutPay revolutPay) {
                this.revolutPay = revolutPay;
                return this;
            }

            public Builder setRevolutPay(EmptyParam revolutPay) {
                this.revolutPay = revolutPay;
                return this;
            }

            public Builder setSepaDebit(SepaDebit sepaDebit) {
                this.sepaDebit = sepaDebit;
                return this;
            }

            public Builder setSepaDebit(EmptyParam sepaDebit) {
                this.sepaDebit = sepaDebit;
                return this;
            }

            public Builder setSofort(Sofort sofort) {
                this.sofort = sofort;
                return this;
            }

            public Builder setSofort(EmptyParam sofort) {
                this.sofort = sofort;
                return this;
            }

            public Builder setSwish(Swish swish) {
                this.swish = swish;
                return this;
            }

            public Builder setSwish(EmptyParam swish) {
                this.swish = swish;
                return this;
            }

            public Builder setUsBankAccount(UsBankAccount usBankAccount) {
                this.usBankAccount = usBankAccount;
                return this;
            }

            public Builder setUsBankAccount(EmptyParam usBankAccount) {
                this.usBankAccount = usBankAccount;
                return this;
            }

            public Builder setWechatPay(WechatPay wechatPay) {
                this.wechatPay = wechatPay;
                return this;
            }

            public Builder setWechatPay(EmptyParam wechatPay) {
                this.wechatPay = wechatPay;
                return this;
            }

            public Builder setZip(Zip zip) {
                this.zip = zip;
                return this;
            }

            public Builder setZip(EmptyParam zip) {
                this.zip = zip;
                return this;
            }
        }

        public static class Zip {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Zip(Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public Zip build() {
                    return new Zip(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class WechatPay {
            @SerializedName(value="app_id")
            Object appId;
            @SerializedName(value="client")
            Client client;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private WechatPay(Object appId, Client client, Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.appId = appId;
                this.client = client;
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Object getAppId() {
                return this.appId;
            }

            @Generated
            public Client getClient() {
                return this.client;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static enum Client implements ApiRequestParams.EnumParam
            {
                ANDROID("android"),
                IOS("ios"),
                WEB("web");

                private final String value;

                private Client(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Object appId;
                private Client client;
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public WechatPay build() {
                    return new WechatPay(this.appId, this.client, this.extraParams, this.setupFutureUsage);
                }

                public Builder setAppId(String appId) {
                    this.appId = appId;
                    return this;
                }

                public Builder setAppId(EmptyParam appId) {
                    this.appId = appId;
                    return this;
                }

                public Builder setClient(Client client) {
                    this.client = client;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class UsBankAccount {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="financial_connections")
            FinancialConnections financialConnections;
            @SerializedName(value="mandate_options")
            MandateOptions mandateOptions;
            @SerializedName(value="networks")
            Networks networks;
            @SerializedName(value="preferred_settlement_speed")
            ApiRequestParams.EnumParam preferredSettlementSpeed;
            @SerializedName(value="setup_future_usage")
            ApiRequestParams.EnumParam setupFutureUsage;
            @SerializedName(value="verification_method")
            VerificationMethod verificationMethod;

            private UsBankAccount(Map<String, Object> extraParams, FinancialConnections financialConnections, MandateOptions mandateOptions, Networks networks, ApiRequestParams.EnumParam preferredSettlementSpeed, ApiRequestParams.EnumParam setupFutureUsage, VerificationMethod verificationMethod) {
                this.extraParams = extraParams;
                this.financialConnections = financialConnections;
                this.mandateOptions = mandateOptions;
                this.networks = networks;
                this.preferredSettlementSpeed = preferredSettlementSpeed;
                this.setupFutureUsage = setupFutureUsage;
                this.verificationMethod = verificationMethod;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public FinancialConnections getFinancialConnections() {
                return this.financialConnections;
            }

            @Generated
            public MandateOptions getMandateOptions() {
                return this.mandateOptions;
            }

            @Generated
            public Networks getNetworks() {
                return this.networks;
            }

            @Generated
            public ApiRequestParams.EnumParam getPreferredSettlementSpeed() {
                return this.preferredSettlementSpeed;
            }

            @Generated
            public ApiRequestParams.EnumParam getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public VerificationMethod getVerificationMethod() {
                return this.verificationMethod;
            }

            public static class FinancialConnections {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="manual_entry")
                ManualEntry manualEntry;
                @SerializedName(value="permissions")
                List<Permission> permissions;
                @SerializedName(value="prefetch")
                List<Prefetch> prefetch;
                @SerializedName(value="return_url")
                Object returnUrl;

                private FinancialConnections(Map<String, Object> extraParams, ManualEntry manualEntry, List<Permission> permissions, List<Prefetch> prefetch, Object returnUrl) {
                    this.extraParams = extraParams;
                    this.manualEntry = manualEntry;
                    this.permissions = permissions;
                    this.prefetch = prefetch;
                    this.returnUrl = returnUrl;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public ManualEntry getManualEntry() {
                    return this.manualEntry;
                }

                @Generated
                public List<Permission> getPermissions() {
                    return this.permissions;
                }

                @Generated
                public List<Prefetch> getPrefetch() {
                    return this.prefetch;
                }

                @Generated
                public Object getReturnUrl() {
                    return this.returnUrl;
                }

                public static class ManualEntry {
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="mode")
                    Mode mode;

                    private ManualEntry(Map<String, Object> extraParams, Mode mode) {
                        this.extraParams = extraParams;
                        this.mode = mode;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public Mode getMode() {
                        return this.mode;
                    }

                    public static enum Mode implements ApiRequestParams.EnumParam
                    {
                        AUTOMATIC("automatic"),
                        CUSTOM("custom");

                        private final String value;

                        private Mode(String value) {
                            this.value = value;
                        }

                        @Override
                        @Generated
                        public String getValue() {
                            return this.value;
                        }
                    }

                    public static class Builder {
                        private Map<String, Object> extraParams;
                        private Mode mode;

                        public ManualEntry build() {
                            return new ManualEntry(this.extraParams, this.mode);
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setMode(Mode mode) {
                            this.mode = mode;
                            return this;
                        }
                    }
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private ManualEntry manualEntry;
                    private List<Permission> permissions;
                    private List<Prefetch> prefetch;
                    private Object returnUrl;

                    public FinancialConnections build() {
                        return new FinancialConnections(this.extraParams, this.manualEntry, this.permissions, this.prefetch, this.returnUrl);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setManualEntry(ManualEntry manualEntry) {
                        this.manualEntry = manualEntry;
                        return this;
                    }

                    public Builder addPermission(Permission element) {
                        if (this.permissions == null) {
                            this.permissions = new ArrayList<Permission>();
                        }
                        this.permissions.add(element);
                        return this;
                    }

                    public Builder addAllPermission(List<Permission> elements) {
                        if (this.permissions == null) {
                            this.permissions = new ArrayList<Permission>();
                        }
                        this.permissions.addAll(elements);
                        return this;
                    }

                    public Builder addPrefetch(Prefetch element) {
                        if (this.prefetch == null) {
                            this.prefetch = new ArrayList<Prefetch>();
                        }
                        this.prefetch.add(element);
                        return this;
                    }

                    public Builder addAllPrefetch(List<Prefetch> elements) {
                        if (this.prefetch == null) {
                            this.prefetch = new ArrayList<Prefetch>();
                        }
                        this.prefetch.addAll(elements);
                        return this;
                    }

                    public Builder setReturnUrl(String returnUrl) {
                        this.returnUrl = returnUrl;
                        return this;
                    }

                    public Builder setReturnUrl(EmptyParam returnUrl) {
                        this.returnUrl = returnUrl;
                        return this;
                    }
                }

                public static enum Prefetch implements ApiRequestParams.EnumParam
                {
                    BALANCES("balances"),
                    INFERRED_BALANCES("inferred_balances"),
                    OWNERSHIP("ownership"),
                    TRANSACTIONS("transactions");

                    private final String value;

                    private Prefetch(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static enum Permission implements ApiRequestParams.EnumParam
                {
                    BALANCES("balances"),
                    OWNERSHIP("ownership"),
                    PAYMENT_METHOD("payment_method"),
                    TRANSACTIONS("transactions");

                    private final String value;

                    private Permission(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }
            }

            public static class MandateOptions {
                @SerializedName(value="collection_method")
                ApiRequestParams.EnumParam collectionMethod;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;

                private MandateOptions(ApiRequestParams.EnumParam collectionMethod, Map<String, Object> extraParams) {
                    this.collectionMethod = collectionMethod;
                    this.extraParams = extraParams;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public ApiRequestParams.EnumParam getCollectionMethod() {
                    return this.collectionMethod;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                public static class Builder {
                    private ApiRequestParams.EnumParam collectionMethod;
                    private Map<String, Object> extraParams;

                    public MandateOptions build() {
                        return new MandateOptions(this.collectionMethod, this.extraParams);
                    }

                    public Builder setCollectionMethod(CollectionMethod collectionMethod) {
                        this.collectionMethod = collectionMethod;
                        return this;
                    }

                    public Builder setCollectionMethod(EmptyParam collectionMethod) {
                        this.collectionMethod = collectionMethod;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }
                }

                public static enum CollectionMethod implements ApiRequestParams.EnumParam
                {
                    PAPER("paper");

                    private final String value;

                    private CollectionMethod(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }
            }

            public static class Networks {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="requested")
                List<Requested> requested;

                private Networks(Map<String, Object> extraParams, List<Requested> requested) {
                    this.extraParams = extraParams;
                    this.requested = requested;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public List<Requested> getRequested() {
                    return this.requested;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private List<Requested> requested;

                    public Networks build() {
                        return new Networks(this.extraParams, this.requested);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder addRequested(Requested element) {
                        if (this.requested == null) {
                            this.requested = new ArrayList<Requested>();
                        }
                        this.requested.add(element);
                        return this;
                    }

                    public Builder addAllRequested(List<Requested> elements) {
                        if (this.requested == null) {
                            this.requested = new ArrayList<Requested>();
                        }
                        this.requested.addAll(elements);
                        return this;
                    }
                }

                public static enum Requested implements ApiRequestParams.EnumParam
                {
                    ACH("ach"),
                    US_DOMESTIC_WIRE("us_domestic_wire");

                    private final String value;

                    private Requested(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }
            }

            public static enum VerificationMethod implements ApiRequestParams.EnumParam
            {
                AUTOMATIC("automatic"),
                INSTANT("instant"),
                MICRODEPOSITS("microdeposits");

                private final String value;

                private VerificationMethod(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private FinancialConnections financialConnections;
                private MandateOptions mandateOptions;
                private Networks networks;
                private ApiRequestParams.EnumParam preferredSettlementSpeed;
                private ApiRequestParams.EnumParam setupFutureUsage;
                private VerificationMethod verificationMethod;

                public UsBankAccount build() {
                    return new UsBankAccount(this.extraParams, this.financialConnections, this.mandateOptions, this.networks, this.preferredSettlementSpeed, this.setupFutureUsage, this.verificationMethod);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setFinancialConnections(FinancialConnections financialConnections) {
                    this.financialConnections = financialConnections;
                    return this;
                }

                public Builder setMandateOptions(MandateOptions mandateOptions) {
                    this.mandateOptions = mandateOptions;
                    return this;
                }

                public Builder setNetworks(Networks networks) {
                    this.networks = networks;
                    return this;
                }

                public Builder setPreferredSettlementSpeed(PreferredSettlementSpeed preferredSettlementSpeed) {
                    this.preferredSettlementSpeed = preferredSettlementSpeed;
                    return this;
                }

                public Builder setPreferredSettlementSpeed(EmptyParam preferredSettlementSpeed) {
                    this.preferredSettlementSpeed = preferredSettlementSpeed;
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setSetupFutureUsage(EmptyParam setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setVerificationMethod(VerificationMethod verificationMethod) {
                    this.verificationMethod = verificationMethod;
                    return this;
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none"),
                OFF_SESSION("off_session"),
                ON_SESSION("on_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum PreferredSettlementSpeed implements ApiRequestParams.EnumParam
            {
                FASTEST("fastest"),
                STANDARD("standard");

                private final String value;

                private PreferredSettlementSpeed(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static class Swish {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="reference")
            Object reference;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Swish(Map<String, Object> extraParams, Object reference, SetupFutureUsage setupFutureUsage) {
                this.extraParams = extraParams;
                this.reference = reference;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Object getReference() {
                return this.reference;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Object reference;
                private SetupFutureUsage setupFutureUsage;

                public Swish build() {
                    return new Swish(this.extraParams, this.reference, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setReference(String reference) {
                    this.reference = reference;
                    return this;
                }

                public Builder setReference(EmptyParam reference) {
                    this.reference = reference;
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class Sofort {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="preferred_language")
            ApiRequestParams.EnumParam preferredLanguage;
            @SerializedName(value="setup_future_usage")
            ApiRequestParams.EnumParam setupFutureUsage;

            private Sofort(Map<String, Object> extraParams, ApiRequestParams.EnumParam preferredLanguage, ApiRequestParams.EnumParam setupFutureUsage) {
                this.extraParams = extraParams;
                this.preferredLanguage = preferredLanguage;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public ApiRequestParams.EnumParam getPreferredLanguage() {
                return this.preferredLanguage;
            }

            @Generated
            public ApiRequestParams.EnumParam getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private ApiRequestParams.EnumParam preferredLanguage;
                private ApiRequestParams.EnumParam setupFutureUsage;

                public Sofort build() {
                    return new Sofort(this.extraParams, this.preferredLanguage, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setPreferredLanguage(PreferredLanguage preferredLanguage) {
                    this.preferredLanguage = preferredLanguage;
                    return this;
                }

                public Builder setPreferredLanguage(EmptyParam preferredLanguage) {
                    this.preferredLanguage = preferredLanguage;
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setSetupFutureUsage(EmptyParam setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none"),
                OFF_SESSION("off_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum PreferredLanguage implements ApiRequestParams.EnumParam
            {
                DE("de"),
                EN("en"),
                ES("es"),
                FR("fr"),
                IT("it"),
                NL("nl"),
                PL("pl");

                private final String value;

                private PreferredLanguage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static class SepaDebit {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="mandate_options")
            MandateOptions mandateOptions;
            @SerializedName(value="setup_future_usage")
            ApiRequestParams.EnumParam setupFutureUsage;

            private SepaDebit(Map<String, Object> extraParams, MandateOptions mandateOptions, ApiRequestParams.EnumParam setupFutureUsage) {
                this.extraParams = extraParams;
                this.mandateOptions = mandateOptions;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public MandateOptions getMandateOptions() {
                return this.mandateOptions;
            }

            @Generated
            public ApiRequestParams.EnumParam getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static class MandateOptions {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;

                private MandateOptions(Map<String, Object> extraParams) {
                    this.extraParams = extraParams;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;

                    public MandateOptions build() {
                        return new MandateOptions(this.extraParams);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private MandateOptions mandateOptions;
                private ApiRequestParams.EnumParam setupFutureUsage;

                public SepaDebit build() {
                    return new SepaDebit(this.extraParams, this.mandateOptions, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setMandateOptions(MandateOptions mandateOptions) {
                    this.mandateOptions = mandateOptions;
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setSetupFutureUsage(EmptyParam setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none"),
                OFF_SESSION("off_session"),
                ON_SESSION("on_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static class RevolutPay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            ApiRequestParams.EnumParam setupFutureUsage;

            private RevolutPay(Map<String, Object> extraParams, ApiRequestParams.EnumParam setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public ApiRequestParams.EnumParam getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private ApiRequestParams.EnumParam setupFutureUsage;

                public RevolutPay build() {
                    return new RevolutPay(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setSetupFutureUsage(EmptyParam setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none"),
                OFF_SESSION("off_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static class Promptpay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Promptpay(Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public Promptpay build() {
                    return new Promptpay(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class Pix {
            @SerializedName(value="expires_after_seconds")
            Long expiresAfterSeconds;
            @SerializedName(value="expires_at")
            Long expiresAt;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Pix(Long expiresAfterSeconds, Long expiresAt, Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.expiresAfterSeconds = expiresAfterSeconds;
                this.expiresAt = expiresAt;
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Long getExpiresAfterSeconds() {
                return this.expiresAfterSeconds;
            }

            @Generated
            public Long getExpiresAt() {
                return this.expiresAt;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Long expiresAfterSeconds;
                private Long expiresAt;
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public Pix build() {
                    return new Pix(this.expiresAfterSeconds, this.expiresAt, this.extraParams, this.setupFutureUsage);
                }

                public Builder setExpiresAfterSeconds(Long expiresAfterSeconds) {
                    this.expiresAfterSeconds = expiresAfterSeconds;
                    return this;
                }

                public Builder setExpiresAt(Long expiresAt) {
                    this.expiresAt = expiresAt;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class Paypal {
            @SerializedName(value="capture_method")
            ApiRequestParams.EnumParam captureMethod;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="preferred_locale")
            PreferredLocale preferredLocale;
            @SerializedName(value="reference")
            Object reference;
            @SerializedName(value="reference_id")
            Object referenceId;
            @SerializedName(value="risk_correlation_id")
            Object riskCorrelationId;
            @SerializedName(value="setup_future_usage")
            ApiRequestParams.EnumParam setupFutureUsage;
            @SerializedName(value="subsellers")
            List<String> subsellers;

            private Paypal(ApiRequestParams.EnumParam captureMethod, Map<String, Object> extraParams, PreferredLocale preferredLocale, Object reference, Object referenceId, Object riskCorrelationId, ApiRequestParams.EnumParam setupFutureUsage, List<String> subsellers) {
                this.captureMethod = captureMethod;
                this.extraParams = extraParams;
                this.preferredLocale = preferredLocale;
                this.reference = reference;
                this.referenceId = referenceId;
                this.riskCorrelationId = riskCorrelationId;
                this.setupFutureUsage = setupFutureUsage;
                this.subsellers = subsellers;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public ApiRequestParams.EnumParam getCaptureMethod() {
                return this.captureMethod;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public PreferredLocale getPreferredLocale() {
                return this.preferredLocale;
            }

            @Generated
            public Object getReference() {
                return this.reference;
            }

            @Generated
            public Object getReferenceId() {
                return this.referenceId;
            }

            @Generated
            public Object getRiskCorrelationId() {
                return this.riskCorrelationId;
            }

            @Generated
            public ApiRequestParams.EnumParam getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public List<String> getSubsellers() {
                return this.subsellers;
            }

            public static enum PreferredLocale implements ApiRequestParams.EnumParam
            {
                CS_CZ("cs-CZ"),
                DA_DK("da-DK"),
                DE_AT("de-AT"),
                DE_DE("de-DE"),
                DE_LU("de-LU"),
                EL_GR("el-GR"),
                EN_GB("en-GB"),
                EN_US("en-US"),
                ES_ES("es-ES"),
                FI_FI("fi-FI"),
                FR_BE("fr-BE"),
                FR_FR("fr-FR"),
                FR_LU("fr-LU"),
                HU_HU("hu-HU"),
                IT_IT("it-IT"),
                NL_BE("nl-BE"),
                NL_NL("nl-NL"),
                PL_PL("pl-PL"),
                PT_PT("pt-PT"),
                SK_SK("sk-SK"),
                SV_SE("sv-SE");

                private final String value;

                private PreferredLocale(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private ApiRequestParams.EnumParam captureMethod;
                private Map<String, Object> extraParams;
                private PreferredLocale preferredLocale;
                private Object reference;
                private Object referenceId;
                private Object riskCorrelationId;
                private ApiRequestParams.EnumParam setupFutureUsage;
                private List<String> subsellers;

                public Paypal build() {
                    return new Paypal(this.captureMethod, this.extraParams, this.preferredLocale, this.reference, this.referenceId, this.riskCorrelationId, this.setupFutureUsage, this.subsellers);
                }

                public Builder setCaptureMethod(CaptureMethod captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder setCaptureMethod(EmptyParam captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setPreferredLocale(PreferredLocale preferredLocale) {
                    this.preferredLocale = preferredLocale;
                    return this;
                }

                public Builder setReference(String reference) {
                    this.reference = reference;
                    return this;
                }

                public Builder setReference(EmptyParam reference) {
                    this.reference = reference;
                    return this;
                }

                public Builder setReferenceId(String referenceId) {
                    this.referenceId = referenceId;
                    return this;
                }

                public Builder setReferenceId(EmptyParam referenceId) {
                    this.referenceId = referenceId;
                    return this;
                }

                public Builder setRiskCorrelationId(String riskCorrelationId) {
                    this.riskCorrelationId = riskCorrelationId;
                    return this;
                }

                public Builder setRiskCorrelationId(EmptyParam riskCorrelationId) {
                    this.riskCorrelationId = riskCorrelationId;
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setSetupFutureUsage(EmptyParam setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder addSubseller(String element) {
                    if (this.subsellers == null) {
                        this.subsellers = new ArrayList<String>();
                    }
                    this.subsellers.add(element);
                    return this;
                }

                public Builder addAllSubseller(List<String> elements) {
                    if (this.subsellers == null) {
                        this.subsellers = new ArrayList<String>();
                    }
                    this.subsellers.addAll(elements);
                    return this;
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none"),
                OFF_SESSION("off_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum CaptureMethod implements ApiRequestParams.EnumParam
            {
                MANUAL("manual");

                private final String value;

                private CaptureMethod(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static class Paynow {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Paynow(Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public Paynow build() {
                    return new Paynow(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class P24 {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;
            @SerializedName(value="tos_shown_and_accepted")
            Boolean tosShownAndAccepted;

            private P24(Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage, Boolean tosShownAndAccepted) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
                this.tosShownAndAccepted = tosShownAndAccepted;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public Boolean getTosShownAndAccepted() {
                return this.tosShownAndAccepted;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;
                private Boolean tosShownAndAccepted;

                public P24 build() {
                    return new P24(this.extraParams, this.setupFutureUsage, this.tosShownAndAccepted);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setTosShownAndAccepted(Boolean tosShownAndAccepted) {
                    this.tosShownAndAccepted = tosShownAndAccepted;
                    return this;
                }
            }
        }

        public static class Oxxo {
            @SerializedName(value="expires_after_days")
            Long expiresAfterDays;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Oxxo(Long expiresAfterDays, Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.expiresAfterDays = expiresAfterDays;
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Long getExpiresAfterDays() {
                return this.expiresAfterDays;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Long expiresAfterDays;
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public Oxxo build() {
                    return new Oxxo(this.expiresAfterDays, this.extraParams, this.setupFutureUsage);
                }

                public Builder setExpiresAfterDays(Long expiresAfterDays) {
                    this.expiresAfterDays = expiresAfterDays;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class Link {
            @SerializedName(value="capture_method")
            ApiRequestParams.EnumParam captureMethod;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="persistent_token")
            Object persistentToken;
            @SerializedName(value="setup_future_usage")
            ApiRequestParams.EnumParam setupFutureUsage;

            private Link(ApiRequestParams.EnumParam captureMethod, Map<String, Object> extraParams, Object persistentToken, ApiRequestParams.EnumParam setupFutureUsage) {
                this.captureMethod = captureMethod;
                this.extraParams = extraParams;
                this.persistentToken = persistentToken;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public ApiRequestParams.EnumParam getCaptureMethod() {
                return this.captureMethod;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Object getPersistentToken() {
                return this.persistentToken;
            }

            @Generated
            public ApiRequestParams.EnumParam getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static class Builder {
                private ApiRequestParams.EnumParam captureMethod;
                private Map<String, Object> extraParams;
                private Object persistentToken;
                private ApiRequestParams.EnumParam setupFutureUsage;

                public Link build() {
                    return new Link(this.captureMethod, this.extraParams, this.persistentToken, this.setupFutureUsage);
                }

                public Builder setCaptureMethod(CaptureMethod captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder setCaptureMethod(EmptyParam captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setPersistentToken(String persistentToken) {
                    this.persistentToken = persistentToken;
                    return this;
                }

                public Builder setPersistentToken(EmptyParam persistentToken) {
                    this.persistentToken = persistentToken;
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setSetupFutureUsage(EmptyParam setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none"),
                OFF_SESSION("off_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum CaptureMethod implements ApiRequestParams.EnumParam
            {
                MANUAL("manual");

                private final String value;

                private CaptureMethod(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static class Konbini {
            @SerializedName(value="confirmation_number")
            Object confirmationNumber;
            @SerializedName(value="expires_after_days")
            Object expiresAfterDays;
            @SerializedName(value="expires_at")
            Object expiresAt;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="product_description")
            Object productDescription;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Konbini(Object confirmationNumber, Object expiresAfterDays, Object expiresAt, Map<String, Object> extraParams, Object productDescription, SetupFutureUsage setupFutureUsage) {
                this.confirmationNumber = confirmationNumber;
                this.expiresAfterDays = expiresAfterDays;
                this.expiresAt = expiresAt;
                this.extraParams = extraParams;
                this.productDescription = productDescription;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Object getConfirmationNumber() {
                return this.confirmationNumber;
            }

            @Generated
            public Object getExpiresAfterDays() {
                return this.expiresAfterDays;
            }

            @Generated
            public Object getExpiresAt() {
                return this.expiresAt;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Object getProductDescription() {
                return this.productDescription;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Object confirmationNumber;
                private Object expiresAfterDays;
                private Object expiresAt;
                private Map<String, Object> extraParams;
                private Object productDescription;
                private SetupFutureUsage setupFutureUsage;

                public Konbini build() {
                    return new Konbini(this.confirmationNumber, this.expiresAfterDays, this.expiresAt, this.extraParams, this.productDescription, this.setupFutureUsage);
                }

                public Builder setConfirmationNumber(String confirmationNumber) {
                    this.confirmationNumber = confirmationNumber;
                    return this;
                }

                public Builder setConfirmationNumber(EmptyParam confirmationNumber) {
                    this.confirmationNumber = confirmationNumber;
                    return this;
                }

                public Builder setExpiresAfterDays(Long expiresAfterDays) {
                    this.expiresAfterDays = expiresAfterDays;
                    return this;
                }

                public Builder setExpiresAfterDays(EmptyParam expiresAfterDays) {
                    this.expiresAfterDays = expiresAfterDays;
                    return this;
                }

                public Builder setExpiresAt(Long expiresAt) {
                    this.expiresAt = expiresAt;
                    return this;
                }

                public Builder setExpiresAt(EmptyParam expiresAt) {
                    this.expiresAt = expiresAt;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setProductDescription(String productDescription) {
                    this.productDescription = productDescription;
                    return this;
                }

                public Builder setProductDescription(EmptyParam productDescription) {
                    this.productDescription = productDescription;
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class Klarna {
            @SerializedName(value="capture_method")
            ApiRequestParams.EnumParam captureMethod;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="preferred_locale")
            PreferredLocale preferredLocale;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Klarna(ApiRequestParams.EnumParam captureMethod, Map<String, Object> extraParams, PreferredLocale preferredLocale, SetupFutureUsage setupFutureUsage) {
                this.captureMethod = captureMethod;
                this.extraParams = extraParams;
                this.preferredLocale = preferredLocale;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public ApiRequestParams.EnumParam getCaptureMethod() {
                return this.captureMethod;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public PreferredLocale getPreferredLocale() {
                return this.preferredLocale;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static enum PreferredLocale implements ApiRequestParams.EnumParam
            {
                CS_CZ("cs-CZ"),
                DA_DK("da-DK"),
                DE_AT("de-AT"),
                DE_CH("de-CH"),
                DE_DE("de-DE"),
                EL_GR("el-GR"),
                EN_AT("en-AT"),
                EN_AU("en-AU"),
                EN_BE("en-BE"),
                EN_CA("en-CA"),
                EN_CH("en-CH"),
                EN_CZ("en-CZ"),
                EN_DE("en-DE"),
                EN_DK("en-DK"),
                EN_ES("en-ES"),
                EN_FI("en-FI"),
                EN_FR("en-FR"),
                EN_GB("en-GB"),
                EN_GR("en-GR"),
                EN_IE("en-IE"),
                EN_IT("en-IT"),
                EN_NL("en-NL"),
                EN_NO("en-NO"),
                EN_NZ("en-NZ"),
                EN_PL("en-PL"),
                EN_PT("en-PT"),
                EN_SE("en-SE"),
                EN_US("en-US"),
                ES_ES("es-ES"),
                ES_US("es-US"),
                FI_FI("fi-FI"),
                FR_BE("fr-BE"),
                FR_CA("fr-CA"),
                FR_CH("fr-CH"),
                FR_FR("fr-FR"),
                IT_CH("it-CH"),
                IT_IT("it-IT"),
                NB_NO("nb-NO"),
                NL_BE("nl-BE"),
                NL_NL("nl-NL"),
                PL_PL("pl-PL"),
                PT_PT("pt-PT"),
                SV_FI("sv-FI"),
                SV_SE("sv-SE");

                private final String value;

                private PreferredLocale(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private ApiRequestParams.EnumParam captureMethod;
                private Map<String, Object> extraParams;
                private PreferredLocale preferredLocale;
                private SetupFutureUsage setupFutureUsage;

                public Klarna build() {
                    return new Klarna(this.captureMethod, this.extraParams, this.preferredLocale, this.setupFutureUsage);
                }

                public Builder setCaptureMethod(CaptureMethod captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder setCaptureMethod(EmptyParam captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setPreferredLocale(PreferredLocale preferredLocale) {
                    this.preferredLocale = preferredLocale;
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }

            public static enum CaptureMethod implements ApiRequestParams.EnumParam
            {
                MANUAL("manual");

                private final String value;

                private CaptureMethod(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static class InteracPresent {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private InteracPresent(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public InteracPresent build() {
                    return new InteracPresent(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Ideal {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            ApiRequestParams.EnumParam setupFutureUsage;

            private Ideal(Map<String, Object> extraParams, ApiRequestParams.EnumParam setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public ApiRequestParams.EnumParam getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private ApiRequestParams.EnumParam setupFutureUsage;

                public Ideal build() {
                    return new Ideal(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setSetupFutureUsage(EmptyParam setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none"),
                OFF_SESSION("off_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static class Grabpay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Grabpay(Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public Grabpay build() {
                    return new Grabpay(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class Giropay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Giropay(Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public Giropay build() {
                    return new Giropay(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class Fpx {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Fpx(Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public Fpx build() {
                    return new Fpx(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class Eps {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Eps(Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public Eps build() {
                    return new Eps(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class CustomerBalance {
            @SerializedName(value="bank_transfer")
            BankTransfer bankTransfer;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="funding_type")
            FundingType fundingType;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private CustomerBalance(BankTransfer bankTransfer, Map<String, Object> extraParams, FundingType fundingType, SetupFutureUsage setupFutureUsage) {
                this.bankTransfer = bankTransfer;
                this.extraParams = extraParams;
                this.fundingType = fundingType;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public BankTransfer getBankTransfer() {
                return this.bankTransfer;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public FundingType getFundingType() {
                return this.fundingType;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static class BankTransfer {
                @SerializedName(value="eu_bank_transfer")
                EuBankTransfer euBankTransfer;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="requested_address_types")
                List<RequestedAddressType> requestedAddressTypes;
                @SerializedName(value="type")
                Type type;

                private BankTransfer(EuBankTransfer euBankTransfer, Map<String, Object> extraParams, List<RequestedAddressType> requestedAddressTypes, Type type) {
                    this.euBankTransfer = euBankTransfer;
                    this.extraParams = extraParams;
                    this.requestedAddressTypes = requestedAddressTypes;
                    this.type = type;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public EuBankTransfer getEuBankTransfer() {
                    return this.euBankTransfer;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public List<RequestedAddressType> getRequestedAddressTypes() {
                    return this.requestedAddressTypes;
                }

                @Generated
                public Type getType() {
                    return this.type;
                }

                public static class EuBankTransfer {
                    @SerializedName(value="country")
                    Object country;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;

                    private EuBankTransfer(Object country, Map<String, Object> extraParams) {
                        this.country = country;
                        this.extraParams = extraParams;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Object getCountry() {
                        return this.country;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    public static class Builder {
                        private Object country;
                        private Map<String, Object> extraParams;

                        public EuBankTransfer build() {
                            return new EuBankTransfer(this.country, this.extraParams);
                        }

                        public Builder setCountry(String country) {
                            this.country = country;
                            return this;
                        }

                        public Builder setCountry(EmptyParam country) {
                            this.country = country;
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }
                    }
                }

                public static enum Type implements ApiRequestParams.EnumParam
                {
                    EU_BANK_TRANSFER("eu_bank_transfer"),
                    GB_BANK_TRANSFER("gb_bank_transfer"),
                    JP_BANK_TRANSFER("jp_bank_transfer"),
                    MX_BANK_TRANSFER("mx_bank_transfer"),
                    US_BANK_TRANSFER("us_bank_transfer");

                    private final String value;

                    private Type(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private EuBankTransfer euBankTransfer;
                    private Map<String, Object> extraParams;
                    private List<RequestedAddressType> requestedAddressTypes;
                    private Type type;

                    public BankTransfer build() {
                        return new BankTransfer(this.euBankTransfer, this.extraParams, this.requestedAddressTypes, this.type);
                    }

                    public Builder setEuBankTransfer(EuBankTransfer euBankTransfer) {
                        this.euBankTransfer = euBankTransfer;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder addRequestedAddressType(RequestedAddressType element) {
                        if (this.requestedAddressTypes == null) {
                            this.requestedAddressTypes = new ArrayList<RequestedAddressType>();
                        }
                        this.requestedAddressTypes.add(element);
                        return this;
                    }

                    public Builder addAllRequestedAddressType(List<RequestedAddressType> elements) {
                        if (this.requestedAddressTypes == null) {
                            this.requestedAddressTypes = new ArrayList<RequestedAddressType>();
                        }
                        this.requestedAddressTypes.addAll(elements);
                        return this;
                    }

                    public Builder setType(Type type) {
                        this.type = type;
                        return this;
                    }
                }

                public static enum RequestedAddressType implements ApiRequestParams.EnumParam
                {
                    ABA("aba"),
                    IBAN("iban"),
                    SEPA("sepa"),
                    SORT_CODE("sort_code"),
                    SPEI("spei"),
                    SWIFT("swift"),
                    ZENGIN("zengin");

                    private final String value;

                    private RequestedAddressType(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }
            }

            public static enum FundingType implements ApiRequestParams.EnumParam
            {
                BANK_TRANSFER("bank_transfer");

                private final String value;

                private FundingType(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private BankTransfer bankTransfer;
                private Map<String, Object> extraParams;
                private FundingType fundingType;
                private SetupFutureUsage setupFutureUsage;

                public CustomerBalance build() {
                    return new CustomerBalance(this.bankTransfer, this.extraParams, this.fundingType, this.setupFutureUsage);
                }

                public Builder setBankTransfer(BankTransfer bankTransfer) {
                    this.bankTransfer = bankTransfer;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setFundingType(FundingType fundingType) {
                    this.fundingType = fundingType;
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class Cashapp {
            @SerializedName(value="capture_method")
            ApiRequestParams.EnumParam captureMethod;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            ApiRequestParams.EnumParam setupFutureUsage;

            private Cashapp(ApiRequestParams.EnumParam captureMethod, Map<String, Object> extraParams, ApiRequestParams.EnumParam setupFutureUsage) {
                this.captureMethod = captureMethod;
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public ApiRequestParams.EnumParam getCaptureMethod() {
                return this.captureMethod;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public ApiRequestParams.EnumParam getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static class Builder {
                private ApiRequestParams.EnumParam captureMethod;
                private Map<String, Object> extraParams;
                private ApiRequestParams.EnumParam setupFutureUsage;

                public Cashapp build() {
                    return new Cashapp(this.captureMethod, this.extraParams, this.setupFutureUsage);
                }

                public Builder setCaptureMethod(CaptureMethod captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder setCaptureMethod(EmptyParam captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setSetupFutureUsage(EmptyParam setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none"),
                OFF_SESSION("off_session"),
                ON_SESSION("on_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum CaptureMethod implements ApiRequestParams.EnumParam
            {
                MANUAL("manual");

                private final String value;

                private CaptureMethod(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static class CardPresent {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="request_extended_authorization")
            Boolean requestExtendedAuthorization;
            @SerializedName(value="request_incremental_authorization")
            RequestIncrementalAuthorization requestIncrementalAuthorization;
            @SerializedName(value="request_incremental_authorization_support")
            Boolean requestIncrementalAuthorizationSupport;

            private CardPresent(Map<String, Object> extraParams, Boolean requestExtendedAuthorization, RequestIncrementalAuthorization requestIncrementalAuthorization, Boolean requestIncrementalAuthorizationSupport) {
                this.extraParams = extraParams;
                this.requestExtendedAuthorization = requestExtendedAuthorization;
                this.requestIncrementalAuthorization = requestIncrementalAuthorization;
                this.requestIncrementalAuthorizationSupport = requestIncrementalAuthorizationSupport;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Boolean getRequestExtendedAuthorization() {
                return this.requestExtendedAuthorization;
            }

            @Generated
            public RequestIncrementalAuthorization getRequestIncrementalAuthorization() {
                return this.requestIncrementalAuthorization;
            }

            @Generated
            public Boolean getRequestIncrementalAuthorizationSupport() {
                return this.requestIncrementalAuthorizationSupport;
            }

            public static enum RequestIncrementalAuthorization implements ApiRequestParams.EnumParam
            {
                IF_AVAILABLE("if_available"),
                NEVER("never");

                private final String value;

                private RequestIncrementalAuthorization(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Boolean requestExtendedAuthorization;
                private RequestIncrementalAuthorization requestIncrementalAuthorization;
                private Boolean requestIncrementalAuthorizationSupport;

                public CardPresent build() {
                    return new CardPresent(this.extraParams, this.requestExtendedAuthorization, this.requestIncrementalAuthorization, this.requestIncrementalAuthorizationSupport);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setRequestExtendedAuthorization(Boolean requestExtendedAuthorization) {
                    this.requestExtendedAuthorization = requestExtendedAuthorization;
                    return this;
                }

                public Builder setRequestIncrementalAuthorization(RequestIncrementalAuthorization requestIncrementalAuthorization) {
                    this.requestIncrementalAuthorization = requestIncrementalAuthorization;
                    return this;
                }

                public Builder setRequestIncrementalAuthorizationSupport(Boolean requestIncrementalAuthorizationSupport) {
                    this.requestIncrementalAuthorizationSupport = requestIncrementalAuthorizationSupport;
                    return this;
                }
            }
        }

        public static class Card {
            @SerializedName(value="capture_method")
            ApiRequestParams.EnumParam captureMethod;
            @SerializedName(value="cvc_token")
            Object cvcToken;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="installments")
            Installments installments;
            @SerializedName(value="mandate_options")
            MandateOptions mandateOptions;
            @SerializedName(value="moto")
            Boolean moto;
            @SerializedName(value="network")
            Network network;
            @SerializedName(value="request_extended_authorization")
            RequestExtendedAuthorization requestExtendedAuthorization;
            @SerializedName(value="request_incremental_authorization")
            RequestIncrementalAuthorization requestIncrementalAuthorization;
            @SerializedName(value="request_multicapture")
            RequestMulticapture requestMulticapture;
            @SerializedName(value="request_overcapture")
            RequestOvercapture requestOvercapture;
            @SerializedName(value="request_three_d_secure")
            RequestThreeDSecure requestThreeDSecure;
            @SerializedName(value="setup_future_usage")
            ApiRequestParams.EnumParam setupFutureUsage;
            @SerializedName(value="statement_descriptor_suffix_kana")
            Object statementDescriptorSuffixKana;
            @SerializedName(value="statement_descriptor_suffix_kanji")
            Object statementDescriptorSuffixKanji;
            @SerializedName(value="statement_details")
            Object statementDetails;
            @SerializedName(value="three_d_secure")
            ThreeDSecure threeDSecure;

            private Card(ApiRequestParams.EnumParam captureMethod, Object cvcToken, Map<String, Object> extraParams, Installments installments, MandateOptions mandateOptions, Boolean moto, Network network, RequestExtendedAuthorization requestExtendedAuthorization, RequestIncrementalAuthorization requestIncrementalAuthorization, RequestMulticapture requestMulticapture, RequestOvercapture requestOvercapture, RequestThreeDSecure requestThreeDSecure, ApiRequestParams.EnumParam setupFutureUsage, Object statementDescriptorSuffixKana, Object statementDescriptorSuffixKanji, Object statementDetails, ThreeDSecure threeDSecure) {
                this.captureMethod = captureMethod;
                this.cvcToken = cvcToken;
                this.extraParams = extraParams;
                this.installments = installments;
                this.mandateOptions = mandateOptions;
                this.moto = moto;
                this.network = network;
                this.requestExtendedAuthorization = requestExtendedAuthorization;
                this.requestIncrementalAuthorization = requestIncrementalAuthorization;
                this.requestMulticapture = requestMulticapture;
                this.requestOvercapture = requestOvercapture;
                this.requestThreeDSecure = requestThreeDSecure;
                this.setupFutureUsage = setupFutureUsage;
                this.statementDescriptorSuffixKana = statementDescriptorSuffixKana;
                this.statementDescriptorSuffixKanji = statementDescriptorSuffixKanji;
                this.statementDetails = statementDetails;
                this.threeDSecure = threeDSecure;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public ApiRequestParams.EnumParam getCaptureMethod() {
                return this.captureMethod;
            }

            @Generated
            public Object getCvcToken() {
                return this.cvcToken;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Installments getInstallments() {
                return this.installments;
            }

            @Generated
            public MandateOptions getMandateOptions() {
                return this.mandateOptions;
            }

            @Generated
            public Boolean getMoto() {
                return this.moto;
            }

            @Generated
            public Network getNetwork() {
                return this.network;
            }

            @Generated
            public RequestExtendedAuthorization getRequestExtendedAuthorization() {
                return this.requestExtendedAuthorization;
            }

            @Generated
            public RequestIncrementalAuthorization getRequestIncrementalAuthorization() {
                return this.requestIncrementalAuthorization;
            }

            @Generated
            public RequestMulticapture getRequestMulticapture() {
                return this.requestMulticapture;
            }

            @Generated
            public RequestOvercapture getRequestOvercapture() {
                return this.requestOvercapture;
            }

            @Generated
            public RequestThreeDSecure getRequestThreeDSecure() {
                return this.requestThreeDSecure;
            }

            @Generated
            public ApiRequestParams.EnumParam getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public Object getStatementDescriptorSuffixKana() {
                return this.statementDescriptorSuffixKana;
            }

            @Generated
            public Object getStatementDescriptorSuffixKanji() {
                return this.statementDescriptorSuffixKanji;
            }

            @Generated
            public Object getStatementDetails() {
                return this.statementDetails;
            }

            @Generated
            public ThreeDSecure getThreeDSecure() {
                return this.threeDSecure;
            }

            public static class Installments {
                @SerializedName(value="enabled")
                Boolean enabled;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="plan")
                Object plan;

                private Installments(Boolean enabled, Map<String, Object> extraParams, Object plan) {
                    this.enabled = enabled;
                    this.extraParams = extraParams;
                    this.plan = plan;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Boolean getEnabled() {
                    return this.enabled;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Object getPlan() {
                    return this.plan;
                }

                public static class Builder {
                    private Boolean enabled;
                    private Map<String, Object> extraParams;
                    private Object plan;

                    public Installments build() {
                        return new Installments(this.enabled, this.extraParams, this.plan);
                    }

                    public Builder setEnabled(Boolean enabled) {
                        this.enabled = enabled;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setPlan(Plan plan) {
                        this.plan = plan;
                        return this;
                    }

                    public Builder setPlan(EmptyParam plan) {
                        this.plan = plan;
                        return this;
                    }
                }

                public static class Plan {
                    @SerializedName(value="count")
                    Long count;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="interval")
                    Interval interval;
                    @SerializedName(value="type")
                    Type type;

                    private Plan(Long count, Map<String, Object> extraParams, Interval interval, Type type) {
                        this.count = count;
                        this.extraParams = extraParams;
                        this.interval = interval;
                        this.type = type;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Long getCount() {
                        return this.count;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public Interval getInterval() {
                        return this.interval;
                    }

                    @Generated
                    public Type getType() {
                        return this.type;
                    }

                    public static enum Interval implements ApiRequestParams.EnumParam
                    {
                        MONTH("month");

                        private final String value;

                        private Interval(String value) {
                            this.value = value;
                        }

                        @Override
                        @Generated
                        public String getValue() {
                            return this.value;
                        }
                    }

                    public static enum Type implements ApiRequestParams.EnumParam
                    {
                        FIXED_COUNT("fixed_count");

                        private final String value;

                        private Type(String value) {
                            this.value = value;
                        }

                        @Override
                        @Generated
                        public String getValue() {
                            return this.value;
                        }
                    }

                    public static class Builder {
                        private Long count;
                        private Map<String, Object> extraParams;
                        private Interval interval;
                        private Type type;

                        public Plan build() {
                            return new Plan(this.count, this.extraParams, this.interval, this.type);
                        }

                        public Builder setCount(Long count) {
                            this.count = count;
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setInterval(Interval interval) {
                            this.interval = interval;
                            return this;
                        }

                        public Builder setType(Type type) {
                            this.type = type;
                            return this;
                        }
                    }
                }
            }

            public static class MandateOptions {
                @SerializedName(value="amount")
                Long amount;
                @SerializedName(value="amount_type")
                AmountType amountType;
                @SerializedName(value="description")
                Object description;
                @SerializedName(value="end_date")
                Long endDate;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="interval")
                Interval interval;
                @SerializedName(value="interval_count")
                Long intervalCount;
                @SerializedName(value="reference")
                Object reference;
                @SerializedName(value="start_date")
                Long startDate;
                @SerializedName(value="supported_types")
                List<SupportedType> supportedTypes;

                private MandateOptions(Long amount, AmountType amountType, Object description, Long endDate, Map<String, Object> extraParams, Interval interval, Long intervalCount, Object reference, Long startDate, List<SupportedType> supportedTypes) {
                    this.amount = amount;
                    this.amountType = amountType;
                    this.description = description;
                    this.endDate = endDate;
                    this.extraParams = extraParams;
                    this.interval = interval;
                    this.intervalCount = intervalCount;
                    this.reference = reference;
                    this.startDate = startDate;
                    this.supportedTypes = supportedTypes;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Long getAmount() {
                    return this.amount;
                }

                @Generated
                public AmountType getAmountType() {
                    return this.amountType;
                }

                @Generated
                public Object getDescription() {
                    return this.description;
                }

                @Generated
                public Long getEndDate() {
                    return this.endDate;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Interval getInterval() {
                    return this.interval;
                }

                @Generated
                public Long getIntervalCount() {
                    return this.intervalCount;
                }

                @Generated
                public Object getReference() {
                    return this.reference;
                }

                @Generated
                public Long getStartDate() {
                    return this.startDate;
                }

                @Generated
                public List<SupportedType> getSupportedTypes() {
                    return this.supportedTypes;
                }

                public static enum AmountType implements ApiRequestParams.EnumParam
                {
                    FIXED("fixed"),
                    MAXIMUM("maximum");

                    private final String value;

                    private AmountType(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static enum Interval implements ApiRequestParams.EnumParam
                {
                    DAY("day"),
                    MONTH("month"),
                    SPORADIC("sporadic"),
                    WEEK("week"),
                    YEAR("year");

                    private final String value;

                    private Interval(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Long amount;
                    private AmountType amountType;
                    private Object description;
                    private Long endDate;
                    private Map<String, Object> extraParams;
                    private Interval interval;
                    private Long intervalCount;
                    private Object reference;
                    private Long startDate;
                    private List<SupportedType> supportedTypes;

                    public MandateOptions build() {
                        return new MandateOptions(this.amount, this.amountType, this.description, this.endDate, this.extraParams, this.interval, this.intervalCount, this.reference, this.startDate, this.supportedTypes);
                    }

                    public Builder setAmount(Long amount) {
                        this.amount = amount;
                        return this;
                    }

                    public Builder setAmountType(AmountType amountType) {
                        this.amountType = amountType;
                        return this;
                    }

                    public Builder setDescription(String description) {
                        this.description = description;
                        return this;
                    }

                    public Builder setDescription(EmptyParam description) {
                        this.description = description;
                        return this;
                    }

                    public Builder setEndDate(Long endDate) {
                        this.endDate = endDate;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setInterval(Interval interval) {
                        this.interval = interval;
                        return this;
                    }

                    public Builder setIntervalCount(Long intervalCount) {
                        this.intervalCount = intervalCount;
                        return this;
                    }

                    public Builder setReference(String reference) {
                        this.reference = reference;
                        return this;
                    }

                    public Builder setReference(EmptyParam reference) {
                        this.reference = reference;
                        return this;
                    }

                    public Builder setStartDate(Long startDate) {
                        this.startDate = startDate;
                        return this;
                    }

                    public Builder addSupportedType(SupportedType element) {
                        if (this.supportedTypes == null) {
                            this.supportedTypes = new ArrayList<SupportedType>();
                        }
                        this.supportedTypes.add(element);
                        return this;
                    }

                    public Builder addAllSupportedType(List<SupportedType> elements) {
                        if (this.supportedTypes == null) {
                            this.supportedTypes = new ArrayList<SupportedType>();
                        }
                        this.supportedTypes.addAll(elements);
                        return this;
                    }
                }

                public static enum SupportedType implements ApiRequestParams.EnumParam
                {
                    INDIA("india");

                    private final String value;

                    private SupportedType(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }
            }

            public static enum Network implements ApiRequestParams.EnumParam
            {
                AMEX("amex"),
                CARTES_BANCAIRES("cartes_bancaires"),
                DINERS("diners"),
                DISCOVER("discover"),
                EFTPOS_AU("eftpos_au"),
                INTERAC("interac"),
                JCB("jcb"),
                MASTERCARD("mastercard"),
                UNIONPAY("unionpay"),
                UNKNOWN("unknown"),
                VISA("visa");

                private final String value;

                private Network(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum RequestExtendedAuthorization implements ApiRequestParams.EnumParam
            {
                IF_AVAILABLE("if_available"),
                NEVER("never");

                private final String value;

                private RequestExtendedAuthorization(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum RequestIncrementalAuthorization implements ApiRequestParams.EnumParam
            {
                IF_AVAILABLE("if_available"),
                NEVER("never");

                private final String value;

                private RequestIncrementalAuthorization(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum RequestMulticapture implements ApiRequestParams.EnumParam
            {
                IF_AVAILABLE("if_available"),
                NEVER("never");

                private final String value;

                private RequestMulticapture(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum RequestOvercapture implements ApiRequestParams.EnumParam
            {
                IF_AVAILABLE("if_available"),
                NEVER("never");

                private final String value;

                private RequestOvercapture(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum RequestThreeDSecure implements ApiRequestParams.EnumParam
            {
                ANY("any"),
                AUTOMATIC("automatic"),
                CHALLENGE("challenge");

                private final String value;

                private RequestThreeDSecure(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class ThreeDSecure {
                @SerializedName(value="ares_trans_status")
                AresTransStatus aresTransStatus;
                @SerializedName(value="cryptogram")
                Object cryptogram;
                @SerializedName(value="electronic_commerce_indicator")
                ElectronicCommerceIndicator electronicCommerceIndicator;
                @SerializedName(value="exemption_indicator")
                ExemptionIndicator exemptionIndicator;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="network_options")
                NetworkOptions networkOptions;
                @SerializedName(value="requestor_challenge_indicator")
                Object requestorChallengeIndicator;
                @SerializedName(value="transaction_id")
                Object transactionId;
                @SerializedName(value="version")
                Version version;

                private ThreeDSecure(AresTransStatus aresTransStatus, Object cryptogram, ElectronicCommerceIndicator electronicCommerceIndicator, ExemptionIndicator exemptionIndicator, Map<String, Object> extraParams, NetworkOptions networkOptions, Object requestorChallengeIndicator, Object transactionId, Version version) {
                    this.aresTransStatus = aresTransStatus;
                    this.cryptogram = cryptogram;
                    this.electronicCommerceIndicator = electronicCommerceIndicator;
                    this.exemptionIndicator = exemptionIndicator;
                    this.extraParams = extraParams;
                    this.networkOptions = networkOptions;
                    this.requestorChallengeIndicator = requestorChallengeIndicator;
                    this.transactionId = transactionId;
                    this.version = version;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public AresTransStatus getAresTransStatus() {
                    return this.aresTransStatus;
                }

                @Generated
                public Object getCryptogram() {
                    return this.cryptogram;
                }

                @Generated
                public ElectronicCommerceIndicator getElectronicCommerceIndicator() {
                    return this.electronicCommerceIndicator;
                }

                @Generated
                public ExemptionIndicator getExemptionIndicator() {
                    return this.exemptionIndicator;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public NetworkOptions getNetworkOptions() {
                    return this.networkOptions;
                }

                @Generated
                public Object getRequestorChallengeIndicator() {
                    return this.requestorChallengeIndicator;
                }

                @Generated
                public Object getTransactionId() {
                    return this.transactionId;
                }

                @Generated
                public Version getVersion() {
                    return this.version;
                }

                public static enum AresTransStatus implements ApiRequestParams.EnumParam
                {
                    A("A"),
                    C("C"),
                    I("I"),
                    N("N"),
                    R("R"),
                    U("U"),
                    Y("Y");

                    private final String value;

                    private AresTransStatus(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static enum ElectronicCommerceIndicator implements ApiRequestParams.EnumParam
                {
                    N01("01"),
                    N02("02"),
                    N05("05"),
                    N06("06"),
                    N07("07");

                    private final String value;

                    private ElectronicCommerceIndicator(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static enum ExemptionIndicator implements ApiRequestParams.EnumParam
                {
                    LOW_RISK("low_risk"),
                    NONE("none");

                    private final String value;

                    private ExemptionIndicator(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class NetworkOptions {
                    @SerializedName(value="cartes_bancaires")
                    CartesBancaires cartesBancaires;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;

                    private NetworkOptions(CartesBancaires cartesBancaires, Map<String, Object> extraParams) {
                        this.cartesBancaires = cartesBancaires;
                        this.extraParams = extraParams;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public CartesBancaires getCartesBancaires() {
                        return this.cartesBancaires;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    public static class CartesBancaires {
                        @SerializedName(value="cb_avalgo")
                        CbAvalgo cbAvalgo;
                        @SerializedName(value="cb_exemption")
                        Object cbExemption;
                        @SerializedName(value="cb_score")
                        Long cbScore;
                        @SerializedName(value="_stripe_java_extra_param_key")
                        Map<String, Object> extraParams;

                        private CartesBancaires(CbAvalgo cbAvalgo, Object cbExemption, Long cbScore, Map<String, Object> extraParams) {
                            this.cbAvalgo = cbAvalgo;
                            this.cbExemption = cbExemption;
                            this.cbScore = cbScore;
                            this.extraParams = extraParams;
                        }

                        public static Builder builder() {
                            return new Builder();
                        }

                        @Generated
                        public CbAvalgo getCbAvalgo() {
                            return this.cbAvalgo;
                        }

                        @Generated
                        public Object getCbExemption() {
                            return this.cbExemption;
                        }

                        @Generated
                        public Long getCbScore() {
                            return this.cbScore;
                        }

                        @Generated
                        public Map<String, Object> getExtraParams() {
                            return this.extraParams;
                        }

                        public static enum CbAvalgo implements ApiRequestParams.EnumParam
                        {
                            N0("0"),
                            N1("1"),
                            N2("2"),
                            N3("3"),
                            N4("4"),
                            A("A");

                            private final String value;

                            private CbAvalgo(String value) {
                                this.value = value;
                            }

                            @Override
                            @Generated
                            public String getValue() {
                                return this.value;
                            }
                        }

                        public static class Builder {
                            private CbAvalgo cbAvalgo;
                            private Object cbExemption;
                            private Long cbScore;
                            private Map<String, Object> extraParams;

                            public CartesBancaires build() {
                                return new CartesBancaires(this.cbAvalgo, this.cbExemption, this.cbScore, this.extraParams);
                            }

                            public Builder setCbAvalgo(CbAvalgo cbAvalgo) {
                                this.cbAvalgo = cbAvalgo;
                                return this;
                            }

                            public Builder setCbExemption(String cbExemption) {
                                this.cbExemption = cbExemption;
                                return this;
                            }

                            public Builder setCbExemption(EmptyParam cbExemption) {
                                this.cbExemption = cbExemption;
                                return this;
                            }

                            public Builder setCbScore(Long cbScore) {
                                this.cbScore = cbScore;
                                return this;
                            }

                            public Builder putExtraParam(String key, Object value) {
                                if (this.extraParams == null) {
                                    this.extraParams = new HashMap<String, Object>();
                                }
                                this.extraParams.put(key, value);
                                return this;
                            }

                            public Builder putAllExtraParam(Map<String, Object> map) {
                                if (this.extraParams == null) {
                                    this.extraParams = new HashMap<String, Object>();
                                }
                                this.extraParams.putAll(map);
                                return this;
                            }
                        }
                    }

                    public static class Builder {
                        private CartesBancaires cartesBancaires;
                        private Map<String, Object> extraParams;

                        public NetworkOptions build() {
                            return new NetworkOptions(this.cartesBancaires, this.extraParams);
                        }

                        public Builder setCartesBancaires(CartesBancaires cartesBancaires) {
                            this.cartesBancaires = cartesBancaires;
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }
                    }
                }

                public static enum Version implements ApiRequestParams.EnumParam
                {
                    N1__0__2("1.0.2"),
                    N2__1__0("2.1.0"),
                    N2__2__0("2.2.0");

                    private final String value;

                    private Version(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private AresTransStatus aresTransStatus;
                    private Object cryptogram;
                    private ElectronicCommerceIndicator electronicCommerceIndicator;
                    private ExemptionIndicator exemptionIndicator;
                    private Map<String, Object> extraParams;
                    private NetworkOptions networkOptions;
                    private Object requestorChallengeIndicator;
                    private Object transactionId;
                    private Version version;

                    public ThreeDSecure build() {
                        return new ThreeDSecure(this.aresTransStatus, this.cryptogram, this.electronicCommerceIndicator, this.exemptionIndicator, this.extraParams, this.networkOptions, this.requestorChallengeIndicator, this.transactionId, this.version);
                    }

                    public Builder setAresTransStatus(AresTransStatus aresTransStatus) {
                        this.aresTransStatus = aresTransStatus;
                        return this;
                    }

                    public Builder setCryptogram(String cryptogram) {
                        this.cryptogram = cryptogram;
                        return this;
                    }

                    public Builder setCryptogram(EmptyParam cryptogram) {
                        this.cryptogram = cryptogram;
                        return this;
                    }

                    public Builder setElectronicCommerceIndicator(ElectronicCommerceIndicator electronicCommerceIndicator) {
                        this.electronicCommerceIndicator = electronicCommerceIndicator;
                        return this;
                    }

                    public Builder setExemptionIndicator(ExemptionIndicator exemptionIndicator) {
                        this.exemptionIndicator = exemptionIndicator;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setNetworkOptions(NetworkOptions networkOptions) {
                        this.networkOptions = networkOptions;
                        return this;
                    }

                    public Builder setRequestorChallengeIndicator(String requestorChallengeIndicator) {
                        this.requestorChallengeIndicator = requestorChallengeIndicator;
                        return this;
                    }

                    public Builder setRequestorChallengeIndicator(EmptyParam requestorChallengeIndicator) {
                        this.requestorChallengeIndicator = requestorChallengeIndicator;
                        return this;
                    }

                    public Builder setTransactionId(String transactionId) {
                        this.transactionId = transactionId;
                        return this;
                    }

                    public Builder setTransactionId(EmptyParam transactionId) {
                        this.transactionId = transactionId;
                        return this;
                    }

                    public Builder setVersion(Version version) {
                        this.version = version;
                        return this;
                    }
                }
            }

            public static class Builder {
                private ApiRequestParams.EnumParam captureMethod;
                private Object cvcToken;
                private Map<String, Object> extraParams;
                private Installments installments;
                private MandateOptions mandateOptions;
                private Boolean moto;
                private Network network;
                private RequestExtendedAuthorization requestExtendedAuthorization;
                private RequestIncrementalAuthorization requestIncrementalAuthorization;
                private RequestMulticapture requestMulticapture;
                private RequestOvercapture requestOvercapture;
                private RequestThreeDSecure requestThreeDSecure;
                private ApiRequestParams.EnumParam setupFutureUsage;
                private Object statementDescriptorSuffixKana;
                private Object statementDescriptorSuffixKanji;
                private Object statementDetails;
                private ThreeDSecure threeDSecure;

                public Card build() {
                    return new Card(this.captureMethod, this.cvcToken, this.extraParams, this.installments, this.mandateOptions, this.moto, this.network, this.requestExtendedAuthorization, this.requestIncrementalAuthorization, this.requestMulticapture, this.requestOvercapture, this.requestThreeDSecure, this.setupFutureUsage, this.statementDescriptorSuffixKana, this.statementDescriptorSuffixKanji, this.statementDetails, this.threeDSecure);
                }

                public Builder setCaptureMethod(CaptureMethod captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder setCaptureMethod(EmptyParam captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder setCvcToken(String cvcToken) {
                    this.cvcToken = cvcToken;
                    return this;
                }

                public Builder setCvcToken(EmptyParam cvcToken) {
                    this.cvcToken = cvcToken;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setInstallments(Installments installments) {
                    this.installments = installments;
                    return this;
                }

                public Builder setMandateOptions(MandateOptions mandateOptions) {
                    this.mandateOptions = mandateOptions;
                    return this;
                }

                public Builder setMoto(Boolean moto) {
                    this.moto = moto;
                    return this;
                }

                public Builder setNetwork(Network network) {
                    this.network = network;
                    return this;
                }

                public Builder setRequestExtendedAuthorization(RequestExtendedAuthorization requestExtendedAuthorization) {
                    this.requestExtendedAuthorization = requestExtendedAuthorization;
                    return this;
                }

                public Builder setRequestIncrementalAuthorization(RequestIncrementalAuthorization requestIncrementalAuthorization) {
                    this.requestIncrementalAuthorization = requestIncrementalAuthorization;
                    return this;
                }

                public Builder setRequestMulticapture(RequestMulticapture requestMulticapture) {
                    this.requestMulticapture = requestMulticapture;
                    return this;
                }

                public Builder setRequestOvercapture(RequestOvercapture requestOvercapture) {
                    this.requestOvercapture = requestOvercapture;
                    return this;
                }

                public Builder setRequestThreeDSecure(RequestThreeDSecure requestThreeDSecure) {
                    this.requestThreeDSecure = requestThreeDSecure;
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setSetupFutureUsage(EmptyParam setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setStatementDescriptorSuffixKana(String statementDescriptorSuffixKana) {
                    this.statementDescriptorSuffixKana = statementDescriptorSuffixKana;
                    return this;
                }

                public Builder setStatementDescriptorSuffixKana(EmptyParam statementDescriptorSuffixKana) {
                    this.statementDescriptorSuffixKana = statementDescriptorSuffixKana;
                    return this;
                }

                public Builder setStatementDescriptorSuffixKanji(String statementDescriptorSuffixKanji) {
                    this.statementDescriptorSuffixKanji = statementDescriptorSuffixKanji;
                    return this;
                }

                public Builder setStatementDescriptorSuffixKanji(EmptyParam statementDescriptorSuffixKanji) {
                    this.statementDescriptorSuffixKanji = statementDescriptorSuffixKanji;
                    return this;
                }

                public Builder setStatementDetails(StatementDetails statementDetails) {
                    this.statementDetails = statementDetails;
                    return this;
                }

                public Builder setStatementDetails(EmptyParam statementDetails) {
                    this.statementDetails = statementDetails;
                    return this;
                }

                public Builder setThreeDSecure(ThreeDSecure threeDSecure) {
                    this.threeDSecure = threeDSecure;
                    return this;
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none"),
                OFF_SESSION("off_session"),
                ON_SESSION("on_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum CaptureMethod implements ApiRequestParams.EnumParam
            {
                MANUAL("manual");

                private final String value;

                private CaptureMethod(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class StatementDetails {
                @SerializedName(value="address")
                Address address;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="phone")
                Object phone;

                private StatementDetails(Address address, Map<String, Object> extraParams, Object phone) {
                    this.address = address;
                    this.extraParams = extraParams;
                    this.phone = phone;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Address getAddress() {
                    return this.address;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Object getPhone() {
                    return this.phone;
                }

                public static class Address {
                    @SerializedName(value="city")
                    Object city;
                    @SerializedName(value="country")
                    Object country;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="line1")
                    Object line1;
                    @SerializedName(value="line2")
                    Object line2;
                    @SerializedName(value="postal_code")
                    Object postalCode;
                    @SerializedName(value="state")
                    Object state;

                    private Address(Object city, Object country, Map<String, Object> extraParams, Object line1, Object line2, Object postalCode, Object state) {
                        this.city = city;
                        this.country = country;
                        this.extraParams = extraParams;
                        this.line1 = line1;
                        this.line2 = line2;
                        this.postalCode = postalCode;
                        this.state = state;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Object getCity() {
                        return this.city;
                    }

                    @Generated
                    public Object getCountry() {
                        return this.country;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public Object getLine1() {
                        return this.line1;
                    }

                    @Generated
                    public Object getLine2() {
                        return this.line2;
                    }

                    @Generated
                    public Object getPostalCode() {
                        return this.postalCode;
                    }

                    @Generated
                    public Object getState() {
                        return this.state;
                    }

                    public static class Builder {
                        private Object city;
                        private Object country;
                        private Map<String, Object> extraParams;
                        private Object line1;
                        private Object line2;
                        private Object postalCode;
                        private Object state;

                        public Address build() {
                            return new Address(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
                        }

                        public Builder setCity(String city) {
                            this.city = city;
                            return this;
                        }

                        public Builder setCity(EmptyParam city) {
                            this.city = city;
                            return this;
                        }

                        public Builder setCountry(String country) {
                            this.country = country;
                            return this;
                        }

                        public Builder setCountry(EmptyParam country) {
                            this.country = country;
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setLine1(String line1) {
                            this.line1 = line1;
                            return this;
                        }

                        public Builder setLine1(EmptyParam line1) {
                            this.line1 = line1;
                            return this;
                        }

                        public Builder setLine2(String line2) {
                            this.line2 = line2;
                            return this;
                        }

                        public Builder setLine2(EmptyParam line2) {
                            this.line2 = line2;
                            return this;
                        }

                        public Builder setPostalCode(String postalCode) {
                            this.postalCode = postalCode;
                            return this;
                        }

                        public Builder setPostalCode(EmptyParam postalCode) {
                            this.postalCode = postalCode;
                            return this;
                        }

                        public Builder setState(String state) {
                            this.state = state;
                            return this;
                        }

                        public Builder setState(EmptyParam state) {
                            this.state = state;
                            return this;
                        }
                    }
                }

                public static class Builder {
                    private Address address;
                    private Map<String, Object> extraParams;
                    private Object phone;

                    public StatementDetails build() {
                        return new StatementDetails(this.address, this.extraParams, this.phone);
                    }

                    public Builder setAddress(Address address) {
                        this.address = address;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setPhone(String phone) {
                        this.phone = phone;
                        return this;
                    }

                    public Builder setPhone(EmptyParam phone) {
                        this.phone = phone;
                        return this;
                    }
                }
            }
        }

        public static class Boleto {
            @SerializedName(value="expires_after_days")
            Long expiresAfterDays;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            ApiRequestParams.EnumParam setupFutureUsage;

            private Boleto(Long expiresAfterDays, Map<String, Object> extraParams, ApiRequestParams.EnumParam setupFutureUsage) {
                this.expiresAfterDays = expiresAfterDays;
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Long getExpiresAfterDays() {
                return this.expiresAfterDays;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public ApiRequestParams.EnumParam getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static class Builder {
                private Long expiresAfterDays;
                private Map<String, Object> extraParams;
                private ApiRequestParams.EnumParam setupFutureUsage;

                public Boleto build() {
                    return new Boleto(this.expiresAfterDays, this.extraParams, this.setupFutureUsage);
                }

                public Builder setExpiresAfterDays(Long expiresAfterDays) {
                    this.expiresAfterDays = expiresAfterDays;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setSetupFutureUsage(EmptyParam setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none"),
                OFF_SESSION("off_session"),
                ON_SESSION("on_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static class Blik {
            @SerializedName(value="code")
            Object code;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Blik(Object code, Map<String, Object> extraParams) {
                this.code = code;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Object getCode() {
                return this.code;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Object code;
                private Map<String, Object> extraParams;

                public Blik build() {
                    return new Blik(this.code, this.extraParams);
                }

                public Builder setCode(String code) {
                    this.code = code;
                    return this;
                }

                public Builder setCode(EmptyParam code) {
                    this.code = code;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Bancontact {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="preferred_language")
            PreferredLanguage preferredLanguage;
            @SerializedName(value="setup_future_usage")
            ApiRequestParams.EnumParam setupFutureUsage;

            private Bancontact(Map<String, Object> extraParams, PreferredLanguage preferredLanguage, ApiRequestParams.EnumParam setupFutureUsage) {
                this.extraParams = extraParams;
                this.preferredLanguage = preferredLanguage;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public PreferredLanguage getPreferredLanguage() {
                return this.preferredLanguage;
            }

            @Generated
            public ApiRequestParams.EnumParam getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static enum PreferredLanguage implements ApiRequestParams.EnumParam
            {
                DE("de"),
                EN("en"),
                FR("fr"),
                NL("nl");

                private final String value;

                private PreferredLanguage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private PreferredLanguage preferredLanguage;
                private ApiRequestParams.EnumParam setupFutureUsage;

                public Bancontact build() {
                    return new Bancontact(this.extraParams, this.preferredLanguage, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setPreferredLanguage(PreferredLanguage preferredLanguage) {
                    this.preferredLanguage = preferredLanguage;
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setSetupFutureUsage(EmptyParam setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none"),
                OFF_SESSION("off_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static class BacsDebit {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            ApiRequestParams.EnumParam setupFutureUsage;

            private BacsDebit(Map<String, Object> extraParams, ApiRequestParams.EnumParam setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public ApiRequestParams.EnumParam getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private ApiRequestParams.EnumParam setupFutureUsage;

                public BacsDebit build() {
                    return new BacsDebit(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setSetupFutureUsage(EmptyParam setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none"),
                OFF_SESSION("off_session"),
                ON_SESSION("on_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static class AuBecsDebit {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            ApiRequestParams.EnumParam setupFutureUsage;

            private AuBecsDebit(Map<String, Object> extraParams, ApiRequestParams.EnumParam setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public ApiRequestParams.EnumParam getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private ApiRequestParams.EnumParam setupFutureUsage;

                public AuBecsDebit build() {
                    return new AuBecsDebit(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setSetupFutureUsage(EmptyParam setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none"),
                OFF_SESSION("off_session"),
                ON_SESSION("on_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static class Alipay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            ApiRequestParams.EnumParam setupFutureUsage;

            private Alipay(Map<String, Object> extraParams, ApiRequestParams.EnumParam setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public ApiRequestParams.EnumParam getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private ApiRequestParams.EnumParam setupFutureUsage;

                public Alipay build() {
                    return new Alipay(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setSetupFutureUsage(EmptyParam setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none"),
                OFF_SESSION("off_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static class AfterpayClearpay {
            @SerializedName(value="capture_method")
            ApiRequestParams.EnumParam captureMethod;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="reference")
            Object reference;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private AfterpayClearpay(ApiRequestParams.EnumParam captureMethod, Map<String, Object> extraParams, Object reference, SetupFutureUsage setupFutureUsage) {
                this.captureMethod = captureMethod;
                this.extraParams = extraParams;
                this.reference = reference;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public ApiRequestParams.EnumParam getCaptureMethod() {
                return this.captureMethod;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Object getReference() {
                return this.reference;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private ApiRequestParams.EnumParam captureMethod;
                private Map<String, Object> extraParams;
                private Object reference;
                private SetupFutureUsage setupFutureUsage;

                public AfterpayClearpay build() {
                    return new AfterpayClearpay(this.captureMethod, this.extraParams, this.reference, this.setupFutureUsage);
                }

                public Builder setCaptureMethod(CaptureMethod captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder setCaptureMethod(EmptyParam captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setReference(String reference) {
                    this.reference = reference;
                    return this;
                }

                public Builder setReference(EmptyParam reference) {
                    this.reference = reference;
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }

            public static enum CaptureMethod implements ApiRequestParams.EnumParam
            {
                MANUAL("manual");

                private final String value;

                private CaptureMethod(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static class Affirm {
            @SerializedName(value="capture_method")
            ApiRequestParams.EnumParam captureMethod;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="preferred_locale")
            Object preferredLocale;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Affirm(ApiRequestParams.EnumParam captureMethod, Map<String, Object> extraParams, Object preferredLocale, SetupFutureUsage setupFutureUsage) {
                this.captureMethod = captureMethod;
                this.extraParams = extraParams;
                this.preferredLocale = preferredLocale;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public ApiRequestParams.EnumParam getCaptureMethod() {
                return this.captureMethod;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Object getPreferredLocale() {
                return this.preferredLocale;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private ApiRequestParams.EnumParam captureMethod;
                private Map<String, Object> extraParams;
                private Object preferredLocale;
                private SetupFutureUsage setupFutureUsage;

                public Affirm build() {
                    return new Affirm(this.captureMethod, this.extraParams, this.preferredLocale, this.setupFutureUsage);
                }

                public Builder setCaptureMethod(CaptureMethod captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder setCaptureMethod(EmptyParam captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setPreferredLocale(String preferredLocale) {
                    this.preferredLocale = preferredLocale;
                    return this;
                }

                public Builder setPreferredLocale(EmptyParam preferredLocale) {
                    this.preferredLocale = preferredLocale;
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }

            public static enum CaptureMethod implements ApiRequestParams.EnumParam
            {
                MANUAL("manual");

                private final String value;

                private CaptureMethod(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static class AcssDebit {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="mandate_options")
            MandateOptions mandateOptions;
            @SerializedName(value="setup_future_usage")
            ApiRequestParams.EnumParam setupFutureUsage;
            @SerializedName(value="verification_method")
            VerificationMethod verificationMethod;

            private AcssDebit(Map<String, Object> extraParams, MandateOptions mandateOptions, ApiRequestParams.EnumParam setupFutureUsage, VerificationMethod verificationMethod) {
                this.extraParams = extraParams;
                this.mandateOptions = mandateOptions;
                this.setupFutureUsage = setupFutureUsage;
                this.verificationMethod = verificationMethod;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public MandateOptions getMandateOptions() {
                return this.mandateOptions;
            }

            @Generated
            public ApiRequestParams.EnumParam getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public VerificationMethod getVerificationMethod() {
                return this.verificationMethod;
            }

            public static class MandateOptions {
                @SerializedName(value="custom_mandate_url")
                Object customMandateUrl;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="interval_description")
                Object intervalDescription;
                @SerializedName(value="payment_schedule")
                PaymentSchedule paymentSchedule;
                @SerializedName(value="transaction_type")
                TransactionType transactionType;

                private MandateOptions(Object customMandateUrl, Map<String, Object> extraParams, Object intervalDescription, PaymentSchedule paymentSchedule, TransactionType transactionType) {
                    this.customMandateUrl = customMandateUrl;
                    this.extraParams = extraParams;
                    this.intervalDescription = intervalDescription;
                    this.paymentSchedule = paymentSchedule;
                    this.transactionType = transactionType;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Object getCustomMandateUrl() {
                    return this.customMandateUrl;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Object getIntervalDescription() {
                    return this.intervalDescription;
                }

                @Generated
                public PaymentSchedule getPaymentSchedule() {
                    return this.paymentSchedule;
                }

                @Generated
                public TransactionType getTransactionType() {
                    return this.transactionType;
                }

                public static enum PaymentSchedule implements ApiRequestParams.EnumParam
                {
                    COMBINED("combined"),
                    INTERVAL("interval"),
                    SPORADIC("sporadic");

                    private final String value;

                    private PaymentSchedule(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static enum TransactionType implements ApiRequestParams.EnumParam
                {
                    BUSINESS("business"),
                    PERSONAL("personal");

                    private final String value;

                    private TransactionType(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Object customMandateUrl;
                    private Map<String, Object> extraParams;
                    private Object intervalDescription;
                    private PaymentSchedule paymentSchedule;
                    private TransactionType transactionType;

                    public MandateOptions build() {
                        return new MandateOptions(this.customMandateUrl, this.extraParams, this.intervalDescription, this.paymentSchedule, this.transactionType);
                    }

                    public Builder setCustomMandateUrl(String customMandateUrl) {
                        this.customMandateUrl = customMandateUrl;
                        return this;
                    }

                    public Builder setCustomMandateUrl(EmptyParam customMandateUrl) {
                        this.customMandateUrl = customMandateUrl;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setIntervalDescription(String intervalDescription) {
                        this.intervalDescription = intervalDescription;
                        return this;
                    }

                    public Builder setIntervalDescription(EmptyParam intervalDescription) {
                        this.intervalDescription = intervalDescription;
                        return this;
                    }

                    public Builder setPaymentSchedule(PaymentSchedule paymentSchedule) {
                        this.paymentSchedule = paymentSchedule;
                        return this;
                    }

                    public Builder setTransactionType(TransactionType transactionType) {
                        this.transactionType = transactionType;
                        return this;
                    }
                }
            }

            public static enum VerificationMethod implements ApiRequestParams.EnumParam
            {
                AUTOMATIC("automatic"),
                INSTANT("instant"),
                MICRODEPOSITS("microdeposits");

                private final String value;

                private VerificationMethod(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private MandateOptions mandateOptions;
                private ApiRequestParams.EnumParam setupFutureUsage;
                private VerificationMethod verificationMethod;

                public AcssDebit build() {
                    return new AcssDebit(this.extraParams, this.mandateOptions, this.setupFutureUsage, this.verificationMethod);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setMandateOptions(MandateOptions mandateOptions) {
                    this.mandateOptions = mandateOptions;
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setSetupFutureUsage(EmptyParam setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setVerificationMethod(VerificationMethod verificationMethod) {
                    this.verificationMethod = verificationMethod;
                    return this;
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none"),
                OFF_SESSION("off_session"),
                ON_SESSION("on_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }
    }

    public static class TransferData {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;

        private TransferData(Long amount, Map<String, Object> extraParams) {
            this.amount = amount;
            this.extraParams = extraParams;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        public static class Builder {
            private Long amount;
            private Map<String, Object> extraParams;

            public TransferData build() {
                return new TransferData(this.amount, this.extraParams);
            }

            public Builder setAmount(Long amount) {
                this.amount = amount;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }
        }
    }

    public static class Builder {
        private Long amount;
        private Object applicationFeeAmount;
        private CaptureMethod captureMethod;
        private Object currency;
        private Object customer;
        private Object description;
        private List<String> expand;
        private Map<String, Object> extraParams;
        private MandateData mandateData;
        private Object metadata;
        private Object paymentDetails;
        private Object paymentMethod;
        private Object paymentMethodConfiguration;
        private PaymentMethodData paymentMethodData;
        private PaymentMethodOptions paymentMethodOptions;
        private List<String> paymentMethodTypes;
        private Object receiptEmail;
        private ApiRequestParams.EnumParam setupFutureUsage;
        private Object shipping;
        private Object statementDescriptor;
        private Object statementDescriptorSuffix;
        private TransferData transferData;
        private Object transferGroup;

        public PaymentIntentUpdateParams build() {
            return new PaymentIntentUpdateParams(this.amount, this.applicationFeeAmount, this.captureMethod, this.currency, this.customer, this.description, this.expand, this.extraParams, this.mandateData, this.metadata, this.paymentDetails, this.paymentMethod, this.paymentMethodConfiguration, this.paymentMethodData, this.paymentMethodOptions, this.paymentMethodTypes, this.receiptEmail, this.setupFutureUsage, this.shipping, this.statementDescriptor, this.statementDescriptorSuffix, this.transferData, this.transferGroup);
        }

        public Builder setAmount(Long amount) {
            this.amount = amount;
            return this;
        }

        public Builder setApplicationFeeAmount(Long applicationFeeAmount) {
            this.applicationFeeAmount = applicationFeeAmount;
            return this;
        }

        public Builder setApplicationFeeAmount(EmptyParam applicationFeeAmount) {
            this.applicationFeeAmount = applicationFeeAmount;
            return this;
        }

        public Builder setCaptureMethod(CaptureMethod captureMethod) {
            this.captureMethod = captureMethod;
            return this;
        }

        public Builder setCurrency(String currency) {
            this.currency = currency;
            return this;
        }

        public Builder setCurrency(EmptyParam currency) {
            this.currency = currency;
            return this;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setCustomer(EmptyParam customer) {
            this.customer = customer;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setDescription(EmptyParam description) {
            this.description = description;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.put(key, value);
            return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.putAll(map);
            return this;
        }

        public Builder setMandateData(MandateData mandateData) {
            this.mandateData = mandateData;
            return this;
        }

        public Builder putMetadata(String key, String value) {
            if (this.metadata == null || this.metadata instanceof EmptyParam) {
                this.metadata = new HashMap();
            }
            ((Map)this.metadata).put(key, value);
            return this;
        }

        public Builder putAllMetadata(Map<String, String> map) {
            if (this.metadata == null || this.metadata instanceof EmptyParam) {
                this.metadata = new HashMap();
            }
            ((Map)this.metadata).putAll(map);
            return this;
        }

        public Builder setMetadata(EmptyParam metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder setMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder setPaymentDetails(PaymentDetails paymentDetails) {
            this.paymentDetails = paymentDetails;
            return this;
        }

        public Builder setPaymentDetails(EmptyParam paymentDetails) {
            this.paymentDetails = paymentDetails;
            return this;
        }

        public Builder setPaymentMethod(String paymentMethod) {
            this.paymentMethod = paymentMethod;
            return this;
        }

        public Builder setPaymentMethod(EmptyParam paymentMethod) {
            this.paymentMethod = paymentMethod;
            return this;
        }

        public Builder setPaymentMethodConfiguration(String paymentMethodConfiguration) {
            this.paymentMethodConfiguration = paymentMethodConfiguration;
            return this;
        }

        public Builder setPaymentMethodConfiguration(EmptyParam paymentMethodConfiguration) {
            this.paymentMethodConfiguration = paymentMethodConfiguration;
            return this;
        }

        public Builder setPaymentMethodData(PaymentMethodData paymentMethodData) {
            this.paymentMethodData = paymentMethodData;
            return this;
        }

        public Builder setPaymentMethodOptions(PaymentMethodOptions paymentMethodOptions) {
            this.paymentMethodOptions = paymentMethodOptions;
            return this;
        }

        public Builder addPaymentMethodType(String element) {
            if (this.paymentMethodTypes == null) {
                this.paymentMethodTypes = new ArrayList<String>();
            }
            this.paymentMethodTypes.add(element);
            return this;
        }

        public Builder addAllPaymentMethodType(List<String> elements) {
            if (this.paymentMethodTypes == null) {
                this.paymentMethodTypes = new ArrayList<String>();
            }
            this.paymentMethodTypes.addAll(elements);
            return this;
        }

        public Builder setReceiptEmail(String receiptEmail) {
            this.receiptEmail = receiptEmail;
            return this;
        }

        public Builder setReceiptEmail(EmptyParam receiptEmail) {
            this.receiptEmail = receiptEmail;
            return this;
        }

        public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
            this.setupFutureUsage = setupFutureUsage;
            return this;
        }

        public Builder setSetupFutureUsage(EmptyParam setupFutureUsage) {
            this.setupFutureUsage = setupFutureUsage;
            return this;
        }

        public Builder setShipping(Shipping shipping) {
            this.shipping = shipping;
            return this;
        }

        public Builder setShipping(EmptyParam shipping) {
            this.shipping = shipping;
            return this;
        }

        public Builder setStatementDescriptor(String statementDescriptor) {
            this.statementDescriptor = statementDescriptor;
            return this;
        }

        public Builder setStatementDescriptor(EmptyParam statementDescriptor) {
            this.statementDescriptor = statementDescriptor;
            return this;
        }

        public Builder setStatementDescriptorSuffix(String statementDescriptorSuffix) {
            this.statementDescriptorSuffix = statementDescriptorSuffix;
            return this;
        }

        public Builder setStatementDescriptorSuffix(EmptyParam statementDescriptorSuffix) {
            this.statementDescriptorSuffix = statementDescriptorSuffix;
            return this;
        }

        public Builder setTransferData(TransferData transferData) {
            this.transferData = transferData;
            return this;
        }

        public Builder setTransferGroup(String transferGroup) {
            this.transferGroup = transferGroup;
            return this;
        }

        public Builder setTransferGroup(EmptyParam transferGroup) {
            this.transferGroup = transferGroup;
            return this;
        }
    }

    public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
    {
        OFF_SESSION("off_session"),
        ON_SESSION("on_session");

        private final String value;

        private SetupFutureUsage(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class Shipping {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="carrier")
        Object carrier;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="name")
        Object name;
        @SerializedName(value="phone")
        Object phone;
        @SerializedName(value="tracking_number")
        Object trackingNumber;

        private Shipping(Address address, Object carrier, Map<String, Object> extraParams, Object name, Object phone, Object trackingNumber) {
            this.address = address;
            this.carrier = carrier;
            this.extraParams = extraParams;
            this.name = name;
            this.phone = phone;
            this.trackingNumber = trackingNumber;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Address getAddress() {
            return this.address;
        }

        @Generated
        public Object getCarrier() {
            return this.carrier;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public Object getName() {
            return this.name;
        }

        @Generated
        public Object getPhone() {
            return this.phone;
        }

        @Generated
        public Object getTrackingNumber() {
            return this.trackingNumber;
        }

        public static class Address {
            @SerializedName(value="city")
            Object city;
            @SerializedName(value="country")
            Object country;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="line1")
            Object line1;
            @SerializedName(value="line2")
            Object line2;
            @SerializedName(value="postal_code")
            Object postalCode;
            @SerializedName(value="state")
            Object state;

            private Address(Object city, Object country, Map<String, Object> extraParams, Object line1, Object line2, Object postalCode, Object state) {
                this.city = city;
                this.country = country;
                this.extraParams = extraParams;
                this.line1 = line1;
                this.line2 = line2;
                this.postalCode = postalCode;
                this.state = state;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Object getCity() {
                return this.city;
            }

            @Generated
            public Object getCountry() {
                return this.country;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Object getLine1() {
                return this.line1;
            }

            @Generated
            public Object getLine2() {
                return this.line2;
            }

            @Generated
            public Object getPostalCode() {
                return this.postalCode;
            }

            @Generated
            public Object getState() {
                return this.state;
            }

            public static class Builder {
                private Object city;
                private Object country;
                private Map<String, Object> extraParams;
                private Object line1;
                private Object line2;
                private Object postalCode;
                private Object state;

                public Address build() {
                    return new Address(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
                }

                public Builder setCity(String city) {
                    this.city = city;
                    return this;
                }

                public Builder setCity(EmptyParam city) {
                    this.city = city;
                    return this;
                }

                public Builder setCountry(String country) {
                    this.country = country;
                    return this;
                }

                public Builder setCountry(EmptyParam country) {
                    this.country = country;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setLine1(String line1) {
                    this.line1 = line1;
                    return this;
                }

                public Builder setLine1(EmptyParam line1) {
                    this.line1 = line1;
                    return this;
                }

                public Builder setLine2(String line2) {
                    this.line2 = line2;
                    return this;
                }

                public Builder setLine2(EmptyParam line2) {
                    this.line2 = line2;
                    return this;
                }

                public Builder setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                    return this;
                }

                public Builder setPostalCode(EmptyParam postalCode) {
                    this.postalCode = postalCode;
                    return this;
                }

                public Builder setState(String state) {
                    this.state = state;
                    return this;
                }

                public Builder setState(EmptyParam state) {
                    this.state = state;
                    return this;
                }
            }
        }

        public static class Builder {
            private Address address;
            private Object carrier;
            private Map<String, Object> extraParams;
            private Object name;
            private Object phone;
            private Object trackingNumber;

            public Shipping build() {
                return new Shipping(this.address, this.carrier, this.extraParams, this.name, this.phone, this.trackingNumber);
            }

            public Builder setAddress(Address address) {
                this.address = address;
                return this;
            }

            public Builder setCarrier(String carrier) {
                this.carrier = carrier;
                return this;
            }

            public Builder setCarrier(EmptyParam carrier) {
                this.carrier = carrier;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setName(String name) {
                this.name = name;
                return this;
            }

            public Builder setName(EmptyParam name) {
                this.name = name;
                return this;
            }

            public Builder setPhone(String phone) {
                this.phone = phone;
                return this;
            }

            public Builder setPhone(EmptyParam phone) {
                this.phone = phone;
                return this;
            }

            public Builder setTrackingNumber(String trackingNumber) {
                this.trackingNumber = trackingNumber;
                return this;
            }

            public Builder setTrackingNumber(EmptyParam trackingNumber) {
                this.trackingNumber = trackingNumber;
                return this;
            }
        }
    }

    public static class PaymentDetails {
        @SerializedName(value="car_rental")
        CarRental carRental;
        @SerializedName(value="event_details")
        EventDetails eventDetails;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="flight")
        Flight flight;
        @SerializedName(value="lodging")
        Lodging lodging;
        @SerializedName(value="subscription")
        Subscription subscription;

        private PaymentDetails(CarRental carRental, EventDetails eventDetails, Map<String, Object> extraParams, Flight flight, Lodging lodging, Subscription subscription) {
            this.carRental = carRental;
            this.eventDetails = eventDetails;
            this.extraParams = extraParams;
            this.flight = flight;
            this.lodging = lodging;
            this.subscription = subscription;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public CarRental getCarRental() {
            return this.carRental;
        }

        @Generated
        public EventDetails getEventDetails() {
            return this.eventDetails;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public Flight getFlight() {
            return this.flight;
        }

        @Generated
        public Lodging getLodging() {
            return this.lodging;
        }

        @Generated
        public Subscription getSubscription() {
            return this.subscription;
        }

        public static class CarRental {
            @SerializedName(value="affiliate")
            Affiliate affiliate;
            @SerializedName(value="booking_number")
            Object bookingNumber;
            @SerializedName(value="car_class_code")
            Object carClassCode;
            @SerializedName(value="car_make")
            Object carMake;
            @SerializedName(value="car_model")
            Object carModel;
            @SerializedName(value="company")
            Object company;
            @SerializedName(value="customer_service_phone_number")
            Object customerServicePhoneNumber;
            @SerializedName(value="days_rented")
            Long daysRented;
            @SerializedName(value="delivery")
            Delivery delivery;
            @SerializedName(value="drivers")
            List<Driver> drivers;
            @SerializedName(value="extra_charges")
            List<ExtraCharge> extraCharges;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="no_show")
            Boolean noShow;
            @SerializedName(value="pickup_address")
            PickupAddress pickupAddress;
            @SerializedName(value="pickup_at")
            Long pickupAt;
            @SerializedName(value="rate_amount")
            Long rateAmount;
            @SerializedName(value="rate_interval")
            RateInterval rateInterval;
            @SerializedName(value="renter_name")
            Object renterName;
            @SerializedName(value="return_address")
            ReturnAddress returnAddress;
            @SerializedName(value="return_at")
            Long returnAt;
            @SerializedName(value="tax_exempt")
            Boolean taxExempt;

            private CarRental(Affiliate affiliate, Object bookingNumber, Object carClassCode, Object carMake, Object carModel, Object company, Object customerServicePhoneNumber, Long daysRented, Delivery delivery, List<Driver> drivers, List<ExtraCharge> extraCharges, Map<String, Object> extraParams, Boolean noShow, PickupAddress pickupAddress, Long pickupAt, Long rateAmount, RateInterval rateInterval, Object renterName, ReturnAddress returnAddress, Long returnAt, Boolean taxExempt) {
                this.affiliate = affiliate;
                this.bookingNumber = bookingNumber;
                this.carClassCode = carClassCode;
                this.carMake = carMake;
                this.carModel = carModel;
                this.company = company;
                this.customerServicePhoneNumber = customerServicePhoneNumber;
                this.daysRented = daysRented;
                this.delivery = delivery;
                this.drivers = drivers;
                this.extraCharges = extraCharges;
                this.extraParams = extraParams;
                this.noShow = noShow;
                this.pickupAddress = pickupAddress;
                this.pickupAt = pickupAt;
                this.rateAmount = rateAmount;
                this.rateInterval = rateInterval;
                this.renterName = renterName;
                this.returnAddress = returnAddress;
                this.returnAt = returnAt;
                this.taxExempt = taxExempt;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Affiliate getAffiliate() {
                return this.affiliate;
            }

            @Generated
            public Object getBookingNumber() {
                return this.bookingNumber;
            }

            @Generated
            public Object getCarClassCode() {
                return this.carClassCode;
            }

            @Generated
            public Object getCarMake() {
                return this.carMake;
            }

            @Generated
            public Object getCarModel() {
                return this.carModel;
            }

            @Generated
            public Object getCompany() {
                return this.company;
            }

            @Generated
            public Object getCustomerServicePhoneNumber() {
                return this.customerServicePhoneNumber;
            }

            @Generated
            public Long getDaysRented() {
                return this.daysRented;
            }

            @Generated
            public Delivery getDelivery() {
                return this.delivery;
            }

            @Generated
            public List<Driver> getDrivers() {
                return this.drivers;
            }

            @Generated
            public List<ExtraCharge> getExtraCharges() {
                return this.extraCharges;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Boolean getNoShow() {
                return this.noShow;
            }

            @Generated
            public PickupAddress getPickupAddress() {
                return this.pickupAddress;
            }

            @Generated
            public Long getPickupAt() {
                return this.pickupAt;
            }

            @Generated
            public Long getRateAmount() {
                return this.rateAmount;
            }

            @Generated
            public RateInterval getRateInterval() {
                return this.rateInterval;
            }

            @Generated
            public Object getRenterName() {
                return this.renterName;
            }

            @Generated
            public ReturnAddress getReturnAddress() {
                return this.returnAddress;
            }

            @Generated
            public Long getReturnAt() {
                return this.returnAt;
            }

            @Generated
            public Boolean getTaxExempt() {
                return this.taxExempt;
            }

            public static class Affiliate {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="name")
                Object name;

                private Affiliate(Map<String, Object> extraParams, Object name) {
                    this.extraParams = extraParams;
                    this.name = name;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Object getName() {
                    return this.name;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private Object name;

                    public Affiliate build() {
                        return new Affiliate(this.extraParams, this.name);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setName(String name) {
                        this.name = name;
                        return this;
                    }

                    public Builder setName(EmptyParam name) {
                        this.name = name;
                        return this;
                    }
                }
            }

            public static class Delivery {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="mode")
                Mode mode;
                @SerializedName(value="recipient")
                Recipient recipient;

                private Delivery(Map<String, Object> extraParams, Mode mode, Recipient recipient) {
                    this.extraParams = extraParams;
                    this.mode = mode;
                    this.recipient = recipient;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Mode getMode() {
                    return this.mode;
                }

                @Generated
                public Recipient getRecipient() {
                    return this.recipient;
                }

                public static enum Mode implements ApiRequestParams.EnumParam
                {
                    EMAIL("email"),
                    PHONE("phone"),
                    PICKUP("pickup"),
                    POST("post");

                    private final String value;

                    private Mode(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Recipient {
                    @SerializedName(value="email")
                    Object email;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="name")
                    Object name;
                    @SerializedName(value="phone")
                    Object phone;

                    private Recipient(Object email, Map<String, Object> extraParams, Object name, Object phone) {
                        this.email = email;
                        this.extraParams = extraParams;
                        this.name = name;
                        this.phone = phone;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Object getEmail() {
                        return this.email;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public Object getName() {
                        return this.name;
                    }

                    @Generated
                    public Object getPhone() {
                        return this.phone;
                    }

                    public static class Builder {
                        private Object email;
                        private Map<String, Object> extraParams;
                        private Object name;
                        private Object phone;

                        public Recipient build() {
                            return new Recipient(this.email, this.extraParams, this.name, this.phone);
                        }

                        public Builder setEmail(String email) {
                            this.email = email;
                            return this;
                        }

                        public Builder setEmail(EmptyParam email) {
                            this.email = email;
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setName(String name) {
                            this.name = name;
                            return this;
                        }

                        public Builder setName(EmptyParam name) {
                            this.name = name;
                            return this;
                        }

                        public Builder setPhone(String phone) {
                            this.phone = phone;
                            return this;
                        }

                        public Builder setPhone(EmptyParam phone) {
                            this.phone = phone;
                            return this;
                        }
                    }
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private Mode mode;
                    private Recipient recipient;

                    public Delivery build() {
                        return new Delivery(this.extraParams, this.mode, this.recipient);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setMode(Mode mode) {
                        this.mode = mode;
                        return this;
                    }

                    public Builder setRecipient(Recipient recipient) {
                        this.recipient = recipient;
                        return this;
                    }
                }
            }

            public static class PickupAddress {
                @SerializedName(value="city")
                Object city;
                @SerializedName(value="country")
                Object country;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="line1")
                Object line1;
                @SerializedName(value="line2")
                Object line2;
                @SerializedName(value="postal_code")
                Object postalCode;
                @SerializedName(value="state")
                Object state;

                private PickupAddress(Object city, Object country, Map<String, Object> extraParams, Object line1, Object line2, Object postalCode, Object state) {
                    this.city = city;
                    this.country = country;
                    this.extraParams = extraParams;
                    this.line1 = line1;
                    this.line2 = line2;
                    this.postalCode = postalCode;
                    this.state = state;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Object getCity() {
                    return this.city;
                }

                @Generated
                public Object getCountry() {
                    return this.country;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Object getLine1() {
                    return this.line1;
                }

                @Generated
                public Object getLine2() {
                    return this.line2;
                }

                @Generated
                public Object getPostalCode() {
                    return this.postalCode;
                }

                @Generated
                public Object getState() {
                    return this.state;
                }

                public static class Builder {
                    private Object city;
                    private Object country;
                    private Map<String, Object> extraParams;
                    private Object line1;
                    private Object line2;
                    private Object postalCode;
                    private Object state;

                    public PickupAddress build() {
                        return new PickupAddress(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
                    }

                    public Builder setCity(String city) {
                        this.city = city;
                        return this;
                    }

                    public Builder setCity(EmptyParam city) {
                        this.city = city;
                        return this;
                    }

                    public Builder setCountry(String country) {
                        this.country = country;
                        return this;
                    }

                    public Builder setCountry(EmptyParam country) {
                        this.country = country;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setLine1(String line1) {
                        this.line1 = line1;
                        return this;
                    }

                    public Builder setLine1(EmptyParam line1) {
                        this.line1 = line1;
                        return this;
                    }

                    public Builder setLine2(String line2) {
                        this.line2 = line2;
                        return this;
                    }

                    public Builder setLine2(EmptyParam line2) {
                        this.line2 = line2;
                        return this;
                    }

                    public Builder setPostalCode(String postalCode) {
                        this.postalCode = postalCode;
                        return this;
                    }

                    public Builder setPostalCode(EmptyParam postalCode) {
                        this.postalCode = postalCode;
                        return this;
                    }

                    public Builder setState(String state) {
                        this.state = state;
                        return this;
                    }

                    public Builder setState(EmptyParam state) {
                        this.state = state;
                        return this;
                    }
                }
            }

            public static enum RateInterval implements ApiRequestParams.EnumParam
            {
                DAY("day"),
                MONTH("month"),
                WEEK("week");

                private final String value;

                private RateInterval(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class ReturnAddress {
                @SerializedName(value="city")
                Object city;
                @SerializedName(value="country")
                Object country;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="line1")
                Object line1;
                @SerializedName(value="line2")
                Object line2;
                @SerializedName(value="postal_code")
                Object postalCode;
                @SerializedName(value="state")
                Object state;

                private ReturnAddress(Object city, Object country, Map<String, Object> extraParams, Object line1, Object line2, Object postalCode, Object state) {
                    this.city = city;
                    this.country = country;
                    this.extraParams = extraParams;
                    this.line1 = line1;
                    this.line2 = line2;
                    this.postalCode = postalCode;
                    this.state = state;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Object getCity() {
                    return this.city;
                }

                @Generated
                public Object getCountry() {
                    return this.country;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Object getLine1() {
                    return this.line1;
                }

                @Generated
                public Object getLine2() {
                    return this.line2;
                }

                @Generated
                public Object getPostalCode() {
                    return this.postalCode;
                }

                @Generated
                public Object getState() {
                    return this.state;
                }

                public static class Builder {
                    private Object city;
                    private Object country;
                    private Map<String, Object> extraParams;
                    private Object line1;
                    private Object line2;
                    private Object postalCode;
                    private Object state;

                    public ReturnAddress build() {
                        return new ReturnAddress(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
                    }

                    public Builder setCity(String city) {
                        this.city = city;
                        return this;
                    }

                    public Builder setCity(EmptyParam city) {
                        this.city = city;
                        return this;
                    }

                    public Builder setCountry(String country) {
                        this.country = country;
                        return this;
                    }

                    public Builder setCountry(EmptyParam country) {
                        this.country = country;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setLine1(String line1) {
                        this.line1 = line1;
                        return this;
                    }

                    public Builder setLine1(EmptyParam line1) {
                        this.line1 = line1;
                        return this;
                    }

                    public Builder setLine2(String line2) {
                        this.line2 = line2;
                        return this;
                    }

                    public Builder setLine2(EmptyParam line2) {
                        this.line2 = line2;
                        return this;
                    }

                    public Builder setPostalCode(String postalCode) {
                        this.postalCode = postalCode;
                        return this;
                    }

                    public Builder setPostalCode(EmptyParam postalCode) {
                        this.postalCode = postalCode;
                        return this;
                    }

                    public Builder setState(String state) {
                        this.state = state;
                        return this;
                    }

                    public Builder setState(EmptyParam state) {
                        this.state = state;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Affiliate affiliate;
                private Object bookingNumber;
                private Object carClassCode;
                private Object carMake;
                private Object carModel;
                private Object company;
                private Object customerServicePhoneNumber;
                private Long daysRented;
                private Delivery delivery;
                private List<Driver> drivers;
                private List<ExtraCharge> extraCharges;
                private Map<String, Object> extraParams;
                private Boolean noShow;
                private PickupAddress pickupAddress;
                private Long pickupAt;
                private Long rateAmount;
                private RateInterval rateInterval;
                private Object renterName;
                private ReturnAddress returnAddress;
                private Long returnAt;
                private Boolean taxExempt;

                public CarRental build() {
                    return new CarRental(this.affiliate, this.bookingNumber, this.carClassCode, this.carMake, this.carModel, this.company, this.customerServicePhoneNumber, this.daysRented, this.delivery, this.drivers, this.extraCharges, this.extraParams, this.noShow, this.pickupAddress, this.pickupAt, this.rateAmount, this.rateInterval, this.renterName, this.returnAddress, this.returnAt, this.taxExempt);
                }

                public Builder setAffiliate(Affiliate affiliate) {
                    this.affiliate = affiliate;
                    return this;
                }

                public Builder setBookingNumber(String bookingNumber) {
                    this.bookingNumber = bookingNumber;
                    return this;
                }

                public Builder setBookingNumber(EmptyParam bookingNumber) {
                    this.bookingNumber = bookingNumber;
                    return this;
                }

                public Builder setCarClassCode(String carClassCode) {
                    this.carClassCode = carClassCode;
                    return this;
                }

                public Builder setCarClassCode(EmptyParam carClassCode) {
                    this.carClassCode = carClassCode;
                    return this;
                }

                public Builder setCarMake(String carMake) {
                    this.carMake = carMake;
                    return this;
                }

                public Builder setCarMake(EmptyParam carMake) {
                    this.carMake = carMake;
                    return this;
                }

                public Builder setCarModel(String carModel) {
                    this.carModel = carModel;
                    return this;
                }

                public Builder setCarModel(EmptyParam carModel) {
                    this.carModel = carModel;
                    return this;
                }

                public Builder setCompany(String company) {
                    this.company = company;
                    return this;
                }

                public Builder setCompany(EmptyParam company) {
                    this.company = company;
                    return this;
                }

                public Builder setCustomerServicePhoneNumber(String customerServicePhoneNumber) {
                    this.customerServicePhoneNumber = customerServicePhoneNumber;
                    return this;
                }

                public Builder setCustomerServicePhoneNumber(EmptyParam customerServicePhoneNumber) {
                    this.customerServicePhoneNumber = customerServicePhoneNumber;
                    return this;
                }

                public Builder setDaysRented(Long daysRented) {
                    this.daysRented = daysRented;
                    return this;
                }

                public Builder setDelivery(Delivery delivery) {
                    this.delivery = delivery;
                    return this;
                }

                public Builder addDriver(Driver element) {
                    if (this.drivers == null) {
                        this.drivers = new ArrayList<Driver>();
                    }
                    this.drivers.add(element);
                    return this;
                }

                public Builder addAllDriver(List<Driver> elements) {
                    if (this.drivers == null) {
                        this.drivers = new ArrayList<Driver>();
                    }
                    this.drivers.addAll(elements);
                    return this;
                }

                public Builder addExtraCharge(ExtraCharge element) {
                    if (this.extraCharges == null) {
                        this.extraCharges = new ArrayList<ExtraCharge>();
                    }
                    this.extraCharges.add(element);
                    return this;
                }

                public Builder addAllExtraCharge(List<ExtraCharge> elements) {
                    if (this.extraCharges == null) {
                        this.extraCharges = new ArrayList<ExtraCharge>();
                    }
                    this.extraCharges.addAll(elements);
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setNoShow(Boolean noShow) {
                    this.noShow = noShow;
                    return this;
                }

                public Builder setPickupAddress(PickupAddress pickupAddress) {
                    this.pickupAddress = pickupAddress;
                    return this;
                }

                public Builder setPickupAt(Long pickupAt) {
                    this.pickupAt = pickupAt;
                    return this;
                }

                public Builder setRateAmount(Long rateAmount) {
                    this.rateAmount = rateAmount;
                    return this;
                }

                public Builder setRateInterval(RateInterval rateInterval) {
                    this.rateInterval = rateInterval;
                    return this;
                }

                public Builder setRenterName(String renterName) {
                    this.renterName = renterName;
                    return this;
                }

                public Builder setRenterName(EmptyParam renterName) {
                    this.renterName = renterName;
                    return this;
                }

                public Builder setReturnAddress(ReturnAddress returnAddress) {
                    this.returnAddress = returnAddress;
                    return this;
                }

                public Builder setReturnAt(Long returnAt) {
                    this.returnAt = returnAt;
                    return this;
                }

                public Builder setTaxExempt(Boolean taxExempt) {
                    this.taxExempt = taxExempt;
                    return this;
                }
            }

            public static enum ExtraCharge implements ApiRequestParams.EnumParam
            {
                EXTRA_MILEAGE("extra_mileage"),
                GAS("gas"),
                LATE_RETURN("late_return"),
                ONE_WAY_SERVICE("one_way_service"),
                PARKING_VIOLATION("parking_violation");

                private final String value;

                private ExtraCharge(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Driver {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="name")
                Object name;

                private Driver(Map<String, Object> extraParams, Object name) {
                    this.extraParams = extraParams;
                    this.name = name;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Object getName() {
                    return this.name;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private Object name;

                    public Driver build() {
                        return new Driver(this.extraParams, this.name);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setName(String name) {
                        this.name = name;
                        return this;
                    }

                    public Builder setName(EmptyParam name) {
                        this.name = name;
                        return this;
                    }
                }
            }
        }

        public static class EventDetails {
            @SerializedName(value="access_controlled_venue")
            Boolean accessControlledVenue;
            @SerializedName(value="address")
            Address address;
            @SerializedName(value="affiliate")
            Affiliate affiliate;
            @SerializedName(value="company")
            Object company;
            @SerializedName(value="delivery")
            Delivery delivery;
            @SerializedName(value="ends_at")
            Long endsAt;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="genre")
            Object genre;
            @SerializedName(value="name")
            Object name;
            @SerializedName(value="starts_at")
            Long startsAt;

            private EventDetails(Boolean accessControlledVenue, Address address, Affiliate affiliate, Object company, Delivery delivery, Long endsAt, Map<String, Object> extraParams, Object genre, Object name, Long startsAt) {
                this.accessControlledVenue = accessControlledVenue;
                this.address = address;
                this.affiliate = affiliate;
                this.company = company;
                this.delivery = delivery;
                this.endsAt = endsAt;
                this.extraParams = extraParams;
                this.genre = genre;
                this.name = name;
                this.startsAt = startsAt;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Boolean getAccessControlledVenue() {
                return this.accessControlledVenue;
            }

            @Generated
            public Address getAddress() {
                return this.address;
            }

            @Generated
            public Affiliate getAffiliate() {
                return this.affiliate;
            }

            @Generated
            public Object getCompany() {
                return this.company;
            }

            @Generated
            public Delivery getDelivery() {
                return this.delivery;
            }

            @Generated
            public Long getEndsAt() {
                return this.endsAt;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Object getGenre() {
                return this.genre;
            }

            @Generated
            public Object getName() {
                return this.name;
            }

            @Generated
            public Long getStartsAt() {
                return this.startsAt;
            }

            public static class Address {
                @SerializedName(value="city")
                Object city;
                @SerializedName(value="country")
                Object country;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="line1")
                Object line1;
                @SerializedName(value="line2")
                Object line2;
                @SerializedName(value="postal_code")
                Object postalCode;
                @SerializedName(value="state")
                Object state;

                private Address(Object city, Object country, Map<String, Object> extraParams, Object line1, Object line2, Object postalCode, Object state) {
                    this.city = city;
                    this.country = country;
                    this.extraParams = extraParams;
                    this.line1 = line1;
                    this.line2 = line2;
                    this.postalCode = postalCode;
                    this.state = state;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Object getCity() {
                    return this.city;
                }

                @Generated
                public Object getCountry() {
                    return this.country;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Object getLine1() {
                    return this.line1;
                }

                @Generated
                public Object getLine2() {
                    return this.line2;
                }

                @Generated
                public Object getPostalCode() {
                    return this.postalCode;
                }

                @Generated
                public Object getState() {
                    return this.state;
                }

                public static class Builder {
                    private Object city;
                    private Object country;
                    private Map<String, Object> extraParams;
                    private Object line1;
                    private Object line2;
                    private Object postalCode;
                    private Object state;

                    public Address build() {
                        return new Address(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
                    }

                    public Builder setCity(String city) {
                        this.city = city;
                        return this;
                    }

                    public Builder setCity(EmptyParam city) {
                        this.city = city;
                        return this;
                    }

                    public Builder setCountry(String country) {
                        this.country = country;
                        return this;
                    }

                    public Builder setCountry(EmptyParam country) {
                        this.country = country;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setLine1(String line1) {
                        this.line1 = line1;
                        return this;
                    }

                    public Builder setLine1(EmptyParam line1) {
                        this.line1 = line1;
                        return this;
                    }

                    public Builder setLine2(String line2) {
                        this.line2 = line2;
                        return this;
                    }

                    public Builder setLine2(EmptyParam line2) {
                        this.line2 = line2;
                        return this;
                    }

                    public Builder setPostalCode(String postalCode) {
                        this.postalCode = postalCode;
                        return this;
                    }

                    public Builder setPostalCode(EmptyParam postalCode) {
                        this.postalCode = postalCode;
                        return this;
                    }

                    public Builder setState(String state) {
                        this.state = state;
                        return this;
                    }

                    public Builder setState(EmptyParam state) {
                        this.state = state;
                        return this;
                    }
                }
            }

            public static class Affiliate {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="name")
                Object name;

                private Affiliate(Map<String, Object> extraParams, Object name) {
                    this.extraParams = extraParams;
                    this.name = name;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Object getName() {
                    return this.name;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private Object name;

                    public Affiliate build() {
                        return new Affiliate(this.extraParams, this.name);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setName(String name) {
                        this.name = name;
                        return this;
                    }

                    public Builder setName(EmptyParam name) {
                        this.name = name;
                        return this;
                    }
                }
            }

            public static class Delivery {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="mode")
                Mode mode;
                @SerializedName(value="recipient")
                Recipient recipient;

                private Delivery(Map<String, Object> extraParams, Mode mode, Recipient recipient) {
                    this.extraParams = extraParams;
                    this.mode = mode;
                    this.recipient = recipient;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Mode getMode() {
                    return this.mode;
                }

                @Generated
                public Recipient getRecipient() {
                    return this.recipient;
                }

                public static enum Mode implements ApiRequestParams.EnumParam
                {
                    EMAIL("email"),
                    PHONE("phone"),
                    PICKUP("pickup"),
                    POST("post");

                    private final String value;

                    private Mode(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Recipient {
                    @SerializedName(value="email")
                    Object email;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="name")
                    Object name;
                    @SerializedName(value="phone")
                    Object phone;

                    private Recipient(Object email, Map<String, Object> extraParams, Object name, Object phone) {
                        this.email = email;
                        this.extraParams = extraParams;
                        this.name = name;
                        this.phone = phone;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Object getEmail() {
                        return this.email;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public Object getName() {
                        return this.name;
                    }

                    @Generated
                    public Object getPhone() {
                        return this.phone;
                    }

                    public static class Builder {
                        private Object email;
                        private Map<String, Object> extraParams;
                        private Object name;
                        private Object phone;

                        public Recipient build() {
                            return new Recipient(this.email, this.extraParams, this.name, this.phone);
                        }

                        public Builder setEmail(String email) {
                            this.email = email;
                            return this;
                        }

                        public Builder setEmail(EmptyParam email) {
                            this.email = email;
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setName(String name) {
                            this.name = name;
                            return this;
                        }

                        public Builder setName(EmptyParam name) {
                            this.name = name;
                            return this;
                        }

                        public Builder setPhone(String phone) {
                            this.phone = phone;
                            return this;
                        }

                        public Builder setPhone(EmptyParam phone) {
                            this.phone = phone;
                            return this;
                        }
                    }
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private Mode mode;
                    private Recipient recipient;

                    public Delivery build() {
                        return new Delivery(this.extraParams, this.mode, this.recipient);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setMode(Mode mode) {
                        this.mode = mode;
                        return this;
                    }

                    public Builder setRecipient(Recipient recipient) {
                        this.recipient = recipient;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Boolean accessControlledVenue;
                private Address address;
                private Affiliate affiliate;
                private Object company;
                private Delivery delivery;
                private Long endsAt;
                private Map<String, Object> extraParams;
                private Object genre;
                private Object name;
                private Long startsAt;

                public EventDetails build() {
                    return new EventDetails(this.accessControlledVenue, this.address, this.affiliate, this.company, this.delivery, this.endsAt, this.extraParams, this.genre, this.name, this.startsAt);
                }

                public Builder setAccessControlledVenue(Boolean accessControlledVenue) {
                    this.accessControlledVenue = accessControlledVenue;
                    return this;
                }

                public Builder setAddress(Address address) {
                    this.address = address;
                    return this;
                }

                public Builder setAffiliate(Affiliate affiliate) {
                    this.affiliate = affiliate;
                    return this;
                }

                public Builder setCompany(String company) {
                    this.company = company;
                    return this;
                }

                public Builder setCompany(EmptyParam company) {
                    this.company = company;
                    return this;
                }

                public Builder setDelivery(Delivery delivery) {
                    this.delivery = delivery;
                    return this;
                }

                public Builder setEndsAt(Long endsAt) {
                    this.endsAt = endsAt;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setGenre(String genre) {
                    this.genre = genre;
                    return this;
                }

                public Builder setGenre(EmptyParam genre) {
                    this.genre = genre;
                    return this;
                }

                public Builder setName(String name) {
                    this.name = name;
                    return this;
                }

                public Builder setName(EmptyParam name) {
                    this.name = name;
                    return this;
                }

                public Builder setStartsAt(Long startsAt) {
                    this.startsAt = startsAt;
                    return this;
                }
            }
        }

        public static class Flight {
            @SerializedName(value="affiliate")
            Affiliate affiliate;
            @SerializedName(value="agency_number")
            Object agencyNumber;
            @SerializedName(value="carrier")
            Object carrier;
            @SerializedName(value="delivery")
            Delivery delivery;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="passenger_name")
            Object passengerName;
            @SerializedName(value="passengers")
            List<Passenger> passengers;
            @SerializedName(value="segments")
            List<Segment> segments;
            @SerializedName(value="ticket_number")
            Object ticketNumber;

            private Flight(Affiliate affiliate, Object agencyNumber, Object carrier, Delivery delivery, Map<String, Object> extraParams, Object passengerName, List<Passenger> passengers, List<Segment> segments, Object ticketNumber) {
                this.affiliate = affiliate;
                this.agencyNumber = agencyNumber;
                this.carrier = carrier;
                this.delivery = delivery;
                this.extraParams = extraParams;
                this.passengerName = passengerName;
                this.passengers = passengers;
                this.segments = segments;
                this.ticketNumber = ticketNumber;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Affiliate getAffiliate() {
                return this.affiliate;
            }

            @Generated
            public Object getAgencyNumber() {
                return this.agencyNumber;
            }

            @Generated
            public Object getCarrier() {
                return this.carrier;
            }

            @Generated
            public Delivery getDelivery() {
                return this.delivery;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Object getPassengerName() {
                return this.passengerName;
            }

            @Generated
            public List<Passenger> getPassengers() {
                return this.passengers;
            }

            @Generated
            public List<Segment> getSegments() {
                return this.segments;
            }

            @Generated
            public Object getTicketNumber() {
                return this.ticketNumber;
            }

            public static class Affiliate {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="name")
                Object name;

                private Affiliate(Map<String, Object> extraParams, Object name) {
                    this.extraParams = extraParams;
                    this.name = name;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Object getName() {
                    return this.name;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private Object name;

                    public Affiliate build() {
                        return new Affiliate(this.extraParams, this.name);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setName(String name) {
                        this.name = name;
                        return this;
                    }

                    public Builder setName(EmptyParam name) {
                        this.name = name;
                        return this;
                    }
                }
            }

            public static class Delivery {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="mode")
                Mode mode;
                @SerializedName(value="recipient")
                Recipient recipient;

                private Delivery(Map<String, Object> extraParams, Mode mode, Recipient recipient) {
                    this.extraParams = extraParams;
                    this.mode = mode;
                    this.recipient = recipient;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Mode getMode() {
                    return this.mode;
                }

                @Generated
                public Recipient getRecipient() {
                    return this.recipient;
                }

                public static enum Mode implements ApiRequestParams.EnumParam
                {
                    EMAIL("email"),
                    PHONE("phone"),
                    PICKUP("pickup"),
                    POST("post");

                    private final String value;

                    private Mode(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Recipient {
                    @SerializedName(value="email")
                    Object email;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="name")
                    Object name;
                    @SerializedName(value="phone")
                    Object phone;

                    private Recipient(Object email, Map<String, Object> extraParams, Object name, Object phone) {
                        this.email = email;
                        this.extraParams = extraParams;
                        this.name = name;
                        this.phone = phone;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Object getEmail() {
                        return this.email;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public Object getName() {
                        return this.name;
                    }

                    @Generated
                    public Object getPhone() {
                        return this.phone;
                    }

                    public static class Builder {
                        private Object email;
                        private Map<String, Object> extraParams;
                        private Object name;
                        private Object phone;

                        public Recipient build() {
                            return new Recipient(this.email, this.extraParams, this.name, this.phone);
                        }

                        public Builder setEmail(String email) {
                            this.email = email;
                            return this;
                        }

                        public Builder setEmail(EmptyParam email) {
                            this.email = email;
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setName(String name) {
                            this.name = name;
                            return this;
                        }

                        public Builder setName(EmptyParam name) {
                            this.name = name;
                            return this;
                        }

                        public Builder setPhone(String phone) {
                            this.phone = phone;
                            return this;
                        }

                        public Builder setPhone(EmptyParam phone) {
                            this.phone = phone;
                            return this;
                        }
                    }
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private Mode mode;
                    private Recipient recipient;

                    public Delivery build() {
                        return new Delivery(this.extraParams, this.mode, this.recipient);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setMode(Mode mode) {
                        this.mode = mode;
                        return this;
                    }

                    public Builder setRecipient(Recipient recipient) {
                        this.recipient = recipient;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Affiliate affiliate;
                private Object agencyNumber;
                private Object carrier;
                private Delivery delivery;
                private Map<String, Object> extraParams;
                private Object passengerName;
                private List<Passenger> passengers;
                private List<Segment> segments;
                private Object ticketNumber;

                public Flight build() {
                    return new Flight(this.affiliate, this.agencyNumber, this.carrier, this.delivery, this.extraParams, this.passengerName, this.passengers, this.segments, this.ticketNumber);
                }

                public Builder setAffiliate(Affiliate affiliate) {
                    this.affiliate = affiliate;
                    return this;
                }

                public Builder setAgencyNumber(String agencyNumber) {
                    this.agencyNumber = agencyNumber;
                    return this;
                }

                public Builder setAgencyNumber(EmptyParam agencyNumber) {
                    this.agencyNumber = agencyNumber;
                    return this;
                }

                public Builder setCarrier(String carrier) {
                    this.carrier = carrier;
                    return this;
                }

                public Builder setCarrier(EmptyParam carrier) {
                    this.carrier = carrier;
                    return this;
                }

                public Builder setDelivery(Delivery delivery) {
                    this.delivery = delivery;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setPassengerName(String passengerName) {
                    this.passengerName = passengerName;
                    return this;
                }

                public Builder setPassengerName(EmptyParam passengerName) {
                    this.passengerName = passengerName;
                    return this;
                }

                public Builder addPassenger(Passenger element) {
                    if (this.passengers == null) {
                        this.passengers = new ArrayList<Passenger>();
                    }
                    this.passengers.add(element);
                    return this;
                }

                public Builder addAllPassenger(List<Passenger> elements) {
                    if (this.passengers == null) {
                        this.passengers = new ArrayList<Passenger>();
                    }
                    this.passengers.addAll(elements);
                    return this;
                }

                public Builder addSegment(Segment element) {
                    if (this.segments == null) {
                        this.segments = new ArrayList<Segment>();
                    }
                    this.segments.add(element);
                    return this;
                }

                public Builder addAllSegment(List<Segment> elements) {
                    if (this.segments == null) {
                        this.segments = new ArrayList<Segment>();
                    }
                    this.segments.addAll(elements);
                    return this;
                }

                public Builder setTicketNumber(String ticketNumber) {
                    this.ticketNumber = ticketNumber;
                    return this;
                }

                public Builder setTicketNumber(EmptyParam ticketNumber) {
                    this.ticketNumber = ticketNumber;
                    return this;
                }
            }

            public static class Segment {
                @SerializedName(value="amount")
                Long amount;
                @SerializedName(value="arrival_airport")
                Object arrivalAirport;
                @SerializedName(value="arrives_at")
                Long arrivesAt;
                @SerializedName(value="carrier")
                Object carrier;
                @SerializedName(value="departs_at")
                Long departsAt;
                @SerializedName(value="departure_airport")
                Object departureAirport;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="flight_number")
                Object flightNumber;
                @SerializedName(value="service_class")
                ServiceClass serviceClass;

                private Segment(Long amount, Object arrivalAirport, Long arrivesAt, Object carrier, Long departsAt, Object departureAirport, Map<String, Object> extraParams, Object flightNumber, ServiceClass serviceClass) {
                    this.amount = amount;
                    this.arrivalAirport = arrivalAirport;
                    this.arrivesAt = arrivesAt;
                    this.carrier = carrier;
                    this.departsAt = departsAt;
                    this.departureAirport = departureAirport;
                    this.extraParams = extraParams;
                    this.flightNumber = flightNumber;
                    this.serviceClass = serviceClass;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Long getAmount() {
                    return this.amount;
                }

                @Generated
                public Object getArrivalAirport() {
                    return this.arrivalAirport;
                }

                @Generated
                public Long getArrivesAt() {
                    return this.arrivesAt;
                }

                @Generated
                public Object getCarrier() {
                    return this.carrier;
                }

                @Generated
                public Long getDepartsAt() {
                    return this.departsAt;
                }

                @Generated
                public Object getDepartureAirport() {
                    return this.departureAirport;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Object getFlightNumber() {
                    return this.flightNumber;
                }

                @Generated
                public ServiceClass getServiceClass() {
                    return this.serviceClass;
                }

                public static enum ServiceClass implements ApiRequestParams.EnumParam
                {
                    BUSINESS("business"),
                    ECONOMY("economy"),
                    FIRST("first"),
                    PREMIUM_ECONOMY("premium_economy");

                    private final String value;

                    private ServiceClass(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Long amount;
                    private Object arrivalAirport;
                    private Long arrivesAt;
                    private Object carrier;
                    private Long departsAt;
                    private Object departureAirport;
                    private Map<String, Object> extraParams;
                    private Object flightNumber;
                    private ServiceClass serviceClass;

                    public Segment build() {
                        return new Segment(this.amount, this.arrivalAirport, this.arrivesAt, this.carrier, this.departsAt, this.departureAirport, this.extraParams, this.flightNumber, this.serviceClass);
                    }

                    public Builder setAmount(Long amount) {
                        this.amount = amount;
                        return this;
                    }

                    public Builder setArrivalAirport(String arrivalAirport) {
                        this.arrivalAirport = arrivalAirport;
                        return this;
                    }

                    public Builder setArrivalAirport(EmptyParam arrivalAirport) {
                        this.arrivalAirport = arrivalAirport;
                        return this;
                    }

                    public Builder setArrivesAt(Long arrivesAt) {
                        this.arrivesAt = arrivesAt;
                        return this;
                    }

                    public Builder setCarrier(String carrier) {
                        this.carrier = carrier;
                        return this;
                    }

                    public Builder setCarrier(EmptyParam carrier) {
                        this.carrier = carrier;
                        return this;
                    }

                    public Builder setDepartsAt(Long departsAt) {
                        this.departsAt = departsAt;
                        return this;
                    }

                    public Builder setDepartureAirport(String departureAirport) {
                        this.departureAirport = departureAirport;
                        return this;
                    }

                    public Builder setDepartureAirport(EmptyParam departureAirport) {
                        this.departureAirport = departureAirport;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setFlightNumber(String flightNumber) {
                        this.flightNumber = flightNumber;
                        return this;
                    }

                    public Builder setFlightNumber(EmptyParam flightNumber) {
                        this.flightNumber = flightNumber;
                        return this;
                    }

                    public Builder setServiceClass(ServiceClass serviceClass) {
                        this.serviceClass = serviceClass;
                        return this;
                    }
                }
            }

            public static class Passenger {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="name")
                Object name;

                private Passenger(Map<String, Object> extraParams, Object name) {
                    this.extraParams = extraParams;
                    this.name = name;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Object getName() {
                    return this.name;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private Object name;

                    public Passenger build() {
                        return new Passenger(this.extraParams, this.name);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setName(String name) {
                        this.name = name;
                        return this;
                    }

                    public Builder setName(EmptyParam name) {
                        this.name = name;
                        return this;
                    }
                }
            }
        }

        public static class Lodging {
            @SerializedName(value="address")
            Address address;
            @SerializedName(value="adults")
            Long adults;
            @SerializedName(value="affiliate")
            Affiliate affiliate;
            @SerializedName(value="booking_number")
            Object bookingNumber;
            @SerializedName(value="category")
            Category category;
            @SerializedName(value="checkin_at")
            Long checkinAt;
            @SerializedName(value="checkout_at")
            Long checkoutAt;
            @SerializedName(value="customer_service_phone_number")
            Object customerServicePhoneNumber;
            @SerializedName(value="daily_room_rate_amount")
            Long dailyRoomRateAmount;
            @SerializedName(value="delivery")
            Delivery delivery;
            @SerializedName(value="extra_charges")
            List<ExtraCharge> extraCharges;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="fire_safety_act_compliance")
            Boolean fireSafetyActCompliance;
            @SerializedName(value="name")
            Object name;
            @SerializedName(value="no_show")
            Boolean noShow;
            @SerializedName(value="number_of_rooms")
            Long numberOfRooms;
            @SerializedName(value="passengers")
            List<Passenger> passengers;
            @SerializedName(value="property_phone_number")
            Object propertyPhoneNumber;
            @SerializedName(value="room_class")
            Object roomClass;
            @SerializedName(value="room_nights")
            Long roomNights;
            @SerializedName(value="total_room_tax_amount")
            Long totalRoomTaxAmount;
            @SerializedName(value="total_tax_amount")
            Long totalTaxAmount;

            private Lodging(Address address, Long adults, Affiliate affiliate, Object bookingNumber, Category category, Long checkinAt, Long checkoutAt, Object customerServicePhoneNumber, Long dailyRoomRateAmount, Delivery delivery, List<ExtraCharge> extraCharges, Map<String, Object> extraParams, Boolean fireSafetyActCompliance, Object name, Boolean noShow, Long numberOfRooms, List<Passenger> passengers, Object propertyPhoneNumber, Object roomClass, Long roomNights, Long totalRoomTaxAmount, Long totalTaxAmount) {
                this.address = address;
                this.adults = adults;
                this.affiliate = affiliate;
                this.bookingNumber = bookingNumber;
                this.category = category;
                this.checkinAt = checkinAt;
                this.checkoutAt = checkoutAt;
                this.customerServicePhoneNumber = customerServicePhoneNumber;
                this.dailyRoomRateAmount = dailyRoomRateAmount;
                this.delivery = delivery;
                this.extraCharges = extraCharges;
                this.extraParams = extraParams;
                this.fireSafetyActCompliance = fireSafetyActCompliance;
                this.name = name;
                this.noShow = noShow;
                this.numberOfRooms = numberOfRooms;
                this.passengers = passengers;
                this.propertyPhoneNumber = propertyPhoneNumber;
                this.roomClass = roomClass;
                this.roomNights = roomNights;
                this.totalRoomTaxAmount = totalRoomTaxAmount;
                this.totalTaxAmount = totalTaxAmount;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Address getAddress() {
                return this.address;
            }

            @Generated
            public Long getAdults() {
                return this.adults;
            }

            @Generated
            public Affiliate getAffiliate() {
                return this.affiliate;
            }

            @Generated
            public Object getBookingNumber() {
                return this.bookingNumber;
            }

            @Generated
            public Category getCategory() {
                return this.category;
            }

            @Generated
            public Long getCheckinAt() {
                return this.checkinAt;
            }

            @Generated
            public Long getCheckoutAt() {
                return this.checkoutAt;
            }

            @Generated
            public Object getCustomerServicePhoneNumber() {
                return this.customerServicePhoneNumber;
            }

            @Generated
            public Long getDailyRoomRateAmount() {
                return this.dailyRoomRateAmount;
            }

            @Generated
            public Delivery getDelivery() {
                return this.delivery;
            }

            @Generated
            public List<ExtraCharge> getExtraCharges() {
                return this.extraCharges;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Boolean getFireSafetyActCompliance() {
                return this.fireSafetyActCompliance;
            }

            @Generated
            public Object getName() {
                return this.name;
            }

            @Generated
            public Boolean getNoShow() {
                return this.noShow;
            }

            @Generated
            public Long getNumberOfRooms() {
                return this.numberOfRooms;
            }

            @Generated
            public List<Passenger> getPassengers() {
                return this.passengers;
            }

            @Generated
            public Object getPropertyPhoneNumber() {
                return this.propertyPhoneNumber;
            }

            @Generated
            public Object getRoomClass() {
                return this.roomClass;
            }

            @Generated
            public Long getRoomNights() {
                return this.roomNights;
            }

            @Generated
            public Long getTotalRoomTaxAmount() {
                return this.totalRoomTaxAmount;
            }

            @Generated
            public Long getTotalTaxAmount() {
                return this.totalTaxAmount;
            }

            public static class Address {
                @SerializedName(value="city")
                Object city;
                @SerializedName(value="country")
                Object country;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="line1")
                Object line1;
                @SerializedName(value="line2")
                Object line2;
                @SerializedName(value="postal_code")
                Object postalCode;
                @SerializedName(value="state")
                Object state;

                private Address(Object city, Object country, Map<String, Object> extraParams, Object line1, Object line2, Object postalCode, Object state) {
                    this.city = city;
                    this.country = country;
                    this.extraParams = extraParams;
                    this.line1 = line1;
                    this.line2 = line2;
                    this.postalCode = postalCode;
                    this.state = state;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Object getCity() {
                    return this.city;
                }

                @Generated
                public Object getCountry() {
                    return this.country;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Object getLine1() {
                    return this.line1;
                }

                @Generated
                public Object getLine2() {
                    return this.line2;
                }

                @Generated
                public Object getPostalCode() {
                    return this.postalCode;
                }

                @Generated
                public Object getState() {
                    return this.state;
                }

                public static class Builder {
                    private Object city;
                    private Object country;
                    private Map<String, Object> extraParams;
                    private Object line1;
                    private Object line2;
                    private Object postalCode;
                    private Object state;

                    public Address build() {
                        return new Address(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
                    }

                    public Builder setCity(String city) {
                        this.city = city;
                        return this;
                    }

                    public Builder setCity(EmptyParam city) {
                        this.city = city;
                        return this;
                    }

                    public Builder setCountry(String country) {
                        this.country = country;
                        return this;
                    }

                    public Builder setCountry(EmptyParam country) {
                        this.country = country;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setLine1(String line1) {
                        this.line1 = line1;
                        return this;
                    }

                    public Builder setLine1(EmptyParam line1) {
                        this.line1 = line1;
                        return this;
                    }

                    public Builder setLine2(String line2) {
                        this.line2 = line2;
                        return this;
                    }

                    public Builder setLine2(EmptyParam line2) {
                        this.line2 = line2;
                        return this;
                    }

                    public Builder setPostalCode(String postalCode) {
                        this.postalCode = postalCode;
                        return this;
                    }

                    public Builder setPostalCode(EmptyParam postalCode) {
                        this.postalCode = postalCode;
                        return this;
                    }

                    public Builder setState(String state) {
                        this.state = state;
                        return this;
                    }

                    public Builder setState(EmptyParam state) {
                        this.state = state;
                        return this;
                    }
                }
            }

            public static class Affiliate {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="name")
                Object name;

                private Affiliate(Map<String, Object> extraParams, Object name) {
                    this.extraParams = extraParams;
                    this.name = name;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Object getName() {
                    return this.name;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private Object name;

                    public Affiliate build() {
                        return new Affiliate(this.extraParams, this.name);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setName(String name) {
                        this.name = name;
                        return this;
                    }

                    public Builder setName(EmptyParam name) {
                        this.name = name;
                        return this;
                    }
                }
            }

            public static enum Category implements ApiRequestParams.EnumParam
            {
                HOTEL("hotel"),
                VACATION_RENTAL("vacation_rental");

                private final String value;

                private Category(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Delivery {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="mode")
                Mode mode;
                @SerializedName(value="recipient")
                Recipient recipient;

                private Delivery(Map<String, Object> extraParams, Mode mode, Recipient recipient) {
                    this.extraParams = extraParams;
                    this.mode = mode;
                    this.recipient = recipient;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Mode getMode() {
                    return this.mode;
                }

                @Generated
                public Recipient getRecipient() {
                    return this.recipient;
                }

                public static enum Mode implements ApiRequestParams.EnumParam
                {
                    EMAIL("email"),
                    PHONE("phone"),
                    PICKUP("pickup"),
                    POST("post");

                    private final String value;

                    private Mode(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Recipient {
                    @SerializedName(value="email")
                    Object email;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="name")
                    Object name;
                    @SerializedName(value="phone")
                    Object phone;

                    private Recipient(Object email, Map<String, Object> extraParams, Object name, Object phone) {
                        this.email = email;
                        this.extraParams = extraParams;
                        this.name = name;
                        this.phone = phone;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Object getEmail() {
                        return this.email;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public Object getName() {
                        return this.name;
                    }

                    @Generated
                    public Object getPhone() {
                        return this.phone;
                    }

                    public static class Builder {
                        private Object email;
                        private Map<String, Object> extraParams;
                        private Object name;
                        private Object phone;

                        public Recipient build() {
                            return new Recipient(this.email, this.extraParams, this.name, this.phone);
                        }

                        public Builder setEmail(String email) {
                            this.email = email;
                            return this;
                        }

                        public Builder setEmail(EmptyParam email) {
                            this.email = email;
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setName(String name) {
                            this.name = name;
                            return this;
                        }

                        public Builder setName(EmptyParam name) {
                            this.name = name;
                            return this;
                        }

                        public Builder setPhone(String phone) {
                            this.phone = phone;
                            return this;
                        }

                        public Builder setPhone(EmptyParam phone) {
                            this.phone = phone;
                            return this;
                        }
                    }
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private Mode mode;
                    private Recipient recipient;

                    public Delivery build() {
                        return new Delivery(this.extraParams, this.mode, this.recipient);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setMode(Mode mode) {
                        this.mode = mode;
                        return this;
                    }

                    public Builder setRecipient(Recipient recipient) {
                        this.recipient = recipient;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Address address;
                private Long adults;
                private Affiliate affiliate;
                private Object bookingNumber;
                private Category category;
                private Long checkinAt;
                private Long checkoutAt;
                private Object customerServicePhoneNumber;
                private Long dailyRoomRateAmount;
                private Delivery delivery;
                private List<ExtraCharge> extraCharges;
                private Map<String, Object> extraParams;
                private Boolean fireSafetyActCompliance;
                private Object name;
                private Boolean noShow;
                private Long numberOfRooms;
                private List<Passenger> passengers;
                private Object propertyPhoneNumber;
                private Object roomClass;
                private Long roomNights;
                private Long totalRoomTaxAmount;
                private Long totalTaxAmount;

                public Lodging build() {
                    return new Lodging(this.address, this.adults, this.affiliate, this.bookingNumber, this.category, this.checkinAt, this.checkoutAt, this.customerServicePhoneNumber, this.dailyRoomRateAmount, this.delivery, this.extraCharges, this.extraParams, this.fireSafetyActCompliance, this.name, this.noShow, this.numberOfRooms, this.passengers, this.propertyPhoneNumber, this.roomClass, this.roomNights, this.totalRoomTaxAmount, this.totalTaxAmount);
                }

                public Builder setAddress(Address address) {
                    this.address = address;
                    return this;
                }

                public Builder setAdults(Long adults) {
                    this.adults = adults;
                    return this;
                }

                public Builder setAffiliate(Affiliate affiliate) {
                    this.affiliate = affiliate;
                    return this;
                }

                public Builder setBookingNumber(String bookingNumber) {
                    this.bookingNumber = bookingNumber;
                    return this;
                }

                public Builder setBookingNumber(EmptyParam bookingNumber) {
                    this.bookingNumber = bookingNumber;
                    return this;
                }

                public Builder setCategory(Category category) {
                    this.category = category;
                    return this;
                }

                public Builder setCheckinAt(Long checkinAt) {
                    this.checkinAt = checkinAt;
                    return this;
                }

                public Builder setCheckoutAt(Long checkoutAt) {
                    this.checkoutAt = checkoutAt;
                    return this;
                }

                public Builder setCustomerServicePhoneNumber(String customerServicePhoneNumber) {
                    this.customerServicePhoneNumber = customerServicePhoneNumber;
                    return this;
                }

                public Builder setCustomerServicePhoneNumber(EmptyParam customerServicePhoneNumber) {
                    this.customerServicePhoneNumber = customerServicePhoneNumber;
                    return this;
                }

                public Builder setDailyRoomRateAmount(Long dailyRoomRateAmount) {
                    this.dailyRoomRateAmount = dailyRoomRateAmount;
                    return this;
                }

                public Builder setDelivery(Delivery delivery) {
                    this.delivery = delivery;
                    return this;
                }

                public Builder addExtraCharge(ExtraCharge element) {
                    if (this.extraCharges == null) {
                        this.extraCharges = new ArrayList<ExtraCharge>();
                    }
                    this.extraCharges.add(element);
                    return this;
                }

                public Builder addAllExtraCharge(List<ExtraCharge> elements) {
                    if (this.extraCharges == null) {
                        this.extraCharges = new ArrayList<ExtraCharge>();
                    }
                    this.extraCharges.addAll(elements);
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setFireSafetyActCompliance(Boolean fireSafetyActCompliance) {
                    this.fireSafetyActCompliance = fireSafetyActCompliance;
                    return this;
                }

                public Builder setName(String name) {
                    this.name = name;
                    return this;
                }

                public Builder setName(EmptyParam name) {
                    this.name = name;
                    return this;
                }

                public Builder setNoShow(Boolean noShow) {
                    this.noShow = noShow;
                    return this;
                }

                public Builder setNumberOfRooms(Long numberOfRooms) {
                    this.numberOfRooms = numberOfRooms;
                    return this;
                }

                public Builder addPassenger(Passenger element) {
                    if (this.passengers == null) {
                        this.passengers = new ArrayList<Passenger>();
                    }
                    this.passengers.add(element);
                    return this;
                }

                public Builder addAllPassenger(List<Passenger> elements) {
                    if (this.passengers == null) {
                        this.passengers = new ArrayList<Passenger>();
                    }
                    this.passengers.addAll(elements);
                    return this;
                }

                public Builder setPropertyPhoneNumber(String propertyPhoneNumber) {
                    this.propertyPhoneNumber = propertyPhoneNumber;
                    return this;
                }

                public Builder setPropertyPhoneNumber(EmptyParam propertyPhoneNumber) {
                    this.propertyPhoneNumber = propertyPhoneNumber;
                    return this;
                }

                public Builder setRoomClass(String roomClass) {
                    this.roomClass = roomClass;
                    return this;
                }

                public Builder setRoomClass(EmptyParam roomClass) {
                    this.roomClass = roomClass;
                    return this;
                }

                public Builder setRoomNights(Long roomNights) {
                    this.roomNights = roomNights;
                    return this;
                }

                public Builder setTotalRoomTaxAmount(Long totalRoomTaxAmount) {
                    this.totalRoomTaxAmount = totalRoomTaxAmount;
                    return this;
                }

                public Builder setTotalTaxAmount(Long totalTaxAmount) {
                    this.totalTaxAmount = totalTaxAmount;
                    return this;
                }
            }

            public static enum ExtraCharge implements ApiRequestParams.EnumParam
            {
                GIFT_SHOP("gift_shop"),
                LAUNDRY("laundry"),
                MINI_BAR("mini_bar"),
                OTHER("other"),
                RESTAURANT("restaurant"),
                TELEPHONE("telephone");

                private final String value;

                private ExtraCharge(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Passenger {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="name")
                Object name;

                private Passenger(Map<String, Object> extraParams, Object name) {
                    this.extraParams = extraParams;
                    this.name = name;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Object getName() {
                    return this.name;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private Object name;

                    public Passenger build() {
                        return new Passenger(this.extraParams, this.name);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setName(String name) {
                        this.name = name;
                        return this;
                    }

                    public Builder setName(EmptyParam name) {
                        this.name = name;
                        return this;
                    }
                }
            }
        }

        public static class Subscription {
            @SerializedName(value="affiliate")
            Affiliate affiliate;
            @SerializedName(value="auto_renewal")
            Boolean autoRenewal;
            @SerializedName(value="billing_interval")
            BillingInterval billingInterval;
            @SerializedName(value="ends_at")
            Long endsAt;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="name")
            Object name;
            @SerializedName(value="starts_at")
            Long startsAt;

            private Subscription(Affiliate affiliate, Boolean autoRenewal, BillingInterval billingInterval, Long endsAt, Map<String, Object> extraParams, Object name, Long startsAt) {
                this.affiliate = affiliate;
                this.autoRenewal = autoRenewal;
                this.billingInterval = billingInterval;
                this.endsAt = endsAt;
                this.extraParams = extraParams;
                this.name = name;
                this.startsAt = startsAt;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Affiliate getAffiliate() {
                return this.affiliate;
            }

            @Generated
            public Boolean getAutoRenewal() {
                return this.autoRenewal;
            }

            @Generated
            public BillingInterval getBillingInterval() {
                return this.billingInterval;
            }

            @Generated
            public Long getEndsAt() {
                return this.endsAt;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Object getName() {
                return this.name;
            }

            @Generated
            public Long getStartsAt() {
                return this.startsAt;
            }

            public static class Affiliate {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="name")
                Object name;

                private Affiliate(Map<String, Object> extraParams, Object name) {
                    this.extraParams = extraParams;
                    this.name = name;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Object getName() {
                    return this.name;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private Object name;

                    public Affiliate build() {
                        return new Affiliate(this.extraParams, this.name);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setName(String name) {
                        this.name = name;
                        return this;
                    }

                    public Builder setName(EmptyParam name) {
                        this.name = name;
                        return this;
                    }
                }
            }

            public static class BillingInterval {
                @SerializedName(value="count")
                Long count;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="interval")
                Interval interval;

                private BillingInterval(Long count, Map<String, Object> extraParams, Interval interval) {
                    this.count = count;
                    this.extraParams = extraParams;
                    this.interval = interval;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Long getCount() {
                    return this.count;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Interval getInterval() {
                    return this.interval;
                }

                public static enum Interval implements ApiRequestParams.EnumParam
                {
                    DAY("day"),
                    MONTH("month"),
                    WEEK("week"),
                    YEAR("year");

                    private final String value;

                    private Interval(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Long count;
                    private Map<String, Object> extraParams;
                    private Interval interval;

                    public BillingInterval build() {
                        return new BillingInterval(this.count, this.extraParams, this.interval);
                    }

                    public Builder setCount(Long count) {
                        this.count = count;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setInterval(Interval interval) {
                        this.interval = interval;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Affiliate affiliate;
                private Boolean autoRenewal;
                private BillingInterval billingInterval;
                private Long endsAt;
                private Map<String, Object> extraParams;
                private Object name;
                private Long startsAt;

                public Subscription build() {
                    return new Subscription(this.affiliate, this.autoRenewal, this.billingInterval, this.endsAt, this.extraParams, this.name, this.startsAt);
                }

                public Builder setAffiliate(Affiliate affiliate) {
                    this.affiliate = affiliate;
                    return this;
                }

                public Builder setAutoRenewal(Boolean autoRenewal) {
                    this.autoRenewal = autoRenewal;
                    return this;
                }

                public Builder setBillingInterval(BillingInterval billingInterval) {
                    this.billingInterval = billingInterval;
                    return this;
                }

                public Builder setEndsAt(Long endsAt) {
                    this.endsAt = endsAt;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setName(String name) {
                    this.name = name;
                    return this;
                }

                public Builder setName(EmptyParam name) {
                    this.name = name;
                    return this;
                }

                public Builder setStartsAt(Long startsAt) {
                    this.startsAt = startsAt;
                    return this;
                }
            }
        }

        public static class Builder {
            private CarRental carRental;
            private EventDetails eventDetails;
            private Map<String, Object> extraParams;
            private Flight flight;
            private Lodging lodging;
            private Subscription subscription;

            public PaymentDetails build() {
                return new PaymentDetails(this.carRental, this.eventDetails, this.extraParams, this.flight, this.lodging, this.subscription);
            }

            public Builder setCarRental(CarRental carRental) {
                this.carRental = carRental;
                return this;
            }

            public Builder setEventDetails(EventDetails eventDetails) {
                this.eventDetails = eventDetails;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setFlight(Flight flight) {
                this.flight = flight;
                return this;
            }

            public Builder setLodging(Lodging lodging) {
                this.lodging = lodging;
                return this;
            }

            public Builder setSubscription(Subscription subscription) {
                this.subscription = subscription;
                return this;
            }
        }
    }
}

