/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.CustomerCashBalanceTransaction;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.CustomerCashBalanceTransactionListParams;
import com.stripe.param.CustomerCashBalanceTransactionRetrieveParams;
import java.lang.reflect.Type;

public final class CustomerCashBalanceTransactionService
extends ApiService {
    public CustomerCashBalanceTransactionService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<CustomerCashBalanceTransaction> list(String customer, CustomerCashBalanceTransactionListParams params) throws StripeException {
        return this.list(customer, params, null);
    }

    public StripeCollection<CustomerCashBalanceTransaction> list(String customer, RequestOptions options) throws StripeException {
        return this.list(customer, null, options);
    }

    public StripeCollection<CustomerCashBalanceTransaction> list(String customer) throws StripeException {
        return this.list(customer, null, null);
    }

    public StripeCollection<CustomerCashBalanceTransaction> list(String customer, CustomerCashBalanceTransactionListParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/customers/%s/cash_balance_transactions", ApiResource.urlEncodeId(customer));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<CustomerCashBalanceTransaction>>(){}.getType());
    }

    public CustomerCashBalanceTransaction retrieve(String customer, String transaction, CustomerCashBalanceTransactionRetrieveParams params) throws StripeException {
        return this.retrieve(customer, transaction, params, null);
    }

    public CustomerCashBalanceTransaction retrieve(String customer, String transaction, RequestOptions options) throws StripeException {
        return this.retrieve(customer, transaction, null, options);
    }

    public CustomerCashBalanceTransaction retrieve(String customer, String transaction) throws StripeException {
        return this.retrieve(customer, transaction, null, null);
    }

    public CustomerCashBalanceTransaction retrieve(String customer, String transaction, CustomerCashBalanceTransactionRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/customers/%s/cash_balance_transactions/%s", ApiResource.urlEncodeId(customer), ApiResource.urlEncodeId(transaction));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (CustomerCashBalanceTransaction)this.getResponseGetter().request(request, (Type)((Object)CustomerCashBalanceTransaction.class));
    }
}

