/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.InvoicePayment;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.InvoicePaymentListParams;
import com.stripe.param.InvoicePaymentRetrieveParams;
import java.lang.reflect.Type;

public final class InvoicePaymentService
extends ApiService {
    public InvoicePaymentService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<InvoicePayment> list(String invoice, InvoicePaymentListParams params) throws StripeException {
        return this.list(invoice, params, null);
    }

    public StripeCollection<InvoicePayment> list(String invoice, RequestOptions options) throws StripeException {
        return this.list(invoice, null, options);
    }

    public StripeCollection<InvoicePayment> list(String invoice) throws StripeException {
        return this.list(invoice, null, null);
    }

    public StripeCollection<InvoicePayment> list(String invoice, InvoicePaymentListParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/invoices/%s/payments", ApiResource.urlEncodeId(invoice));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<InvoicePayment>>(){}.getType());
    }

    public InvoicePayment retrieve(String invoice, String invoicePayment, InvoicePaymentRetrieveParams params) throws StripeException {
        return this.retrieve(invoice, invoicePayment, params, null);
    }

    public InvoicePayment retrieve(String invoice, String invoicePayment, RequestOptions options) throws StripeException {
        return this.retrieve(invoice, invoicePayment, null, options);
    }

    public InvoicePayment retrieve(String invoice, String invoicePayment) throws StripeException {
        return this.retrieve(invoice, invoicePayment, null, null);
    }

    public InvoicePayment retrieve(String invoice, String invoicePayment, InvoicePaymentRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/invoices/%s/payments/%s", ApiResource.urlEncodeId(invoice), ApiResource.urlEncodeId(invoicePayment));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (InvoicePayment)this.getResponseGetter().request(request, (Type)((Object)InvoicePayment.class));
    }
}

