/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.giftcards;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.giftcards.Transaction;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.giftcards.TransactionCancelParams;
import com.stripe.param.giftcards.TransactionConfirmParams;
import com.stripe.param.giftcards.TransactionCreateParams;
import com.stripe.param.giftcards.TransactionListParams;
import com.stripe.param.giftcards.TransactionRetrieveParams;
import com.stripe.param.giftcards.TransactionUpdateParams;
import java.lang.reflect.Type;

public final class TransactionService
extends ApiService {
    public TransactionService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<Transaction> list(TransactionListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Transaction> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Transaction> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Transaction> list(TransactionListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/gift_cards/transactions";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<Transaction>>(){}.getType());
    }

    public Transaction create(TransactionCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Transaction create(TransactionCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/gift_cards/transactions";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Transaction)this.getResponseGetter().request(request, (Type)((Object)Transaction.class));
    }

    public Transaction retrieve(String id, TransactionRetrieveParams params) throws StripeException {
        return this.retrieve(id, params, null);
    }

    public Transaction retrieve(String id, RequestOptions options) throws StripeException {
        return this.retrieve(id, null, options);
    }

    public Transaction retrieve(String id) throws StripeException {
        return this.retrieve(id, null, null);
    }

    public Transaction retrieve(String id, TransactionRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/gift_cards/transactions/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Transaction)this.getResponseGetter().request(request, (Type)((Object)Transaction.class));
    }

    public Transaction update(String id, TransactionUpdateParams params) throws StripeException {
        return this.update(id, params, null);
    }

    public Transaction update(String id, RequestOptions options) throws StripeException {
        return this.update(id, null, options);
    }

    public Transaction update(String id) throws StripeException {
        return this.update(id, null, null);
    }

    public Transaction update(String id, TransactionUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/gift_cards/transactions/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Transaction)this.getResponseGetter().request(request, (Type)((Object)Transaction.class));
    }

    public Transaction cancel(String id, TransactionCancelParams params) throws StripeException {
        return this.cancel(id, params, null);
    }

    public Transaction cancel(String id, RequestOptions options) throws StripeException {
        return this.cancel(id, null, options);
    }

    public Transaction cancel(String id) throws StripeException {
        return this.cancel(id, null, null);
    }

    public Transaction cancel(String id, TransactionCancelParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/gift_cards/transactions/%s/cancel", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Transaction)this.getResponseGetter().request(request, (Type)((Object)Transaction.class));
    }

    public Transaction confirm(String id, TransactionConfirmParams params) throws StripeException {
        return this.confirm(id, params, null);
    }

    public Transaction confirm(String id, RequestOptions options) throws StripeException {
        return this.confirm(id, null, options);
    }

    public Transaction confirm(String id) throws StripeException {
        return this.confirm(id, null, null);
    }

    public Transaction confirm(String id, TransactionConfirmParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/gift_cards/transactions/%s/confirm", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (Transaction)this.getResponseGetter().request(request, (Type)((Object)Transaction.class));
    }
}

