/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.identity;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.identity.VerificationReport;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.identity.VerificationReportListParams;
import com.stripe.param.identity.VerificationReportRetrieveParams;
import java.lang.reflect.Type;

public final class VerificationReportService
extends ApiService {
    public VerificationReportService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<VerificationReport> list(VerificationReportListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<VerificationReport> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<VerificationReport> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<VerificationReport> list(VerificationReportListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/identity/verification_reports";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (StripeCollection)this.getResponseGetter().request(request, new TypeToken<StripeCollection<VerificationReport>>(){}.getType());
    }

    public VerificationReport retrieve(String report, VerificationReportRetrieveParams params) throws StripeException {
        return this.retrieve(report, params, null);
    }

    public VerificationReport retrieve(String report, RequestOptions options) throws StripeException {
        return this.retrieve(report, null, options);
    }

    public VerificationReport retrieve(String report) throws StripeException {
        return this.retrieve(report, null, null);
    }

    public VerificationReport retrieve(String report, VerificationReportRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/identity/verification_reports/%s", ApiResource.urlEncodeId(report));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        request = request.addUsage("stripe_client");
        return (VerificationReport)this.getResponseGetter().request(request, (Type)((Object)VerificationReport.class));
    }
}

