/*
 * Decompiled with CFR 0.152.
 */
package com.stripe;

import com.google.gson.JsonObject;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RawRequestOptions;
import com.stripe.net.StripeResponse;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.HashMap;
import java.util.Map;

public abstract class Stripe {
    public static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    public static final int DEFAULT_READ_TIMEOUT = 80000;
    public static final String API_VERSION = "2023-10-16";
    public static final String PREVIEW_API_VERSION = "2023-12-11.preview-v2";
    public static final String CONNECT_API_BASE = "https://connect.stripe.com";
    public static final String LIVE_API_BASE = "https://api.stripe.com";
    public static final String UPLOAD_API_BASE = "https://files.stripe.com";
    public static final String VERSION = "24.16.0-beta.1";
    public static volatile String apiKey;
    public static volatile String clientId;
    public static volatile boolean enableTelemetry;
    public static volatile String partnerId;
    public static volatile String stripeVersion;
    private static volatile int connectTimeout;
    private static volatile int readTimeout;
    private static volatile int maxNetworkRetries;
    private static volatile String apiBase;
    private static volatile String connectBase;
    private static volatile String uploadBase;
    private static volatile Proxy connectionProxy;
    private static volatile PasswordAuthentication proxyCredential;
    private static volatile Map<String, String> appInfo;

    public static void overrideApiBase(String overriddenApiBase) {
        apiBase = overriddenApiBase;
    }

    public static String getApiBase() {
        return apiBase;
    }

    public static void overrideConnectBase(String overriddenConnectBase) {
        connectBase = overriddenConnectBase;
    }

    public static String getConnectBase() {
        return connectBase;
    }

    public static void overrideUploadBase(String overriddenUploadBase) {
        uploadBase = overriddenUploadBase;
    }

    public static String getUploadBase() {
        return uploadBase;
    }

    public static void setConnectionProxy(Proxy proxy) {
        connectionProxy = proxy;
    }

    public static Proxy getConnectionProxy() {
        return connectionProxy;
    }

    public static int getConnectTimeout() {
        if (connectTimeout == -1) {
            return 30000;
        }
        return connectTimeout;
    }

    public static void setConnectTimeout(int timeout) {
        connectTimeout = timeout;
    }

    public static int getReadTimeout() {
        if (readTimeout == -1) {
            return 80000;
        }
        return readTimeout;
    }

    public static void setReadTimeout(int timeout) {
        readTimeout = timeout;
    }

    public static int getMaxNetworkRetries() {
        return maxNetworkRetries;
    }

    public static void setMaxNetworkRetries(int numRetries) {
        maxNetworkRetries = numRetries;
    }

    public static void setProxyCredential(PasswordAuthentication auth) {
        proxyCredential = auth;
    }

    public static PasswordAuthentication getProxyCredential() {
        return proxyCredential;
    }

    public static void setAppInfo(String name) {
        Stripe.setAppInfo(name, null, null, null);
    }

    public static void setAppInfo(String name, String version) {
        Stripe.setAppInfo(name, version, null, null);
    }

    public static void setAppInfo(String name, String version, String url) {
        Stripe.setAppInfo(name, version, url, null);
    }

    public static void setAppInfo(String name, String version, String url, String partnerId) {
        if (appInfo == null) {
            appInfo = new HashMap<String, String>();
        }
        appInfo.put("name", name);
        appInfo.put("version", version);
        appInfo.put("url", url);
        appInfo.put("partner_id", partnerId);
    }

    public static Map<String, String> getAppInfo() {
        return appInfo;
    }

    @Deprecated
    public static StripeResponse rawRequest(ApiResource.RequestMethod method, String relativeUrl, String content) throws StripeException {
        return Stripe.rawRequest(method, relativeUrl, content, null);
    }

    @Deprecated
    public static StripeResponse rawRequest(ApiResource.RequestMethod method, String relativeUrl, String content, RawRequestOptions options) throws StripeException {
        if (options == null) {
            options = RawRequestOptions.builder().build();
        }
        if (method != ApiResource.RequestMethod.POST && content != null && !content.equals("")) {
            throw new IllegalArgumentException("content is not allowed for non-POST requests. Please pass null and add request parameters to the query string of the URL.");
        }
        return ApiResource.rawRequest(method, relativeUrl, content, options);
    }

    @Deprecated
    public static StripeObject deserialize(String rawJson) throws StripeException {
        if (rawJson == null) {
            throw new IllegalArgumentException("rawJson cannot be null");
        }
        return StripeObject.deserializeStripeObject((JsonObject)ApiResource.GSON.fromJson(rawJson, JsonObject.class));
    }

    static {
        enableTelemetry = true;
        stripeVersion = API_VERSION;
        connectTimeout = -1;
        readTimeout = -1;
        maxNetworkRetries = 0;
        apiBase = LIVE_API_BASE;
        connectBase = CONNECT_API_BASE;
        uploadBase = UPLOAD_API_BASE;
        connectionProxy = null;
        proxyCredential = null;
        appInfo = null;
    }
}

