/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.CustomerEntitlementCollection;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.CustomerEntitlementListParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class CustomerEntitlement
extends ApiResource
implements HasId {
    @SerializedName(value="feature")
    String feature;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="lookup_key")
    String lookupKey;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="quantity")
    Quantity quantity;
    @SerializedName(value="type")
    String type;

    public static CustomerEntitlementCollection list(String customer, Map<String, Object> params) throws StripeException {
        return CustomerEntitlement.list(customer, params, (RequestOptions)null);
    }

    public static CustomerEntitlementCollection list(String customer, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/customers/%s/entitlements", ApiResource.urlEncodeId(customer));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (CustomerEntitlementCollection)CustomerEntitlement.getGlobalResponseGetter().request(request, (Type)((Object)CustomerEntitlementCollection.class));
    }

    public static CustomerEntitlementCollection list(String customer, CustomerEntitlementListParams params) throws StripeException {
        return CustomerEntitlement.list(customer, params, (RequestOptions)null);
    }

    public static CustomerEntitlementCollection list(String customer, CustomerEntitlementListParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/customers/%s/entitlements", ApiResource.urlEncodeId(customer));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (CustomerEntitlementCollection)CustomerEntitlement.getGlobalResponseGetter().request(request, (Type)((Object)CustomerEntitlementCollection.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.quantity, responseGetter);
    }

    @Generated
    public String getFeature() {
        return this.feature;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getLookupKey() {
        return this.lookupKey;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Quantity getQuantity() {
        return this.quantity;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setFeature(String feature) {
        this.feature = feature;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setLookupKey(String lookupKey) {
        this.lookupKey = lookupKey;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setQuantity(Quantity quantity) {
        this.quantity = quantity;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomerEntitlement)) {
            return false;
        }
        CustomerEntitlement other = (CustomerEntitlement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$feature = this.getFeature();
        String other$feature = other.getFeature();
        if (this$feature == null ? other$feature != null : !this$feature.equals(other$feature)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$lookupKey = this.getLookupKey();
        String other$lookupKey = other.getLookupKey();
        if (this$lookupKey == null ? other$lookupKey != null : !this$lookupKey.equals(other$lookupKey)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Quantity this$quantity = this.getQuantity();
        Quantity other$quantity = other.getQuantity();
        if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CustomerEntitlement;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $feature = this.getFeature();
        result = result * 59 + ($feature == null ? 43 : $feature.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $lookupKey = this.getLookupKey();
        result = result * 59 + ($lookupKey == null ? 43 : $lookupKey.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Quantity $quantity = this.getQuantity();
        result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class Quantity
    extends StripeObject {
        @SerializedName(value="total_available")
        Long totalAvailable;

        @Generated
        public Long getTotalAvailable() {
            return this.totalAvailable;
        }

        @Generated
        public void setTotalAvailable(Long totalAvailable) {
            this.totalAvailable = totalAvailable;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Quantity)) {
                return false;
            }
            Quantity other = (Quantity)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$totalAvailable = this.getTotalAvailable();
            Long other$totalAvailable = other.getTotalAvailable();
            return !(this$totalAvailable == null ? other$totalAvailable != null : !((Object)this$totalAvailable).equals(other$totalAvailable));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Quantity;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $totalAvailable = this.getTotalAvailable();
            result = result * 59 + ($totalAvailable == null ? 43 : ((Object)$totalAvailable).hashCode());
            return result;
        }
    }
}

