/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.Account;
import com.stripe.model.Application;
import com.stripe.model.Customer;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.Mandate;
import com.stripe.model.MetadataStore;
import com.stripe.model.PaymentMethod;
import com.stripe.model.SetupAttempt;
import com.stripe.model.SetupIntentCollection;
import com.stripe.model.StripeError;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.SetupIntentCancelParams;
import com.stripe.param.SetupIntentConfirmParams;
import com.stripe.param.SetupIntentCreateParams;
import com.stripe.param.SetupIntentListParams;
import com.stripe.param.SetupIntentRetrieveParams;
import com.stripe.param.SetupIntentUpdateParams;
import com.stripe.param.SetupIntentVerifyMicrodepositsParams;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class SetupIntent
extends ApiResource
implements HasId,
MetadataStore<SetupIntent> {
    @SerializedName(value="application")
    ExpandableField<Application> application;
    @SerializedName(value="attach_to_self")
    Boolean attachToSelf;
    @SerializedName(value="automatic_payment_methods")
    AutomaticPaymentMethods automaticPaymentMethods;
    @SerializedName(value="cancellation_reason")
    String cancellationReason;
    @SerializedName(value="client_secret")
    String clientSecret;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="customer")
    ExpandableField<Customer> customer;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="flow_directions")
    List<String> flowDirections;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="last_setup_error")
    StripeError lastSetupError;
    @SerializedName(value="latest_attempt")
    ExpandableField<SetupAttempt> latestAttempt;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="mandate")
    ExpandableField<Mandate> mandate;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="next_action")
    NextAction nextAction;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="on_behalf_of")
    ExpandableField<Account> onBehalfOf;
    @SerializedName(value="payment_method")
    ExpandableField<PaymentMethod> paymentMethod;
    @SerializedName(value="payment_method_configuration_details")
    PaymentMethodConfigurationDetails paymentMethodConfigurationDetails;
    @SerializedName(value="payment_method_options")
    PaymentMethodOptions paymentMethodOptions;
    @SerializedName(value="payment_method_types")
    List<String> paymentMethodTypes;
    @SerializedName(value="single_use_mandate")
    ExpandableField<Mandate> singleUseMandate;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="usage")
    String usage;

    public String getApplication() {
        return this.application != null ? this.application.getId() : null;
    }

    public void setApplication(String id) {
        this.application = ApiResource.setExpandableFieldId(id, this.application);
    }

    public Application getApplicationObject() {
        return this.application != null ? this.application.getExpanded() : null;
    }

    public void setApplicationObject(Application expandableObject) {
        this.application = new ExpandableField<Application>(expandableObject.getId(), expandableObject);
    }

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String id) {
        this.customer = ApiResource.setExpandableFieldId(id, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer expandableObject) {
        this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
    }

    public String getLatestAttempt() {
        return this.latestAttempt != null ? this.latestAttempt.getId() : null;
    }

    public void setLatestAttempt(String id) {
        this.latestAttempt = ApiResource.setExpandableFieldId(id, this.latestAttempt);
    }

    public SetupAttempt getLatestAttemptObject() {
        return this.latestAttempt != null ? this.latestAttempt.getExpanded() : null;
    }

    public void setLatestAttemptObject(SetupAttempt expandableObject) {
        this.latestAttempt = new ExpandableField<SetupAttempt>(expandableObject.getId(), expandableObject);
    }

    public String getMandate() {
        return this.mandate != null ? this.mandate.getId() : null;
    }

    public void setMandate(String id) {
        this.mandate = ApiResource.setExpandableFieldId(id, this.mandate);
    }

    public Mandate getMandateObject() {
        return this.mandate != null ? this.mandate.getExpanded() : null;
    }

    public void setMandateObject(Mandate expandableObject) {
        this.mandate = new ExpandableField<Mandate>(expandableObject.getId(), expandableObject);
    }

    public String getOnBehalfOf() {
        return this.onBehalfOf != null ? this.onBehalfOf.getId() : null;
    }

    public void setOnBehalfOf(String id) {
        this.onBehalfOf = ApiResource.setExpandableFieldId(id, this.onBehalfOf);
    }

    public Account getOnBehalfOfObject() {
        return this.onBehalfOf != null ? this.onBehalfOf.getExpanded() : null;
    }

    public void setOnBehalfOfObject(Account expandableObject) {
        this.onBehalfOf = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
    }

    public String getPaymentMethod() {
        return this.paymentMethod != null ? this.paymentMethod.getId() : null;
    }

    public void setPaymentMethod(String id) {
        this.paymentMethod = ApiResource.setExpandableFieldId(id, this.paymentMethod);
    }

    public PaymentMethod getPaymentMethodObject() {
        return this.paymentMethod != null ? this.paymentMethod.getExpanded() : null;
    }

    public void setPaymentMethodObject(PaymentMethod expandableObject) {
        this.paymentMethod = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
    }

    public String getSingleUseMandate() {
        return this.singleUseMandate != null ? this.singleUseMandate.getId() : null;
    }

    public void setSingleUseMandate(String id) {
        this.singleUseMandate = ApiResource.setExpandableFieldId(id, this.singleUseMandate);
    }

    public Mandate getSingleUseMandateObject() {
        return this.singleUseMandate != null ? this.singleUseMandate.getExpanded() : null;
    }

    public void setSingleUseMandateObject(Mandate expandableObject) {
        this.singleUseMandate = new ExpandableField<Mandate>(expandableObject.getId(), expandableObject);
    }

    public SetupIntent cancel() throws StripeException {
        return this.cancel((Map<String, Object>)null, (RequestOptions)null);
    }

    public SetupIntent cancel(RequestOptions options) throws StripeException {
        return this.cancel((Map<String, Object>)null, options);
    }

    public SetupIntent cancel(Map<String, Object> params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public SetupIntent cancel(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/setup_intents/%s/cancel", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (SetupIntent)this.getResponseGetter().request(request, (Type)((Object)SetupIntent.class));
    }

    public SetupIntent cancel(SetupIntentCancelParams params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public SetupIntent cancel(SetupIntentCancelParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/setup_intents/%s/cancel", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (SetupIntent)this.getResponseGetter().request(request, (Type)((Object)SetupIntent.class));
    }

    public SetupIntent confirm() throws StripeException {
        return this.confirm((Map<String, Object>)null, (RequestOptions)null);
    }

    public SetupIntent confirm(RequestOptions options) throws StripeException {
        return this.confirm((Map<String, Object>)null, options);
    }

    public SetupIntent confirm(Map<String, Object> params) throws StripeException {
        return this.confirm(params, (RequestOptions)null);
    }

    public SetupIntent confirm(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/setup_intents/%s/confirm", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (SetupIntent)this.getResponseGetter().request(request, (Type)((Object)SetupIntent.class));
    }

    public SetupIntent confirm(SetupIntentConfirmParams params) throws StripeException {
        return this.confirm(params, (RequestOptions)null);
    }

    public SetupIntent confirm(SetupIntentConfirmParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/setup_intents/%s/confirm", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (SetupIntent)this.getResponseGetter().request(request, (Type)((Object)SetupIntent.class));
    }

    public static SetupIntent create(Map<String, Object> params) throws StripeException {
        return SetupIntent.create(params, (RequestOptions)null);
    }

    public static SetupIntent create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/setup_intents";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (SetupIntent)SetupIntent.getGlobalResponseGetter().request(request, (Type)((Object)SetupIntent.class));
    }

    public static SetupIntent create(SetupIntentCreateParams params) throws StripeException {
        return SetupIntent.create(params, (RequestOptions)null);
    }

    public static SetupIntent create(SetupIntentCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/setup_intents";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (SetupIntent)SetupIntent.getGlobalResponseGetter().request(request, (Type)((Object)SetupIntent.class));
    }

    public static SetupIntentCollection list(Map<String, Object> params) throws StripeException {
        return SetupIntent.list(params, (RequestOptions)null);
    }

    public static SetupIntentCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/setup_intents";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (SetupIntentCollection)SetupIntent.getGlobalResponseGetter().request(request, (Type)((Object)SetupIntentCollection.class));
    }

    public static SetupIntentCollection list(SetupIntentListParams params) throws StripeException {
        return SetupIntent.list(params, (RequestOptions)null);
    }

    public static SetupIntentCollection list(SetupIntentListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/setup_intents";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (SetupIntentCollection)SetupIntent.getGlobalResponseGetter().request(request, (Type)((Object)SetupIntentCollection.class));
    }

    public static SetupIntent retrieve(String intent) throws StripeException {
        return SetupIntent.retrieve(intent, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static SetupIntent retrieve(String intent, RequestOptions options) throws StripeException {
        return SetupIntent.retrieve(intent, (Map<String, Object>)null, options);
    }

    public static SetupIntent retrieve(String intent, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/setup_intents/%s", ApiResource.urlEncodeId(intent));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (SetupIntent)SetupIntent.getGlobalResponseGetter().request(request, (Type)((Object)SetupIntent.class));
    }

    public static SetupIntent retrieve(String intent, SetupIntentRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/setup_intents/%s", ApiResource.urlEncodeId(intent));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (SetupIntent)SetupIntent.getGlobalResponseGetter().request(request, (Type)((Object)SetupIntent.class));
    }

    public SetupIntent update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public SetupIntent update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/setup_intents/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (SetupIntent)this.getResponseGetter().request(request, (Type)((Object)SetupIntent.class));
    }

    public SetupIntent update(SetupIntentUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public SetupIntent update(SetupIntentUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/setup_intents/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (SetupIntent)this.getResponseGetter().request(request, (Type)((Object)SetupIntent.class));
    }

    public SetupIntent verifyMicrodeposits() throws StripeException {
        return this.verifyMicrodeposits((Map<String, Object>)null, (RequestOptions)null);
    }

    public SetupIntent verifyMicrodeposits(RequestOptions options) throws StripeException {
        return this.verifyMicrodeposits((Map<String, Object>)null, options);
    }

    public SetupIntent verifyMicrodeposits(Map<String, Object> params) throws StripeException {
        return this.verifyMicrodeposits(params, (RequestOptions)null);
    }

    public SetupIntent verifyMicrodeposits(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/setup_intents/%s/verify_microdeposits", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (SetupIntent)this.getResponseGetter().request(request, (Type)((Object)SetupIntent.class));
    }

    public SetupIntent verifyMicrodeposits(SetupIntentVerifyMicrodepositsParams params) throws StripeException {
        return this.verifyMicrodeposits(params, (RequestOptions)null);
    }

    public SetupIntent verifyMicrodeposits(SetupIntentVerifyMicrodepositsParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/setup_intents/%s/verify_microdeposits", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (SetupIntent)this.getResponseGetter().request(request, (Type)((Object)SetupIntent.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.application, responseGetter);
        this.trySetResponseGetter(this.automaticPaymentMethods, responseGetter);
        this.trySetResponseGetter(this.customer, responseGetter);
        this.trySetResponseGetter(this.lastSetupError, responseGetter);
        this.trySetResponseGetter(this.latestAttempt, responseGetter);
        this.trySetResponseGetter(this.mandate, responseGetter);
        this.trySetResponseGetter(this.nextAction, responseGetter);
        this.trySetResponseGetter(this.onBehalfOf, responseGetter);
        this.trySetResponseGetter(this.paymentMethod, responseGetter);
        this.trySetResponseGetter(this.paymentMethodConfigurationDetails, responseGetter);
        this.trySetResponseGetter(this.paymentMethodOptions, responseGetter);
        this.trySetResponseGetter(this.singleUseMandate, responseGetter);
    }

    @Generated
    public Boolean getAttachToSelf() {
        return this.attachToSelf;
    }

    @Generated
    public AutomaticPaymentMethods getAutomaticPaymentMethods() {
        return this.automaticPaymentMethods;
    }

    @Generated
    public String getCancellationReason() {
        return this.cancellationReason;
    }

    @Generated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public List<String> getFlowDirections() {
        return this.flowDirections;
    }

    @Generated
    public StripeError getLastSetupError() {
        return this.lastSetupError;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public NextAction getNextAction() {
        return this.nextAction;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public PaymentMethodConfigurationDetails getPaymentMethodConfigurationDetails() {
        return this.paymentMethodConfigurationDetails;
    }

    @Generated
    public PaymentMethodOptions getPaymentMethodOptions() {
        return this.paymentMethodOptions;
    }

    @Generated
    public List<String> getPaymentMethodTypes() {
        return this.paymentMethodTypes;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getUsage() {
        return this.usage;
    }

    @Generated
    public void setAttachToSelf(Boolean attachToSelf) {
        this.attachToSelf = attachToSelf;
    }

    @Generated
    public void setAutomaticPaymentMethods(AutomaticPaymentMethods automaticPaymentMethods) {
        this.automaticPaymentMethods = automaticPaymentMethods;
    }

    @Generated
    public void setCancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
    }

    @Generated
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setFlowDirections(List<String> flowDirections) {
        this.flowDirections = flowDirections;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLastSetupError(StripeError lastSetupError) {
        this.lastSetupError = lastSetupError;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setNextAction(NextAction nextAction) {
        this.nextAction = nextAction;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPaymentMethodConfigurationDetails(PaymentMethodConfigurationDetails paymentMethodConfigurationDetails) {
        this.paymentMethodConfigurationDetails = paymentMethodConfigurationDetails;
    }

    @Generated
    public void setPaymentMethodOptions(PaymentMethodOptions paymentMethodOptions) {
        this.paymentMethodOptions = paymentMethodOptions;
    }

    @Generated
    public void setPaymentMethodTypes(List<String> paymentMethodTypes) {
        this.paymentMethodTypes = paymentMethodTypes;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setUsage(String usage) {
        this.usage = usage;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetupIntent)) {
            return false;
        }
        SetupIntent other = (SetupIntent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$attachToSelf = this.getAttachToSelf();
        Boolean other$attachToSelf = other.getAttachToSelf();
        if (this$attachToSelf == null ? other$attachToSelf != null : !((Object)this$attachToSelf).equals(other$attachToSelf)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        AutomaticPaymentMethods this$automaticPaymentMethods = this.getAutomaticPaymentMethods();
        AutomaticPaymentMethods other$automaticPaymentMethods = other.getAutomaticPaymentMethods();
        if (this$automaticPaymentMethods == null ? other$automaticPaymentMethods != null : !((Object)this$automaticPaymentMethods).equals(other$automaticPaymentMethods)) {
            return false;
        }
        String this$cancellationReason = this.getCancellationReason();
        String other$cancellationReason = other.getCancellationReason();
        if (this$cancellationReason == null ? other$cancellationReason != null : !this$cancellationReason.equals(other$cancellationReason)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<String> this$flowDirections = this.getFlowDirections();
        List<String> other$flowDirections = other.getFlowDirections();
        if (this$flowDirections == null ? other$flowDirections != null : !((Object)this$flowDirections).equals(other$flowDirections)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        StripeError this$lastSetupError = this.getLastSetupError();
        StripeError other$lastSetupError = other.getLastSetupError();
        if (this$lastSetupError == null ? other$lastSetupError != null : !((Object)this$lastSetupError).equals(other$lastSetupError)) {
            return false;
        }
        String this$latestAttempt = this.getLatestAttempt();
        String other$latestAttempt = other.getLatestAttempt();
        if (this$latestAttempt == null ? other$latestAttempt != null : !this$latestAttempt.equals(other$latestAttempt)) {
            return false;
        }
        String this$mandate = this.getMandate();
        String other$mandate = other.getMandate();
        if (this$mandate == null ? other$mandate != null : !this$mandate.equals(other$mandate)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        NextAction this$nextAction = this.getNextAction();
        NextAction other$nextAction = other.getNextAction();
        if (this$nextAction == null ? other$nextAction != null : !((Object)this$nextAction).equals(other$nextAction)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$onBehalfOf = this.getOnBehalfOf();
        String other$onBehalfOf = other.getOnBehalfOf();
        if (this$onBehalfOf == null ? other$onBehalfOf != null : !this$onBehalfOf.equals(other$onBehalfOf)) {
            return false;
        }
        String this$paymentMethod = this.getPaymentMethod();
        String other$paymentMethod = other.getPaymentMethod();
        if (this$paymentMethod == null ? other$paymentMethod != null : !this$paymentMethod.equals(other$paymentMethod)) {
            return false;
        }
        PaymentMethodConfigurationDetails this$paymentMethodConfigurationDetails = this.getPaymentMethodConfigurationDetails();
        PaymentMethodConfigurationDetails other$paymentMethodConfigurationDetails = other.getPaymentMethodConfigurationDetails();
        if (this$paymentMethodConfigurationDetails == null ? other$paymentMethodConfigurationDetails != null : !((Object)this$paymentMethodConfigurationDetails).equals(other$paymentMethodConfigurationDetails)) {
            return false;
        }
        PaymentMethodOptions this$paymentMethodOptions = this.getPaymentMethodOptions();
        PaymentMethodOptions other$paymentMethodOptions = other.getPaymentMethodOptions();
        if (this$paymentMethodOptions == null ? other$paymentMethodOptions != null : !((Object)this$paymentMethodOptions).equals(other$paymentMethodOptions)) {
            return false;
        }
        List<String> this$paymentMethodTypes = this.getPaymentMethodTypes();
        List<String> other$paymentMethodTypes = other.getPaymentMethodTypes();
        if (this$paymentMethodTypes == null ? other$paymentMethodTypes != null : !((Object)this$paymentMethodTypes).equals(other$paymentMethodTypes)) {
            return false;
        }
        String this$singleUseMandate = this.getSingleUseMandate();
        String other$singleUseMandate = other.getSingleUseMandate();
        if (this$singleUseMandate == null ? other$singleUseMandate != null : !this$singleUseMandate.equals(other$singleUseMandate)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$usage = this.getUsage();
        String other$usage = other.getUsage();
        return !(this$usage == null ? other$usage != null : !this$usage.equals(other$usage));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SetupIntent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $attachToSelf = this.getAttachToSelf();
        result = result * 59 + ($attachToSelf == null ? 43 : ((Object)$attachToSelf).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        AutomaticPaymentMethods $automaticPaymentMethods = this.getAutomaticPaymentMethods();
        result = result * 59 + ($automaticPaymentMethods == null ? 43 : ((Object)$automaticPaymentMethods).hashCode());
        String $cancellationReason = this.getCancellationReason();
        result = result * 59 + ($cancellationReason == null ? 43 : $cancellationReason.hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<String> $flowDirections = this.getFlowDirections();
        result = result * 59 + ($flowDirections == null ? 43 : ((Object)$flowDirections).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        StripeError $lastSetupError = this.getLastSetupError();
        result = result * 59 + ($lastSetupError == null ? 43 : ((Object)$lastSetupError).hashCode());
        String $latestAttempt = this.getLatestAttempt();
        result = result * 59 + ($latestAttempt == null ? 43 : $latestAttempt.hashCode());
        String $mandate = this.getMandate();
        result = result * 59 + ($mandate == null ? 43 : $mandate.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        NextAction $nextAction = this.getNextAction();
        result = result * 59 + ($nextAction == null ? 43 : ((Object)$nextAction).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $onBehalfOf = this.getOnBehalfOf();
        result = result * 59 + ($onBehalfOf == null ? 43 : $onBehalfOf.hashCode());
        String $paymentMethod = this.getPaymentMethod();
        result = result * 59 + ($paymentMethod == null ? 43 : $paymentMethod.hashCode());
        PaymentMethodConfigurationDetails $paymentMethodConfigurationDetails = this.getPaymentMethodConfigurationDetails();
        result = result * 59 + ($paymentMethodConfigurationDetails == null ? 43 : ((Object)$paymentMethodConfigurationDetails).hashCode());
        PaymentMethodOptions $paymentMethodOptions = this.getPaymentMethodOptions();
        result = result * 59 + ($paymentMethodOptions == null ? 43 : ((Object)$paymentMethodOptions).hashCode());
        List<String> $paymentMethodTypes = this.getPaymentMethodTypes();
        result = result * 59 + ($paymentMethodTypes == null ? 43 : ((Object)$paymentMethodTypes).hashCode());
        String $singleUseMandate = this.getSingleUseMandate();
        result = result * 59 + ($singleUseMandate == null ? 43 : $singleUseMandate.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : $usage.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class AutomaticPaymentMethods
    extends StripeObject {
        @SerializedName(value="allow_redirects")
        String allowRedirects;
        @SerializedName(value="enabled")
        Boolean enabled;

        @Generated
        public String getAllowRedirects() {
            return this.allowRedirects;
        }

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public void setAllowRedirects(String allowRedirects) {
            this.allowRedirects = allowRedirects;
        }

        @Generated
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AutomaticPaymentMethods)) {
                return false;
            }
            AutomaticPaymentMethods other = (AutomaticPaymentMethods)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                return false;
            }
            String this$allowRedirects = this.getAllowRedirects();
            String other$allowRedirects = other.getAllowRedirects();
            return !(this$allowRedirects == null ? other$allowRedirects != null : !this$allowRedirects.equals(other$allowRedirects));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AutomaticPaymentMethods;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            String $allowRedirects = this.getAllowRedirects();
            result = result * 59 + ($allowRedirects == null ? 43 : $allowRedirects.hashCode());
            return result;
        }
    }

    public static class NextAction
    extends StripeObject {
        @SerializedName(value="cashapp_handle_redirect_or_display_qr_code")
        CashappHandleRedirectOrDisplayQrCode cashappHandleRedirectOrDisplayQrCode;
        @SerializedName(value="redirect_to_url")
        RedirectToUrl redirectToUrl;
        @SerializedName(value="type")
        String type;
        @SerializedName(value="use_stripe_sdk")
        Map<String, Object> useStripeSdk;
        @SerializedName(value="verify_with_microdeposits")
        VerifyWithMicrodeposits verifyWithMicrodeposits;

        @Generated
        public CashappHandleRedirectOrDisplayQrCode getCashappHandleRedirectOrDisplayQrCode() {
            return this.cashappHandleRedirectOrDisplayQrCode;
        }

        @Generated
        public RedirectToUrl getRedirectToUrl() {
            return this.redirectToUrl;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public Map<String, Object> getUseStripeSdk() {
            return this.useStripeSdk;
        }

        @Generated
        public VerifyWithMicrodeposits getVerifyWithMicrodeposits() {
            return this.verifyWithMicrodeposits;
        }

        @Generated
        public void setCashappHandleRedirectOrDisplayQrCode(CashappHandleRedirectOrDisplayQrCode cashappHandleRedirectOrDisplayQrCode) {
            this.cashappHandleRedirectOrDisplayQrCode = cashappHandleRedirectOrDisplayQrCode;
        }

        @Generated
        public void setRedirectToUrl(RedirectToUrl redirectToUrl) {
            this.redirectToUrl = redirectToUrl;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setUseStripeSdk(Map<String, Object> useStripeSdk) {
            this.useStripeSdk = useStripeSdk;
        }

        @Generated
        public void setVerifyWithMicrodeposits(VerifyWithMicrodeposits verifyWithMicrodeposits) {
            this.verifyWithMicrodeposits = verifyWithMicrodeposits;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NextAction)) {
                return false;
            }
            NextAction other = (NextAction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CashappHandleRedirectOrDisplayQrCode this$cashappHandleRedirectOrDisplayQrCode = this.getCashappHandleRedirectOrDisplayQrCode();
            CashappHandleRedirectOrDisplayQrCode other$cashappHandleRedirectOrDisplayQrCode = other.getCashappHandleRedirectOrDisplayQrCode();
            if (this$cashappHandleRedirectOrDisplayQrCode == null ? other$cashappHandleRedirectOrDisplayQrCode != null : !((Object)this$cashappHandleRedirectOrDisplayQrCode).equals(other$cashappHandleRedirectOrDisplayQrCode)) {
                return false;
            }
            RedirectToUrl this$redirectToUrl = this.getRedirectToUrl();
            RedirectToUrl other$redirectToUrl = other.getRedirectToUrl();
            if (this$redirectToUrl == null ? other$redirectToUrl != null : !((Object)this$redirectToUrl).equals(other$redirectToUrl)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Map<String, Object> this$useStripeSdk = this.getUseStripeSdk();
            Map<String, Object> other$useStripeSdk = other.getUseStripeSdk();
            if (this$useStripeSdk == null ? other$useStripeSdk != null : !((Object)this$useStripeSdk).equals(other$useStripeSdk)) {
                return false;
            }
            VerifyWithMicrodeposits this$verifyWithMicrodeposits = this.getVerifyWithMicrodeposits();
            VerifyWithMicrodeposits other$verifyWithMicrodeposits = other.getVerifyWithMicrodeposits();
            return !(this$verifyWithMicrodeposits == null ? other$verifyWithMicrodeposits != null : !((Object)this$verifyWithMicrodeposits).equals(other$verifyWithMicrodeposits));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NextAction;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CashappHandleRedirectOrDisplayQrCode $cashappHandleRedirectOrDisplayQrCode = this.getCashappHandleRedirectOrDisplayQrCode();
            result = result * 59 + ($cashappHandleRedirectOrDisplayQrCode == null ? 43 : ((Object)$cashappHandleRedirectOrDisplayQrCode).hashCode());
            RedirectToUrl $redirectToUrl = this.getRedirectToUrl();
            result = result * 59 + ($redirectToUrl == null ? 43 : ((Object)$redirectToUrl).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Map<String, Object> $useStripeSdk = this.getUseStripeSdk();
            result = result * 59 + ($useStripeSdk == null ? 43 : ((Object)$useStripeSdk).hashCode());
            VerifyWithMicrodeposits $verifyWithMicrodeposits = this.getVerifyWithMicrodeposits();
            result = result * 59 + ($verifyWithMicrodeposits == null ? 43 : ((Object)$verifyWithMicrodeposits).hashCode());
            return result;
        }

        public static class CashappHandleRedirectOrDisplayQrCode
        extends StripeObject {
            @SerializedName(value="hosted_instructions_url")
            String hostedInstructionsUrl;
            @SerializedName(value="mobile_auth_url")
            String mobileAuthUrl;
            @SerializedName(value="qr_code")
            QrCode qrCode;

            @Generated
            public String getHostedInstructionsUrl() {
                return this.hostedInstructionsUrl;
            }

            @Generated
            public String getMobileAuthUrl() {
                return this.mobileAuthUrl;
            }

            @Generated
            public QrCode getQrCode() {
                return this.qrCode;
            }

            @Generated
            public void setHostedInstructionsUrl(String hostedInstructionsUrl) {
                this.hostedInstructionsUrl = hostedInstructionsUrl;
            }

            @Generated
            public void setMobileAuthUrl(String mobileAuthUrl) {
                this.mobileAuthUrl = mobileAuthUrl;
            }

            @Generated
            public void setQrCode(QrCode qrCode) {
                this.qrCode = qrCode;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CashappHandleRedirectOrDisplayQrCode)) {
                    return false;
                }
                CashappHandleRedirectOrDisplayQrCode other = (CashappHandleRedirectOrDisplayQrCode)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$hostedInstructionsUrl = this.getHostedInstructionsUrl();
                String other$hostedInstructionsUrl = other.getHostedInstructionsUrl();
                if (this$hostedInstructionsUrl == null ? other$hostedInstructionsUrl != null : !this$hostedInstructionsUrl.equals(other$hostedInstructionsUrl)) {
                    return false;
                }
                String this$mobileAuthUrl = this.getMobileAuthUrl();
                String other$mobileAuthUrl = other.getMobileAuthUrl();
                if (this$mobileAuthUrl == null ? other$mobileAuthUrl != null : !this$mobileAuthUrl.equals(other$mobileAuthUrl)) {
                    return false;
                }
                QrCode this$qrCode = this.getQrCode();
                QrCode other$qrCode = other.getQrCode();
                return !(this$qrCode == null ? other$qrCode != null : !((Object)this$qrCode).equals(other$qrCode));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CashappHandleRedirectOrDisplayQrCode;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $hostedInstructionsUrl = this.getHostedInstructionsUrl();
                result = result * 59 + ($hostedInstructionsUrl == null ? 43 : $hostedInstructionsUrl.hashCode());
                String $mobileAuthUrl = this.getMobileAuthUrl();
                result = result * 59 + ($mobileAuthUrl == null ? 43 : $mobileAuthUrl.hashCode());
                QrCode $qrCode = this.getQrCode();
                result = result * 59 + ($qrCode == null ? 43 : ((Object)$qrCode).hashCode());
                return result;
            }

            public static class QrCode
            extends StripeObject {
                @SerializedName(value="expires_at")
                Long expiresAt;
                @SerializedName(value="image_url_png")
                String imageUrlPng;
                @SerializedName(value="image_url_svg")
                String imageUrlSvg;

                @Generated
                public Long getExpiresAt() {
                    return this.expiresAt;
                }

                @Generated
                public String getImageUrlPng() {
                    return this.imageUrlPng;
                }

                @Generated
                public String getImageUrlSvg() {
                    return this.imageUrlSvg;
                }

                @Generated
                public void setExpiresAt(Long expiresAt) {
                    this.expiresAt = expiresAt;
                }

                @Generated
                public void setImageUrlPng(String imageUrlPng) {
                    this.imageUrlPng = imageUrlPng;
                }

                @Generated
                public void setImageUrlSvg(String imageUrlSvg) {
                    this.imageUrlSvg = imageUrlSvg;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof QrCode)) {
                        return false;
                    }
                    QrCode other = (QrCode)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$expiresAt = this.getExpiresAt();
                    Long other$expiresAt = other.getExpiresAt();
                    if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
                        return false;
                    }
                    String this$imageUrlPng = this.getImageUrlPng();
                    String other$imageUrlPng = other.getImageUrlPng();
                    if (this$imageUrlPng == null ? other$imageUrlPng != null : !this$imageUrlPng.equals(other$imageUrlPng)) {
                        return false;
                    }
                    String this$imageUrlSvg = this.getImageUrlSvg();
                    String other$imageUrlSvg = other.getImageUrlSvg();
                    return !(this$imageUrlSvg == null ? other$imageUrlSvg != null : !this$imageUrlSvg.equals(other$imageUrlSvg));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof QrCode;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $expiresAt = this.getExpiresAt();
                    result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
                    String $imageUrlPng = this.getImageUrlPng();
                    result = result * 59 + ($imageUrlPng == null ? 43 : $imageUrlPng.hashCode());
                    String $imageUrlSvg = this.getImageUrlSvg();
                    result = result * 59 + ($imageUrlSvg == null ? 43 : $imageUrlSvg.hashCode());
                    return result;
                }
            }
        }

        public static class RedirectToUrl
        extends StripeObject {
            @SerializedName(value="return_url")
            String returnUrl;
            @SerializedName(value="url")
            String url;

            @Generated
            public String getReturnUrl() {
                return this.returnUrl;
            }

            @Generated
            public String getUrl() {
                return this.url;
            }

            @Generated
            public void setReturnUrl(String returnUrl) {
                this.returnUrl = returnUrl;
            }

            @Generated
            public void setUrl(String url) {
                this.url = url;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof RedirectToUrl)) {
                    return false;
                }
                RedirectToUrl other = (RedirectToUrl)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$returnUrl = this.getReturnUrl();
                String other$returnUrl = other.getReturnUrl();
                if (this$returnUrl == null ? other$returnUrl != null : !this$returnUrl.equals(other$returnUrl)) {
                    return false;
                }
                String this$url = this.getUrl();
                String other$url = other.getUrl();
                return !(this$url == null ? other$url != null : !this$url.equals(other$url));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof RedirectToUrl;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $returnUrl = this.getReturnUrl();
                result = result * 59 + ($returnUrl == null ? 43 : $returnUrl.hashCode());
                String $url = this.getUrl();
                result = result * 59 + ($url == null ? 43 : $url.hashCode());
                return result;
            }
        }

        public static class VerifyWithMicrodeposits
        extends StripeObject {
            @SerializedName(value="arrival_date")
            Long arrivalDate;
            @SerializedName(value="hosted_verification_url")
            String hostedVerificationUrl;
            @SerializedName(value="microdeposit_type")
            String microdepositType;

            @Generated
            public Long getArrivalDate() {
                return this.arrivalDate;
            }

            @Generated
            public String getHostedVerificationUrl() {
                return this.hostedVerificationUrl;
            }

            @Generated
            public String getMicrodepositType() {
                return this.microdepositType;
            }

            @Generated
            public void setArrivalDate(Long arrivalDate) {
                this.arrivalDate = arrivalDate;
            }

            @Generated
            public void setHostedVerificationUrl(String hostedVerificationUrl) {
                this.hostedVerificationUrl = hostedVerificationUrl;
            }

            @Generated
            public void setMicrodepositType(String microdepositType) {
                this.microdepositType = microdepositType;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof VerifyWithMicrodeposits)) {
                    return false;
                }
                VerifyWithMicrodeposits other = (VerifyWithMicrodeposits)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$arrivalDate = this.getArrivalDate();
                Long other$arrivalDate = other.getArrivalDate();
                if (this$arrivalDate == null ? other$arrivalDate != null : !((Object)this$arrivalDate).equals(other$arrivalDate)) {
                    return false;
                }
                String this$hostedVerificationUrl = this.getHostedVerificationUrl();
                String other$hostedVerificationUrl = other.getHostedVerificationUrl();
                if (this$hostedVerificationUrl == null ? other$hostedVerificationUrl != null : !this$hostedVerificationUrl.equals(other$hostedVerificationUrl)) {
                    return false;
                }
                String this$microdepositType = this.getMicrodepositType();
                String other$microdepositType = other.getMicrodepositType();
                return !(this$microdepositType == null ? other$microdepositType != null : !this$microdepositType.equals(other$microdepositType));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof VerifyWithMicrodeposits;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $arrivalDate = this.getArrivalDate();
                result = result * 59 + ($arrivalDate == null ? 43 : ((Object)$arrivalDate).hashCode());
                String $hostedVerificationUrl = this.getHostedVerificationUrl();
                result = result * 59 + ($hostedVerificationUrl == null ? 43 : $hostedVerificationUrl.hashCode());
                String $microdepositType = this.getMicrodepositType();
                result = result * 59 + ($microdepositType == null ? 43 : $microdepositType.hashCode());
                return result;
            }
        }
    }

    public static class PaymentMethodConfigurationDetails
    extends StripeObject
    implements HasId {
        @SerializedName(value="id")
        String id;
        @SerializedName(value="parent")
        String parent;

        @Generated
        public String getParent() {
            return this.parent;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public void setParent(String parent) {
            this.parent = parent;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaymentMethodConfigurationDetails)) {
                return false;
            }
            PaymentMethodConfigurationDetails other = (PaymentMethodConfigurationDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$parent = this.getParent();
            String other$parent = other.getParent();
            return !(this$parent == null ? other$parent != null : !this$parent.equals(other$parent));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PaymentMethodConfigurationDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $parent = this.getParent();
            result = result * 59 + ($parent == null ? 43 : $parent.hashCode());
            return result;
        }

        @Override
        @Generated
        public String getId() {
            return this.id;
        }
    }

    public static class PaymentMethodOptions
    extends StripeObject {
        @SerializedName(value="acss_debit")
        AcssDebit acssDebit;
        @SerializedName(value="card")
        Card card;
        @SerializedName(value="link")
        Link link;
        @SerializedName(value="paypal")
        Paypal paypal;
        @SerializedName(value="sepa_debit")
        SepaDebit sepaDebit;
        @SerializedName(value="us_bank_account")
        UsBankAccount usBankAccount;

        @Generated
        public AcssDebit getAcssDebit() {
            return this.acssDebit;
        }

        @Generated
        public Card getCard() {
            return this.card;
        }

        @Generated
        public Link getLink() {
            return this.link;
        }

        @Generated
        public Paypal getPaypal() {
            return this.paypal;
        }

        @Generated
        public SepaDebit getSepaDebit() {
            return this.sepaDebit;
        }

        @Generated
        public UsBankAccount getUsBankAccount() {
            return this.usBankAccount;
        }

        @Generated
        public void setAcssDebit(AcssDebit acssDebit) {
            this.acssDebit = acssDebit;
        }

        @Generated
        public void setCard(Card card) {
            this.card = card;
        }

        @Generated
        public void setLink(Link link) {
            this.link = link;
        }

        @Generated
        public void setPaypal(Paypal paypal) {
            this.paypal = paypal;
        }

        @Generated
        public void setSepaDebit(SepaDebit sepaDebit) {
            this.sepaDebit = sepaDebit;
        }

        @Generated
        public void setUsBankAccount(UsBankAccount usBankAccount) {
            this.usBankAccount = usBankAccount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaymentMethodOptions)) {
                return false;
            }
            PaymentMethodOptions other = (PaymentMethodOptions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AcssDebit this$acssDebit = this.getAcssDebit();
            AcssDebit other$acssDebit = other.getAcssDebit();
            if (this$acssDebit == null ? other$acssDebit != null : !((Object)this$acssDebit).equals(other$acssDebit)) {
                return false;
            }
            Card this$card = this.getCard();
            Card other$card = other.getCard();
            if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
                return false;
            }
            Link this$link = this.getLink();
            Link other$link = other.getLink();
            if (this$link == null ? other$link != null : !((Object)this$link).equals(other$link)) {
                return false;
            }
            Paypal this$paypal = this.getPaypal();
            Paypal other$paypal = other.getPaypal();
            if (this$paypal == null ? other$paypal != null : !((Object)this$paypal).equals(other$paypal)) {
                return false;
            }
            SepaDebit this$sepaDebit = this.getSepaDebit();
            SepaDebit other$sepaDebit = other.getSepaDebit();
            if (this$sepaDebit == null ? other$sepaDebit != null : !((Object)this$sepaDebit).equals(other$sepaDebit)) {
                return false;
            }
            UsBankAccount this$usBankAccount = this.getUsBankAccount();
            UsBankAccount other$usBankAccount = other.getUsBankAccount();
            return !(this$usBankAccount == null ? other$usBankAccount != null : !((Object)this$usBankAccount).equals(other$usBankAccount));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PaymentMethodOptions;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AcssDebit $acssDebit = this.getAcssDebit();
            result = result * 59 + ($acssDebit == null ? 43 : ((Object)$acssDebit).hashCode());
            Card $card = this.getCard();
            result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
            Link $link = this.getLink();
            result = result * 59 + ($link == null ? 43 : ((Object)$link).hashCode());
            Paypal $paypal = this.getPaypal();
            result = result * 59 + ($paypal == null ? 43 : ((Object)$paypal).hashCode());
            SepaDebit $sepaDebit = this.getSepaDebit();
            result = result * 59 + ($sepaDebit == null ? 43 : ((Object)$sepaDebit).hashCode());
            UsBankAccount $usBankAccount = this.getUsBankAccount();
            result = result * 59 + ($usBankAccount == null ? 43 : ((Object)$usBankAccount).hashCode());
            return result;
        }

        public static class AcssDebit
        extends StripeObject {
            @SerializedName(value="currency")
            String currency;
            @SerializedName(value="mandate_options")
            MandateOptions mandateOptions;
            @SerializedName(value="verification_method")
            String verificationMethod;

            @Generated
            public String getCurrency() {
                return this.currency;
            }

            @Generated
            public MandateOptions getMandateOptions() {
                return this.mandateOptions;
            }

            @Generated
            public String getVerificationMethod() {
                return this.verificationMethod;
            }

            @Generated
            public void setCurrency(String currency) {
                this.currency = currency;
            }

            @Generated
            public void setMandateOptions(MandateOptions mandateOptions) {
                this.mandateOptions = mandateOptions;
            }

            @Generated
            public void setVerificationMethod(String verificationMethod) {
                this.verificationMethod = verificationMethod;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AcssDebit)) {
                    return false;
                }
                AcssDebit other = (AcssDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$currency = this.getCurrency();
                String other$currency = other.getCurrency();
                if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                    return false;
                }
                MandateOptions this$mandateOptions = this.getMandateOptions();
                MandateOptions other$mandateOptions = other.getMandateOptions();
                if (this$mandateOptions == null ? other$mandateOptions != null : !((Object)this$mandateOptions).equals(other$mandateOptions)) {
                    return false;
                }
                String this$verificationMethod = this.getVerificationMethod();
                String other$verificationMethod = other.getVerificationMethod();
                return !(this$verificationMethod == null ? other$verificationMethod != null : !this$verificationMethod.equals(other$verificationMethod));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AcssDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $currency = this.getCurrency();
                result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
                MandateOptions $mandateOptions = this.getMandateOptions();
                result = result * 59 + ($mandateOptions == null ? 43 : ((Object)$mandateOptions).hashCode());
                String $verificationMethod = this.getVerificationMethod();
                result = result * 59 + ($verificationMethod == null ? 43 : $verificationMethod.hashCode());
                return result;
            }

            public static class MandateOptions
            extends StripeObject {
                @SerializedName(value="custom_mandate_url")
                String customMandateUrl;
                @SerializedName(value="default_for")
                List<String> defaultFor;
                @SerializedName(value="interval_description")
                String intervalDescription;
                @SerializedName(value="payment_schedule")
                String paymentSchedule;
                @SerializedName(value="transaction_type")
                String transactionType;

                @Generated
                public String getCustomMandateUrl() {
                    return this.customMandateUrl;
                }

                @Generated
                public List<String> getDefaultFor() {
                    return this.defaultFor;
                }

                @Generated
                public String getIntervalDescription() {
                    return this.intervalDescription;
                }

                @Generated
                public String getPaymentSchedule() {
                    return this.paymentSchedule;
                }

                @Generated
                public String getTransactionType() {
                    return this.transactionType;
                }

                @Generated
                public void setCustomMandateUrl(String customMandateUrl) {
                    this.customMandateUrl = customMandateUrl;
                }

                @Generated
                public void setDefaultFor(List<String> defaultFor) {
                    this.defaultFor = defaultFor;
                }

                @Generated
                public void setIntervalDescription(String intervalDescription) {
                    this.intervalDescription = intervalDescription;
                }

                @Generated
                public void setPaymentSchedule(String paymentSchedule) {
                    this.paymentSchedule = paymentSchedule;
                }

                @Generated
                public void setTransactionType(String transactionType) {
                    this.transactionType = transactionType;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof MandateOptions)) {
                        return false;
                    }
                    MandateOptions other = (MandateOptions)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$customMandateUrl = this.getCustomMandateUrl();
                    String other$customMandateUrl = other.getCustomMandateUrl();
                    if (this$customMandateUrl == null ? other$customMandateUrl != null : !this$customMandateUrl.equals(other$customMandateUrl)) {
                        return false;
                    }
                    List<String> this$defaultFor = this.getDefaultFor();
                    List<String> other$defaultFor = other.getDefaultFor();
                    if (this$defaultFor == null ? other$defaultFor != null : !((Object)this$defaultFor).equals(other$defaultFor)) {
                        return false;
                    }
                    String this$intervalDescription = this.getIntervalDescription();
                    String other$intervalDescription = other.getIntervalDescription();
                    if (this$intervalDescription == null ? other$intervalDescription != null : !this$intervalDescription.equals(other$intervalDescription)) {
                        return false;
                    }
                    String this$paymentSchedule = this.getPaymentSchedule();
                    String other$paymentSchedule = other.getPaymentSchedule();
                    if (this$paymentSchedule == null ? other$paymentSchedule != null : !this$paymentSchedule.equals(other$paymentSchedule)) {
                        return false;
                    }
                    String this$transactionType = this.getTransactionType();
                    String other$transactionType = other.getTransactionType();
                    return !(this$transactionType == null ? other$transactionType != null : !this$transactionType.equals(other$transactionType));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof MandateOptions;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $customMandateUrl = this.getCustomMandateUrl();
                    result = result * 59 + ($customMandateUrl == null ? 43 : $customMandateUrl.hashCode());
                    List<String> $defaultFor = this.getDefaultFor();
                    result = result * 59 + ($defaultFor == null ? 43 : ((Object)$defaultFor).hashCode());
                    String $intervalDescription = this.getIntervalDescription();
                    result = result * 59 + ($intervalDescription == null ? 43 : $intervalDescription.hashCode());
                    String $paymentSchedule = this.getPaymentSchedule();
                    result = result * 59 + ($paymentSchedule == null ? 43 : $paymentSchedule.hashCode());
                    String $transactionType = this.getTransactionType();
                    result = result * 59 + ($transactionType == null ? 43 : $transactionType.hashCode());
                    return result;
                }
            }
        }

        public static class Card
        extends StripeObject {
            @SerializedName(value="mandate_options")
            MandateOptions mandateOptions;
            @SerializedName(value="network")
            String network;
            @SerializedName(value="request_three_d_secure")
            String requestThreeDSecure;

            @Generated
            public MandateOptions getMandateOptions() {
                return this.mandateOptions;
            }

            @Generated
            public String getNetwork() {
                return this.network;
            }

            @Generated
            public String getRequestThreeDSecure() {
                return this.requestThreeDSecure;
            }

            @Generated
            public void setMandateOptions(MandateOptions mandateOptions) {
                this.mandateOptions = mandateOptions;
            }

            @Generated
            public void setNetwork(String network) {
                this.network = network;
            }

            @Generated
            public void setRequestThreeDSecure(String requestThreeDSecure) {
                this.requestThreeDSecure = requestThreeDSecure;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Card)) {
                    return false;
                }
                Card other = (Card)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                MandateOptions this$mandateOptions = this.getMandateOptions();
                MandateOptions other$mandateOptions = other.getMandateOptions();
                if (this$mandateOptions == null ? other$mandateOptions != null : !((Object)this$mandateOptions).equals(other$mandateOptions)) {
                    return false;
                }
                String this$network = this.getNetwork();
                String other$network = other.getNetwork();
                if (this$network == null ? other$network != null : !this$network.equals(other$network)) {
                    return false;
                }
                String this$requestThreeDSecure = this.getRequestThreeDSecure();
                String other$requestThreeDSecure = other.getRequestThreeDSecure();
                return !(this$requestThreeDSecure == null ? other$requestThreeDSecure != null : !this$requestThreeDSecure.equals(other$requestThreeDSecure));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Card;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                MandateOptions $mandateOptions = this.getMandateOptions();
                result = result * 59 + ($mandateOptions == null ? 43 : ((Object)$mandateOptions).hashCode());
                String $network = this.getNetwork();
                result = result * 59 + ($network == null ? 43 : $network.hashCode());
                String $requestThreeDSecure = this.getRequestThreeDSecure();
                result = result * 59 + ($requestThreeDSecure == null ? 43 : $requestThreeDSecure.hashCode());
                return result;
            }

            public static class MandateOptions
            extends StripeObject {
                @SerializedName(value="amount")
                Long amount;
                @SerializedName(value="amount_type")
                String amountType;
                @SerializedName(value="currency")
                String currency;
                @SerializedName(value="description")
                String description;
                @SerializedName(value="end_date")
                Long endDate;
                @SerializedName(value="interval")
                String interval;
                @SerializedName(value="interval_count")
                Long intervalCount;
                @SerializedName(value="reference")
                String reference;
                @SerializedName(value="start_date")
                Long startDate;
                @SerializedName(value="supported_types")
                List<String> supportedTypes;

                @Generated
                public Long getAmount() {
                    return this.amount;
                }

                @Generated
                public String getAmountType() {
                    return this.amountType;
                }

                @Generated
                public String getCurrency() {
                    return this.currency;
                }

                @Generated
                public String getDescription() {
                    return this.description;
                }

                @Generated
                public Long getEndDate() {
                    return this.endDate;
                }

                @Generated
                public String getInterval() {
                    return this.interval;
                }

                @Generated
                public Long getIntervalCount() {
                    return this.intervalCount;
                }

                @Generated
                public String getReference() {
                    return this.reference;
                }

                @Generated
                public Long getStartDate() {
                    return this.startDate;
                }

                @Generated
                public List<String> getSupportedTypes() {
                    return this.supportedTypes;
                }

                @Generated
                public void setAmount(Long amount) {
                    this.amount = amount;
                }

                @Generated
                public void setAmountType(String amountType) {
                    this.amountType = amountType;
                }

                @Generated
                public void setCurrency(String currency) {
                    this.currency = currency;
                }

                @Generated
                public void setDescription(String description) {
                    this.description = description;
                }

                @Generated
                public void setEndDate(Long endDate) {
                    this.endDate = endDate;
                }

                @Generated
                public void setInterval(String interval) {
                    this.interval = interval;
                }

                @Generated
                public void setIntervalCount(Long intervalCount) {
                    this.intervalCount = intervalCount;
                }

                @Generated
                public void setReference(String reference) {
                    this.reference = reference;
                }

                @Generated
                public void setStartDate(Long startDate) {
                    this.startDate = startDate;
                }

                @Generated
                public void setSupportedTypes(List<String> supportedTypes) {
                    this.supportedTypes = supportedTypes;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof MandateOptions)) {
                        return false;
                    }
                    MandateOptions other = (MandateOptions)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$amount = this.getAmount();
                    Long other$amount = other.getAmount();
                    if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                        return false;
                    }
                    Long this$endDate = this.getEndDate();
                    Long other$endDate = other.getEndDate();
                    if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
                        return false;
                    }
                    Long this$intervalCount = this.getIntervalCount();
                    Long other$intervalCount = other.getIntervalCount();
                    if (this$intervalCount == null ? other$intervalCount != null : !((Object)this$intervalCount).equals(other$intervalCount)) {
                        return false;
                    }
                    Long this$startDate = this.getStartDate();
                    Long other$startDate = other.getStartDate();
                    if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
                        return false;
                    }
                    String this$amountType = this.getAmountType();
                    String other$amountType = other.getAmountType();
                    if (this$amountType == null ? other$amountType != null : !this$amountType.equals(other$amountType)) {
                        return false;
                    }
                    String this$currency = this.getCurrency();
                    String other$currency = other.getCurrency();
                    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                        return false;
                    }
                    String this$description = this.getDescription();
                    String other$description = other.getDescription();
                    if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                        return false;
                    }
                    String this$interval = this.getInterval();
                    String other$interval = other.getInterval();
                    if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) {
                        return false;
                    }
                    String this$reference = this.getReference();
                    String other$reference = other.getReference();
                    if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                        return false;
                    }
                    List<String> this$supportedTypes = this.getSupportedTypes();
                    List<String> other$supportedTypes = other.getSupportedTypes();
                    return !(this$supportedTypes == null ? other$supportedTypes != null : !((Object)this$supportedTypes).equals(other$supportedTypes));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof MandateOptions;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $amount = this.getAmount();
                    result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                    Long $endDate = this.getEndDate();
                    result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
                    Long $intervalCount = this.getIntervalCount();
                    result = result * 59 + ($intervalCount == null ? 43 : ((Object)$intervalCount).hashCode());
                    Long $startDate = this.getStartDate();
                    result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
                    String $amountType = this.getAmountType();
                    result = result * 59 + ($amountType == null ? 43 : $amountType.hashCode());
                    String $currency = this.getCurrency();
                    result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
                    String $description = this.getDescription();
                    result = result * 59 + ($description == null ? 43 : $description.hashCode());
                    String $interval = this.getInterval();
                    result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
                    String $reference = this.getReference();
                    result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
                    List<String> $supportedTypes = this.getSupportedTypes();
                    result = result * 59 + ($supportedTypes == null ? 43 : ((Object)$supportedTypes).hashCode());
                    return result;
                }
            }
        }

        public static class Link
        extends StripeObject {
            @SerializedName(value="persistent_token")
            String persistentToken;

            @Generated
            public String getPersistentToken() {
                return this.persistentToken;
            }

            @Generated
            public void setPersistentToken(String persistentToken) {
                this.persistentToken = persistentToken;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Link)) {
                    return false;
                }
                Link other = (Link)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$persistentToken = this.getPersistentToken();
                String other$persistentToken = other.getPersistentToken();
                return !(this$persistentToken == null ? other$persistentToken != null : !this$persistentToken.equals(other$persistentToken));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Link;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $persistentToken = this.getPersistentToken();
                result = result * 59 + ($persistentToken == null ? 43 : $persistentToken.hashCode());
                return result;
            }
        }

        public static class Paypal
        extends StripeObject {
            @SerializedName(value="billing_agreement_id")
            String billingAgreementId;
            @SerializedName(value="currency")
            String currency;
            @SerializedName(value="subsellers")
            List<String> subsellers;

            @Generated
            public String getBillingAgreementId() {
                return this.billingAgreementId;
            }

            @Generated
            public String getCurrency() {
                return this.currency;
            }

            @Generated
            public List<String> getSubsellers() {
                return this.subsellers;
            }

            @Generated
            public void setBillingAgreementId(String billingAgreementId) {
                this.billingAgreementId = billingAgreementId;
            }

            @Generated
            public void setCurrency(String currency) {
                this.currency = currency;
            }

            @Generated
            public void setSubsellers(List<String> subsellers) {
                this.subsellers = subsellers;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Paypal)) {
                    return false;
                }
                Paypal other = (Paypal)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$billingAgreementId = this.getBillingAgreementId();
                String other$billingAgreementId = other.getBillingAgreementId();
                if (this$billingAgreementId == null ? other$billingAgreementId != null : !this$billingAgreementId.equals(other$billingAgreementId)) {
                    return false;
                }
                String this$currency = this.getCurrency();
                String other$currency = other.getCurrency();
                if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                    return false;
                }
                List<String> this$subsellers = this.getSubsellers();
                List<String> other$subsellers = other.getSubsellers();
                return !(this$subsellers == null ? other$subsellers != null : !((Object)this$subsellers).equals(other$subsellers));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Paypal;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $billingAgreementId = this.getBillingAgreementId();
                result = result * 59 + ($billingAgreementId == null ? 43 : $billingAgreementId.hashCode());
                String $currency = this.getCurrency();
                result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
                List<String> $subsellers = this.getSubsellers();
                result = result * 59 + ($subsellers == null ? 43 : ((Object)$subsellers).hashCode());
                return result;
            }
        }

        public static class SepaDebit
        extends StripeObject {
            @SerializedName(value="mandate_options")
            MandateOptions mandateOptions;

            @Generated
            public MandateOptions getMandateOptions() {
                return this.mandateOptions;
            }

            @Generated
            public void setMandateOptions(MandateOptions mandateOptions) {
                this.mandateOptions = mandateOptions;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SepaDebit)) {
                    return false;
                }
                SepaDebit other = (SepaDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                MandateOptions this$mandateOptions = this.getMandateOptions();
                MandateOptions other$mandateOptions = other.getMandateOptions();
                return !(this$mandateOptions == null ? other$mandateOptions != null : !((Object)this$mandateOptions).equals(other$mandateOptions));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SepaDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                MandateOptions $mandateOptions = this.getMandateOptions();
                result = result * 59 + ($mandateOptions == null ? 43 : ((Object)$mandateOptions).hashCode());
                return result;
            }

            public static class MandateOptions
            extends StripeObject {
                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof MandateOptions)) {
                        return false;
                    }
                    MandateOptions other = (MandateOptions)o;
                    return other.canEqual(this);
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof MandateOptions;
                }

                @Generated
                public int hashCode() {
                    boolean result = true;
                    return 1;
                }
            }
        }

        public static class UsBankAccount
        extends StripeObject {
            @SerializedName(value="financial_connections")
            FinancialConnections financialConnections;
            @SerializedName(value="mandate_options")
            MandateOptions mandateOptions;
            @SerializedName(value="verification_method")
            String verificationMethod;

            @Generated
            public FinancialConnections getFinancialConnections() {
                return this.financialConnections;
            }

            @Generated
            public MandateOptions getMandateOptions() {
                return this.mandateOptions;
            }

            @Generated
            public String getVerificationMethod() {
                return this.verificationMethod;
            }

            @Generated
            public void setFinancialConnections(FinancialConnections financialConnections) {
                this.financialConnections = financialConnections;
            }

            @Generated
            public void setMandateOptions(MandateOptions mandateOptions) {
                this.mandateOptions = mandateOptions;
            }

            @Generated
            public void setVerificationMethod(String verificationMethod) {
                this.verificationMethod = verificationMethod;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof UsBankAccount)) {
                    return false;
                }
                UsBankAccount other = (UsBankAccount)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                FinancialConnections this$financialConnections = this.getFinancialConnections();
                FinancialConnections other$financialConnections = other.getFinancialConnections();
                if (this$financialConnections == null ? other$financialConnections != null : !((Object)this$financialConnections).equals(other$financialConnections)) {
                    return false;
                }
                MandateOptions this$mandateOptions = this.getMandateOptions();
                MandateOptions other$mandateOptions = other.getMandateOptions();
                if (this$mandateOptions == null ? other$mandateOptions != null : !((Object)this$mandateOptions).equals(other$mandateOptions)) {
                    return false;
                }
                String this$verificationMethod = this.getVerificationMethod();
                String other$verificationMethod = other.getVerificationMethod();
                return !(this$verificationMethod == null ? other$verificationMethod != null : !this$verificationMethod.equals(other$verificationMethod));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof UsBankAccount;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                FinancialConnections $financialConnections = this.getFinancialConnections();
                result = result * 59 + ($financialConnections == null ? 43 : ((Object)$financialConnections).hashCode());
                MandateOptions $mandateOptions = this.getMandateOptions();
                result = result * 59 + ($mandateOptions == null ? 43 : ((Object)$mandateOptions).hashCode());
                String $verificationMethod = this.getVerificationMethod();
                result = result * 59 + ($verificationMethod == null ? 43 : $verificationMethod.hashCode());
                return result;
            }

            public static class FinancialConnections
            extends StripeObject {
                @SerializedName(value="manual_entry")
                ManualEntry manualEntry;
                @SerializedName(value="permissions")
                List<String> permissions;
                @SerializedName(value="prefetch")
                List<String> prefetch;
                @SerializedName(value="return_url")
                String returnUrl;

                @Generated
                public ManualEntry getManualEntry() {
                    return this.manualEntry;
                }

                @Generated
                public List<String> getPermissions() {
                    return this.permissions;
                }

                @Generated
                public List<String> getPrefetch() {
                    return this.prefetch;
                }

                @Generated
                public String getReturnUrl() {
                    return this.returnUrl;
                }

                @Generated
                public void setManualEntry(ManualEntry manualEntry) {
                    this.manualEntry = manualEntry;
                }

                @Generated
                public void setPermissions(List<String> permissions) {
                    this.permissions = permissions;
                }

                @Generated
                public void setPrefetch(List<String> prefetch) {
                    this.prefetch = prefetch;
                }

                @Generated
                public void setReturnUrl(String returnUrl) {
                    this.returnUrl = returnUrl;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof FinancialConnections)) {
                        return false;
                    }
                    FinancialConnections other = (FinancialConnections)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    ManualEntry this$manualEntry = this.getManualEntry();
                    ManualEntry other$manualEntry = other.getManualEntry();
                    if (this$manualEntry == null ? other$manualEntry != null : !((Object)this$manualEntry).equals(other$manualEntry)) {
                        return false;
                    }
                    List<String> this$permissions = this.getPermissions();
                    List<String> other$permissions = other.getPermissions();
                    if (this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions)) {
                        return false;
                    }
                    List<String> this$prefetch = this.getPrefetch();
                    List<String> other$prefetch = other.getPrefetch();
                    if (this$prefetch == null ? other$prefetch != null : !((Object)this$prefetch).equals(other$prefetch)) {
                        return false;
                    }
                    String this$returnUrl = this.getReturnUrl();
                    String other$returnUrl = other.getReturnUrl();
                    return !(this$returnUrl == null ? other$returnUrl != null : !this$returnUrl.equals(other$returnUrl));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof FinancialConnections;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    ManualEntry $manualEntry = this.getManualEntry();
                    result = result * 59 + ($manualEntry == null ? 43 : ((Object)$manualEntry).hashCode());
                    List<String> $permissions = this.getPermissions();
                    result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
                    List<String> $prefetch = this.getPrefetch();
                    result = result * 59 + ($prefetch == null ? 43 : ((Object)$prefetch).hashCode());
                    String $returnUrl = this.getReturnUrl();
                    result = result * 59 + ($returnUrl == null ? 43 : $returnUrl.hashCode());
                    return result;
                }

                public static class ManualEntry
                extends StripeObject {
                    @SerializedName(value="mode")
                    String mode;

                    @Generated
                    public String getMode() {
                        return this.mode;
                    }

                    @Generated
                    public void setMode(String mode) {
                        this.mode = mode;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof ManualEntry)) {
                            return false;
                        }
                        ManualEntry other = (ManualEntry)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$mode = this.getMode();
                        String other$mode = other.getMode();
                        return !(this$mode == null ? other$mode != null : !this$mode.equals(other$mode));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof ManualEntry;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $mode = this.getMode();
                        result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
                        return result;
                    }
                }
            }

            public static class MandateOptions
            extends StripeObject {
                @SerializedName(value="collection_method")
                String collectionMethod;

                @Generated
                public String getCollectionMethod() {
                    return this.collectionMethod;
                }

                @Generated
                public void setCollectionMethod(String collectionMethod) {
                    this.collectionMethod = collectionMethod;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof MandateOptions)) {
                        return false;
                    }
                    MandateOptions other = (MandateOptions)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$collectionMethod = this.getCollectionMethod();
                    String other$collectionMethod = other.getCollectionMethod();
                    return !(this$collectionMethod == null ? other$collectionMethod != null : !this$collectionMethod.equals(other$collectionMethod));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof MandateOptions;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $collectionMethod = this.getCollectionMethod();
                    result = result * 59 + ($collectionMethod == null ? 43 : $collectionMethod.hashCode());
                    return result;
                }
            }
        }
    }
}

