/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.CustomerEntitlementCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.CustomerEntitlementSummaryRetrieveParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class CustomerEntitlementSummary
extends ApiResource {
    @SerializedName(value="customer")
    String customer;
    @SerializedName(value="entitlements")
    CustomerEntitlementCollection entitlements;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;

    public static CustomerEntitlementSummary retrieve(String customer) throws StripeException {
        return CustomerEntitlementSummary.retrieve(customer, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static CustomerEntitlementSummary retrieve(String customer, RequestOptions options) throws StripeException {
        return CustomerEntitlementSummary.retrieve(customer, (Map<String, Object>)null, options);
    }

    public static CustomerEntitlementSummary retrieve(String customer, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/customers/%s/entitlement_summary", ApiResource.urlEncodeId(customer));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (CustomerEntitlementSummary)CustomerEntitlementSummary.getGlobalResponseGetter().request(request, (Type)((Object)CustomerEntitlementSummary.class));
    }

    public static CustomerEntitlementSummary retrieve(String customer, CustomerEntitlementSummaryRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/customers/%s/entitlement_summary", ApiResource.urlEncodeId(customer));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (CustomerEntitlementSummary)CustomerEntitlementSummary.getGlobalResponseGetter().request(request, (Type)((Object)CustomerEntitlementSummary.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.entitlements, responseGetter);
    }

    @Generated
    public String getCustomer() {
        return this.customer;
    }

    @Generated
    public CustomerEntitlementCollection getEntitlements() {
        return this.entitlements;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public void setCustomer(String customer) {
        this.customer = customer;
    }

    @Generated
    public void setEntitlements(CustomerEntitlementCollection entitlements) {
        this.entitlements = entitlements;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomerEntitlementSummary)) {
            return false;
        }
        CustomerEntitlementSummary other = (CustomerEntitlementSummary)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        CustomerEntitlementCollection this$entitlements = this.getEntitlements();
        CustomerEntitlementCollection other$entitlements = other.getEntitlements();
        if (this$entitlements == null ? other$entitlements != null : !((Object)this$entitlements).equals(other$entitlements)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        return !(this$object == null ? other$object != null : !this$object.equals(other$object));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CustomerEntitlementSummary;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        CustomerEntitlementCollection $entitlements = this.getEntitlements();
        result = result * 59 + ($entitlements == null ? 43 : ((Object)$entitlements).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        return result;
    }
}

