/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.BankAccount;
import com.stripe.model.PaymentSource;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.PaymentSourceCreateParams;
import com.stripe.param.PaymentSourceDeleteParams;
import com.stripe.param.PaymentSourceListParams;
import com.stripe.param.PaymentSourceRetrieveParams;
import com.stripe.param.PaymentSourceUpdateParams;
import com.stripe.param.PaymentSourceVerifyParams;
import java.lang.reflect.Type;

public final class PaymentSourceService
extends ApiService {
    public PaymentSourceService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<PaymentSource> list(String customer, PaymentSourceListParams params) throws StripeException {
        return this.list(customer, params, null);
    }

    public StripeCollection<PaymentSource> list(String customer, RequestOptions options) throws StripeException {
        return this.list(customer, null, options);
    }

    public StripeCollection<PaymentSource> list(String customer) throws StripeException {
        return this.list(customer, null, null);
    }

    public StripeCollection<PaymentSource> list(String customer, PaymentSourceListParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/customers/%s/sources", ApiResource.urlEncodeId(customer));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<PaymentSource>>(){}.getType());
    }

    public PaymentSource create(String customer, PaymentSourceCreateParams params) throws StripeException {
        return this.create(customer, params, null);
    }

    public PaymentSource create(String customer, PaymentSourceCreateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/customers/%s/sources", ApiResource.urlEncodeId(customer));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (PaymentSource)this.request(request, (Type)((Object)PaymentSource.class));
    }

    public PaymentSource retrieve(String customer, String id, PaymentSourceRetrieveParams params) throws StripeException {
        return this.retrieve(customer, id, params, null);
    }

    public PaymentSource retrieve(String customer, String id, RequestOptions options) throws StripeException {
        return this.retrieve(customer, id, null, options);
    }

    public PaymentSource retrieve(String customer, String id) throws StripeException {
        return this.retrieve(customer, id, null, null);
    }

    public PaymentSource retrieve(String customer, String id, PaymentSourceRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/customers/%s/sources/%s", ApiResource.urlEncodeId(customer), ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (PaymentSource)this.request(request, (Type)((Object)PaymentSource.class));
    }

    public PaymentSource update(String customer, String id, PaymentSourceUpdateParams params) throws StripeException {
        return this.update(customer, id, params, null);
    }

    public PaymentSource update(String customer, String id, RequestOptions options) throws StripeException {
        return this.update(customer, id, null, options);
    }

    public PaymentSource update(String customer, String id) throws StripeException {
        return this.update(customer, id, null, null);
    }

    public PaymentSource update(String customer, String id, PaymentSourceUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/customers/%s/sources/%s", ApiResource.urlEncodeId(customer), ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (PaymentSource)this.request(request, (Type)((Object)PaymentSource.class));
    }

    public PaymentSource delete(String customer, String id, PaymentSourceDeleteParams params) throws StripeException {
        return this.delete(customer, id, params, null);
    }

    public PaymentSource delete(String customer, String id, RequestOptions options) throws StripeException {
        return this.delete(customer, id, null, options);
    }

    public PaymentSource delete(String customer, String id) throws StripeException {
        return this.delete(customer, id, null, null);
    }

    public PaymentSource delete(String customer, String id, PaymentSourceDeleteParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/customers/%s/sources/%s", ApiResource.urlEncodeId(customer), ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (PaymentSource)this.request(request, (Type)((Object)PaymentSource.class));
    }

    public BankAccount verify(String customer, String id, PaymentSourceVerifyParams params) throws StripeException {
        return this.verify(customer, id, params, null);
    }

    public BankAccount verify(String customer, String id, RequestOptions options) throws StripeException {
        return this.verify(customer, id, null, options);
    }

    public BankAccount verify(String customer, String id) throws StripeException {
        return this.verify(customer, id, null, null);
    }

    public BankAccount verify(String customer, String id, PaymentSourceVerifyParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/customers/%s/sources/%s/verify", ApiResource.urlEncodeId(customer), ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (BankAccount)this.request(request, (Type)((Object)BankAccount.class));
    }
}

