/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.stripe.exception.StripeException;
import com.stripe.model.EphemeralKey;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.EphemeralKeyCreateParams;
import com.stripe.param.EphemeralKeyDeleteParams;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public final class EphemeralKeyService
extends ApiService {
    public EphemeralKeyService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public EphemeralKey create(EphemeralKeyCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public EphemeralKey create(RequestOptions options) throws StripeException {
        return this.create(null, options);
    }

    public EphemeralKey create() throws StripeException {
        return this.create(null, null);
    }

    public EphemeralKey create(EphemeralKeyCreateParams params, RequestOptions options) throws StripeException {
        String versionOverride;
        Map<String, Object> paramsMap = ApiRequestParams.paramsToMap(params);
        if (!paramsMap.containsKey("stripe-version")) {
            throw new IllegalArgumentException("`stripe-version` must be explicitly specified in `params` as the stripe version of your mobile client.");
        }
        try {
            versionOverride = (String)paramsMap.get("stripe-version");
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("`stripe-version` must be explicitly specified in `params` as a string");
        }
        if (options == null) {
            options = RequestOptions.getDefault();
        }
        RequestOptions overriddenOptions = RequestOptions.RequestOptionsBuilder.unsafeSetStripeVersionOverride(options.toBuilderFullCopy(), versionOverride).build();
        HashMap<String, Object> overriddenParams = new HashMap<String, Object>(paramsMap);
        overriddenParams.remove("stripe-version");
        String path = "/v1/ephemeral_keys";
        return (EphemeralKey)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, (Map<String, Object>)overriddenParams, (Type)((Object)EphemeralKey.class), overriddenOptions, ApiMode.V1);
    }

    public EphemeralKey delete(String key, EphemeralKeyDeleteParams params) throws StripeException {
        return this.delete(key, params, null);
    }

    public EphemeralKey delete(String key, RequestOptions options) throws StripeException {
        return this.delete(key, null, options);
    }

    public EphemeralKey delete(String key) throws StripeException {
        return this.delete(key, null, null);
    }

    public EphemeralKey delete(String key, EphemeralKeyDeleteParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/ephemeral_keys/%s", ApiResource.urlEncodeId(key));
        return (EphemeralKey)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, ApiRequestParams.paramsToMap(params), (Type)((Object)EphemeralKey.class), options, ApiMode.V1);
    }
}

